/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.system.exception;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;
import org.jeecgframework.p3.core.common.utils.AjaxJson;
import org.jeecgframework.p3.core.util.plugin.ViewVelocity;
import org.jeewx.api.core.common.JSONHelper;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

@Component
public class GlobalExceptionResolver
implements HandlerExceptionResolver {
    private static final Logger log = Logger.getLogger(GlobalExceptionResolver.class);
    private static final int WIRTE_DB_MAX_LENGTH = 1500;
    private static final short LOG_LEVEL = 6;
    private static final short LOG_OPT = 3;

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        boolean isajax = this.isAjax(request, response);
        Throwable deepestException = this.deepestException(ex);
        return this.processException(request, response, handler, deepestException, isajax);
    }

    private boolean isAjax(HttpServletRequest request, HttpServletResponse response) {
        return StringUtils.isNotEmpty((String)request.getHeader("X-Requested-With"));
    }

    private Throwable deepestException(Throwable e) {
        Throwable tmp = e;
        int breakPoint = 0;
        while (tmp.getCause() != null) {
            if (tmp.equals(tmp.getCause())) break;
            tmp = tmp.getCause();
            if (++breakPoint > 1000) break;
        }
        return tmp;
    }

    private ModelAndView processException(HttpServletRequest request, HttpServletResponse response, Object handler, Throwable ex, boolean isajax) {
        log.error((Object)"\u5168\u5c40\u5904\u7406\u5f02\u5e38\u6355\u83b7:", ex);
        if (isajax) {
            return this.processAjax(request, response, handler, ex);
        }
        this.processNotAjax(request, response, handler, ex);
        return null;
    }

    private ModelAndView processAjax(HttpServletRequest request, HttpServletResponse response, Object handler, Throwable deepestException) {
        ModelAndView empty;
        block5: {
            empty = new ModelAndView();
            response.setHeader("Cache-Control", "no-store");
            AjaxJson json = new AjaxJson();
            json.setSuccess(true);
            json.setMsg(deepestException.getMessage());
            PrintWriter pw = null;
            try {
                try {
                    pw = response.getWriter();
                    pw.write(JSONHelper.bean2json((Object)json));
                    pw.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    pw.close();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                pw.close();
                throw throwable;
            }
            pw.close();
        }
        empty.clear();
        return empty;
    }

    private void processNotAjax(HttpServletRequest request, HttpServletResponse response, Object handler, Throwable ex) {
        try {
            String exceptionMessage = this.getThrowableMessage(ex);
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("exceptionMessage", (Object)exceptionMessage);
            velocityContext.put("ex", (Object)ex);
            String viewName = "base/back/common/errorexception.vm";
            ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getThrowableMessage(Throwable ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        return sw.toString();
    }
}

