/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.adapter.node;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.FieldExtension;
import org.flowable.bpmn.model.FlowableListener;
import org.flowable.bpmn.model.MultiInstanceLoopCharacteristics;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.flowable.bpmn.model.UserTask;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.modules.extbpm.process.adapter.BpmnCreator;
import org.jeecg.modules.extbpm.process.adapter.entity.ChildAttr;
import org.jeecg.modules.extbpm.process.adapter.entity.ChildNode;
import org.jeecg.modules.extbpm.process.adapter.entity.ProcessData;
import org.jeecg.modules.extbpm.process.adapter.model.ApproverModel;
import org.jeecg.modules.extbpm.process.adapter.model.ListenerModel;
import org.jeecg.modules.extbpm.process.entity.ExtActProcessNode;

public class UserTaskNodeCreator {
    public static final String OR_SIGN = "orSign";
    public static final Integer COUNTER_SIGN = 1;
    public static final String APPROVRE_TYPE_DEPT = "candidateDepts";
    public static final String APPROVRE_TYPE_ROLE = "candidateGroups";
    public static final String APPROVRE_TYPE_POST = "candidatePosts";
    public static final String APPROVRE_TYPE_USERS = "candidateUsers";
    public static final String APPROVRE_TYPE_USER = "candidateUser";
    public static final String ASSIGNEE_TYPE_CANDIDATE_USERS = "candidateUsers";
    public static final String ASSIGNEE_TYPE_BY_NAME = "assigneeByName";
    public static final String ASSIGNEE_TYPE_BY_EXP = "assigneeByExp";
    public static final String ASSIGNEE_TYPE_BY_VAR = "assigneeByVariable";
    public static final String ASSIGNEE_TYPE_CANDIDATE_GROUPS = "candidateGroups";
    public static final String ASSIGNEE_TYPE_MYSELF = "myself";

    public static List<UserTask> createUserTask(ProcessData processData, List<ChildNode> approverNodes, List<ExtActProcessNode> extActProcessNodes) {
        ArrayList<UserTask> tasks = new ArrayList<UserTask>();
        for (ChildNode node : approverNodes) {
            String[] expressionsIds;
            String formCode;
            ChildAttr processDataAttr;
            ExtActProcessNode extActProcessNode = new ExtActProcessNode();
            ChildAttr childAttr = node.getAttr();
            Integer approvalMode = node.getApprovalMode();
            String id = node.getId();
            String name = node.getName();
            extActProcessNode.setProcessNodeCode(id);
            extActProcessNode.setProcessNodeName(name);
            String type = node.getType();
            if (type.equals("edit") && ObjectUtils.isNotEmpty((Object)(processDataAttr = processData.getAttr())) && StringUtil.isNotEmpty((String)(formCode = processDataAttr.getFormTableCode()))) {
                extActProcessNode.setModelAndView("{{DOMAIN_URL}}/desform/edit/" + formCode + "/${BPM_DES_DATA_ID}?token={{TOKEN}}&taskId={{TASKID}}");
            }
            if (ObjectUtils.isNotEmpty((Object)childAttr)) {
                extActProcessNode.setNodeConfigJson(JSON.toJSONString((Object)childAttr));
            }
            UserTask userTask = new UserTask();
            userTask.setId(id);
            userTask.setName(name);
            List<ApproverModel> groups = node.getApproverGroups();
            if (!COUNTER_SIGN.equals(approvalMode)) {
                MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics = new MultiInstanceLoopCharacteristics();
                multiInstanceLoopCharacteristics.setLoopCardinality(childAttr.getLoopCardinality());
                multiInstanceLoopCharacteristics.setElementVariable(childAttr.getElementVariable());
                multiInstanceLoopCharacteristics.setCompletionCondition(childAttr.getCompletionCondition());
                multiInstanceLoopCharacteristics.setInputDataItem(childAttr.getCollection());
                multiInstanceLoopCharacteristics.setSequential(childAttr.getIsSequential().booleanValue());
                userTask.setLoopCharacteristics(multiInstanceLoopCharacteristics);
                if (ObjectUtils.isNotEmpty(groups)) {
                    ApproverModel approverModel = groups.get(0);
                    Object[] approverIds = approverModel.getApproverIds();
                    if (ObjectUtils.isNotEmpty((Object)approverIds)) {
                        String ids = StringUtils.join((Object[])approverIds, (String)",");
                        multiInstanceLoopCharacteristics.setInputDataItem("${flowUtil.stringToList('" + ids + "')}");
                    }
                    if (ObjectUtils.isNotEmpty((Object)(expressionsIds = approverModel.getExpressionsIds()))) {
                        userTask.setAssignee(expressionsIds[0]);
                    } else {
                        userTask.setAssignee("${" + childAttr.getElementVariable() + "}");
                    }
                }
            }
            if (ObjectUtils.isNotEmpty(groups)) {
                ApproverModel approverModel = groups.get(0);
                String assigneeType = approverModel.getAssigneeType();
                String approverType = approverModel.getApproverType();
                if (COUNTER_SIGN.equals(approvalMode)) {
                    String[] postIds;
                    ArrayList<String> expressions;
                    String variableContent;
                    String[] approverIds;
                    if (APPROVRE_TYPE_USER.equals(approverType)) {
                        if (ASSIGNEE_TYPE_BY_NAME.equals(assigneeType) && ObjectUtils.isNotEmpty((Object)(approverIds = approverModel.getApproverIds()))) {
                            userTask.setAssignee(approverIds[0]);
                        }
                        if (ASSIGNEE_TYPE_BY_EXP.equals(assigneeType) && ObjectUtils.isNotEmpty((Object)(expressionsIds = approverModel.getExpressionsIds()))) {
                            userTask.setAssignee(expressionsIds[0]);
                        }
                        if (ASSIGNEE_TYPE_BY_VAR.equals(assigneeType) && ObjectUtils.isNotEmpty((Object)(variableContent = approverModel.getVariableContent()))) {
                            userTask.setAssignee("${minFlowUtils.getAssigneeUser(false,execution.getId(),execution.getProcessInstanceId(),'" + variableContent + "')}");
                        }
                        if (ASSIGNEE_TYPE_MYSELF.equals(assigneeType)) {
                            userTask.setAssignee("${applyUserId}");
                        }
                    }
                    if ("candidateUsers".equals(approverType)) {
                        if (ASSIGNEE_TYPE_BY_NAME.equals(assigneeType) && ObjectUtils.isNotEmpty((Object)(approverIds = approverModel.getApproverIds()))) {
                            if (approverIds.length > 1) {
                                userTask.setCandidateUsers(Arrays.asList(approverIds));
                            } else {
                                userTask.setAssignee(approverIds[0]);
                            }
                        }
                        if (ASSIGNEE_TYPE_BY_EXP.equals(assigneeType)) {
                            expressionsIds = approverModel.getExpressionsIds();
                            expressions = new ArrayList<String>();
                            if (ObjectUtils.isNotEmpty((Object)expressionsIds)) {
                                expressions.add(expressionsIds[0]);
                                userTask.setCandidateUsers(expressions);
                            }
                        }
                        if (ASSIGNEE_TYPE_BY_VAR.equals(assigneeType) && ObjectUtils.isNotEmpty((Object)(variableContent = approverModel.getVariableContent()))) {
                            expressions = new ArrayList();
                            expressions.add("${minFlowUtils.getAssigneeUser(true,execution.getId(),execution.getProcessInstanceId(),'" + variableContent + "')}");
                            userTask.setCandidateUsers(expressions);
                        }
                    }
                    if ("candidateGroups".equals(approverType)) {
                        String[] roleIds;
                        if (ASSIGNEE_TYPE_BY_NAME.equals(assigneeType) && ObjectUtils.isNotEmpty((Object)(roleIds = approverModel.getRoleIds()))) {
                            userTask.setCandidateGroups(Arrays.asList(roleIds));
                        }
                        if (ASSIGNEE_TYPE_BY_EXP.equals(assigneeType)) {
                            expressionsIds = approverModel.getExpressionsIds();
                            expressions = new ArrayList();
                            if (ObjectUtils.isNotEmpty((Object)expressionsIds)) {
                                expressions.add(expressionsIds[0]);
                                userTask.setCandidateGroups(expressions);
                            }
                        }
                    }
                    if (APPROVRE_TYPE_POST.equals(approverType) && ASSIGNEE_TYPE_BY_NAME.equals(assigneeType) && ObjectUtils.isNotEmpty((Object)(postIds = approverModel.getPostIds()))) {
                        userTask.setCandidateGroups(Arrays.asList(postIds));
                    }
                    if (APPROVRE_TYPE_DEPT.equals(approverType)) {
                        String[] deptIds;
                        if (ASSIGNEE_TYPE_BY_NAME.equals(assigneeType) && ObjectUtils.isNotEmpty((Object)(deptIds = approverModel.getDeptIds()))) {
                            userTask.setCandidateGroups(Arrays.asList(deptIds));
                        }
                        if (ASSIGNEE_TYPE_BY_EXP.equals(assigneeType)) {
                            expressionsIds = approverModel.getExpressionsIds();
                            expressions = new ArrayList();
                            if (ObjectUtils.isNotEmpty((Object)expressionsIds)) {
                                expressions.add(expressionsIds[0]);
                                userTask.setCandidateGroups(expressions);
                            }
                        }
                        if (ASSIGNEE_TYPE_BY_VAR.equals(assigneeType) && ObjectUtils.isNotEmpty((Object)(variableContent = approverModel.getVariableContent()))) {
                            expressions = new ArrayList();
                            expressions.add("${minFlowUtils.getAssigneeUser(true,execution.getId(),execution.getProcessInstanceId(),'" + variableContent + "')}");
                            userTask.setCandidateGroups(expressions);
                        }
                    }
                }
                UserTaskNodeCreator.setListener(userTask, node, approverType);
            }
            UserTaskNodeCreator.setBoundaryEvent(userTask, node);
            tasks.add(userTask);
            extActProcessNodes.add(extActProcessNode);
        }
        return tasks;
    }

    private static List<FlowableListener> getGroupCounterSignListener(String list, String listType) {
        ArrayList<FlowableListener> listeners = new ArrayList<FlowableListener>();
        FlowableListener activitiListener = new FlowableListener();
        activitiListener.setEvent("start");
        activitiListener.setImplementationType("delegateExpression");
        activitiListener.setImplementation("${groupCounterSignListener}");
        ArrayList<FieldExtension> fieldExtensions = new ArrayList<FieldExtension>();
        if (listType.equals("candidateUsers")) {
            FieldExtension userListField = new FieldExtension();
            userListField.setFieldName("userList");
            userListField.setStringValue(list);
            fieldExtensions.add(userListField);
        } else if (listType.equals("candidateGroups")) {
            FieldExtension roleListField = new FieldExtension();
            roleListField.setFieldName("roleList");
            roleListField.setStringValue(list);
            fieldExtensions.add(roleListField);
        } else {
            throw new JeecgBootException("\u8bf7\u6c42\u7684\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        activitiListener.setFieldExtensions(fieldExtensions);
        listeners.add(activitiListener);
        return listeners;
    }

    private static void setListener(UserTask userTask, ChildNode node, String approverType) {
        List<ListenerModel> listenerModel;
        Integer sameMode;
        List<ListenerModel> taskListenerModel = node.getTaskListenerData();
        ChildAttr childAttr = node.getAttr();
        if (ObjectUtils.isNotEmpty((Object)childAttr) && APPROVRE_TYPE_USER.equals(approverType) && ObjectUtils.isNotEmpty((Object)(sameMode = childAttr.getSameMode())) && !sameMode.equals(1)) {
            ListenerModel listenerModel2 = new ListenerModel();
            listenerModel2.setListenerType("javaClass");
            listenerModel2.setEventType("create");
            listenerModel2.setValue("org.jeecg.modules.listener.easyoa.TaskApprovalListener");
            listenerModel2.setId("listener" + IdWorker.getId());
            taskListenerModel.add(listenerModel2);
        }
        if (ObjectUtils.isNotEmpty(taskListenerModel)) {
            ArrayList<FlowableListener> taskListeners = new ArrayList<FlowableListener>();
            for (ListenerModel taskListener : taskListenerModel) {
                FlowableListener activitiListener = BpmnCreator.createActivitiListener(taskListener);
                taskListeners.add(activitiListener);
            }
            userTask.setTaskListeners(taskListeners);
        }
        if (ObjectUtils.isNotEmpty(listenerModel = node.getListenerData())) {
            ArrayList<FlowableListener> executionListeners = new ArrayList<FlowableListener>();
            for (ListenerModel listener : listenerModel) {
                FlowableListener activitiListener = BpmnCreator.createActivitiListener(listener);
                executionListeners.add(activitiListener);
            }
            userTask.setExecutionListeners(executionListeners);
        }
    }

    private static void setBoundaryEvent(UserTask userTask, ChildNode childNode) {
        String timeDate;
        ChildAttr childAttr = childNode.getAttr();
        if (ObjectUtils.isNotEmpty((Object)childAttr) && ObjectUtils.isNotEmpty((Object)(timeDate = childAttr.getTimeDate()))) {
            ArrayList<BoundaryEvent> boundaryEvents = new ArrayList<BoundaryEvent>();
            BoundaryEvent boundaryEvent = new BoundaryEvent();
            boundaryEvent.setId("Event_" + IdUtil.simpleUUID().substring(0, 7));
            boundaryEvent.setAttachedToRef((Activity)userTask);
            TimerEventDefinition timerEventDefinition = new TimerEventDefinition();
            timerEventDefinition.setId("TimerEventDefinition_" + IdUtil.simpleUUID().substring(0, 7));
            timerEventDefinition.setTimeDate(timeDate);
            boundaryEvent.addEventDefinition((EventDefinition)timerEventDefinition);
            boundaryEvents.add(boundaryEvent);
            userTask.setBoundaryEvents(boundaryEvents);
        }
    }
}

