/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.adapter.node;

import cn.hutool.core.util.IdUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.IntermediateCatchEvent;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.jeecg.modules.extbpm.process.adapter.entity.ChildAttr;
import org.jeecg.modules.extbpm.process.adapter.entity.ChildNode;
import org.jeecg.modules.extbpm.process.adapter.enums.TimeTypeEnums;

public class TimeEventCreator {
    public static List<BoundaryEvent> createBoundaryEvent(List<ChildNode> boundaryEventNodes) {
        ArrayList<BoundaryEvent> events = new ArrayList<BoundaryEvent>();
        for (ChildNode node : boundaryEventNodes) {
            ChildAttr childAttr = node.getAttr();
            BoundaryEvent boundaryEvent = new BoundaryEvent();
            boundaryEvent.setId(node.getId());
            boundaryEvent.setName(node.getName());
            events.add(boundaryEvent);
        }
        return events;
    }

    public static List<IntermediateCatchEvent> createIntermediateCatchEvent(List<ChildNode> childNodes) {
        ArrayList<IntermediateCatchEvent> events = new ArrayList<IntermediateCatchEvent>();
        for (ChildNode node : childNodes) {
            ChildAttr childAttr = node.getAttr();
            String timeDate = childAttr.getTimeDate();
            String timeCycle = childAttr.getTimeCycle();
            String timeType = childAttr.getTimeType();
            IntermediateCatchEvent intermediateCatchEvent = new IntermediateCatchEvent();
            intermediateCatchEvent.setId(node.getId());
            intermediateCatchEvent.setName(node.getName());
            TimerEventDefinition timerEventDefinition = new TimerEventDefinition();
            timerEventDefinition.setId("TimerEventDefinition_" + IdUtil.simpleUUID().substring(0, 6));
            if (ObjectUtils.isNotEmpty((Object)timeType)) {
                if (TimeTypeEnums.timeDate.name().equals(timeType)) {
                    if (!"custom".equals(timeCycle)) {
                        timerEventDefinition.setTimeCycle(timeCycle);
                    } else {
                        timerEventDefinition.setTimeCycle(timeDate);
                    }
                }
                if (TimeTypeEnums.timeDuration.name().equals(timeType)) {
                    if (!"custom".equals(timeCycle)) {
                        timerEventDefinition.setTimeDuration(timeCycle);
                    } else {
                        timerEventDefinition.setTimeDuration(timeDate);
                    }
                }
                if (TimeTypeEnums.timeDate.name().equals(timeType)) {
                    timerEventDefinition.setTimeDate(timeDate);
                }
            }
            intermediateCatchEvent.addEventDefinition((EventDefinition)timerEventDefinition);
            events.add(intermediateCatchEvent);
        }
        return events;
    }
}

