/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.adapter.mq.client;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.Expression;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.bson.Document;
import org.flowable.engine.IdentityService;
import org.flowable.engine.ManagementService;
import org.flowable.engine.RuntimeService;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.base.BaseMap;
import org.jeecg.common.desform.vo.DesignFormDataVo;
import org.jeecg.common.miniflow.ISignalProcessStartApi;
import org.jeecg.common.system.query.QueryRuleEnum;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.Md5Util;
import org.jeecg.modules.extbpm.process.adapter.entity.ChildAttr;
import org.jeecg.modules.extbpm.process.adapter.entity.ConditionGroup;
import org.jeecg.modules.extbpm.process.adapter.enums.StartTypeEnums;
import org.jeecg.modules.extbpm.process.adapter.enums.TriggerActionEnums;
import org.jeecg.modules.extbpm.process.adapter.mapper.FlowTimerJobMapper;
import org.jeecg.modules.extbpm.process.adapter.mq.utils.MinFlowUtils;
import org.jeecg.modules.extbpm.process.common.WorkFlowGlobals;
import org.jeecg.modules.extbpm.process.entity.ExtActProcess;
import org.jeecg.modules.extbpm.process.entity.ExtActProcessForm;
import org.jeecg.modules.extbpm.process.entity.ExtActProcessNode;
import org.jeecg.modules.extbpm.process.entity.ExtActProcessNodeDeployment;
import org.jeecg.modules.extbpm.process.mapper.ExtActProcessMapper;
import org.jeecg.modules.joa.util.ProcessUtils;
import org.jeecg.modules.online.desform.entity.DesignFormData;
import org.jeecg.modules.online.desform.util.DesformQueryUtils;
import org.jeecg.modules.online.desform.vo.query.DesformSuperQuery;
import org.jeecg.modules.online.desform.vo.query.SuperQueryItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component(value="processHandlerClient")
public class ProcessHandlerClient
implements ISignalProcessStartApi {
    private static final Logger log = LoggerFactory.getLogger(ProcessHandlerClient.class);
    private final RuntimeService runtimeService;
    private final ProcessUtils processUtils;
    private final MinFlowUtils minFlowUtils;
    private final MongoTemplate mongoTemplate;
    private final FlowTimerJobMapper flowTimerJobMapper;
    private final ManagementService managementService;
    private final IdentityService identityService;
    private final ExtActProcessMapper extActProcessMapper;

    public Result signalStartProcess(String action, String dataId, DesignFormDataVo data, String formKey, String applyUserId) {
        log.info(" \u63a5\u53d7\u8868\u5355\u89e6\u53d1\u4e8b\u4ef6 formKey={}\uff0caction={}\uff0cdataId={},data={}, applyUserId={}", new Object[]{formKey, action, dataId, data, applyUserId});
        Result result = new Result();
        BaseMap params = new BaseMap();
        if (action.equals("delete") && ObjectUtils.isNotEmpty((Object)data)) {
            log.info(" \u63a5\u53d7\u8868\u5355 DesignFormDataVo = ", (Object)data.toString());
            dataId = data.getId();
            params.put("BPM_DELETE_DATA", JSON.toJSON((Object)data));
        }
        log.info(" \u63a5\u53d7\u8868\u5355 dataId = " + dataId);
        params.put(WorkFlowGlobals.BPM_DATA_ID, (Object)dataId);
        params.put("BPM_FORM_TYPE", (Object)"2");
        params.put("BPM_FORM_KEY", (Object)formKey);
        String url = "{{DOMAIN_URL}}/desform/detail/" + formKey + "/${BPM_DES_DATA_ID}?token={{TOKEN}}&taskId={{TASKID}}";
        String mobileUrl = "{{DOMAIN_URL}}/desform/detail/" + formKey + "/${BPM_DES_DATA_ID}?token={{TOKEN}}&taskId={{TASKID}}";
        params.put("BPM_FORM_CONTENT_URL", (Object)url);
        params.put("BPM_FORM_CONTENT_URL_MOBILE", (Object)mobileUrl);
        params.put("applyUserId", (Object)applyUserId);
        List formList = this.processUtils.selectProcessFormByActionAndFormCode(action, formKey);
        if (ObjectUtils.isNotEmpty((Object)formList)) {
            log.info("\u67e5\u8be2\u5339\u914d\u5230\u7684\u6d41\u7a0b\uff0cformList size = " + formList.size() + "\uff0cformList \u5185\u5bb9 = " + formList.toString());
            for (ExtActProcessForm extActProcessForm : formList) {
                String processId = extActProcessForm.getProcessId();
                ExtActProcess extActProcess = (ExtActProcess)this.extActProcessMapper.selectById((Serializable)((Object)processId));
                if (ObjectUtils.isEmpty((Object)extActProcess)) {
                    log.error(" \u89e6\u53d1\u6d41\u7a0b\u4e8b\u4ef6\u5931\u8d25\uff0c\u67e5\u8be2\u4e0d\u5230\u6d41\u7a0b\u4fe1\u606f! processId = {}", (Object)processId);
                    continue;
                }
                if (Integer.valueOf(0).equals(extActProcess.getOpenStatus())) {
                    log.warn(" \u89e6\u53d1\u6d41\u7a0b\u4e8b\u4ef6\u5931\u8d25\uff0c\u6d41\u7a0b\u672a\u5f00\u542f\u4e0d\u89e6\u53d1\u6d41\u7a0b! processId = {}", (Object)processId);
                    continue;
                }
                String startType = extActProcess.getStartType();
                if (StartTypeEnums.dateFieldEvent.name().equals(startType) || StartTypeEnums.timerEvent.name().equals(startType) || StartTypeEnums.buttonEvent.name().equals(startType)) {
                    log.info(" \u5b9a\u65f6\u7c7b\u6d41\u7a0b \u6dfb\u52a0\u6570\u636e\u65f6\u4e0d\u6267\u884c\u6d41\u7a0b! processId = {}", (Object)processId);
                    continue;
                }
                ExtActProcessNodeDeployment startNode = this.processUtils.getExtActProcessNodeDeployment(extActProcess.getId(), "start");
                if (ObjectUtils.isEmpty((Object)startNode)) {
                    log.error(" \u89e6\u53d1\u6d41\u7a0b\u4e8b\u4ef6\u5931\u8d25\uff0cstartNode\u83b7\u53d6\u4e0d\u5230! processId = {}", (Object)processId);
                    continue;
                }
                action = extActProcessForm.getTriggerAction();
                if (StringUtil.isEmpty((String)action)) {
                    log.warn(" \u65e0\u6548\u8868\u5355\u89e6\u53d1\u4e8b\u4ef6 formKey={}\uff0caction={}\uff0cdataId={}\uff0c\u4e0d\u9700\u8981\u89e6\u53d1\u6d41\u7a0b\uff01", new Object[]{formKey, action, dataId});
                    result.setMessage("\u6d41\u7a0b\u89e6\u53d1\u5931\u8d25");
                    result.setSuccess(false);
                    return result;
                }
                String signalName = this.validCondition(extActProcessForm, action, startNode, formKey, dataId, data);
                if (ObjectUtils.isEmpty((Object)signalName)) {
                    log.info(" ################### \u8868\u5355\u6570\u636e\u4e0d\u7b26\u5408\u89e6\u53d1\u6d41\u7a0b\u6761\u4ef6\uff0cformKey={}\uff0caction={}\uff0cdataId={}\uff01", new Object[]{formKey, action, dataId});
                    result.setSuccess(false);
                    result.setMessage("\u8868\u5355\u6570\u636e\u4e0d\u7b26\u5408\u89e6\u53d1\u6d41\u7a0b\u6761\u4ef6!");
                    continue;
                }
                try {
                    log.info("\u6d41\u7a0b\u542f\u52a8\u4fe1\u53f7\u540d\u79f0\uff0csignalName={}", (Object)signalName);
                    this.signalEventReceived(signalName, applyUserId, params, false);
                    result.setSuccess(true);
                    result.setMessage("\u542f\u52a8\u6210\u529f");
                    log.info("\u6d41\u7a0b\u542f\u52a8\u6210\u529f \uff01");
                }
                catch (Exception e) {
                    result.setSuccess(false);
                    result.setMessage("\u6d41\u7a0b\u89e6\u53d1\u5931\u8d25");
                    log.error(" \u6d41\u7a0b\u89e6\u53d1\u5931\u8d25, ERROR: {}", (Object)e.getMessage());
                }
            }
            this.addTimerJob(action, formKey, dataId);
        } else {
            log.warn("\u672a\u67e5\u8be2\u5339\u914d\u5230\u7684\u6d41\u7a0b\uff0cformList size = 0");
        }
        return result;
    }

    public Result buttonStartProcess(String processId, String dataId, String formKey, String inputParams, String applyUserId) {
        boolean validate;
        log.info("\u6309\u94ae\u89e6\u53d1\u4e8b\u4ef6 processId={}\uff0cinputParams={}\uff0cdataId={},formKey={}, applyUserId={}", new Object[]{processId, inputParams, dataId, formKey, applyUserId});
        Result result = new Result();
        BaseMap params = new BaseMap();
        if (StringUtil.isNotEmpty((String)formKey)) {
            params.put("BPM_FORM_TYPE", (Object)"2");
            params.put(WorkFlowGlobals.BPM_DATA_ID, (Object)dataId);
            params.put("BPM_FORM_KEY", (Object)formKey);
            String url = "{{DOMAIN_URL}}/desform/detail/" + formKey + "/${BPM_DES_DATA_ID}?token={{TOKEN}}&taskId={{TASKID}}";
            String mobileUrl = "{{DOMAIN_URL}}/desform/detail/" + formKey + "/${BPM_DES_DATA_ID}?token={{TOKEN}}&taskId={{TASKID}}";
            params.put("BPM_FORM_CONTENT_URL", (Object)url);
            params.put("BPM_FORM_CONTENT_URL_MOBILE", (Object)mobileUrl);
        }
        params.put("applyUserId", (Object)applyUserId);
        if (StringUtil.isNotEmpty((String)inputParams)) {
            JSONArray paramsArray = JSONObject.parseArray((String)inputParams);
            for (Object o : paramsArray) {
                JSONObject obj = (JSONObject)o;
                String field = obj.getString("field");
                Object value = obj.get((Object)"value");
                params.put(field, value);
            }
        }
        if (validate = this.validCondition(processId, formKey, dataId)) {
            String signalName = "button_signal:" + processId;
            try {
                this.signalEventReceived(signalName, applyUserId, params, false);
                result.setMessage("\u542f\u52a8\u6210\u529f");
            }
            catch (Exception e) {
                result.setSuccess(false);
                result.setMessage("\u6d41\u7a0b\u89e6\u53d1\u5931\u8d25");
            }
        } else {
            result.setSuccess(false);
            result.setMessage("\u6d41\u7a0b\u89e6\u53d1\u5931\u8d25,\u89e6\u53d1\u6761\u4ef6\u4e0d\u6ee1\u8db3");
        }
        return result;
    }

    public Result userStartProcess(Integer eventType, LoginUser loginUser, String applyUserId, String tenantId) {
        log.info("\u4eba\u5458\u89e6\u53d1\u4e8b\u4ef6 eventType={}\uff0cloginUser={}\uff0c applyUserId={}\uff0c tenantId={}", new Object[]{eventType, loginUser, applyUserId, tenantId});
        Result result = new Result();
        List processList = this.processUtils.getExtActProcessByStartType(StartTypeEnums.userEvent.name());
        if (ObjectUtils.isNotEmpty((Object)processList)) {
            for (ExtActProcess extActProcess : processList) {
                Map params;
                String condition;
                String expression;
                Expression compile;
                Boolean execute;
                List groups;
                String startCondition;
                ExtActProcessNode extActProcessNode;
                String nodeConfig;
                ChildAttr childAttr;
                Integer selectType;
                if (Integer.valueOf(0).equals(extActProcess.getOpenStatus()) || !eventType.equals(selectType = (childAttr = (ChildAttr)JSON.parseObject((String)(nodeConfig = (extActProcessNode = this.processUtils.getExtActProcessNode(extActProcess.getId(), "start")).getNodeConfigJson()), ChildAttr.class)).getSelectType()) || StringUtil.isNotEmpty((String)(startCondition = childAttr.getStartCondition())) && ObjectUtils.isNotEmpty((Object)(groups = JSONObject.parseArray((String)startCondition, ConditionGroup.class))) && !(execute = (Boolean)(compile = AviatorEvaluator.compile((String)(expression = MinFlowUtils.replaceCondition(condition = MinFlowUtils.getCondition(groups), params = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)loginUser), Map.class))))).execute(params)).booleanValue()) continue;
                String signalName = MessageFormat.format("{0}:{1}", selectType.equals(1) ? "user_signal:add" : "user_signal:leave", extActProcess.getProcessKey());
                BaseMap params2 = new BaseMap();
                params2.put("BPM_FORM_TYPE", (Object)"3");
                params2.put("BPM_FORM_KEY", (Object)"sys_user");
                params2.put(WorkFlowGlobals.BPM_DATA_ID, (Object)loginUser.getId());
                params2.put("applyUserId", (Object)applyUserId);
                try {
                    this.signalEventReceived(signalName, applyUserId, params2, false);
                    result.setMessage("\u542f\u52a8\u6210\u529f");
                }
                catch (Exception e) {
                    result.setSuccess(false);
                    result.setMessage("\u6d41\u7a0b\u89e6\u53d1\u5931\u8d25");
                }
            }
        }
        return result;
    }

    private boolean validCondition(String processId, String formKey, String dataId) {
        List groups;
        String nodeConfig;
        ChildAttr childAttr;
        String startCondition;
        ExtActProcess extActProcess = (ExtActProcess)this.extActProcessMapper.selectById((Serializable)((Object)processId));
        if (ObjectUtils.isEmpty((Object)extActProcess)) {
            return false;
        }
        if (Integer.valueOf(0).equals(extActProcess.getOpenStatus())) {
            return false;
        }
        ExtActProcessNode extActProcessNode = this.processUtils.getExtActProcessNode(processId, "start");
        if (ObjectUtils.isNotEmpty((Object)extActProcessNode) && StringUtil.isNotEmpty((String)(startCondition = (childAttr = (ChildAttr)JSON.parseObject((String)(nodeConfig = extActProcessNode.getNodeConfigJson()), ChildAttr.class)).getStartCondition())) && ObjectUtils.isNotEmpty((Object)(groups = JSONObject.parseArray((String)startCondition, ConditionGroup.class)))) {
            String condition = MinFlowUtils.getCondition(groups);
            DesignFormData designFormData = this.minFlowUtils.getDesignFormData(formKey, dataId);
            if (ObjectUtils.isNotEmpty((Object)designFormData)) {
                JSONObject params = designFormData.getDesformData();
                String expression = MinFlowUtils.replaceCondition(condition, (Map<String, Object>)params);
                Expression compile = AviatorEvaluator.compile((String)expression);
                return (Boolean)compile.execute((Map)params);
            }
        }
        return true;
    }

    private String validCondition(ExtActProcessForm extActProcessForm, String action, ExtActProcessNodeDeployment startNode, String formKey, String dataId, DesignFormDataVo newDesignFormData) {
        String nodeConfig = startNode.getNodeConfigJson();
        String signalName = formKey + ":" + action;
        if (StringUtil.isNotEmpty((String)nodeConfig)) {
            ChildAttr childAttr = null;
            try {
                childAttr = (ChildAttr)JSONObject.parseObject((String)nodeConfig, ChildAttr.class);
            }
            catch (Exception e) {
                JSONObject object = JSONObject.parseObject((String)nodeConfig);
                String pretty = JSON.toJSONString((Object)object, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
                log.warn(pretty);
                log.error("\u89e3\u6790\u53c2\u6570\u5f02\u5e38::" + e.getMessage(), (Throwable)e);
            }
            DesignFormData dbFormData = null;
            log.info("===================================\u5f00\u59cb\u8282\u70b9\uff0c\u89e6\u53d1\u5b57\u6bb5\u903b\u8f91===================================Start=================================== >");
            if (!TriggerActionEnums.delete.getAction().equals(action)) {
                dbFormData = this.minFlowUtils.getDesignFormData(formKey, dataId);
                Object[] conditionFields = childAttr.getConditionFields();
                if (ObjectUtils.isNotEmpty((Object)conditionFields) && action.contains(TriggerActionEnums.update.getAction())) {
                    String conditionFieldKey = Md5Util.md5Encode((String)ArrayUtil.join((Object[])conditionFields, (CharSequence)","), (String)"utf-8");
                    signalName = signalName + ":" + conditionFieldKey;
                    boolean isTrigger = false;
                    for (Object conditionField : conditionFields) {
                        JSONObject jsonObject;
                        Object valueOld = null;
                        Object valueNew = null;
                        if (ObjectUtils.isNotEmpty((Object)dbFormData)) {
                            jsonObject = dbFormData.getDesformData();
                            valueOld = jsonObject.get(conditionField);
                        }
                        if (ObjectUtils.isNotEmpty((Object)newDesignFormData)) {
                            jsonObject = newDesignFormData.getDesformData();
                            valueNew = jsonObject.get(conditionField);
                        }
                        if (ObjectUtils.isNotEmpty(valueOld) && ObjectUtils.isNotEmpty(valueNew)) {
                            if (!valueOld.equals(valueNew)) {
                                isTrigger = true;
                            } else {
                                log.info("\u4e0d\u6ee1\u8db3\u66f4\u65b0\u89e6\u53d1\u5b57\u6bb5\u6761\u4ef6 valueOld={}\uff0cvalueNew={}", valueOld, valueNew);
                            }
                        }
                        if (ObjectUtils.isNotEmpty((Object)valueOld) && ObjectUtils.isEmpty((Object)valueNew)) {
                            isTrigger = true;
                        }
                        if (!ObjectUtils.isEmpty((Object)valueOld) || !ObjectUtils.isNotEmpty((Object)valueNew)) continue;
                        isTrigger = true;
                    }
                    if (!isTrigger) {
                        log.info("\u4e0d\u6ee1\u8db3\u66f4\u65b0\u89e6\u53d1\u5b57\u6bb5\u6761\u4ef6,\u503c\u5bf9\u6bd4\u672a\u901a\u8fc7! ");
                        return null;
                    }
                }
            }
            log.info("===================================\u5f00\u59cb\u8282\u70b9\uff0c\u89e6\u53d1\u5b57\u6bb5\u903b\u8f91===================================Start=================================== >");
            log.info("");
            log.info("===================================\u5f00\u59cb\u8282\u70b9\uff0c\u89e6\u53d1\u6761\u4ef6\u903b\u8f91===================================Start=================================== >");
            String startCondition = childAttr.getStartCondition();
            List<?> list = this.queryDesformDataByStartCondition(startCondition, formKey, dataId, action);
            if (ObjectUtils.isEmpty(list)) {
                log.info("\u5339\u914d\u4e0d\u5230\u6570\u636e\uff0c\u4e0d\u6ee1\u8db3\u89e6\u53d1\u6761\u4ef6\uff01 startCondition={}\uff0cformKey={}, dataId={}", new Object[]{startCondition, formKey, dataId});
                return null;
            }
            log.info("\u6ee1\u8db3\u89e6\u53d1\u6761\u4ef6\uff0c\u8fdb\u5165\u6d41\u7a0b\u89e6\u53d1\uff01 startCondition={}\uff0cformKey={}, dataId={}", new Object[]{startCondition, formKey, dataId});
            List groups = JSONObject.parseArray((String)startCondition, ConditionGroup.class);
            if (ObjectUtils.isNotEmpty((Object)groups)) {
                String conditionKey = Md5Util.md5Encode((String)startCondition, (String)"utf-8");
                signalName = signalName + ":" + conditionKey;
                log.debug("\u4fe1\u53f7\u540d\u79f0, signalName={}", (Object)signalName);
            }
            log.info("===================================\u5f00\u59cb\u8282\u70b9\uff0c\u89e6\u53d1\u6761\u4ef6\u903b\u8f91===================================End=================================== >");
        }
        if (ObjectUtils.isNotEmpty((Object)extActProcessForm.getStartSignalName())) {
            signalName = extActProcessForm.getStartSignalName();
        }
        return signalName;
    }

    private List<?> queryDesformDataByStartCondition(String startCondition, String formKey, String dataId, String action) {
        DesformSuperQuery desformSuperQuery = this.minFlowUtils.getDesformSuperQuery(startCondition);
        if (ObjectUtils.isEmpty((Object)desformSuperQuery)) {
            desformSuperQuery = new DesformSuperQuery();
        }
        log.info("---\u5f00\u59cb\u8282\u70b9\u89e6\u53d1\u6761\u4ef6\uff0c\u67e5\u8be2\u89c4\u5219\uff1a {} ", (Object)desformSuperQuery.getMatchType());
        log.info("---\u5f00\u59cb\u8282\u70b9\u89e6\u53d1\u6761\u4ef6\uff0c\u67e5\u8be2\u6761\u4ef6\uff1a {} ", (Object)desformSuperQuery.toString());
        this.minFlowUtils.replaceStartCondition(formKey, dataId, desformSuperQuery);
        SuperQueryItem superQueryItem = new SuperQueryItem("", "_id", dataId, QueryRuleEnum.EQ);
        desformSuperQuery.getQueryItems().add(superQueryItem);
        if (TriggerActionEnums.delete.getAction().equals(action)) {
            SuperQueryItem delQueryItem = new SuperQueryItem("", "del_flag", "1", QueryRuleEnum.EQ);
            desformSuperQuery.getQueryItems().add(delQueryItem);
            log.info("---\u5f00\u59cb\u8282\u70b9\u89e6\u53d1\u6761\u4ef6\uff0c\u5220\u9664\u89e6\u53d1 \u52a0\u5165\u67e5\u8be2\u5220\u9664\u6570\u636e\u6761\u4ef6\uff01");
        }
        Query query = DesformQueryUtils.fillMongoQuery((DesformSuperQuery)desformSuperQuery);
        log.info("mongodb \u67e5\u8be2\u6761\u4ef6\uff0cdesformCode\uff1a{}\uff0cquery\uff1a{}", (Object)formKey, (Object)query);
        List list = this.mongoTemplate.find(query, Document.class, formKey).stream().map(document -> new DesignFormData(formKey, document)).collect(Collectors.toList());
        log.info("---\u5f00\u59cb\u8282\u70b9\u89e6\u53d1\u6761\u4ef6\uff0c\u67e5\u8be2\u7ed3\u679c size \uff1a{}", (Object)list.size());
        log.info("---\u5f00\u59cb\u8282\u70b9\u89e6\u53d1\u6761\u4ef6\uff0c\u67e5\u8be2\u7ed3\u679c data \uff1a{}", (Object)list.toString());
        return list;
    }

    public void signalEventReceived(String signalName, String userid, BaseMap params, Boolean useMq) {
        log.info(" ---- \u8c03\u7528flowable api\u89e6\u53d1\u6d41\u7a0b ---- ");
        this.identityService.setAuthenticatedUserId(userid);
        this.runtimeService.signalEventReceived(signalName, (Map)params);
    }

    public void addTimerJob(String action, String formKey, String dataId) {
        List<ExtActProcess> list = this.flowTimerJobMapper.selectHasJobProcess(formKey);
        if (ObjectUtils.isNotEmpty(list)) {
            for (ExtActProcess extActProcess : list) {
                String jobId;
                Map timerJob;
                String startType = extActProcess.getStartType();
                if (!StartTypeEnums.dateFieldEvent.name().equals(startType)) continue;
                ExtActProcessNode extActProcessNode = this.processUtils.getExtActProcessNode(extActProcess.getId(), "start");
                String nodeConfig = extActProcessNode.getNodeConfigJson();
                ChildAttr childAttr = (ChildAttr)JSON.parseObject((String)nodeConfig, ChildAttr.class);
                String processKey = extActProcess.getProcessKey();
                log.info("formKey={} , dataId={}", (Object)formKey, (Object)dataId);
                DesignFormData designFormData = this.minFlowUtils.getDesignFormData(formKey, dataId);
                log.info("minFlowUtils \u67e5\u8be2\u8868\u5355\u6570\u636e = {}", (Object)designFormData);
                if (!StringUtil.isNotEmpty((String)action)) continue;
                if (action.contains("add")) {
                    this.minFlowUtils.addTimerJob(designFormData, childAttr, processKey);
                }
                if (action.contains("delete") && ObjectUtils.isNotEmpty((Object)(timerJob = this.minFlowUtils.getTimerJob(processKey, dataId)))) {
                    jobId = MapUtil.getStr((Map)timerJob, (Object)"ID_");
                    this.managementService.deleteTimerJob(jobId);
                }
                if (!action.contains("update")) continue;
                timerJob = this.minFlowUtils.getTimerJob(processKey, dataId);
                if (ObjectUtils.isNotEmpty((Object)timerJob)) {
                    jobId = MapUtil.getStr((Map)timerJob, (Object)"ID_");
                    this.managementService.deleteTimerJob(jobId);
                }
                this.minFlowUtils.addTimerJob(designFormData, childAttr, processKey);
            }
        }
    }

    public ProcessHandlerClient(RuntimeService runtimeService, ProcessUtils processUtils, MinFlowUtils minFlowUtils, MongoTemplate mongoTemplate, FlowTimerJobMapper flowTimerJobMapper, ManagementService managementService, IdentityService identityService, ExtActProcessMapper extActProcessMapper) {
        this.runtimeService = runtimeService;
        this.processUtils = processUtils;
        this.minFlowUtils = minFlowUtils;
        this.mongoTemplate = mongoTemplate;
        this.flowTimerJobMapper = flowTimerJobMapper;
        this.managementService = managementService;
        this.identityService = identityService;
        this.extActProcessMapper = extActProcessMapper;
    }
}

