/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.adapter.job;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.flowable.engine.RuntimeService;
import org.jeecg.common.system.query.QueryRuleEnum;
import org.jeecg.common.util.DateUtils;
import org.jeecg.modules.extbpm.process.adapter.entity.ChildAttr;
import org.jeecg.modules.extbpm.process.adapter.enums.StartTypeEnums;
import org.jeecg.modules.extbpm.process.adapter.mapper.FlowTimerJobMapper;
import org.jeecg.modules.extbpm.process.adapter.mq.utils.MinFlowUtils;
import org.jeecg.modules.extbpm.process.entity.ExtActProcess;
import org.jeecg.modules.extbpm.process.entity.ExtActProcessNode;
import org.jeecg.modules.joa.util.ProcessUtils;
import org.jeecg.modules.online.desform.entity.DesignFormData;
import org.jeecg.modules.online.desform.service.IDesignFormDataService;
import org.jeecg.modules.online.desform.vo.query.DesformSuperQuery;
import org.jeecg.modules.online.desform.vo.query.SuperQueryItem;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DateFieldTriggerProcessJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(DateFieldTriggerProcessJob.class);
    @Autowired
    private ProcessUtils processUtils;
    @Autowired
    private MinFlowUtils minFlowUtils;
    @Autowired
    public IDesignFormDataService designFormDataService;
    @Autowired
    public RuntimeService runtimeService;
    @Autowired
    private FlowTimerJobMapper flowTimerJobMapper;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        log.info(String.format(" Jeecg-Boot \u53d1\u9001\u6d88\u606f\u4efb\u52a1 DateFieldTriggerProcessJob !  \u65f6\u95f4:" + DateUtils.getTimestamp(), new Object[0]));
        List processList = this.processUtils.getExtActProcessByStartType(StartTypeEnums.dateFieldEvent.name());
        if (ObjectUtils.isNotEmpty((Object)processList)) {
            for (ExtActProcess extActProcess : processList) {
                ExtActProcessNode extActProcessNode = this.processUtils.getExtActProcessNode(extActProcess.getId(), "start");
                String nodeConfig = extActProcessNode.getNodeConfigJson();
                ChildAttr childAttr = (ChildAttr)JSON.parseObject((String)nodeConfig, ChildAttr.class);
                String formTableCode = childAttr.getFormTableCode();
                String processKey = extActProcess.getProcessKey();
                DesformSuperQuery desformSuperQuery = this.getDesformSuperQuery(childAttr);
                List list = this.designFormDataService.list(formTableCode, desformSuperQuery);
                if (!ObjectUtils.isNotEmpty((Object)list)) continue;
                for (DesignFormData designFormData : list) {
                    this.minFlowUtils.addTimerJob(designFormData, childAttr, processKey);
                }
            }
        }
    }

    private DesformSuperQuery getDesformSuperQuery(ChildAttr childAttr) {
        String triggerField = childAttr.getTriggerField();
        Integer executeType = childAttr.getExecuteType();
        Integer plusDate = childAttr.getPlusDate();
        Integer plusDateUnit = childAttr.getPlusDateUnit();
        DesformSuperQuery desformSuperQuery = this.minFlowUtils.getDesformSuperQuery(childAttr.getStartCondition());
        try {
            Date data1 = DateUtils.parseDate((String)DateUtils.getDate((String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
            Date data2 = org.apache.commons.lang3.time.DateUtils.addDays((Date)data1, (int)1);
            if (executeType.equals(2) && plusDateUnit.equals(3)) {
                data1 = org.apache.commons.lang3.time.DateUtils.addDays((Date)data1, (int)plusDate);
                data2 = org.apache.commons.lang3.time.DateUtils.addDays((Date)data1, (int)(plusDate + 1));
            }
            SuperQueryItem superQueryItem = new SuperQueryItem("", triggerField, data1.getTime() + "", QueryRuleEnum.GE);
            SuperQueryItem superQueryItem2 = new SuperQueryItem("", triggerField, data2.getTime() + "", QueryRuleEnum.LT);
            desformSuperQuery.getQueryItems().add(superQueryItem);
            desformSuperQuery.getQueryItems().add(superQueryItem2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return desformSuperQuery;
    }

    public static void main(String[] args) {
        try {
            Date data1 = DateUtils.parseDate((String)"2022-12-24", (String)"yyyy-MM-dd");
            Date data2 = org.apache.commons.lang3.time.DateUtils.addDays((Date)data1, (int)1);
            System.out.println(data1.getTime());
            System.out.println(data2.getTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

