/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.adapter.delegate.datahandle;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.JavaDelegate;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryRuleEnum;
import org.jeecg.modules.extbpm.process.adapter.delegate.datahandle.BaseDataDelegate;
import org.jeecg.modules.extbpm.process.adapter.entity.ChildAttr;
import org.jeecg.modules.extbpm.process.adapter.enums.SelectTypeEnums;
import org.jeecg.modules.extbpm.process.common.WorkFlowGlobals;
import org.jeecg.modules.minides.enums.FormTableTypeEnums;
import org.jeecg.modules.minides.enums.GetDataTypeEnums;
import org.jeecg.modules.online.desform.entity.DesignFormData;
import org.jeecg.modules.online.desform.vo.query.DesformSuperQuery;
import org.jeecg.modules.online.desform.vo.query.SuperQueryItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GetMoreRecordDelegate
extends BaseDataDelegate
implements JavaDelegate {
    private static final Logger log = LoggerFactory.getLogger(GetMoreRecordDelegate.class);

    public void execute(DelegateExecution delegateExecution) {
        boolean init = this.init(delegateExecution);
        if (init) {
            List<DesignFormData> records = null;
            Integer selectType = this.childAttr.getSelectType();
            String formTableSourceTaskId = this.childAttr.getFormTableSourceTaskId();
            if (SelectTypeEnums.table.getType().equals(selectType)) {
                records = this.executeQuery();
            }
            if (SelectTypeEnums.link_field.getType().equals(selectType)) {
                String dataId;
                String formDataSourceKey;
                String formTableSourceNodeType = this.childAttr.getFormTableSourceNodeType();
                if (FormTableTypeEnums.plus.name().equals(formTableSourceNodeType)) {
                    formDataSourceKey = MessageFormat.format("flow:task:form_data:{0}:{1}", this.processInstanceId, formTableSourceTaskId);
                    dataId = (String)delegateExecution.getVariable(formDataSourceKey, String.class);
                    records = this.getRecords(this.childAttr, dataId, null);
                }
                if (FormTableTypeEnums.table.name().equals(formTableSourceNodeType)) {
                    String dataId2 = (String)delegateExecution.getVariable(WorkFlowGlobals.BPM_DATA_ID, String.class);
                    DesignFormData designFormData = this.getStartDesFormData(this.childAttr.getFormTableCode());
                    records = this.getRecords(this.childAttr, dataId2, designFormData);
                }
                if (FormTableTypeEnums.search.name().equals(formTableSourceNodeType)) {
                    formDataSourceKey = MessageFormat.format("flow:task:get_data:{0}:{1}", this.processInstanceId, formTableSourceTaskId);
                    dataId = (String)delegateExecution.getVariable(formDataSourceKey, String.class);
                    records = this.getRecords(this.childAttr, dataId, null);
                }
            }
            if (SelectTypeEnums.plus.getType().equals(selectType)) {
                String formDataSourceKey = MessageFormat.format("flow:task:get_data:{0}:{1}", this.processInstanceId, formTableSourceTaskId);
                records = this.queryRedisData(formDataSourceKey);
            }
            if (ObjectUtils.isNotEmpty(records)) {
                Integer getDataType = this.childAttr.getGetDataType();
                String formDataKey = MessageFormat.format("flow:task:get_data:{0}:{1}", this.processInstanceId, this.activityId);
                List dataIds = records.stream().map(DesignFormData::getId).collect(Collectors.toList());
                dataIds = dataIds.stream().distinct().collect(Collectors.toList());
                if (getDataType.equals(GetDataTypeEnums.from_redis.getType())) {
                    String redisFormDataKey = MessageFormat.format("flow:task:redis_get_data:{0}:{1}", this.processInstanceId, this.activityId);
                    this.redisUtil.set(redisFormDataKey, records);
                    delegateExecution.setVariable(formDataKey, (Object)redisFormDataKey);
                    log.info("------------\u83b7\u53d6\u591a\u6761\u6570\u636e\u8282\u70b9,\u5b58\u50a8\u6570\u636e\u5230redis:--------------");
                }
                if (getDataType.equals(GetDataTypeEnums.from_db.getType())) {
                    delegateExecution.setVariable(formDataKey, dataIds);
                    log.info("------------\u83b7\u53d6\u591a\u6761\u6570\u636e\u8282\u70b9: {}--------------", dataIds);
                }
                delegateExecution.setVariable("assigneeDataIdList", (Object)StringUtils.join(dataIds, (String)","));
            }
        }
    }

    private List<DesignFormData> getRecords(ChildAttr childAttr, String dataId, DesignFormData formData) {
        JSONArray jsonArray;
        JSONObject jsonObject;
        List<Object> records = new ArrayList<DesignFormData>();
        String formTableCode = childAttr.getFormTableCode();
        String linkFormTableCode = childAttr.getLinkFormTableCode();
        String linkFormTableField = childAttr.getLinkFormTableField();
        DesignFormData designFormData = this.designFormDataService.getById(formTableCode, dataId);
        if (ObjectUtils.isEmpty((Object)designFormData)) {
            designFormData = formData;
        }
        if (ObjectUtils.isNotEmpty((Object)designFormData) && ObjectUtils.isNotEmpty((Object)(jsonObject = designFormData.getDesformData())) && ObjectUtils.isNotEmpty((Object)(jsonArray = jsonObject.getJSONArray(linkFormTableField)))) {
            Integer linkFormTableType = childAttr.getLinkFormTableType();
            if (ObjectUtils.isNotEmpty((Object)linkFormTableType) && linkFormTableType.equals(2)) {
                for (Object o : jsonArray) {
                    JSONObject obj = (JSONObject)o;
                    DesignFormData data = new DesignFormData();
                    data.setDesformData(obj);
                    data.setId(dataId);
                    data.setDesformCode(linkFormTableCode);
                    records.add(data);
                }
            } else {
                List<OrderItem> orderItems;
                DesformSuperQuery desformSuperQuery = this.initSuperQuery();
                SuperQueryItem superQueryItem = new SuperQueryItem("", "_id", StringUtils.join((Iterable)jsonArray, (String)","), QueryRuleEnum.IN);
                desformSuperQuery.getQueryItems().add(superQueryItem);
                Page page = new Page();
                Long limitNum = ObjectUtils.isEmpty((Object)childAttr.getLimitNum()) ? 100L : childAttr.getLimitNum();
                if (ObjectUtils.isNotEmpty((Object)limitNum)) {
                    page.setSize(limitNum.longValue());
                }
                if (ObjectUtils.isNotEmpty(orderItems = GetMoreRecordDelegate.getQueryConditionOrders(childAttr))) {
                    page.setOrders(orderItems);
                }
                Result pageList = this.designFormDataService.pageList(linkFormTableCode, page, desformSuperQuery);
                IPage result = (IPage)pageList.getResult();
                records = result.getRecords();
            }
        }
        return records;
    }
}

