/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.adapter.delegate.datahandle;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.JavaDelegate;
import org.jeecg.modules.extbpm.process.adapter.delegate.datahandle.BaseDataDelegate;
import org.jeecg.modules.extbpm.process.common.WorkFlowGlobals;
import org.jeecg.modules.minides.enums.FormTableTypeEnums;
import org.jeecg.modules.minides.enums.GetDataTypeEnums;
import org.jeecg.modules.online.desform.entity.DesignFormData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="deleteRecordDelegate")
public class DeleteRecordDelegate
extends BaseDataDelegate
implements JavaDelegate {
    private static final Logger log = LoggerFactory.getLogger(DeleteRecordDelegate.class);

    public void execute(DelegateExecution delegateExecution) {
        boolean init = this.init(delegateExecution);
        if (init) {
            String formTableSourceNodeType = this.childAttr.getFormTableSourceNodeType();
            String formTableSourceTaskId = this.childAttr.getFormTableSourceTaskId();
            List<String> dataIds = new ArrayList<String>();
            if (FormTableTypeEnums.table.name().equals(formTableSourceNodeType)) {
                String dataId = (String)delegateExecution.getVariable(WorkFlowGlobals.BPM_DATA_ID, String.class);
                if (StringUtil.isNotEmpty((String)dataId)) {
                    dataIds.add(dataId);
                }
            } else if (FormTableTypeEnums.plus.name().equals(formTableSourceNodeType)) {
                String formDataSourceKey = MessageFormat.format("flow:task:form_data:{0}:{1}", this.processInstanceId, formTableSourceTaskId);
                String dataId = (String)delegateExecution.getVariable(formDataSourceKey, String.class);
                if (StringUtil.isNotEmpty((String)dataId)) {
                    dataIds.add(dataId);
                }
            } else if (FormTableTypeEnums.search.name().equals(formTableSourceNodeType)) {
                String formDataSourceKey = MessageFormat.format("flow:task:get_data:{0}:{1}", this.processInstanceId, formTableSourceTaskId);
                String dataId = (String)delegateExecution.getVariable(formDataSourceKey, String.class);
                if (StringUtil.isNotEmpty((String)dataId)) {
                    dataIds.add(dataId);
                }
            } else if (FormTableTypeEnums.getMore.name().equals(formTableSourceNodeType)) {
                List records;
                String dataKey;
                Integer getDataType = this.childAttr.getFormTableSourceGetDataType();
                String formDataSourceKey = MessageFormat.format("flow:task:get_data:{0}:{1}", this.processInstanceId, formTableSourceTaskId);
                if (GetDataTypeEnums.from_redis.getType().equals(getDataType) && StringUtil.isNotEmpty((String)(dataKey = (String)delegateExecution.getVariable(formDataSourceKey, String.class))) && ObjectUtils.isNotEmpty((Object)(records = (List)this.redisUtil.get(dataKey)))) {
                    dataIds = records.stream().map(DesignFormData::getId).collect(Collectors.toList());
                }
                if (GetDataTypeEnums.from_db.getType().equals(getDataType)) {
                    dataIds = (List)delegateExecution.getVariable(formDataSourceKey, List.class);
                }
            }
            if (ObjectUtils.isNotEmpty(dataIds)) {
                log.info("------------\u5220\u9664\u6570\u636e\u8282\u70b9: {}--------------", dataIds);
                this.designFormDataService.removeBatchByIds(this.childAttr.getFormTableCode(), dataIds);
            }
        }
    }
}

