/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.adapter.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jeecg.common.api.CommonAPI;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.TokenUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.JeecgBaseConfig;
import org.jeecg.modules.extbpm.process.adapter.model.MiniDesRequest;
import org.jeecg.modules.extbpm.process.entity.ExtActFlowData;
import org.jeecg.modules.extbpm.process.entity.ExtActProcess;
import org.jeecg.modules.extbpm.process.service.IExtActFlowDataService;
import org.jeecg.modules.joa.util.ProcessUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller(value="miniDesFlowIndexController")
@RequestMapping(value={"/act/designer/miniDesFlow"})
public class MiniDesFlowIndexController {
    private static final Logger log = LoggerFactory.getLogger(MiniDesFlowIndexController.class);
    private static final Log logger = LogFactory.getLog(MiniDesFlowIndexController.class);
    @Lazy
    @Autowired
    private ISysBaseAPI sysBaseApi;
    @Lazy
    @Autowired
    private RedisUtil redisUtil;
    private static final String DESIGN_INDEX = "joa/miniDesFlow/index";
    private static final String PROCESS_ID = "id";
    private static final String REAL_PROC_DEF_ID = "realProcDefId";
    private static final String TYPE_ID = "typeid";
    @Autowired
    private JeecgBaseConfig jeecgBaseConfig;
    @Autowired
    private IExtActFlowDataService extActFlowDataService;
    @Autowired
    private ProcessUtils processUtils;

    @RequestMapping(value={"/index"})
    public String index(HttpServletRequest request, Model map, MiniDesRequest miniDesRequest) {
        logger.info((Object)(" index \u767b\u5f55\u4ee4\u724ctoken\uff1a " + miniDesRequest.getToken()));
        TokenUtils.verifyToken((HttpServletRequest)request, (CommonAPI)this.sysBaseApi, (RedisUtil)this.redisUtil);
        String domianURL = this.getBaseUrl(request);
        String lowAppId = request.getParameter("lowAppId");
        if (oConvertUtils.isNotEmpty((Object)lowAppId)) {
            map.addAttribute("lowAppId", (Object)lowAppId);
        }
        map.addAttribute("token", (Object)miniDesRequest.getToken());
        map.addAttribute("tenantId", (Object)miniDesRequest.getTenantId());
        map.addAttribute("preview", (Object)"false");
        map.addAttribute("domianURL", (Object)domianURL);
        map.addAttribute("signatureSecret", (Object)this.jeecgBaseConfig.getSignatureSecret());
        map.addAttribute("startType", (Object)miniDesRequest.getStartType());
        map.addAttribute("signName", (Object)miniDesRequest.getSignName());
        map.addAttribute("customProcessId", (Object)miniDesRequest.getProcessId());
        map.addAttribute("formCode", (Object)miniDesRequest.getFormCode());
        map.addAttribute("formName", (Object)miniDesRequest.getFormName());
        map.addAttribute("formTableId", (Object)miniDesRequest.getFormTableId());
        map.addAttribute("subFormTableObject", (Object)miniDesRequest.getSubFormTableObject());
        map.addAttribute("isLowApp", (Object)miniDesRequest.getIsLowApp());
        map.addAttribute(TYPE_ID, (Object)"oa");
        map.addAttribute(PROCESS_ID, (Object)miniDesRequest.getId());
        map.addAttribute(REAL_PROC_DEF_ID, (Object)miniDesRequest.getRealProcDefId());
        return DESIGN_INDEX;
    }

    @RequestMapping(value={"/preview"})
    public String preview(HttpServletRequest request, MiniDesRequest miniDesRequest, Model map) {
        logger.info((Object)(" index \u767b\u5f55\u4ee4\u724ctoken\uff1a " + miniDesRequest.getToken()));
        TokenUtils.verifyToken((HttpServletRequest)request, (CommonAPI)this.sysBaseApi, (RedisUtil)this.redisUtil);
        String domianURL = this.getBaseUrl(request);
        map.addAttribute("token", (Object)miniDesRequest.getToken());
        map.addAttribute("preview", (Object)"true");
        map.addAttribute("startType", (Object)"");
        map.addAttribute("domianURL", (Object)domianURL);
        map.addAttribute("signatureSecret", (Object)this.jeecgBaseConfig.getSignatureSecret());
        ExtActFlowData extActFlowData = this.getExtActFlowData(miniDesRequest.getFlowCode(), miniDesRequest.getDataId());
        String instanceId = "";
        String processId = "";
        if (ObjectUtils.isNotEmpty((Object)extActFlowData)) {
            instanceId = extActFlowData.getProcessInstId();
            ExtActProcess extActProcess = this.processUtils.getExtActProcessByProcessKey(extActFlowData.getProcessKey());
            if (ObjectUtils.isNotEmpty((Object)extActProcess)) {
                processId = extActProcess.getId();
            }
        }
        map.addAttribute("instanceId", (Object)instanceId);
        map.addAttribute(TYPE_ID, (Object)"oa");
        map.addAttribute(PROCESS_ID, (Object)processId);
        map.addAttribute(REAL_PROC_DEF_ID, (Object)"");
        return DESIGN_INDEX;
    }

    private String getBaseUrl(HttpServletRequest request) {
        String xGatewayBasePath = request.getHeader("X_GATEWAY_BASE_PATH");
        if (oConvertUtils.isNotEmpty((Object)xGatewayBasePath)) {
            log.info("x_gateway_base_path = " + xGatewayBasePath);
            return xGatewayBasePath;
        }
        String scheme = request.getHeader("X-Forwarded-Scheme");
        if (oConvertUtils.isEmpty((Object)scheme)) {
            scheme = request.getScheme();
        }
        String serverName = request.getServerName();
        int serverPort = request.getServerPort();
        String contextPath = request.getContextPath();
        String baseDomainPath = null;
        baseDomainPath = 80 == serverPort ? scheme + "://" + serverName + contextPath : scheme + "://" + serverName + ":" + serverPort + contextPath;
        log.info("================getBaseUrl==============: " + baseDomainPath);
        return baseDomainPath;
    }

    private ExtActFlowData getExtActFlowData(String flowCode, String dataId) {
        LambdaQueryWrapper var5 = new LambdaQueryWrapper();
        var5.eq(ExtActFlowData::getRelationCode, (Object)flowCode);
        var5.eq(ExtActFlowData::getFormDataId, (Object)dataId);
        ExtActFlowData extActFlowData = (ExtActFlowData)this.extActFlowDataService.getOne((Wrapper)var5);
        return extActFlowData;
    }
}

