/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.adapter.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtil;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.miniflow.ISignalProcessStartApi;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.TokenUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.extbpm.process.adapter.DesignerAdapterUtil;
import org.jeecg.modules.extbpm.process.adapter.entity.ChildAttr;
import org.jeecg.modules.extbpm.process.adapter.entity.MyExtActProcess;
import org.jeecg.modules.extbpm.process.adapter.enums.StartTypeEnums;
import org.jeecg.modules.extbpm.process.adapter.enums.TriggerActionEnums;
import org.jeecg.modules.extbpm.process.adapter.mapper.MyExtActProcessMapper;
import org.jeecg.modules.extbpm.process.adapter.mq.utils.MinFlowUtils;
import org.jeecg.modules.extbpm.process.entity.ExtActProcess;
import org.jeecg.modules.extbpm.process.entity.ExtActProcessForm;
import org.jeecg.modules.extbpm.process.entity.ExtActProcessNode;
import org.jeecg.modules.extbpm.process.mapper.ExtActProcessNodeMapper;
import org.jeecg.modules.extbpm.process.service.IExtActProcessFormService;
import org.jeecg.modules.extbpm.process.service.IExtActProcessNodeService;
import org.jeecg.modules.joa.util.ProcessUtils;
import org.jeecg.modules.online.desform.entity.DesignFormData;
import org.jeecg.modules.online.desform.service.IDesignFormDataService;
import org.jeecgframework.designer.vo.AjaxJson;
import org.quartz.TriggerUtils;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.OperableTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="miniDesFlowController")
@RequestMapping(value={"/act/designer/miniDesFlow/api"})
public class MiniDesFlowController {
    private static final Logger log = LoggerFactory.getLogger(MiniDesFlowController.class);
    @Autowired
    private MyExtActProcessMapper extActProcessMapper;
    @Autowired
    private ExtActProcessNodeMapper extActProcessNodeMapper;
    @Autowired
    private IExtActProcessFormService extActProcessFormService;
    @Autowired
    private IExtActProcessNodeService extActProcessNodeService;
    @Autowired
    private ISignalProcessStartApi signalProcessStartApi;
    @Autowired
    private ProcessUtils processUtils;
    @Autowired
    private MinFlowUtils minFlowUtils;
    @Autowired
    public IDesignFormDataService designFormDataService;

    @GetMapping(value={"/getProcess"})
    @ResponseBody
    public Result<MyExtActProcess> getProcess(@RequestParam(value="processId") String processId) {
        MyExtActProcess myExtActProcess = (MyExtActProcess)((Object)this.extActProcessMapper.selectById((Serializable)((Object)processId)));
        return Result.ok((Object)((Object)myExtActProcess));
    }

    @GetMapping(value={"/processList"})
    @ResponseBody
    public Result<List<MyExtActProcess>> processList(@RequestParam(value="startType", required=false) String startType) {
        QueryWrapper qw = new QueryWrapper();
        qw.select(new String[]{"id", "process_name", "process_key"});
        qw.lambda().eq(StringUtil.isNotEmpty((String)startType), ExtActProcess::getStartType, (Object)startType);
        List list = this.extActProcessMapper.selectList((Wrapper)qw);
        return Result.ok((Object)list);
    }

    @RequestMapping(value={"/saveFlow"})
    @ResponseBody
    public Result saveFlow(HttpServletRequest request, MyExtActProcess extActProcess) throws Exception {
        List delIds;
        ExtActProcessForm updateObj;
        Result result = new Result();
        String processDefinitionId = extActProcess.getId();
        String customProcessId = extActProcess.getCustomProcessId();
        ArrayList<ExtActProcessNode> extActProcessNodes = new ArrayList<ExtActProcessNode>();
        ExtActProcessForm extActProcessForm = new ExtActProcessForm();
        String startType = extActProcess.getStartType();
        if (ObjectUtils.isNotEmpty((Object)startType) && StartTypeEnums.buttonEvent.name().equals(startType) && ObjectUtils.isEmpty((Object)customProcessId) && ObjectUtils.isEmpty((Object)extActProcess.getId())) {
            extActProcess.setId(IdWorker.getIdStr());
        }
        if (ObjectUtils.isNotEmpty((Object)extActProcess.getId()) && ObjectUtils.isNotEmpty((Object)(updateObj = this.processUtils.selectProcessFormByProcessId(extActProcess.getId())))) {
            extActProcessForm.setId(updateObj.getId());
        }
        if (ObjectUtils.isEmpty((Object)extActProcessForm.getId())) {
            String extActProcessFormId = IdWorker.getIdStr();
            extActProcessForm.setId(extActProcessFormId);
        }
        String lowAppId = TokenUtils.getLowAppIdByRequest((HttpServletRequest)request);
        String tenantId = TokenUtils.getTenantIdByRequest((HttpServletRequest)request);
        String xml = DesignerAdapterUtil.JSONToBPMN(extActProcess, extActProcessForm, extActProcessNodes, tenantId);
        log.info(" lowAppId \uff1a" + lowAppId);
        log.info(" tenantId \uff1a" + tenantId);
        if (StringUtil.isNotEmpty((String)customProcessId)) {
            MyExtActProcess check = (MyExtActProcess)((Object)this.extActProcessMapper.selectById((Serializable)((Object)customProcessId)));
            processDefinitionId = ObjectUtils.isNotEmpty((Object)((Object)check)) ? customProcessId : null;
        }
        if (StartTypeEnums.subEvent.name().equals(startType)) {
            extActProcess.setProcessKey("process" + extActProcess.getCustomProcessId());
        }
        if (StringUtil.isNotEmpty((String)processDefinitionId)) {
            extActProcess.setNote(null);
            extActProcess.setProcessXml(xml.getBytes());
            this.extActProcessMapper.updateById((Object)extActProcess);
            result.setResult((Object)extActProcess.getId());
            result.setMessage("\u6d41\u7a0b\u4fee\u6539\u6210\u529f");
        } else {
            if (ObjectUtils.isNotEmpty((Object)extActProcess.getCustomProcessId())) {
                extActProcess.setId(extActProcess.getCustomProcessId());
            }
            extActProcess.setProcessStatus(0);
            extActProcess.setOpenStatus(Integer.parseInt("1"));
            System.out.println(xml);
            if (oConvertUtils.isNotEmpty((Object)lowAppId) && !"undefined".equals(lowAppId)) {
                extActProcess.setLowAppId(lowAppId);
            }
            if (oConvertUtils.isNotEmpty((Object)tenantId)) {
                extActProcess.setTenantId(Integer.parseInt(tenantId));
            }
            extActProcess.setProcessXml(xml.getBytes());
            this.extActProcessMapper.insert((Object)extActProcess);
            result.setMessage("\u6d41\u7a0b\u521b\u5efa\u6210\u529f");
            result.setResult((Object)extActProcess.getId());
        }
        if (StringUtil.isNotEmpty((String)extActProcessForm.getFormTableName()) && !StartTypeEnums.subEvent.name().equals(startType)) {
            String relationCode = "";
            if (!StartTypeEnums.userEvent.name().equals(startType)) {
                relationCode = relationCode + "desform_";
            }
            relationCode = relationCode + extActProcessForm.getFormTableName() + "_" + extActProcess.getId();
            extActProcessForm.setProcessId(extActProcess.getId());
            extActProcessForm.setRelationCode(relationCode);
            this.extActProcessFormService.saveOrUpdate((Object)extActProcessForm);
        }
        ArrayList<String> updateIds = new ArrayList<String>();
        List nodesIds = this.processUtils.selectProcessNodeIds(processDefinitionId);
        if (ObjectUtils.isNotEmpty(extActProcessNodes)) {
            String processKey = extActProcess.getProcessKey();
            for (ExtActProcessNode extActProcessNode : extActProcessNodes) {
                String nodeCode = extActProcessNode.getProcessNodeCode();
                ExtActProcessNode check = this.extActProcessNodeMapper.queryByNodeCodeAndProcessKey(processKey, nodeCode);
                if (check == null) {
                    extActProcessNode.setProcessId(extActProcess.getId());
                    this.extActProcessNodeMapper.insert((Object)extActProcessNode);
                    continue;
                }
                extActProcessNode.setId(check.getId());
                extActProcessNode.setProcessId(extActProcess.getId());
                updateIds.add(extActProcessNode.getId());
                this.extActProcessNodeMapper.updateById((Object)extActProcessNode);
            }
        }
        if (StringUtil.isNotEmpty((String)processDefinitionId) && ObjectUtils.isNotEmpty(delIds = nodesIds.stream().filter(e -> !updateIds.contains(e)).collect(Collectors.toList()))) {
            this.extActProcessNodeService.removeBatchByIds(delIds);
        }
        return result;
    }

    @RequestMapping(value={"/saveConfigure"})
    @ResponseBody
    public Result saveConfigure(HttpServletRequest request, ExtActProcessNode extActProcessNode) throws Exception {
        String processNodeCode;
        Result result = new Result();
        String processId = extActProcessNode.getProcessId();
        ExtActProcessNode processNode = this.processUtils.getExtActProcessNode(processId, processNodeCode = extActProcessNode.getProcessNodeCode());
        if (ObjectUtils.isEmpty((Object)processNode)) {
            result.setMessage("\u6d41\u7a0b\u672a\u53d1\u5e03");
            result.setSuccess(false);
        }
        result.setMessage("\u4fdd\u5b58\u6210\u529f");
        extActProcessNode.setId(processNode.getId());
        this.extActProcessNodeMapper.updateById((Object)extActProcessNode);
        return result;
    }

    @RequestMapping(value={"/executeProcess"})
    @ResponseBody
    public AjaxJson executeProcess(@RequestParam(value="dataId") String dataId, @RequestParam(value="processId") String processId, @RequestParam(value="desformCode") String desformCode) throws Exception {
        AjaxJson ajaxJson = new AjaxJson();
        ExtActProcessForm extActProcessForm = this.processUtils.selectProcessFormByProcessIdAndFormCode(processId, desformCode);
        if (ObjectUtils.isNotEmpty((Object)extActProcessForm)) {
            String action = extActProcessForm.getTriggerAction();
            LoginUser loginUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            log.info("\u83b7\u53d6\u6d41\u7a0b\u53d1\u8d77\u4eba = {}", (Object)loginUser.getUsername());
            DesignFormData designFormData = this.minFlowUtils.getDesignFormData(desformCode, dataId);
            if (TriggerActionEnums.delete.getAction().equals(action)) {
                this.designFormDataService.deleteOne(designFormData);
            }
            if (TriggerActionEnums.add.getAction().equals(action) || TriggerActionEnums.add_update.getAction().equals(action)) {
                Result result = this.signalProcessStartApi.signalStartProcess(action, dataId, null, desformCode, loginUser.getUsername());
                ajaxJson.setMsg(result.getMessage());
                ajaxJson.setSuccess(result.isSuccess());
            }
            if (TriggerActionEnums.update.getAction().equals(action)) {
                designFormData.setUpdateTime(DateUtils.getDate());
                this.designFormDataService.editOne(designFormData);
            }
        } else {
            log.error("extActProcessForm \u4e3a\u7a7a\uff0cprocessId={}\uff0cdesformCode={}", (Object)processId, (Object)desformCode);
            ajaxJson.setMsg("\u542f\u52a8\u5931\u8d25\uff0c\u67e5\u4e0d\u5230\u6d41\u7a0b\u4e0e\u8868\u5355\u914d\u7f6e\uff01");
        }
        return ajaxJson;
    }

    @RequestMapping(value={"/generateExecTime"})
    @ResponseBody
    public AjaxJson generateExecTime(ChildAttr childAttr) throws Exception {
        String cron;
        AjaxJson ajaxJson = new AjaxJson();
        ArrayList<String> result = new ArrayList<String>();
        if (ObjectUtils.isNotEmpty((Object)childAttr) && ObjectUtils.isNotEmpty((Object)(cron = MinFlowUtils.getCustomCron(childAttr)))) {
            CronTriggerImpl cronTriggerImpl = new CronTriggerImpl();
            cronTriggerImpl.setCronExpression(cron);
            Calendar calendar = Calendar.getInstance();
            Date now = calendar.getTime();
            calendar.add(1, 2);
            List dates = TriggerUtils.computeFireTimesBetween((OperableTrigger)cronTriggerImpl, null, (Date)now, (Date)calendar.getTime());
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (int i = 0; i < 7; ++i) {
                result.add(dateFormat.format((Date)dates.get(i)));
            }
            ajaxJson.setObj(result);
        }
        return ajaxJson;
    }
}

