/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.eoa.plan.job;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.exceptions.ClientException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtil;
import org.jeecg.common.api.dto.message.MessageDTO;
import org.jeecg.common.constant.enums.DySmsEnum;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.vo.UserAccountInfo;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.DySmsHelper;
import org.jeecg.modules.eoa.plan.entity.EoaPlan;
import org.jeecg.modules.eoa.plan.service.IEoaPlanService;
import org.jeecg.modules.eoa.plan.util.EoaPlanRemindTypeEnum;
import org.jeecg.modules.eoa.plan.util.EoaPlanStatusEnum;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RemindJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(RemindJob.class);
    @Autowired
    private IEoaPlanService planService;
    @Autowired
    private ISysBaseAPI sysBaseAPI;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss");
    private String parameter;
    private JSONObject params;

    public void setParameter(String parameter) {
        this.parameter = parameter;
        try {
            this.params = JSON.parseObject((String)parameter);
        }
        catch (Exception exception) {
            this.params = new JSONObject();
        }
        this.params.putIfAbsent((Object)"advanceTime", (Object)30L);
        this.params.putIfAbsent((Object)"autoComplete", (Object)true);
    }

    public void execute(JobExecutionContext context) {
        Boolean bl = this.params.getBoolean("autoComplete");
        Long l = this.params.getLong("advanceTime");
        long l2 = 60000L * l;
        long l3 = System.currentTimeMillis();
        List<EoaPlan> list = this.planService.queryAllEffectivePlan();
        for (EoaPlan eoaPlan : list) {
            long l4;
            long l5 = eoaPlan.getStartTime().getTime();
            Date date = eoaPlan.getReminderTime();
            EoaPlanStatusEnum eoaPlanStatusEnum = null;
            if (date != null) {
                l4 = Long.valueOf(DateUtils.formatDate((Date)date, (String)"yyyyMMddHHmm"));
                long l6 = Long.valueOf(DateUtils.formatDate((Date)new Date(), (String)"yyyyMMddHHmm"));
                if (EoaPlanStatusEnum.NOT_STARTED.getValue().equals(eoaPlan.getStatus()) && l4 == l6) {
                    eoaPlanStatusEnum = EoaPlanStatusEnum.PROCESSING;
                    long l7 = System.currentTimeMillis();
                    long l8 = l5 - l7;
                    double d2 = (double)l8 / 1000.0 / 60.0;
                    long l9 = (int)Math.ceil(d2);
                    this.sendReminder(eoaPlan, l9);
                    Date date2 = this.nextTime(eoaPlan);
                    eoaPlan.setReminderTime(date2);
                    this.planService.updateById(eoaPlan);
                }
            }
            if (bl.booleanValue()) {
                l4 = eoaPlan.getEndTime().getTime();
                if (EoaPlanStatusEnum.PROCESSING.getValue().equals(eoaPlan.getStatus()) && l4 <= l3) {
                    eoaPlanStatusEnum = EoaPlanStatusEnum.COMPLETED;
                }
            }
            if (eoaPlanStatusEnum == null) continue;
            this.planService.changePlanStatus(eoaPlan.getId(), eoaPlanStatusEnum);
        }
    }

    private void sendReminder(EoaPlan plan, long time) {
        try {
            String string = plan.getRemindType();
            String string2 = plan.getJoinPerson();
            if (StringUtil.isEmpty((String)string2)) {
                return;
            }
            String[] stringArray = string2.split(",");
            if (!StringUtil.isEmpty((String)string) && stringArray.length > 0) {
                List list = this.sysBaseAPI.queryUserByNames(stringArray);
                for (UserAccountInfo userAccountInfo : list) {
                    String[] stringArray2;
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("id", (Object)userAccountInfo.getId());
                    jSONObject.put("username", (Object)userAccountInfo.getUsername());
                    jSONObject.put("realname", (Object)userAccountInfo.getRealname());
                    if (userAccountInfo.getEmail() != null) {
                        jSONObject.put("email", (Object)userAccountInfo.getEmail());
                    }
                    jSONObject.put("phone", (Object)userAccountInfo.getPhone());
                    jSONObject.put("title", (Object)plan.getTitle());
                    String string3 = DateUtils.formatDate((Date)plan.getReminderTime(), (String)"yyyy\u5e74MM\u6708dd\u65e5");
                    String string4 = DateUtils.formatDate((Date)plan.getStartTime(), (String)"HH:mm");
                    jSONObject.put("startTime", (Object)(string3 + " " + string4 + ":00"));
                    jSONObject.put("endTime", (Object)this.sdf.format(plan.getEndTime()));
                    String string5 = "";
                    if (time >= 0L) {
                        jSONObject.put("format", (Object)time);
                        string5 = "\u5c0a\u656c\u7684%s\u60a8\u597d\uff0c\u60a8\u7684\u65e5\u7a0b%s\u8fd8\u6709%s\u5206\u949f\u5c31\u5f00\u59cb\u4e86\uff0c\u5f00\u59cb\u65f6\u95f4\u4e3a\uff1a%s\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\uff01";
                        jSONObject.put("content", (Object)String.format(string5, jSONObject.getString("realname"), jSONObject.getString("title"), jSONObject.getString("format"), jSONObject.getString("startTime")));
                    } else {
                        string5 = "\u5c0a\u656c\u7684%s\u60a8\u597d\uff0c\u60a8\u7684\u65e5\u7a0b%s\u5f00\u59cb\u65f6\u95f4\u4e3a\uff1a%s\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\uff01";
                        jSONObject.put("content", (Object)String.format(string5, jSONObject.getString("realname"), jSONObject.getString("title"), jSONObject.getString("startTime")));
                    }
                    jSONObject.put("template", (Object)string5);
                    for (String string6 : stringArray2 = string.split(",")) {
                        try {
                            if (EoaPlanRemindTypeEnum.EMAIL.getValue().equals(string6)) {
                                this.sendOutEmail(jSONObject);
                            }
                            if (EoaPlanRemindTypeEnum.SMS.getValue().equals(string6)) {
                                this.sendSms(jSONObject);
                            }
                            if (!EoaPlanRemindTypeEnum.SYS_MESSAGE.getValue().equals(string6)) continue;
                            this.sendSysMessage(jSONObject);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void sendSysMessage(JSONObject params) {
        String string = "admin";
        String string2 = params.getString("username");
        String string3 = "\u60a8\u7684\u65e5\u7a0b\u4efb\u52a1\u5373\u5c06\u5f00\u59cb";
        String string4 = params.getString("content");
        this.sysBaseAPI.sendSysAnnouncement(new MessageDTO(string, string2, string3, string4));
    }

    private void sendOutEmail(JSONObject params) {
        String string = "\u3010\u65e5\u7a0b\u63d0\u9192\u3011\u60a8\u7684\u65e5\u7a0b\u4efb\u52a1\u5373\u5c06\u5f00\u59cb";
        String string2 = params.getString("content");
        String string3 = params.getString("email");
        this.sysBaseAPI.sendEmailMsg(string3, string, string2);
    }

    private void sendSms(JSONObject params) throws ClientException {
        String string;
        String string2 = params.getString("phone");
        String string3 = params.getString("realname");
        if (StringUtil.isBlank((String)string3)) {
            string3 = params.getString("username");
        }
        string = (string = params.getString("title")).length() > 20 ? string.substring(0, 19) : string;
        String string4 = params.getString("startTime");
        if (!StringUtil.isEmpty((String)string2)) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("username", (Object)string3);
            jSONObject.put("title", (Object)string);
            jSONObject.put("time", (Object)string4);
            DySmsHelper.sendSms((String)string2, (JSONObject)jSONObject, (DySmsEnum)DySmsEnum.PLAN_NOTICE_TEMPLATE_CODE);
        }
    }

    public Date mouthExistence(Date date, int i2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        simpleDateFormat.format(date);
        String string = simpleDateFormat.format(date.getTime());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String string2 = simpleDateFormat.format(calendar.getTime());
        int n = Integer.parseInt(string.substring(6, 8));
        int n2 = Integer.parseInt(string2.substring(6, 8));
        if (n <= n2) {
            return calendar.getTime();
        }
        return this.mouthExistence(date, i2);
    }

    public Date nextTime(EoaPlan plan) {
        Calendar calendar = Calendar.getInstance();
        Date date = plan.getReminderTime();
        if (plan.getReminders().equals("1")) {
            calendar.add(5, 1);
            date = calendar.getTime();
        } else if (plan.getReminders().equals("2")) {
            calendar.add(4, 1);
            date = calendar.getTime();
        } else if (plan.getReminders().equals("3")) {
            date = this.mouthExistence(calendar.getTime(), 1);
        } else if (plan.getReminders().equals("4")) {
            calendar.add(1, 1);
            date = calendar.getTime();
        }
        return date;
    }
}

