/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.eoa.plan.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtil;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.HTMLUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.eoa.plan.entity.EoaPlan;
import org.jeecg.modules.eoa.plan.service.IEoaPlanService;
import org.jeecg.modules.eoa.plan.util.EoaPlanStatusEnum;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@Api(tags={"\u65e5\u7a0b\u8ba1\u5212"})
@RestController(value="eoaPlanController")
@RequestMapping(value={"/eoa/plan"})
public class EoaPlanController {
    private static final Logger a = LoggerFactory.getLogger(EoaPlanController.class);
    @Autowired
    private IEoaPlanService eoaPlanService;

    @GetMapping(value={"/queryMyCreation"})
    public Result<?> a(HttpServletRequest httpServletRequest) {
        String string = JwtUtil.getUserNameByToken((HttpServletRequest)httpServletRequest);
        if (StringUtil.isEmpty((String)string)) {
            return Result.error((String)"Token\u65e0\u6548\u6216\u5df2\u8fc7\u671f");
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(EoaPlan::getCreateBy, (Object)string);
        return Result.ok((Object)this.eoaPlanService.list((Wrapper)lambdaQueryWrapper));
    }

    @AutoLog(value="\u65e5\u7a0b\u8ba1\u5212-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @ApiOperation(value="\u65e5\u7a0b\u8ba1\u5212-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u65e5\u7a0b\u8ba1\u5212-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<IPage<EoaPlan>> a(EoaPlan eoaPlan, @RequestParam(name="pageNo", defaultValue="1") Integer n, @RequestParam(name="pageSize", defaultValue="10") Integer n2, HttpServletRequest httpServletRequest) {
        Result result = new Result();
        if (oConvertUtils.isNotEmpty((Object)eoaPlan.getRemindType())) {
            eoaPlan.setRemindType("," + eoaPlan.getRemindType() + ",");
        }
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)eoaPlan, (Map)httpServletRequest.getParameterMap());
        Page page = new Page((long)n.intValue(), (long)n2.intValue());
        IPage iPage = this.eoaPlanService.page((IPage)page, (Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult((Object)iPage);
        return result;
    }

    @Deprecated
    @GetMapping(value={"/queryByDay"})
    public Result<List<EoaPlan>> a(@RequestParam(name="day") String string) {
        Result result = new Result();
        QueryWrapper queryWrapper = new QueryWrapper();
        LoginUser loginUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        queryWrapper.eq((Object)"DATE_FORMAT(start_time,'%Y%m%d')", (Object)string);
        queryWrapper.eq((Object)"DATE_FORMAT(end_time,'%Y%m%d')", (Object)string);
        queryWrapper.like((Object)"join_person", (Object)loginUser.getUsername());
        queryWrapper.orderByAsc((Object)"start_time");
        List list = this.eoaPlanService.list((Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult((Object)list);
        return result;
    }

    @AutoLog(value="\u65e5\u7a0b\u8ba1\u5212-\u6dfb\u52a0")
    @ApiOperation(value="\u65e5\u7a0b\u8ba1\u5212-\u6dfb\u52a0", notes="\u65e5\u7a0b\u8ba1\u5212-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<EoaPlan> a(@RequestBody EoaPlan eoaPlan) {
        Result result = new Result();
        try {
            String string = eoaPlan.getRemind();
            if (StringUtil.isNotBlank((String)string) && !string.equals("0")) {
                Date date = this.eoaPlanService.remindedTime(eoaPlan);
                eoaPlan.setReminderTime(date);
            }
            eoaPlan.setStatus(EoaPlanStatusEnum.NOT_STARTED.getValue());
            this.eoaPlanService.save(eoaPlan);
            result.success("\u6dfb\u52a0\u6210\u529f\uff01");
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @AutoLog(value="\u65e5\u7a0b\u8ba1\u5212-\u7f16\u8f91")
    @ApiOperation(value="\u65e5\u7a0b\u8ba1\u5212-\u7f16\u8f91", notes="\u65e5\u7a0b\u8ba1\u5212-\u7f16\u8f91")
    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT, RequestMethod.POST})
    public Result<EoaPlan> b(@RequestBody EoaPlan eoaPlan) throws ParseException {
        Comparable<Calendar> comparable;
        Result result = new Result();
        EoaPlan eoaPlan2 = (EoaPlan)this.eoaPlanService.getById((Serializable)((Object)eoaPlan.getId()));
        String string = eoaPlan.getRemind();
        if (StringUtil.isBlank((String)string) || string.equals("0")) {
            eoaPlan.setReminderTime(null);
        } else if (!eoaPlan.getReminders().equals("0")) {
            comparable = this.eoaPlanService.remindedTime(eoaPlan);
            eoaPlan.setReminderTime((Date)comparable);
        } else {
            comparable = Calendar.getInstance();
            if (((Calendar)comparable).getTime().getTime() < eoaPlan.getStartTime().getTime()) {
                eoaPlan.setReminderTime(((Calendar)comparable).getTime());
            }
        }
        if (eoaPlan2 == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            boolean bl = this.eoaPlanService.updateById(eoaPlan);
            if (bl) {
                result.success("\u4fee\u6539\u6210\u529f!");
            }
        }
        return result;
    }

    @AutoLog(value="\u65e5\u7a0b\u8ba1\u5212-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u65e5\u7a0b\u8ba1\u5212-\u901a\u8fc7id\u5220\u9664", notes="\u65e5\u7a0b\u8ba1\u5212-\u901a\u8fc7id\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result<?> b(@RequestParam(name="id", required=true) String string) {
        try {
            this.eoaPlanService.removeById((Serializable)((Object)string));
        }
        catch (Exception exception) {
            a.error("\u5220\u9664\u5931\u8d25:" + exception.getMessage(), (Throwable)exception);
            return Result.error((String)"\u5220\u9664\u5931\u8d25!");
        }
        return Result.ok((String)"\u5220\u9664\u6210\u529f!");
    }

    @AutoLog(value="\u65e5\u7a0b\u8ba1\u5212-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u65e5\u7a0b\u8ba1\u5212-\u6279\u91cf\u5220\u9664", notes="\u65e5\u7a0b\u8ba1\u5212-\u6279\u91cf\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result<EoaPlan> c(@RequestParam(name="ids", required=true) String string) {
        Result result = new Result();
        if (string == null || "".equals(string.trim())) {
            result.error500("\u53c2\u6570\u4e0d\u8bc6\u522b\uff01");
        } else {
            this.eoaPlanService.removeByIds(Arrays.asList(string.split(",")));
            result.success("\u5220\u9664\u6210\u529f!");
        }
        return result;
    }

    @AutoLog(value="\u65e5\u7a0b\u8ba1\u5212-\u901a\u8fc7id\u67e5\u8be2")
    @ApiOperation(value="\u65e5\u7a0b\u8ba1\u5212-\u901a\u8fc7id\u67e5\u8be2", notes="\u65e5\u7a0b\u8ba1\u5212-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<EoaPlan> d(@RequestParam(name="id", required=true) String string) {
        Result result = new Result();
        EoaPlan eoaPlan = (EoaPlan)this.eoaPlanService.getById((Serializable)((Object)string));
        if (eoaPlan == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            result.setResult((Object)eoaPlan);
            result.setSuccess(true);
        }
        return result;
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView a(HttpServletRequest httpServletRequest, EoaPlan eoaPlan) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)eoaPlan, (Map)httpServletRequest.getParameterMap());
        LoginUser loginUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        List list = this.eoaPlanService.list((Wrapper)queryWrapper);
        for (EoaPlan eoaPlan2 : list) {
            String string = HTMLUtils.getInnerText((String)eoaPlan2.getRemark());
            eoaPlan2.setRemark(string);
        }
        ModelAndView modelAndView = new ModelAndView((View)new JeecgEntityExcelView());
        modelAndView.addObject("fileName", (Object)"\u65e5\u7a0b\u8ba1\u5212\u5217\u8868");
        modelAndView.addObject("entity", EoaPlan.class);
        modelAndView.addObject("params", (Object)new ExportParams("\u65e5\u7a0b\u8ba1\u5212\u5217\u8868\u6570\u636e", "\u5bfc\u51fa\u4eba:" + loginUser.getRealname(), "\u5bfc\u51fa\u4fe1\u606f"));
        modelAndView.addObject("data", (Object)list);
        return modelAndView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest)httpServletRequest;
        Map map = multipartHttpServletRequest.getFileMap();
        Iterator iterator = map.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            MultipartFile multipartFile = (MultipartFile)entry.getValue();
            ImportParams importParams = new ImportParams();
            importParams.setTitleRows(2);
            importParams.setHeadRows(1);
            importParams.setNeedSave(true);
            try {
                List list = ExcelImportUtil.importExcel((InputStream)multipartFile.getInputStream(), EoaPlan.class, (ImportParams)importParams);
                this.eoaPlanService.saveBatch(list);
                Result result = Result.ok((String)("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01\u6570\u636e\u884c\u6570:" + list.size()));
                return result;
            }
            catch (Exception exception) {
                a.error(exception.getMessage(), (Throwable)exception);
                Result result = Result.error((String)("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:" + exception.getMessage()));
                return result;
            }
            finally {
                try {
                    multipartFile.getInputStream().close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return Result.ok((String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
    }

    @GetMapping(value={"/queryMyCreationByDate"})
    public Result<?> a(@RequestParam(name="date", required=false) String string, HttpServletRequest httpServletRequest) {
        String string2 = JwtUtil.getUserNameByToken((HttpServletRequest)httpServletRequest);
        if (StringUtil.isEmpty((String)string2)) {
            return Result.error((String)"Token\u65e0\u6548\u6216\u5df2\u8fc7\u671f");
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.like(EoaPlan::getJoinPerson, (Object)string2);
        lambdaQueryWrapper.orderByAsc(EoaPlan::getStartTime);
        if (!StringUtil.isBlank((String)string)) {
            long l = Long.parseLong(string);
            long l2 = TimeZone.getDefault().getRawOffset();
            long l3 = (l + l2) / 86400000L * 86400000L - l2;
            long l4 = l3 + 86400000L - 1L;
            Date date = new Date(l3);
            Date date2 = new Date(l4);
            lambdaQueryWrapper.le(EoaPlan::getStartTime, (Object)date2);
            lambdaQueryWrapper.ge(EoaPlan::getEndTime, (Object)date);
            return Result.ok((Object)this.eoaPlanService.list((Wrapper)lambdaQueryWrapper));
        }
        return Result.ok((Object)this.eoaPlanService.list((Wrapper)lambdaQueryWrapper));
    }

    @GetMapping(value={"/queryMyPlanByDate"})
    public Result<?> b(@RequestParam(name="date", required=false) String string, HttpServletRequest httpServletRequest) throws Exception {
        String string2 = JwtUtil.getUserNameByToken((HttpServletRequest)httpServletRequest);
        if (StringUtil.isEmpty((String)string2)) {
            return Result.error((String)"Token\u65e0\u6548\u6216\u5df2\u8fc7\u671f");
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.like(EoaPlan::getJoinPerson, (Object)string2);
        lambdaQueryWrapper.orderByAsc(EoaPlan::getStartTime);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(simpleDateFormat.parse(string));
        calendar.add(2, 0);
        calendar.set(5, 1);
        String string3 = simpleDateFormat.format(calendar.getTime()) + " 00:00:00";
        calendar = Calendar.getInstance();
        calendar.setTime(simpleDateFormat.parse(string));
        calendar.add(2, 1);
        calendar.set(5, 0);
        String string4 = simpleDateFormat.format(calendar.getTime()) + " 23:59:59";
        Date date = simpleDateFormat.parse(string3);
        Date date2 = simpleDateFormat.parse(string4);
        lambdaQueryWrapper.le(EoaPlan::getStartTime, (Object)date2);
        lambdaQueryWrapper.ge(EoaPlan::getEndTime, (Object)date);
        return Result.ok((Object)this.eoaPlanService.list((Wrapper)lambdaQueryWrapper));
    }

    @GetMapping(value={"/queryPlanByUser"})
    public Result<?> c(@RequestParam(name="username", required=false) String string, HttpServletRequest httpServletRequest) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.like(EoaPlan::getJoinPerson, (Object)string);
        return Result.ok((Object)this.eoaPlanService.list((Wrapper)lambdaQueryWrapper));
    }

    @GetMapping(value={"/queryMyPlan"})
    public Result<?> b(HttpServletRequest httpServletRequest) {
        String string = JwtUtil.getUserNameByToken((HttpServletRequest)httpServletRequest);
        if (StringUtil.isEmpty((String)string)) {
            return Result.error((String)"Token\u65e0\u6548\u6216\u5df2\u8fc7\u671f");
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.like(EoaPlan::getJoinPerson, (Object)string);
        return Result.ok((Object)this.eoaPlanService.list((Wrapper)lambdaQueryWrapper));
    }

    public static void main(String[] args) throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String string = "2016-07-16";
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(simpleDateFormat.parse(string));
        calendar.add(2, 0);
        calendar.set(5, 1);
        String string2 = simpleDateFormat.format(calendar.getTime());
        calendar = Calendar.getInstance();
        calendar.setTime(simpleDateFormat.parse(string));
        calendar.add(2, 1);
        calendar.set(5, 0);
        String string3 = simpleDateFormat.format(calendar.getTime());
        System.out.println("\u672c\u6708\u7b2c\u4e00\u5929\u548c\u6700\u540e\u4e00\u5929\u5206\u522b\u662f\uff1a" + string2 + " \u548c " + string3 + "\u3002");
    }

    @AutoLog(value="\u65e5\u7a0b\u8ba1\u5212-\u5206\u9875\u67e5\u8be2\u6211\u53c2\u4e0e\u521b\u5efa\u7684\u65e5\u7a0b")
    @ApiOperation(value="\u65e5\u7a0b\u8ba1\u5212-\u5206\u9875\u67e5\u8be2\u6211\u53c2\u4e0e\u521b\u5efa\u7684\u65e5\u7a0b", notes="\u65e5\u7a0b\u8ba1\u5212-\u5206\u9875\u67e5\u8be2\u6211\u53c2\u4e0e\u521b\u5efa\u7684\u65e5\u7a0b")
    @GetMapping(value={"/myPlanlist"})
    public Result<IPage<EoaPlan>> b(EoaPlan eoaPlan, @RequestParam(name="pageNo", defaultValue="1") Integer n, @RequestParam(name="pageSize", defaultValue="10") Integer n2, HttpServletRequest httpServletRequest) {
        Result result = new Result();
        String string = JwtUtil.getUserNameByToken((HttpServletRequest)httpServletRequest);
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)eoaPlan, (Map)httpServletRequest.getParameterMap());
        Page page = new Page((long)n.intValue(), (long)n2.intValue());
        queryWrapper.and(queryWrapper2 -> ((QueryWrapper)queryWrapper2.like((Object)"join_person", (Object)string)).or(queryWrapper -> queryWrapper.eq((Object)"create_by", (Object)string)));
        IPage iPage = this.eoaPlanService.page((IPage)page, (Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult((Object)iPage);
        return result;
    }

    @GetMapping(value={"/getPlanList"})
    public Result<List<EoaPlan>> a(EoaPlan eoaPlan, HttpServletRequest httpServletRequest) {
        String string = JwtUtil.getUserNameByToken((HttpServletRequest)httpServletRequest);
        if (StringUtil.isEmpty((String)string)) {
            return Result.error((String)"Token\u65e0\u6548\u6216\u5df2\u8fc7\u671f");
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        this.eoaPlanService.setQueryParams((LambdaQueryWrapper<EoaPlan>)lambdaQueryWrapper, httpServletRequest, string);
        List list = this.eoaPlanService.list((Wrapper)lambdaQueryWrapper);
        return Result.ok((Object)list);
    }

    @AutoLog(value="\u65e5\u7a0b\u8ba1\u5212-\u5206\u9875\u67e5\u8be2\u6211\u53c2\u4e0e\u521b\u5efa\u7684\u65e5\u7a0b")
    @ApiOperation(value="\u65e5\u7a0b\u8ba1\u5212-\u5206\u9875\u67e5\u8be2\u6211\u53c2\u4e0e\u521b\u5efa\u7684\u65e5\u7a0b", notes="\u65e5\u7a0b\u8ba1\u5212-\u5206\u9875\u67e5\u8be2\u6211\u53c2\u4e0e\u521b\u5efa\u7684\u65e5\u7a0b")
    @GetMapping(value={"/getPlanListByPage"})
    public Result<IPage<EoaPlan>> c(EoaPlan eoaPlan, @RequestParam(name="pageNo", defaultValue="1") Integer n, @RequestParam(name="pageSize", defaultValue="10") Integer n2, HttpServletRequest httpServletRequest) {
        Result result = new Result();
        String string = JwtUtil.getUserNameByToken((HttpServletRequest)httpServletRequest);
        if (StringUtil.isEmpty((String)string)) {
            return Result.error((String)"Token\u65e0\u6548\u6216\u5df2\u8fc7\u671f");
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        Page page = new Page((long)n.intValue(), (long)n2.intValue());
        this.eoaPlanService.setQueryParams((LambdaQueryWrapper<EoaPlan>)lambdaQueryWrapper, httpServletRequest, string);
        lambdaQueryWrapper.orderByDesc(EoaPlan::getStartTime);
        IPage iPage = this.eoaPlanService.page((IPage)page, (Wrapper)lambdaQueryWrapper);
        result.setSuccess(true);
        result.setResult((Object)iPage);
        return result;
    }

    private static /* synthetic */ Object a(SerializedLambda serializedLambda) {
        switch (serializedLambda.getImplMethodName()) {
            case "getCreateBy": {
                if (serializedLambda.getImplMethodKind() != 5 || !serializedLambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !serializedLambda.getFunctionalInterfaceMethodName().equals("apply") || !serializedLambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !serializedLambda.getImplClass().equals("org/jeecg/modules/eoa/plan/entity/EoaPlan") || !serializedLambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return EoaPlan::getCreateBy;
            }
            case "getJoinPerson": {
                if (serializedLambda.getImplMethodKind() == 5 && serializedLambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && serializedLambda.getFunctionalInterfaceMethodName().equals("apply") && serializedLambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && serializedLambda.getImplClass().equals("org/jeecg/modules/eoa/plan/entity/EoaPlan") && serializedLambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return EoaPlan::getJoinPerson;
                }
                if (serializedLambda.getImplMethodKind() == 5 && serializedLambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && serializedLambda.getFunctionalInterfaceMethodName().equals("apply") && serializedLambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && serializedLambda.getImplClass().equals("org/jeecg/modules/eoa/plan/entity/EoaPlan") && serializedLambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return EoaPlan::getJoinPerson;
                }
                if (serializedLambda.getImplMethodKind() == 5 && serializedLambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && serializedLambda.getFunctionalInterfaceMethodName().equals("apply") && serializedLambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && serializedLambda.getImplClass().equals("org/jeecg/modules/eoa/plan/entity/EoaPlan") && serializedLambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return EoaPlan::getJoinPerson;
                }
                if (serializedLambda.getImplMethodKind() != 5 || !serializedLambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !serializedLambda.getFunctionalInterfaceMethodName().equals("apply") || !serializedLambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !serializedLambda.getImplClass().equals("org/jeecg/modules/eoa/plan/entity/EoaPlan") || !serializedLambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return EoaPlan::getJoinPerson;
            }
            case "getEndTime": {
                if (serializedLambda.getImplMethodKind() == 5 && serializedLambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && serializedLambda.getFunctionalInterfaceMethodName().equals("apply") && serializedLambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && serializedLambda.getImplClass().equals("org/jeecg/modules/eoa/plan/entity/EoaPlan") && serializedLambda.getImplMethodSignature().equals("()Ljava/util/Date;")) {
                    return EoaPlan::getEndTime;
                }
                if (serializedLambda.getImplMethodKind() != 5 || !serializedLambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !serializedLambda.getFunctionalInterfaceMethodName().equals("apply") || !serializedLambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !serializedLambda.getImplClass().equals("org/jeecg/modules/eoa/plan/entity/EoaPlan") || !serializedLambda.getImplMethodSignature().equals("()Ljava/util/Date;")) break;
                return EoaPlan::getEndTime;
            }
            case "getStartTime": {
                if (serializedLambda.getImplMethodKind() == 5 && serializedLambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && serializedLambda.getFunctionalInterfaceMethodName().equals("apply") && serializedLambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && serializedLambda.getImplClass().equals("org/jeecg/modules/eoa/plan/entity/EoaPlan") && serializedLambda.getImplMethodSignature().equals("()Ljava/util/Date;")) {
                    return EoaPlan::getStartTime;
                }
                if (serializedLambda.getImplMethodKind() == 5 && serializedLambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && serializedLambda.getFunctionalInterfaceMethodName().equals("apply") && serializedLambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && serializedLambda.getImplClass().equals("org/jeecg/modules/eoa/plan/entity/EoaPlan") && serializedLambda.getImplMethodSignature().equals("()Ljava/util/Date;")) {
                    return EoaPlan::getStartTime;
                }
                if (serializedLambda.getImplMethodKind() == 5 && serializedLambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && serializedLambda.getFunctionalInterfaceMethodName().equals("apply") && serializedLambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && serializedLambda.getImplClass().equals("org/jeecg/modules/eoa/plan/entity/EoaPlan") && serializedLambda.getImplMethodSignature().equals("()Ljava/util/Date;")) {
                    return EoaPlan::getStartTime;
                }
                if (serializedLambda.getImplMethodKind() == 5 && serializedLambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && serializedLambda.getFunctionalInterfaceMethodName().equals("apply") && serializedLambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && serializedLambda.getImplClass().equals("org/jeecg/modules/eoa/plan/entity/EoaPlan") && serializedLambda.getImplMethodSignature().equals("()Ljava/util/Date;")) {
                    return EoaPlan::getStartTime;
                }
                if (serializedLambda.getImplMethodKind() != 5 || !serializedLambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !serializedLambda.getFunctionalInterfaceMethodName().equals("apply") || !serializedLambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !serializedLambda.getImplClass().equals("org/jeecg/modules/eoa/plan/entity/EoaPlan") || !serializedLambda.getImplMethodSignature().equals("()Ljava/util/Date;")) break;
                return EoaPlan::getStartTime;
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }
}

