/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.eoa.im.scoket;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.jeecg.common.base.BaseMap;
import org.jeecg.common.modules.redis.client.JeecgRedisClient;
import org.jeecg.modules.eoa.im.entity.EoaChatSession;
import org.jeecg.modules.eoa.im.entity.EoaChatUser;
import org.jeecg.modules.eoa.im.service.IEoaChatUserService;
import org.jeecg.modules.eoa.im.vo.ChatLogVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ServerEndpoint(value="/eoaNewChatSocket/{userId}/{messageId}")
public class EoaNewChatSocket {
    private static final Logger log = LoggerFactory.getLogger(EoaNewChatSocket.class);
    private static ConcurrentHashMap<String, Session> connections = new ConcurrentHashMap();
    public static final String REDIS_TOPIC_NAME = "chatSocketHandler";
    private static JeecgRedisClient jeecgRedisClient;
    private static IEoaChatUserService eoaChatUserService;

    @Autowired
    private void setJeecgRedisClient(JeecgRedisClient jeecgRedisClient) {
        EoaNewChatSocket.jeecgRedisClient = jeecgRedisClient;
    }

    @Autowired
    public void setChatService(IEoaChatUserService eoaChatUserService) {
        EoaNewChatSocket.eoaChatUserService = eoaChatUserService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnOpen
    public void onOpen(Session session, @PathParam(value="userId") String userId) {
        try {
            connections.put(userId, session);
            log.debug("\u3010TIM\u3011\u6709\u65b0\u7684\u8fde\u63a5\uff0c\u603b\u6570\u4e3a:" + connections.size());
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("event", (Object)"connect");
            Session session2 = session;
            synchronized (session2) {
                session.getBasicRemote().sendText(jSONObject.toJSONString());
            }
        }
        catch (Exception exception) {
            log.warn(exception.getMessage(), (Throwable)exception);
        }
    }

    @OnClose
    public void onClose(@PathParam(value="userId") String userId, @PathParam(value="messageId") String messageId) {
        try {
            connections.remove(userId);
            this.updateUserStatus(userId, messageId);
            log.debug("\u3010TIM\u3011\u8fde\u63a5\u65ad\u5f00\uff0c\u603b\u6570\u4e3a:" + connections.size());
        }
        catch (Exception exception) {
            log.warn(exception.getMessage(), (Throwable)exception);
        }
    }

    @OnError
    public void onError(Throwable throwable) {
        throwable.printStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnMessage
    public void onMessage(Session session, String message) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("event", (Object)"heartbeat");
        Session session2 = session;
        synchronized (session2) {
            try {
                session.getBasicRemote().sendText(jSONObject.toJSONString());
            }
            catch (IOException iOException) {
                log.error(iOException.getMessage(), (Throwable)iOException);
            }
        }
        log.debug("\u3010TIM\u3011\u6536\u5230\u5ba2\u6237\u7aef\u6d88\u606f: " + message);
    }

    public void sendMessageTo(String message, String toUserId) {
        for (Map.Entry<String, Session> entry : connections.entrySet()) {
            if (!entry.getKey().contains(toUserId)) continue;
            try {
                log.debug("\u3010TIM\u3011\u53d1\u9001\u6d88\u606f" + message);
                entry.getValue().getAsyncRemote().sendText(message);
            }
            catch (Exception exception) {
                log.error(exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public void updateUserStatus(String userId, String messageId) {
        EoaChatUser eoaChatUser = new EoaChatUser();
        if (userId.contains("_")) {
            userId = userId.replace("_" + messageId, "");
        }
        String string = userId;
        Map<String, Session> map = connections.entrySet().stream().filter(item -> ((String)item.getKey()).contains(string)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (map.size() > 0) {
            return;
        }
        eoaChatUser.setStatus("offline");
        eoaChatUser.setId(userId);
        eoaChatUserService.updateById(eoaChatUser);
        List<EoaChatSession> list = eoaChatUserService.noticeOnline(userId, "offline");
        for (EoaChatSession eoaChatSession : list) {
            JSONObject jSONObject = new JSONObject();
            ChatLogVo chatLogVo = new ChatLogVo();
            BeanUtils.copyProperties((Object)eoaChatSession, (Object)chatLogVo);
            chatLogVo.setStatus("offline");
            jSONObject.put("data", (Object)chatLogVo);
            jSONObject.put("event", (Object)"event_chat_online");
            jSONObject.put("type", (Object)eoaChatSession.getType());
            this.sendMessage(jSONObject.toString(), eoaChatSession.getMsgFrom());
        }
    }

    public void sendMessage(String message, String userId) {
        BaseMap baseMap = new BaseMap();
        baseMap.put("userId", (Object)userId);
        baseMap.put("message", (Object)message);
        jeecgRedisClient.sendMessage(REDIS_TOPIC_NAME, baseMap);
    }
}

