/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.desform.datafactory.impl.sql.service.a;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.SerializedLambda;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtil;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.CommonAPI;
import org.jeecg.common.api.dto.message.MessageDTO;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.constant.enums.MessageTypeEnum;
import org.jeecg.common.exception.JeecgBootBizTipException;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.lowapp.api.ILowAppBaseApi;
import org.jeecg.common.lowapp.model.LowAppFormAuthRecordModel;
import org.jeecg.common.miniflow.ISignalProcessStartApi;
import org.jeecg.common.online.api.IOnlineBaseExtApi;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.query.MatchTypeEnum;
import org.jeecg.common.system.query.QueryRuleEnum;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.DictModel;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.system.vo.SysUserCacheInfo;
import org.jeecg.common.util.AssertUtils;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.RestUtil;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.JeecgBaseConfig;
import org.jeecg.modules.online.desform.constant.WidgetTypes;
import org.jeecg.modules.online.desform.d.a;
import org.jeecg.modules.online.desform.datafactory.a.c;
import org.jeecg.modules.online.desform.datafactory.impl.sql.entity.DesignFormColumnData;
import org.jeecg.modules.online.desform.datafactory.impl.sql.mapper.DesignFormColumnDataMapper;
import org.jeecg.modules.online.desform.datafactory.impl.sql.service.a.d;
import org.jeecg.modules.online.desform.datafactory.impl.sql.service.a.f;
import org.jeecg.modules.online.desform.datafactory.impl.sql.vo.SuperQuerySqlConditions;
import org.jeecg.modules.online.desform.datafactory.inter.dao.IDesformDataDao;
import org.jeecg.modules.online.desform.datafactory.inter.dao.IDesformViewDao;
import org.jeecg.modules.online.desform.datafactory.inter.service.a.b;
import org.jeecg.modules.online.desform.entity.DesignForm;
import org.jeecg.modules.online.desform.entity.DesignFormData;
import org.jeecg.modules.online.desform.mapper.DesignFormDataMapper;
import org.jeecg.modules.online.desform.mongo.model.FieldOption;
import org.jeecg.modules.online.desform.mongo.model.ListViewModel;
import org.jeecg.modules.online.desform.mongo.model.SummaryModel;
import org.jeecg.modules.online.desform.mongo.service.IDesignFormListViewService;
import org.jeecg.modules.online.desform.service.IDesignFormDataService;
import org.jeecg.modules.online.desform.service.IDesignFormService;
import org.jeecg.modules.online.desform.util.DesformQueryUtils;
import org.jeecg.modules.online.desform.util.h;
import org.jeecg.modules.online.desform.util.k;
import org.jeecg.modules.online.desform.vo.ADefValLinkageVo;
import org.jeecg.modules.online.desform.vo.BatchUpdateModel;
import org.jeecg.modules.online.desform.vo.DesformOperationEnum;
import org.jeecg.modules.online.desform.vo.DesformPageVo;
import org.jeecg.modules.online.desform.vo.excel.DesformWidgetList;
import org.jeecg.modules.online.desform.vo.query.DesformQuery;
import org.jeecg.modules.online.desform.vo.query.DesformSuperQuery;
import org.jeecg.modules.online.desform.vo.query.DesformSuperQueryGroup;
import org.jeecg.modules.online.desform.vo.query.IdOrCodeParam;
import org.jeecg.modules.online.desform.vo.query.SuperQueryItem;
import org.jeecg.modules.online.desform.vo.query.params.DesformExtentdParam;
import org.jeecg.modules.online.desform.vo.widget.DesformWidget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Conditional(value={c.class})
@Service(value="designFormDataServiceImpl")
public class g
extends b
implements IDesignFormDataService {
    @Generated
    private static final Logger o = LoggerFactory.getLogger(g.class);
    @Autowired
    private DesignFormDataMapper baseMapper;
    @Autowired
    private DesignFormColumnDataMapper columnDataMapper;
    @Lazy
    @Autowired
    private IDesignFormService desformService;
    @Autowired
    private IDesformDataDao dataDao;
    @Lazy
    @Autowired
    IDesformViewDao desformViewDao;
    @Autowired
    private f superServ;
    @Autowired
    private IDesignFormListViewService designFormListViewService;
    @Autowired
    ISysBaseAPI sysBaseApi;
    @Autowired
    @Lazy
    IOnlineBaseExtApi onlineBaseExtApi;
    @Autowired
    d indexService;
    @Lazy
    @Autowired
    ILowAppBaseApi lowAppBaseApi;
    @Lazy
    @Autowired
    a translService;
    @Lazy
    @Autowired
    private CommonAPI commonApi;
    private final String p = "UPDATE";
    private final String q = "DELETE";
    private final String r = "LOGIC_DELETE";

    @Autowired
    public g(JeecgBaseConfig jeecgBaseConfig, RedisUtil redisUtil, @Lazy ISysBaseAPI sysBaseApi, @Lazy org.jeecg.modules.online.desform.service.a.a oaSignService, @Lazy a translService, @Lazy IDesignFormService desformService, @Lazy ISignalProcessStartApi signalProcessStartApi, @Lazy IOnlineBaseExtApi onlineBaseExtApi) {
        super(jeecgBaseConfig, redisUtil, sysBaseApi, translService, oaSignService, desformService, signalProcessStartApi, onlineBaseExtApi);
    }

    @Override
    public Result<IPage<DesignFormData>> pageList(String desformCode, Page<DesignFormData> page, DesformSuperQuery superQuery) {
        Result result = new Result();
        try {
            DesformSuperQueryGroup superQueryGroup = new DesformSuperQueryGroup();
            superQueryGroup.setMatchType(MatchTypeEnum.AND);
            DesformSuperQuery copySuperQuery = new DesformSuperQuery();
            copySuperQuery.setMatchType(superQuery.getMatchType());
            copySuperQuery.setQueryItems(superQuery.getQueryItems());
            superQueryGroup.setSuperQueryGroup(Collections.singletonList(copySuperQuery));
            HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
            String username = JwtUtil.getUserNameByToken((HttpServletRequest)request);
            DesformExtentdParam desformExtentdParam = new DesformExtentdParam(superQuery.getListViewId(), superQuery.isQueryLinkField(), null, username, superQuery.getParameterMap());
            Result<Page<DesignFormData>> pageDataRes = this.queryPage(desformCode, page, superQueryGroup, desformExtentdParam);
            BeanUtils.copyProperties(pageDataRes, (Object)result);
        }
        catch (UnsupportedEncodingException e2) {
            result.setMessage("\u67e5\u8be2\u5931\u8d25");
            result.setSuccess(false);
            o.error("\u67e5\u8be2\u5931\u8d25", (Throwable)e2);
        }
        return result;
    }

    @Override
    public Result<List<DesignFormData>> queryList(String desformCode, Page<DesignFormData> page, DesformSuperQuery superQuery, String username) throws UnsupportedEncodingException {
        Result result = new Result();
        Result<?> get = this.a(desformCode, page, superQuery, username, false);
        BeanUtils.copyProperties(get, (Object)result);
        return result;
    }

    @Override
    public Result<Page<DesignFormData>> queryPage(String desformCode, Page<DesignFormData> page, DesformSuperQueryGroup desformSuperQueryGroup, DesformExtentdParam desformExtentdParam) throws UnsupportedEncodingException {
        Result result = new Result();
        Result<?> get = this.a(desformCode, page, desformSuperQueryGroup, desformExtentdParam, false);
        BeanUtils.copyProperties(get, (Object)result);
        return result;
    }

    private Result<?> a(String desformCode, Page<DesignFormData> page, DesformSuperQueryGroup superQueryGroup, DesformExtentdParam extendParams, boolean queryList) throws UnsupportedEncodingException {
        boolean isOperation;
        long perfTime1 = System.currentTimeMillis();
        Result result = new Result();
        DesignForm designForm = this.desformService.getByCode(desformCode);
        long perfTime2 = System.currentTimeMillis();
        o.info("[perf] 1. \u67e5\u8be2\u8bbe\u8ba1\u8868\u5355\uff0c\u4ee3\u7801\u6267\u884c\u8017\u65f6\uff1a{}\u6beb\u79d2", (Object)(perfTime2 - perfTime1));
        if (designForm == null) {
            result.setCode(CommonConstant.SC_INTERNAL_NOT_FOUND_404);
            result.setMessage("\u8868\u5355\u4e0d\u5b58\u5728");
            result.setSuccess(false);
            return result;
        }
        String queryDesformCode = designForm.getDesformCode();
        if (org.jeecg.modules.online.desform.constant.b.e.equals(designForm.getDesformType())) {
            queryDesformCode = designForm.getParentCode();
        }
        boolean hasListView = oConvertUtils.isNotEmpty((Object)extendParams.getListViewId());
        ListViewModel listViewModel = this.designFormListViewService.queryListViewInfo(designForm, extendParams.getListViewId(), extendParams.getUsername());
        long perfTime3 = System.currentTimeMillis();
        o.info("[perf] 2. \u67e5\u8be2\u53f3\u4fa7\u7684\u6392\u5e8f\u914d\u7f6e\uff0c\u4ee3\u7801\u6267\u884c\u8017\u65f6\uff1a{}\u6beb\u79d2", (Object)(perfTime3 - perfTime2));
        List<FieldOption> top5List = DesformQueryUtils.a(designForm);
        listViewModel.setFieldList(top5List);
        ArrayList<OrderItem> orderList = null;
        page.setOrders(new ArrayList());
        if (CollectionUtils.isEmpty(orderList)) {
            orderList = new ArrayList<OrderItem>();
            orderList.add(OrderItem.desc((String)"create_time"));
        }
        DesformQueryUtils.a(page, orderList);
        result.setMessage("\u67e5\u8be2\u6210\u529f");
        SuperQuerySqlConditions sqConditions = (SuperQuerySqlConditions)this.dataDao.generateConditions(designForm, superQueryGroup, listViewModel, extendParams);
        QueryWrapper<DesignFormData> groupQueryWrapper = sqConditions.getQueryWrapper();
        Map<String, Object> valueMap = sqConditions.getValueMap();
        if (groupQueryWrapper != null) {
            o.debug("[desform-sql] \u67e5\u8be2\u6761\u4ef6: {}", (Object)groupQueryWrapper.getCustomSqlSegment());
            o.debug("[desform-sql] \u67e5\u8be2\u503c\uff08paramNameValuePairs\uff09: {}", (Object)JSON.toJSONString((Object)groupQueryWrapper.getParamNameValuePairs()));
        }
        if (valueMap != null && !valueMap.isEmpty()) {
            o.debug("[desform-sql] \u67e5\u8be2\u503c\uff08valueMap\uff09: {}", (Object)JSON.toJSONString(valueMap));
        }
        boolean bl = isOperation = extendParams.getOperationType() != null;
        if (isOperation) {
            Object res = this.a(extendParams.getOperationType(), extendParams.getOperationField(), sqConditions);
            result.setResult(res);
            long perfTime4 = System.currentTimeMillis();
            o.info("[perf] 3. \u805a\u5408\u67e5\u8be2\u6570\u636e\u5e93\u6570\u636e\uff0c\u4ee3\u7801\u6267\u884c\u8017\u65f6\uff1a{}\u6beb\u79d2", (Object)(perfTime4 - perfTime3));
        } else if (queryList) {
            List<DesignFormData> dataList = this.baseMapper.selectListBySuperQuery((Wrapper<DesignFormData>)groupQueryWrapper, valueMap);
            org.jeecg.modules.online.desform.util.k.a(dataList);
            result.setResult(dataList);
            long perfTime4 = System.currentTimeMillis();
            o.info("[perf] 3. \u975e\u5206\u9875\u67e5\u8be2\u6570\u636e\u5e93\u6570\u636e\uff0c\u4ee3\u7801\u6267\u884c\u8017\u65f6\uff1a{}\u6beb\u79d2", (Object)(perfTime4 - perfTime3));
        } else {
            List<SummaryModel> summaryList;
            Page<DesignFormData> pageData = this.baseMapper.selectPageBySuperQuery(page, (Wrapper<DesignFormData>)groupQueryWrapper, valueMap);
            org.jeecg.modules.online.desform.util.k.a(pageData.getRecords());
            DesformPageVo<DesignFormData> res = new DesformPageVo<DesignFormData>(pageData);
            long perfTime4 = System.currentTimeMillis();
            o.info("[perf] 3. \u5206\u9875\u67e5\u8be2\u6570\u636e\u5e93\u6570\u636e\uff0c\u4ee3\u7801\u6267\u884c\u8017\u65f6\uff1a{}\u6beb\u79d2", (Object)(perfTime4 - perfTime3));
            JSONObject translData = this.translService.a(designForm, res.getRecords());
            res.setTranslData(translData);
            long perfTime5 = System.currentTimeMillis();
            o.info("[perf] 4. \u7ffb\u8bd1\u6570\u636e\u5e93\u6570\u636e\uff0c\u4ee3\u7801\u6267\u884c\u8017\u65f6\uff1a{}\u6beb\u79d2", (Object)(perfTime5 - perfTime4));
            res.setHasSuperQuery(superQueryGroup.hasQuery());
            if (extendParams.getQueryLinkField().booleanValue()) {
                super.queryLinkFieldData(designForm, res.getRecords(), true);
                long perfTime6 = System.currentTimeMillis();
                o.info("[perf] 5. \u7ffb\u8bd1\u4ed6\u8868\u5b57\u6bb5\uff0c\u4ee3\u7801\u6267\u884c\u8017\u65f6\uff1a{}\u6beb\u79d2", (Object)(perfTime6 - perfTime5));
            }
            if (!CollectionUtils.isEmpty(summaryList = listViewModel.getSummaryList())) {
                for (SummaryModel sm : summaryList) {
                    String type = sm.getType();
                    if (!oConvertUtils.isNotEmpty((Object)type)) continue;
                    String field = sm.getField();
                    String val = this.desformViewDao.getFieldSummaryVal(designForm, field, type, superQueryGroup, listViewModel, extendParams);
                    sm.setVal(val);
                }
            }
            long endTime5 = System.currentTimeMillis();
            o.info("[perf] 6. \u8ba1\u7b97\u5408\u8ba1\u503c\uff0c\u4ee3\u7801\u6267\u884c\u8017\u65f6\uff1a{}\u6beb\u79d2", (Object)(endTime5 - perfTime5));
            res.setSummaryList(summaryList);
            result.setResult(res);
        }
        return result;
    }

    @Override
    public Result<?> queryOperation(String desformCode, DesformOperationEnum operationType, String operationField, DesformSuperQueryGroup desformSuperQueryGroup, DesformExtentdParam desformExtentdParam) throws UnsupportedEncodingException {
        Result result = new Result();
        desformExtentdParam.setOperationType(operationType);
        desformExtentdParam.setOperationField(operationField);
        Result<?> get = this.a(desformCode, null, desformSuperQueryGroup, desformExtentdParam, false);
        BeanUtils.copyProperties(get, (Object)result);
        return result;
    }

    private Object a(DesformOperationEnum operationType, String operationField, SuperQuerySqlConditions sqConditions) {
        Map<String, Object> valueMap = sqConditions.getValueMap();
        String groupFunc = null;
        switch (operationType) {
            case COUNT: {
                return this.baseMapper.countBySuperQuery((Wrapper<DesignFormData>)sqConditions.getQueryWrapper(), valueMap);
            }
            case MAX: 
            case MIN: 
            case AVG: 
            case SUM: {
                groupFunc = operationType.toString();
            }
        }
        if (groupFunc != null && oConvertUtils.isNotEmpty((Object)sqConditions.getUserDataIdSql())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.select((Object[])new String[]{groupFunc + "(value), " + groupFunc + "(value_long), " + groupFunc + "(value_decimal)"});
            queryWrapper.eq((Object)"field_name", (Object)operationField);
            queryWrapper.inSql((Object)"data_id", sqConditions.getUserDataIdSql());
            List<Map<String, Object>> result = this.columnDataMapper.selectMapsBySuperQuery((Wrapper<DesignFormColumnData>)queryWrapper, valueMap);
            if (!CollectionUtils.isEmpty(result) && result.get(0) != null) {
                Map<String, Object> res = result.get(0);
                for (String key : res.keySet()) {
                    Object value = res.get(key);
                    if (!oConvertUtils.isNotEmpty((Object)value)) continue;
                    return value;
                }
            }
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<?> addOne(DesignFormData designFormData, boolean isExternal) {
        Object xOaTimeoutDateObj;
        if (designFormData == null || designFormData.getDesformData() == null) {
            return Result.error((String)"designFormData \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String desformCode = designFormData.getDesformCode();
        if (StringUtil.isEmpty((String)desformCode)) {
            return Result.error((String)"\u5fc5\u987b\u4f20\u9012 desformCode \u53c2\u6570");
        }
        DesignForm designForm = this.desformService.getByCode(desformCode);
        if (designForm == null) {
            return Result.error((String)("\u8868\u5355\u8bbe\u8ba1\u5668\uff08" + desformCode + "\uff09\u4e0d\u5b58\u5728"));
        }
        designFormData.setDesformId(designForm.getId());
        designFormData.setDesformCode(designForm.getDesformCode());
        designFormData.setDesformName(designForm.getDesformName());
        JSONObject designJson = JSON.parseObject((String)designForm.getDesformDesignJson());
        JSONArray designList = designJson.getJSONArray("list");
        JSONObject config = designJson.getJSONObject("config");
        if (designFormData.getxOaArchiveStatus() == null) {
            designFormData.setxOaArchiveStatus(org.jeecg.modules.online.desform.constant.b.aJ);
        }
        if (oConvertUtils.isNotEmpty((Object)(xOaTimeoutDateObj = designFormData.getDesformData().get((Object)"x_oa_timeout_date")))) {
            try {
                if (xOaTimeoutDateObj instanceof Long) {
                    designFormData.setxOaTimeoutDate(new Date((Long)xOaTimeoutDateObj));
                }
            }
            catch (Exception e2) {
                o.warn("\u8d85\u65f6\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u65e0\u6cd5\u8f6c\u6362\u6210\u65e5\u671f\u7c7b\u578b", (Throwable)e2);
            }
        }
        if (!this.a(designFormData)) {
            throw new JeecgBootException("\u4fdd\u5b58\u5173\u8054\u8bb0\u5f55\u7684\u4e34\u65f6\u6570\u636e\u5931\u8d25");
        }
        Map<WidgetTypes, List<JSONObject>> specialWidgets = org.jeecg.modules.online.desform.util.h.d(designList);
        super.a(desformCode, specialWidgets.get((Object)WidgetTypes.AUTO_NUMBER), designFormData);
        super.a(desformCode, specialWidgets, designFormData);
        super.b(desformCode, specialWidgets.get((Object)WidgetTypes.SUB_TABLE_DESIGN), designFormData);
        super.a(designFormData, org.jeecg.modules.online.desform.constant.b.aF);
        HttpMethod method = HttpMethod.POST;
        try {
            String onlineFormCode = config.getString("onlineForm");
            if (oConvertUtils.isNotEmpty((Object)onlineFormCode)) {
                designFormData.setOnlineFormCode(onlineFormCode);
                super.a(designFormData, designList, method);
            }
        }
        catch (Exception e3) {
            o.error("\u540c\u6b65\u4fdd\u5b58\u5230Online\u8868\u5355\u5931\u8d25", (Throwable)e3);
            throw new JeecgBootBizTipException("\u540c\u6b65\u4fdd\u5b58\u5230Online\u8868\u5355\u5931\u8d25\uff1a" + e3.getMessage());
        }
        if ("ONLINE-DATA-TEMP-ID".equals(designFormData.getId())) {
            return Result.OK((String)"\u6dfb\u52a0\u6210\u529f", (Object)designFormData.getId());
        }
        try {
            if (CommonConstant.DESIGN_FORM_TYPE_SUB.equals(designForm.getDesformType())) {
                designFormData.setDesformId(designForm.getParentId());
                designFormData.setDesformCode(designForm.getParentCode());
            } else {
                designFormData.setDesformId(designForm.getId());
            }
            designFormData.setDesformName(designForm.getDesformName());
            designFormData.setDelFlag(CommonConstant.DEL_FLAG_0);
            SysUserCacheInfo userCacheInfo = this.commonApi.getCacheUser(designFormData.getCreateBy());
            if (userCacheInfo != null) {
                designFormData.setSysOrgCode(userCacheInfo.getSysOrgCode());
            }
            this.superServ.save(designFormData);
            this.indexService.save(designForm, designFormData);
            boolean transactional = config.getBooleanValue("transactional");
            boolean customUrlFail = this.a(designFormData, designForm, method, transactional);
            this.a(designFormData, designForm, designList, config, isExternal);
            this.a(desformCode, specialWidgets.get((Object)WidgetTypes.LINK_RECORD), designFormData, null, this.p);
            Objects.requireNonNull(this);
            super.a("ADD", desformCode, specialWidgets, designFormData, null);
            super.a(desformCode, designFormData);
            this.e.a(specialWidgets.get((Object)WidgetTypes.OA_SIGN_PATCH_SELECT), designFormData);
            super.a("add", designFormData, desformCode, designFormData.isTriggerProcess());
            JSONObject result = new JSONObject();
            result.put("dataId", (Object)designFormData.getId());
            result.put("customURLFail", (Object)customUrlFail);
            return Result.OK((String)"\u6dfb\u52a0\u6210\u529f\uff01", (Object)result);
        }
        catch (Exception e4) {
            o.error(e4.getMessage(), (Throwable)e4);
            throw new JeecgBootException("\u64cd\u4f5c\u5931\u8d25\uff1a" + e4.getMessage());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<?> addOne(DesignFormData designFormData) {
        return this.addOne(designFormData, false);
    }

    @Override
    protected boolean a(String desformCode, Collection<String> dataIds) {
        return this.superServ.removeBatchByIds(dataIds);
    }

    private void a(DesignFormData designFormData, DesignForm designForm, JSONArray dataList, JSONObject config, boolean isExternal) {
        org.jeecg.modules.online.desform.util.h.a(() -> {
            try {
                boolean enableNotice = config.getBooleanValue("enableNotice");
                if (!enableNotice) {
                    return;
                }
                String noticeMode = config.getString("noticeMode");
                if ("external".equals(noticeMode) && !isExternal) {
                    return;
                }
                String noticeType = config.getString("noticeType");
                String noticeReceiver = config.getString("noticeReceiver");
                MessageDTO md = new MessageDTO();
                md.setToAll(Boolean.valueOf(false));
                md.setTitle("[" + designForm.getDesformName() + "]\u65b0\u589e\u4e86\u4e00\u6761\u6570\u636e");
                MessageTypeEnum messageType = MessageTypeEnum.valueOfType((String)noticeType);
                switch (Objects.requireNonNull(messageType)) {
                    case XT: 
                    case YJ: {
                        md.setTemplateCode("desform_notice_write_email");
                        break;
                    }
                    default: {
                        md.setTemplateCode("desform_notice_write_wechat");
                    }
                }
                md.setToUser(noticeReceiver);
                md.setType(noticeType);
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("userName", designForm.getCreateBy());
                String domainUrl = this.a.getDomainUrl().getPc();
                String formLink = domainUrl + "/online/desform/list/" + designForm.getDesformCode();
                data.put("formLink", formLink);
                data.put("formName", designForm.getDesformName());
                data.put("createTime", ((SimpleDateFormat)DateUtils.datetimeFormat.get()).format(designFormData.getCreateTime()));
                StringBuffer dataHtml = new StringBuffer();
                JSONObject dataJson = JSONObject.parseObject((String)designFormData.getDesformDataJson());
                org.jeecg.modules.online.desform.util.h.a(dataList, (WidgetTypes type, JSONObject item, JSONObject parent) -> {
                    String dataValue = dataJson.getString(item.getString("model"));
                    if (oConvertUtils.isNotEmpty((Object)dataValue)) {
                        dataHtml.append("<p><h4>").append(item.getString("name")).append("</h4><div>").append(dataValue).append("</div></p>");
                    }
                });
                data.put("dataHtml", dataHtml.toString());
                data.put("moreLink", formLink);
                md.setData(data);
                md.setFromUser("system");
                this.sysBaseApi.sendTemplateMessage(md);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        });
    }

    private boolean a(DesignFormData designFormData, DesignForm designForm, HttpMethod method, boolean transactional) {
        Object url;
        boolean customUrlFail = false;
        JSONObject designJson = JSON.parseObject((String)designForm.getDesformDesignJson());
        JSONArray curl = designJson.getJSONObject("config").getJSONArray("customRequestURL");
        if (curl != null && curl.size() > 0 && oConvertUtils.isNotEmpty((Object)(url = curl.getJSONObject(0).getString("url")))) {
            url = ((String)url).trim();
            o.info("\u63d0\u4ea4\u5230\u7528\u6237\u81ea\u5b9a\u4e49url:" + (String)url);
            String regexp = "^https?:/{2}";
            if (!Pattern.matches(regexp, (CharSequence)url)) {
                url = RestUtil.getBaseUrl() + (String)url;
            }
            JSONObject formData = JSON.parseObject((String)JSON.toJSONString((Object)designFormData));
            formData.put("dataId", (Object)designFormData.getId());
            HttpHeaders headers = new HttpHeaders();
            String mediaType = "application/json";
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set("Accept", mediaType);
            HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
            String token = request.getHeader("X-Access-Token");
            headers.set("X-Access-Token", token);
            ResponseEntity response = RestUtil.request((String)url, (HttpMethod)method, (HttpHeaders)headers, null, (Object)formData, JSONObject.class);
            if (HttpStatus.OK == response.getStatusCode()) {
                JSONObject res = (JSONObject)response.getBody();
                String success = "success";
                if (res == null || !res.getBooleanValue(success)) {
                    String resMessage;
                    Object message = "";
                    if (res != null && oConvertUtils.isNotEmpty((Object)(resMessage = res.getString("message")))) {
                        message = ":" + resMessage;
                    }
                    o.error("\u540c\u6b65\u4fdd\u5b58\u5230\u7528\u6237\u81ea\u5b9a\u4e49URL\u5931\u8d25\uff1a" + response.toString());
                    if (transactional) {
                        throw new JeecgBootException("\u4fdd\u5b58\u5230\u81ea\u5b9a\u4e49URL\u5931\u8d25" + (String)message);
                    }
                    customUrlFail = true;
                }
            } else {
                o.error("\u540c\u6b65\u4fdd\u5b58\u5230\u7528\u6237\u81ea\u5b9a\u4e49URL\u5931\u8d25\uff1a" + response.toString());
                if (transactional) {
                    throw new JeecgBootException("\u540c\u6b65\u4fdd\u5b58\u5230\u7528\u6237\u81ea\u5b9a\u4e49URL\u5931\u8d25");
                }
                customUrlFail = true;
            }
        }
        return customUrlFail;
    }

    @Transactional(rollbackFor={Exception.class})
    public Result<?> editOne(DesignFormData designFormData) {
        DesignFormData designFormEntity = (DesignFormData)this.superServ.getById((Serializable)((Object)designFormData.getId()));
        if (designFormEntity == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e!");
        }
        String desformCode = designFormData.getDesformCode();
        if (StringUtil.isEmpty((String)desformCode)) {
            return Result.error((String)"\u5fc5\u987b\u4f20\u9012 desformCode \u53c2\u6570");
        }
        DesignForm designForm = this.desformService.getByCode(desformCode);
        if (designForm == null) {
            return Result.error((String)("\u8868\u5355\u8bbe\u8ba1\u5668\uff08" + desformCode + "\uff09\u4e0d\u5b58\u5728"));
        }
        designFormData.setDesformId(designForm.getId());
        designFormData.setDesformCode(designForm.getDesformCode());
        designFormData.setDesformName(designForm.getDesformName());
        if (org.jeecg.modules.online.desform.constant.b.e.equals(designForm.getDesformType())) {
            desformCode = designForm.getParentCode();
        }
        JSONObject desformData = designFormData.getDesformData();
        JSONObject designJson = JSON.parseObject((String)designForm.getDesformDesignJson());
        JSONArray dataList = designJson.getJSONArray("list");
        String uniqueMessage = super.a(desformCode, dataList, desformData);
        if (oConvertUtils.isNotEmpty((Object)uniqueMessage)) {
            return Result.error((String)uniqueMessage);
        }
        Object xOaTimeoutDateObj = designFormData.getDesformData().get((Object)"x_oa_timeout_date");
        if (oConvertUtils.isNotEmpty((Object)xOaTimeoutDateObj)) {
            try {
                if (xOaTimeoutDateObj instanceof Long) {
                    designFormData.setxOaTimeoutDate(new Date((Long)xOaTimeoutDateObj));
                }
            }
            catch (Exception e2) {
                o.warn("\u8d85\u65f6\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u65e0\u6cd5\u8f6c\u6362\u6210\u65e5\u671f\u7c7b\u578b", (Throwable)e2);
            }
        }
        if (!super.a(designFormData)) {
            throw new JeecgBootException("\u4fdd\u5b58\u5173\u8054\u8bb0\u5f55\u7684\u4e34\u65f6\u6570\u636e\u5931\u8d25");
        }
        desformData = designFormData.getDesformData();
        DesignFormData oldFormData = this.getById(desformCode, designFormData.getId());
        if (oldFormData == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e!");
        }
        ArrayList dataKeys = new ArrayList(desformData.keySet());
        for (String key : dataKeys) {
            if (!key.endsWith("_dictText") && !key.endsWith("_dictColor")) continue;
            desformData.remove((Object)key);
        }
        designFormData.setDesformDataJson(desformData.toJSONString());
        HttpMethod method = HttpMethod.PUT;
        try {
            if (oConvertUtils.isNotEmpty((Object)oldFormData.getOnlineFormCode())) {
                designFormData.setOnlineFormCode(oldFormData.getOnlineFormCode());
                designFormData.setOnlineFormDataId(oldFormData.getOnlineFormDataId());
                super.a(designFormData, dataList, method);
            }
        }
        catch (Exception e3) {
            o.error("\u540c\u6b65\u66f4\u65b0\u5230Online\u8868\u5355\u5931\u8d25", (Throwable)e3);
            throw new JeecgBootBizTipException("\u540c\u6b65\u66f4\u65b0\u5230Online\u8868\u5355\u5931\u8d25\uff1a" + e3.getMessage());
        }
        if ("ONLINE-DATA-TEMP-ID".equals(designFormData.getId())) {
            return Result.OK((String)"\u6dfb\u52a0\u6210\u529f", (Object)designFormData.getId());
        }
        Map<WidgetTypes, List<JSONObject>> specialWidgets = org.jeecg.modules.online.desform.util.h.d(dataList);
        super.b(desformCode, specialWidgets.get((Object)WidgetTypes.SUB_TABLE_DESIGN), designFormData);
        designFormData.setDesformId(null);
        designFormData.setDesformCode(null);
        this.superServ.updateById(designFormData);
        this.indexService.update(designForm, designFormData);
        JSONObject config = designJson.getJSONObject("config");
        boolean transactional = config.getBooleanValue("transactional");
        boolean customUrlFail = this.a(designFormData, designForm, method, transactional);
        this.a(desformCode, specialWidgets.get((Object)WidgetTypes.LINK_RECORD), designFormData, oldFormData, this.p);
        super.a(this.p, desformCode, specialWidgets, designFormData, oldFormData);
        super.a(designForm, oldFormData, designFormData);
        super.b(designForm, oldFormData, designFormData);
        super.a("update", oldFormData, desformCode, designFormData.isTriggerProcess());
        JSONObject result = new JSONObject();
        result.put("dataId", (Object)designFormData.getId());
        result.put("customURLFail", (Object)customUrlFail);
        return Result.OK((String)"\u4fee\u6539\u6210\u529f\uff01", (Object)result);
    }

    public Result<?> deleteOne(DesignFormData designFormData) {
        String desformCode = designFormData.getDesformCode();
        if (oConvertUtils.isEmpty((Object)desformCode)) {
            return Result.error((String)"\u5fc5\u987b\u4f20\u9012 desformCode \u53c2\u6570");
        }
        DesignForm designForm = this.desformService.getByCode(desformCode);
        if (designForm == null) {
            return Result.error((String)("\u8868\u5355\u8bbe\u8ba1\u5668\uff08" + desformCode + "\uff09\u4e0d\u5b58\u5728"));
        }
        if ((designFormData = (DesignFormData)this.superServ.getById((Serializable)((Object)designFormData.getId()))) == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        }
        this.superServ.removeById((Serializable)((Object)designFormData.getId()));
        JSONObject designJson = JSON.parseObject((String)designForm.getDesformDesignJson());
        JSONArray designList = designJson.getJSONArray("list");
        Map<WidgetTypes, List<JSONObject>> specialWidgets = org.jeecg.modules.online.desform.util.h.d(designList);
        this.c(designFormData);
        this.indexService.delete(designFormData.getDesformCode(), designFormData.getId());
        super.b(designForm, designFormData, null);
        this.e.b(specialWidgets.get((Object)WidgetTypes.OA_SIGN_PATCH_SELECT), designFormData);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public void a(List<String> idList) {
        List dataList = this.baseMapper.selectList((Wrapper)new LambdaQueryWrapper().in(DesignFormData::getId, idList));
        this.b(dataList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void b(List<DesignFormData> dataList) {
        HashMap<String, DesignForm> formMap = new HashMap<String, DesignForm>();
        for (DesignFormData designFormData : dataList) {
            String desformCode = designFormData.getDesformCode();
            if (oConvertUtils.isEmpty((Object)desformCode)) {
                o.warn("\u6570\u636eID\u4e3a " + designFormData.getId() + " \u7684 desformCode \u4e3a\u7a7a\uff0c\u8df3\u8fc7\u5220\u9664");
                continue;
            }
            DesignForm designForm = (DesignForm)formMap.get(desformCode);
            if (designForm == null) {
                designForm = this.desformService.getByCode(desformCode);
                if (designForm == null) {
                    o.warn("\u8868\u5355\u8bbe\u8ba1\u5668 " + desformCode + " \u4e0d\u5b58\u5728\uff0c\u8df3\u8fc7\u5220\u9664");
                    continue;
                }
                formMap.put(desformCode, designForm);
            }
            this.baseMapper.deleteById((Serializable)((Object)designFormData.getId()));
            JSONObject designJson = JSON.parseObject((String)designForm.getDesformDesignJson());
            JSONArray designList = designJson.getJSONArray("list");
            Map<WidgetTypes, List<JSONObject>> specialWidgets = org.jeecg.modules.online.desform.util.h.d(designList);
            this.c(designFormData);
            this.indexService.delete(designFormData.getDesformCode(), designFormData.getId());
            super.b(designForm, designFormData, null);
            this.e.b(specialWidgets.get((Object)WidgetTypes.OA_SIGN_PATCH_SELECT), designFormData);
        }
    }

    private void c(DesignFormData designFormData) {
        String onlineFormCode = designFormData.getOnlineFormCode();
        String onlineDataId = designFormData.getOnlineFormDataId();
        if (StringUtil.isNotBlank((String)onlineFormCode) && StringUtil.isNotBlank((String)onlineDataId)) {
            try {
                this.onlineBaseExtApi.cgformDeleteDataByCode(onlineFormCode, onlineDataId);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    @Override
    public JSONObject queryJmReportDataById(IdOrCodeParam idOrCode, String id) throws Exception {
        return super.queryJmReportDataById(idOrCode, id);
    }

    @Override
    public Page<JSONObject> queryJmReportDataList(String desformCode, int pageNo, int pageSize) {
        return super.queryJmReportDataList(desformCode, pageNo, pageSize);
    }

    @Override
    public List<JSONObject> queryJmReportSubDataById(IdOrCodeParam idOrCode, String id, String subCode) throws Exception {
        return Collections.emptyList();
    }

    private boolean b(List<DesformWidget> widgetList, String key) {
        for (DesformWidget widget : widgetList) {
            if (!widget.getModel().equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<DesignFormData> queryByCode(String desformCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DesignFormData::getDesformCode, (Object)desformCode);
        return this.superServ.list((Wrapper)queryWrapper);
    }

    @Override
    public List<JSONObject> listFieldById(String desformCode, String id, String fieldKeys, DesformSuperQuery superQuery) {
        Map<String, String[]> parameterMap;
        DesignForm designForm = this.desformService.getByCode(desformCode);
        if (designForm == null) {
            throw new JeecgBootException("\u8868\u5355\u4e0d\u5b58\u5728", CommonConstant.SC_INTERNAL_NOT_FOUND_404.intValue());
        }
        if (superQuery == null) {
            superQuery = new DesformSuperQuery();
        }
        HashSet<String> idSet = new HashSet<String>(Arrays.asList(id.split(",")));
        String[] fields = null;
        if (oConvertUtils.isNotEmpty((Object)fieldKeys)) {
            fields = fieldKeys.split(",");
        }
        if ((parameterMap = superQuery.getParameterMap()) == null) {
            parameterMap = new HashMap<String, String[]>();
            superQuery.setParameterMap(parameterMap);
        }
        parameterMap.put("id", new String[]{id});
        List<DesignFormData> list = this.list(desformCode, superQuery);
        ArrayList<DesignFormData> newList = new ArrayList<DesignFormData>();
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        for (DesignFormData data : list) {
            JSONObject desformData;
            DesignFormData newData = new DesignFormData();
            newData.setId(data.getId());
            if (fields != null) {
                desformData = new JSONObject();
                for (String field : fields) {
                    desformData.put(field, data.getDesformData().get((Object)field));
                }
            } else {
                desformData = data.getDesformData();
            }
            newData.setDesformData(desformData);
            newList.add(newData);
            desformData.put("id", (Object)data.getId());
            result.add(desformData);
            idSet.remove(data.getId());
        }
        for (String tempId : idSet) {
            JSONObject record = new JSONObject();
            record.put("id", (Object)tempId);
            result.add(record);
        }
        this.translService.a(designForm, newList);
        return result;
    }

    @Override
    public Page<DesignFormData> a(Page<DesignFormData> page, String desformCode) {
        return this.page(page, desformCode, null);
    }

    @Override
    public Page<DesignFormData> page(Page<DesignFormData> page, String desformCode, DesformSuperQuery superQuery) {
        try {
            Result<Page<DesignFormData>> res = this.queryPage(desformCode, page, superQuery, null);
            if (res.isSuccess()) {
                return (Page)res.getResult();
            }
            o.error("page \u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)res.getMessage());
        }
        catch (UnsupportedEncodingException e2) {
            o.error(e2.getMessage(), (Throwable)e2);
        }
        page.setRecords(new ArrayList());
        return page;
    }

    @Override
    public List<Map<String, Object>> getExportDataPage(String username, DesignForm designForm, DesformSuperQuery superQuery, int pageNo, int pageSize, ListViewModel listViewModel) {
        String desformCode = designForm.getDesformCode();
        try {
            Result<Page<DesignFormData>> pageData = this.queryPage(desformCode, (Page<DesignFormData>)new Page((long)pageNo, (long)pageSize), superQuery, username);
            if (!pageData.isSuccess()) {
                throw new JeecgBootBizTipException(pageData.getMessage());
            }
            Page page = (Page)pageData.getResult();
            List dataList = page.getRecords();
            this.queryLinkFieldData(designForm, dataList);
            return dataList.stream().map(DesignFormData::getDesformData).collect(Collectors.toList());
        }
        catch (UnsupportedEncodingException e2) {
            throw new JeecgBootException("\u5bfc\u51fa\u5931\u8d25\uff1a" + e2.getMessage());
        }
    }

    @Override
    public boolean save(String desformCode, DesignFormData entity) {
        return this.superServ.save(entity);
    }

    @Override
    public boolean saveBatch(String desformCode, Collection<DesignFormData> entityList) {
        boolean flag = this.superServ.saveBatch(entityList);
        if (!flag) {
            return false;
        }
        this.indexService.saveBatch(desformCode, entityList);
        for (DesignFormData data : entityList) {
            super.a("add", data, desformCode, data.isTriggerProcess());
        }
        return true;
    }

    @Override
    public boolean removeById(String desformCode, Serializable id) {
        return this.superServ.removeById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean removeLogicallyById(String desformCode, Serializable id) {
        ArrayList<String> idList = new ArrayList<String>();
        idList.add((String)((Object)id));
        return this.removeBatchLogicallyByIds(desformCode, idList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean removeBatchLogicallyByIds(String desformCode, List<String> idList) {
        return this.removeBatchLogicallyByIds(desformCode, idList, true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean removeBatchLogicallyByIds(String desformCode, List<String> idList, Boolean isTriggerProcess) {
        if (oConvertUtils.isEmpty((Object)desformCode)) {
            throw new JeecgBootException("\u5fc5\u987b\u4f20\u9012 desformCode");
        }
        DesignForm designForm = this.desformService.getByCode(desformCode);
        if (designForm == null) {
            throw new JeecgBootException("\u8868\u5355\u8bbe\u8ba1\u5668\uff08" + desformCode + "\uff09\u4e0d\u5b58\u5728");
        }
        List<DesignFormData> dataList = this.getByIds(desformCode, idList);
        if (dataList == null || dataList.isEmpty()) {
            return true;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"id", idList);
        DesignFormData updateEntity = new DesignFormData();
        updateEntity.setDelFlag(CommonConstant.DEL_FLAG_1);
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        if (sysUser != null) {
            updateEntity.setDeleteBy(sysUser.getUsername());
        }
        updateEntity.setDeleteTime(new Date());
        boolean result = this.superServ.update(updateEntity, (Wrapper)queryWrapper);
        if (result) {
            JSONObject designJson = JSON.parseObject((String)designForm.getDesformDesignJson());
            JSONArray designList = designJson.getJSONArray("list");
            Map<WidgetTypes, List<JSONObject>> specialWidgets = org.jeecg.modules.online.desform.util.h.d(designList);
            for (DesignFormData oldDesignFormData : dataList) {
                this.a(desformCode, specialWidgets.get((Object)WidgetTypes.LINK_RECORD), oldDesignFormData, null, this.r);
                super.a(this.r, desformCode, specialWidgets, oldDesignFormData, null);
                if (!isTriggerProcess.booleanValue()) continue;
                super.a("delete", oldDesignFormData, desformCode, true);
            }
            return true;
        }
        return false;
    }

    private synchronized void a(String desformCode, List<JSONObject> widgets, DesignFormData designFormData, DesignFormData oldFormData, String actionType) {
        if (widgets == null || widgets.isEmpty()) {
            return;
        }
        boolean isDelete = this.q.equals(actionType);
        boolean isLogicDelete = this.r.equals(actionType);
        isDelete = isDelete || isLogicDelete;
        JSONObject newData = designFormData.getDesformData();
        JSONObject oldData = null;
        if (oldFormData != null) {
            oldData = oldFormData.getDesformData();
        }
        if (oldData == null) {
            oldData = newData;
        }
        for (JSONObject widget : widgets) {
            JSONObject options = widget.getJSONObject("options");
            String twoWayModel = options.getString("twoWayModel");
            if (oConvertUtils.isEmpty((Object)twoWayModel)) continue;
            String model = widget.getString("model");
            o.info("---\u81ea\u52a8\u66f4\u65b0\u53cc\u5411\u5173\u8054\u6570\u636e---\u5b57\u6bb5: desformCode={}\uff0ctwoWayModel={}\uff0c model={}", new Object[]{desformCode, twoWayModel, model});
            o.debug("---\u81ea\u52a8\u66f4\u65b0\u53cc\u5411\u5173\u8054\u6570\u636e---\u5b57\u6bb5: options={}", (Object)options);
            List<String> oldDataIds = this.b(oldData, model);
            List<String> newDataIds = this.b(newData, model);
            ArrayList<String> needToDeleteDataIds = new ArrayList<String>(oldDataIds);
            needToDeleteDataIds.removeAll(newDataIds);
            String sourceCode = options.getString("sourceCode");
            boolean isSubTable = widget.getBooleanValue("isSubTable");
            if (isSubTable && isDelete) {
                if (isLogicDelete) {
                    this.removeBatchLogicallyByIds(sourceCode, newDataIds);
                    continue;
                }
                this.removeBatchByIds(sourceCode, newDataIds);
                continue;
            }
            if (isSubTable && !needToDeleteDataIds.isEmpty()) {
                this.removeBatchLogicallyByIds(sourceCode, needToDeleteDataIds);
            }
            ArrayList<DesignFormData> updateDataList = new ArrayList<DesignFormData>();
            ArrayList<String> newAndOldDataIds = new ArrayList<String>();
            newAndOldDataIds.addAll(oldDataIds);
            newAndOldDataIds.addAll(newDataIds);
            List<DesignFormData> sourceDataList = this.getByIds(sourceCode, newAndOldDataIds);
            if (sourceDataList == null) continue;
            for (DesignFormData sourceData : sourceDataList) {
                Object idsObj = sourceData.getDesformData().get((Object)twoWayModel);
                JSONArray ids = idsObj instanceof List ? sourceData.getDesformData().getJSONArray(twoWayModel) : new JSONArray();
                if (!isDelete) {
                    String relationPrimaryTableForeignKey = "sys:cache:desform:relFieldOldVal::" + sourceCode + ":" + twoWayModel;
                    this.b.set(relationPrimaryTableForeignKey, oldDataIds, 1800L);
                    o.info("---\u81ea\u52a8\u66f4\u65b0\u53cc\u5411\u5173\u8054\u6570\u636e----Cache Relation PrimaryTable\uff0ckey={}\uff0coldDataIds={}", (Object)relationPrimaryTableForeignKey, (Object)ids);
                }
                if (ids.contains((Object)designFormData.getId())) {
                    if (isDelete) {
                        ids.remove((Object)designFormData.getId());
                    } else {
                        if (!needToDeleteDataIds.contains(sourceData.getId())) continue;
                        ids.remove((Object)designFormData.getId());
                    }
                } else {
                    if (isDelete) continue;
                    ids.add((Object)designFormData.getId());
                }
                sourceData.getDesformData().put(twoWayModel, (Object)ids);
                super.b(sourceData);
                updateDataList.add(sourceData);
            }
            if (updateDataList.isEmpty()) continue;
            this.updateBatchById(updateDataList);
        }
    }

    private List<String> b(JSONObject data, String model) {
        ArrayList<String> dataIds;
        Object dataIdArrayObj = data.get((Object)model);
        if (oConvertUtils.isEmpty((Object)dataIdArrayObj)) {
            return new ArrayList<String>();
        }
        if (dataIdArrayObj instanceof JSONArray) {
            JSONArray dataIdArray = data.getJSONArray(model);
            if (dataIdArray == null) {
                return new ArrayList<String>();
            }
            dataIds = dataIdArray.toJavaList(String.class);
        } else if (dataIdArrayObj instanceof List) {
            dataIds = new ArrayList((List)dataIdArrayObj);
        } else {
            dataIds = new ArrayList<String>();
            dataIds.add(dataIdArrayObj.toString());
        }
        return dataIds;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean restoreData(String desformCode, List<String> idList) {
        if (oConvertUtils.isEmpty((Object)desformCode)) {
            throw new JeecgBootException("\u5fc5\u987b\u4f20\u9012 desformCode");
        }
        if (idList == null) {
            throw new JeecgBootException("\u5fc5\u987b\u4f20\u9012 idList");
        }
        if ((idList = idList.stream().filter(id -> !oConvertUtils.isEmpty((Object)id)).collect(Collectors.toList())).isEmpty()) {
            throw new JeecgBootException("\u5fc5\u987b\u4f20\u9012 idList");
        }
        DesignForm designForm = this.desformService.getByCode(desformCode);
        if (designForm == null) {
            throw new JeecgBootException("\u8868\u5355\u8bbe\u8ba1\u5668\uff08" + desformCode + "\uff09\u4e0d\u5b58\u5728");
        }
        List<DesignFormData> dataList = this.getByIds(desformCode, idList);
        if (dataList == null || dataList.isEmpty()) {
            throw new JeecgBootException("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        }
        JSONObject designJson = JSON.parseObject((String)designForm.getDesformDesignJson());
        JSONArray designList = designJson.getJSONArray("list");
        Map<WidgetTypes, List<JSONObject>> specialWidgets = org.jeecg.modules.online.desform.util.h.d(designList);
        List linkRecordList = specialWidgets.computeIfAbsent(WidgetTypes.LINK_RECORD, v2 -> new ArrayList()).stream().filter(widget -> widget.getBooleanValue("isSubTable")).collect(Collectors.toList());
        for (DesignFormData data : dataList) {
            String mainId = data.getId();
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"id", (Object)mainId);
            DesignFormData updateEntity = new DesignFormData();
            updateEntity.setDelFlag(org.jeecg.modules.online.desform.constant.b.ak);
            JSONObject oldJson = data.getDesformData();
            if (!linkRecordList.isEmpty()) {
                for (JSONObject linkRecord : linkRecordList) {
                    String twoWayModel;
                    JSONObject options = linkRecord.getJSONObject("options");
                    String subTableCode = options.getString("sourceCode");
                    if (oConvertUtils.isEmpty((Object)subTableCode) || oConvertUtils.isEmpty((Object)(twoWayModel = options.getString("twoWayModel")))) continue;
                    DesformSuperQuery superQuery = new DesformSuperQuery();
                    superQuery.add(new SuperQueryItem("string", twoWayModel, mainId, QueryRuleEnum.IN));
                    List<DesignFormData> subDataList = this.list(subTableCode, superQuery);
                    if (subDataList == null || subDataList.isEmpty()) continue;
                    DesignFormData subUpdateEntity = new DesignFormData();
                    subUpdateEntity.setDelFlag(org.jeecg.modules.online.desform.constant.b.ak);
                    QueryWrapper subUpdateQuery = new QueryWrapper();
                    subUpdateQuery.eq((Object)"id", (Object)mainId);
                    this.superServ.update(subUpdateEntity, (Wrapper)subUpdateQuery);
                    List subIdList = subDataList.stream().map(DesignFormData::getId).collect(Collectors.toList());
                    String model = linkRecord.getString("model");
                    oldJson.put(model, subIdList);
                }
            }
            Objects.requireNonNull(this);
            super.a("LOGIC_RESTORE", desformCode, specialWidgets, data, null);
            updateEntity.setDesformData(oldJson);
            this.superServ.update(updateEntity, (Wrapper)queryWrapper);
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean clearRecycle(String desformCode) {
        if (oConvertUtils.isEmpty((Object)desformCode)) {
            throw new JeecgBootException("\u5fc5\u987b\u4f20\u9012 desformCode \u53c2\u6570");
        }
        DesignForm designForm = this.desformService.getByCode(desformCode);
        if (designForm == null) {
            throw new JeecgBootException("\u8868\u5355\u8bbe\u8ba1\u5668\uff08" + desformCode + "\uff09\u4e0d\u5b58\u5728");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DesignFormData::getDesformCode, (Object)desformCode);
        queryWrapper.eq(DesignFormData::getDelFlag, (Object)org.jeecg.modules.online.desform.constant.b.al);
        List dataList = this.superServ.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return true;
        }
        this.b(dataList);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean removeBatchByIds(String desformCode, List<String> idList) {
        this.a(idList);
        return true;
    }

    @Override
    public DesignFormData getByOnlineDataId(String desformCode, String onlineDataId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DesignFormData::getOnlineFormDataId, (Object)onlineDataId);
        return (DesignFormData)this.superServ.getOne((Wrapper)queryWrapper);
    }

    @Override
    public boolean updateById(DesignFormData entity) {
        boolean flag;
        boolean updateDataJson;
        DesignFormData oldData = (DesignFormData)this.superServ.getById((Serializable)((Object)entity.getId()));
        if (oldData == null) {
            return false;
        }
        JSONObject oldJson = oldData.getDesformData();
        JSONObject newJson = entity.getDesformData();
        boolean bl = updateDataJson = newJson != null;
        if (updateDataJson) {
            newJson.forEach((key, value) -> {
                if (value != null) {
                    oldJson.put(key, value);
                }
            });
            entity.setDesformData(oldJson);
        }
        if (flag = this.superServ.updateById(entity)) {
            if (!updateDataJson) {
                entity.setDesformData(oldJson);
            }
            this.indexService.update(entity.getDesformCode(), entity);
        }
        return flag;
    }

    @Override
    public boolean updateBatchById(List<DesignFormData> entityList) {
        for (DesignFormData data : entityList) {
            this.updateById(data);
        }
        return true;
    }

    @Override
    public boolean removeByCode(String desformCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DesignFormData::getDesformCode, (Object)desformCode);
        return this.superServ.remove((Wrapper)queryWrapper);
    }

    @Override
    public DesignFormData getById(String desformCode, String id) {
        return (DesignFormData)this.superServ.getById((Serializable)((Object)id));
    }

    @Override
    public JSONObject getFieldDataById(String desformCode, String dataId, Collection<String> fieldNames) {
        AssertUtils.assertNotEmpty((String)"dataId \u4e0d\u80fd\u4e3a\u7a7a", (Object)dataId);
        o.debug("sql\u6a21\u5f0f\u4e0d\u652f\u6301\u83b7\u53d6\u6307\u5b9a\u5b57\u6bb5\u7684\u6570\u636e\uff0c\u5df2\u91cd\u5b9a\u5411\u4e3a\u83b7\u53d6\u5168\u90e8\u6570\u636e\uff0c\u5e76\u624b\u52a8\u8fc7\u6ee4\u5b57\u6bb5");
        DesignFormData formData = this.getById(desformCode, dataId);
        if (formData != null && formData.getDesformData() != null) {
            JSONObject dataJson = formData.getDesformData();
            if (CollectionUtils.isEmpty(fieldNames)) {
                return dataJson;
            }
            JSONObject filterData = new JSONObject();
            for (String field : fieldNames) {
                if (!dataJson.containsKey((Object)field)) continue;
                filterData.put(field, dataJson.get((Object)field));
            }
            return filterData;
        }
        return null;
    }

    @Override
    public DesignFormData getDataWithDictText(String desformCode, String id) {
        return null;
    }

    @Override
    public List<DesignFormData> getByIds(String desformCode, Collection<String> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Collections.emptyList();
        }
        return this.superServ.listByIds(idList);
    }

    @Override
    public boolean removeFieldById(String desformCode, String dataId, String ... fieldNames) {
        return false;
    }

    @Override
    public Result<?> batchUpdate(BatchUpdateModel batchUpdateModel) {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String userId = sysUser.getId();
        String appId = batchUpdateModel.getAppId();
        String designFormCode = batchUpdateModel.getDesignFormCode();
        String authType = batchUpdateModel.getAuthType();
        if (oConvertUtils.isEmpty((Object)authType)) {
            return Result.error((String)"\u53c2\u6570\u7f3a\u5931!");
        }
        LowAppFormAuthRecordModel authRecord = null;
        if (oConvertUtils.isNotEmpty((Object)appId) && this.lowAppBaseApi != null) {
            try {
                authRecord = this.lowAppBaseApi.getLowAppReadAuth(userId, appId, designFormCode, authType);
            }
            catch (NoSuchBeanDefinitionException e2) {
                o.warn("\u4f4e\u4ee3\u7801\u6a21\u5f0f\uff0c\u4e0d\u9700\u8981\u96f6\u4ee3\u7801\u5e94\u7528\u6743\u9650\u5224\u65ad~");
            }
            catch (RuntimeException e3) {
                if (e3.getClass().getName().contains("feign.FeignException")) {
                    o.warn("\u3010\u5fae\u670d\u52a1\u3011\u4f4e\u4ee3\u7801\u6a21\u5f0f\uff0c\u4e0d\u9700\u8981\u96f6\u4ee3\u7801\u5e94\u7528\u6743\u9650\u5224\u65ad~");
                }
                throw e3;
            }
        }
        List<String> idList = batchUpdateModel.getIdList();
        if (authRecord == null || authRecord.isUpdateAll()) {
            this.a(designFormCode, idList, batchUpdateModel.getField(), batchUpdateModel.getVal());
        } else if (authRecord.isUpdateOwn()) {
            boolean hasNoAuthData = false;
            String username = sysUser.getUsername();
            List<DesignFormData> dataList = this.getByIds(designFormCode, idList);
            DesignForm designForm = this.desformService.getByCode(designFormCode);
            List roleCodeList = this.sysBaseApi.getRolesByUsername(username);
            List departIdList = this.sysBaseApi.getDepartIdsByUsername(username);
            List<DesformWidget> widgets = org.jeecg.modules.online.desform.mongo.b.a.b(designForm, "owners");
            ArrayList<String> updateIdList = new ArrayList<String>();
            for (DesignFormData designFormData : dataList) {
                boolean ownAuth = this.a(designFormData, widgets, username, roleCodeList, departIdList);
                if (!ownAuth) {
                    hasNoAuthData = true;
                    continue;
                }
                updateIdList.add(designFormData.getId());
            }
            if (updateIdList.size() > 0) {
                this.a(designFormCode, updateIdList, batchUpdateModel.getField(), batchUpdateModel.getVal());
            }
            if (hasNoAuthData) {
                if (batchUpdateModel.isUpdate()) {
                    return Result.ok((String)"\u4fee\u6539\u6210\u529f\uff0c\u65e0\u7f16\u8f91\u6743\u9650\u7684\u8bb0\u5f55\u65e0\u6cd5\u4fee\u6539!");
                }
                return Result.ok((String)"\u5220\u9664\u6210\u529f\uff0c\u65e0\u5220\u9664\u6743\u9650\u7684\u8bb0\u5f55\u65e0\u6cd5\u5220\u9664!");
            }
        } else {
            return Result.error((String)"\u6ca1\u6709\u6743\u9650!");
        }
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f!");
    }

    private boolean a(DesignFormData designFormData, List<DesformWidget> widgets, String username, List<String> roleCodeList, List<String> departIdList) {
        boolean flag = false;
        String createBy = designFormData.getCreateBy();
        if (createBy != null && createBy.equals(username)) {
            return true;
        }
        JSONObject json = designFormData.getDesformData();
        if (!widgets.isEmpty()) {
            block0: for (DesformWidget widget : widgets) {
                String str;
                int n2;
                int n3;
                String objStr;
                JSONArray dataArray;
                ArrayList list;
                Object obj;
                WidgetTypes type = widget.getType();
                String model = widget.getModel();
                if (flag) break;
                if (WidgetTypes.SELECT_USER.equals((Object)type)) {
                    obj = json.get((Object)model);
                    if (obj == null) continue;
                    if (obj instanceof ArrayList) {
                        list = (ArrayList)obj;
                        if (!list.contains(username)) continue;
                        flag = true;
                        break;
                    }
                    if (obj instanceof JSONArray) {
                        dataArray = json.getJSONArray(model);
                        if (!dataArray.contains((Object)username)) continue;
                        flag = true;
                        break;
                    }
                    objStr = obj.toString();
                    String[] stringArray = objStr.split(",");
                    n3 = stringArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        str = stringArray[n2];
                        if (!str.equals(username)) continue;
                        flag = true;
                        continue block0;
                    }
                    continue;
                }
                if (WidgetTypes.SELECT_DEPART.equals((Object)type)) {
                    obj = json.get((Object)model);
                    if (obj == null || departIdList == null || departIdList.isEmpty()) continue;
                    if (obj instanceof ArrayList) {
                        list = (ArrayList)obj;
                        for (String str2 : list) {
                            if (!departIdList.contains(str2)) continue;
                            flag = true;
                            continue block0;
                        }
                        continue;
                    }
                    if (obj instanceof JSONArray) {
                        dataArray = json.getJSONArray(model);
                        for (int i2 = 0; i2 < dataArray.size(); ++i2) {
                            String str3 = dataArray.getString(i2);
                            if (!departIdList.contains(str3)) continue;
                            flag = true;
                            continue block0;
                        }
                        continue;
                    }
                    objStr = obj.toString();
                    String[] i2 = objStr.split(",");
                    int str3 = i2.length;
                    for (n2 = 0; n2 < str3; ++n2) {
                        str = i2[n2];
                        if (!departIdList.contains(str)) continue;
                        flag = true;
                        continue block0;
                    }
                    continue;
                }
                if (!WidgetTypes.ORG_ROLE.equals((Object)type) || (obj = json.get((Object)model)) == null || roleCodeList == null || roleCodeList.isEmpty()) continue;
                if (obj instanceof ArrayList) {
                    list = (ArrayList)obj;
                    for (String str4 : list) {
                        if (!roleCodeList.contains(str4)) continue;
                        flag = true;
                        continue block0;
                    }
                    continue;
                }
                if (obj instanceof JSONArray) {
                    dataArray = json.getJSONArray(model);
                    for (int i3 = 0; i3 < dataArray.size(); ++i3) {
                        String str5 = dataArray.getString(i3);
                        if (!roleCodeList.contains(str5)) continue;
                        flag = true;
                        continue block0;
                    }
                    continue;
                }
                objStr = obj.toString();
                String[] stringArray = objStr.split(",");
                n3 = stringArray.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    str = stringArray[n2];
                    if (!roleCodeList.contains(str)) continue;
                    flag = true;
                    continue block0;
                }
            }
        }
        return flag;
    }

    private void a(String designFormCode, List<String> idList, String field, Object val) {
        DesignForm designForm = this.desformService.getByCode(designFormCode);
        if (designForm == null) {
            return;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"id", idList);
        boolean isLogicallyDelete = false;
        if ("del_flag".equals(field) && val != null && org.jeecg.modules.online.desform.constant.b.al.equals(val)) {
            isLogicallyDelete = true;
        }
        if (isLogicallyDelete) {
            this.removeBatchLogicallyByIds(designFormCode, idList);
            LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            DesignFormData updateEntity = new DesignFormData();
            if (sysUser != null) {
                updateEntity.setDeleteBy(sysUser.getUsername());
            }
            updateEntity.setDeleteTime(new Date());
            updateEntity.setDelFlag(CommonConstant.DEL_FLAG_1);
            this.superServ.update(updateEntity, (Wrapper)queryWrapper);
        }
    }

    @Override
    public void a(Set<String> approvalModels, DesignFormData oldData) {
        JSONObject json = oldData.getDesformData();
        if (json == null) {
            json = new JSONObject();
        }
        for (String field : approvalModels) {
            json.put(field, (Object)"");
        }
        DesignFormData updateEntity = new DesignFormData();
        updateEntity.setId(oldData.getId());
        updateEntity.setDesformData(json);
        this.updateById(updateEntity);
    }

    @Override
    public List<DesignFormData> querySubTableData(String designFormCode, String subTableField, String mainDataId, DesformSuperQuery desformSuperQuery) {
        return Collections.emptyList();
    }

    @Override
    public List<DictModel> queryLinkDataOptions(String desformCode, String fieldModel) {
        return Collections.emptyList();
    }

    @Override
    public void handlerSubTableDataByBatchInsert(DesignFormData designFormData) {
        String code = designFormData.getDesformCode();
        o.info("\u8c03\u7528\u4e86 \u3010\u6279\u91cf\u63d2\u5165\u5b50\u8868\u65b0\u6570\u636e\uff0c\u5173\u8054\u8bb0\u5f55\uff08\u5b50\u8868\u6a21\u5f0f\uff09\u3011\uff0ccode\uff1a {}\uff0cdesignFormData\uff1a {}", (Object)code, (Object)designFormData);
        DesignForm designForm = this.desformService.getByCode(code);
        JSONArray dataList = org.jeecg.modules.online.desform.util.h.b(designForm);
        DesformWidgetList allWidgetList = org.jeecg.modules.online.desform.util.h.a(dataList, false);
        List<DesformWidget> widgetList = allWidgetList.main;
        JSONObject formData = designFormData.getDesformData();
        for (DesformWidget widget : widgetList) {
            Object val;
            WidgetTypes type = widget.getType();
            String model = widget.getModel();
            if (WidgetTypes.LINK_RECORD != type || !widget.isSubTable() || (val = formData.get((Object)model)) == null) continue;
            try {
                List<JSONObject> subTableRecordList = this.a(widget, val);
                DesignForm subDesignForm = this.desformService.getByCode(widget.getOptions().getSourceCode());
                String twoWayModel = widget.getOptions().getTwoWayModel();
                subTableRecordList.forEach(jsonObject -> jsonObject.remove((Object)twoWayModel));
                this.saveBatchByImport(subDesignForm, subTableRecordList, false);
                JSONArray relationIds = subTableRecordList.stream().map(jsonObject -> jsonObject.get((Object)"_id")).collect(Collectors.toCollection(JSONArray::new));
                formData.put(model, (Object)relationIds);
            }
            catch (Exception e2) {
                o.error("\u5b50\u8868\u6570\u636e\u8f6c\u5316\u5931\u8d25:" + val.toString());
            }
        }
    }

    @Override
    protected List<JSONObject> a(String desformCode, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<JSONObject>();
        }
        List dataList = this.superServ.listByIds(ids);
        return dataList.stream().map(DesignFormData::getDesformData).collect(Collectors.toList());
    }

    @Override
    public void updateLinkRecordDataForAdd(String desformCode, List<JSONObject> linkRecordList, List<JSONObject> dataList) {
        if (linkRecordList != null && !linkRecordList.isEmpty() && dataList != null && !dataList.isEmpty()) {
            for (JSONObject data : dataList) {
                DesignFormData designFormData = new DesignFormData(desformCode, data);
                String id = data.getString("_id");
                designFormData.setId(id);
                this.a(desformCode, linkRecordList, designFormData, null, this.p);
            }
        }
    }

    @Override
    public void updateLinkRecordDataForUpdate(String desformCode, List<JSONObject> linkRecordList, DesignFormData designFormData, DesignFormData oldData) {
        if (linkRecordList != null && !linkRecordList.isEmpty()) {
            this.a(desformCode, linkRecordList, oldData, null, this.r);
            this.a(desformCode, linkRecordList, designFormData, null, this.p);
        }
    }

    @Override
    public boolean checkUniqueForField(String desformCode, String fieldName, String fieldValue, String dataId) {
        return false;
    }

    @Override
    public Object queryADefValLinkageData(ADefValLinkageVo vo, DesformExtentdParam desformExtentdParam) throws UnsupportedEncodingException {
        DesformSuperQueryGroup desformSuperQueryGroup = DesformQueryUtils.parseSuperQueryGroup(vo.getSuperQueryString(), null);
        Page page = new Page(1L, 1L);
        if (vo.getOperation() == null) {
            vo.setOperation(DesformOperationEnum.FIRST);
        }
        if (vo.isMultiple()) {
            page.setSize(vo.getMaxRecordCount() == null ? 200L : (long)vo.getMaxRecordCount().intValue());
        }
        boolean isAsc = true;
        boolean isCount = false;
        boolean isCustomSort = false;
        boolean isIgnore = false;
        switch (vo.getOperation()) {
            case IGNORE: {
                isIgnore = true;
            }
            case CUSTOM_SORT: {
                isCustomSort = true;
            }
            case FIRST: {
                isAsc = false;
            }
            case LAST: {
                List dataList;
                Result<Page<DesignFormData>> result;
                String order = isAsc ? "asc" : "desc";
                String sortString = isCustomSort ? vo.getSortString() : null;
                List<OrderItem> orderItemList = DesformQueryUtils.a("create_time", order, sortString);
                page.setOrders(orderItemList);
                if (isIgnore) {
                    page.setSize(2L);
                }
                if (!(result = this.queryPage(vo.getDesformCode(), (Page<DesignFormData>)page, desformSuperQueryGroup, desformExtentdParam)).isSuccess() || CollectionUtils.isEmpty((Collection)(dataList = ((Page)result.getResult()).getRecords()))) break;
                if (isIgnore && dataList.size() > 1) {
                    return "";
                }
                if (vo.isDesignSubMode()) {
                    return this.a(vo, dataList);
                }
                ADefValLinkageVo.LinkageItem linkageItem = vo.getLinkages().get(0);
                String linkModel = linkageItem.getLinkModel();
                if (vo.isMultiple()) {
                    ArrayList<String> dataObjs = new ArrayList<String>();
                    for (DesignFormData data : dataList) {
                        JSONObject formData = data.getDesformData();
                        dataObjs.add(formData.getString(linkModel));
                    }
                    return dataObjs;
                }
                JSONObject formData = ((DesignFormData)dataList.get(0)).getDesformData();
                return formData.getString(linkModel);
            }
            case COUNT: {
                isCount = true;
            }
            case MAX: 
            case MIN: 
            case AVG: 
            case SUM: {
                Result<?> result2;
                String linkModel = "";
                if (!isCount) {
                    if (vo.getLinkages().isEmpty()) {
                        o.error("\u805a\u5408\u65f6\u975ecount\u64cd\u4f5c\uff0clinkages\u4e0d\u80fd\u4e3a\u7a7a");
                        return "";
                    }
                    ADefValLinkageVo.LinkageItem linkageItem = vo.getLinkages().get(0);
                    linkModel = linkageItem.getLinkModel();
                }
                if (!(result2 = this.queryOperation(vo.getDesformCode(), vo.getOperation(), linkModel, desformSuperQueryGroup, desformExtentdParam)).isSuccess()) break;
                return result2.getResult();
            }
        }
        return "";
    }

    private List<JSONObject> a(ADefValLinkageVo vo, List<DesignFormData> dataList) {
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        for (DesignFormData data : dataList) {
            JSONObject source = data.getDesformData();
            JSONObject target = new JSONObject();
            for (ADefValLinkageVo.LinkageItem linkageItem : vo.getLinkages()) {
                target.put(linkageItem.getModel(), source.get((Object)linkageItem.getLinkModel()));
            }
            list.add(target);
        }
        return list;
    }

    @Override
    @Deprecated
    public List<DictModel> linkFormGetOptions(String desformCode, String fieldModel) {
        return Collections.emptyList();
    }

    @Override
    public List<DictModel> linkDataGetOptions(String desformCode, String fieldModel, String superQueryString, org.jeecg.modules.online.desform.constant.d sortType) {
        DesformSuperQueryGroup superQueryGroup = DesformQueryUtils.autoParseSuperQueryGroup(superQueryString, new HashMap<String, String[]>());
        if (superQueryGroup == null) {
            superQueryGroup = new DesformSuperQueryGroup();
        }
        return this.a(desformCode, fieldModel, superQueryGroup, sortType);
    }

    private List<DictModel> a(String desformCode, String fieldModel, DesformSuperQueryGroup superQueryGroup, org.jeecg.modules.online.desform.constant.d sortType) {
        String sortField;
        DesignForm designForm = this.desformService.getByCode(desformCode);
        if (designForm == null) {
            throw new JeecgBootBizTipException("\u8868\u5355\u8bbe\u8ba1\u5668\uff08" + desformCode + "\uff09\u4e0d\u5b58\u5728");
        }
        DesformExtentdParam extendParams = new DesformExtentdParam();
        String username = JwtUtil.getUserNameByToken((HttpServletRequest)SpringContextUtils.getHttpServletRequest());
        extendParams.setUsername(username);
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        parameterMap.put("del_flag", new String[]{org.jeecg.modules.online.desform.constant.b.ak.toString()});
        extendParams.setParameterMap(parameterMap);
        SuperQuerySqlConditions sqConditions = (SuperQuerySqlConditions)this.dataDao.generateConditions(designForm, superQueryGroup, null, extendParams);
        QueryWrapper<DesignFormData> groupQueryWrapper = sqConditions.getQueryWrapper();
        Map<String, Object> valueMap = sqConditions.getValueMap();
        if (groupQueryWrapper != null) {
            o.warn("[desform-sql] \u67e5\u8be2\u6761\u4ef6: {}", (Object)groupQueryWrapper.getCustomSqlSegment());
            o.warn("[desform-sql] \u67e5\u8be2\u503c\uff08paramNameValuePairs\uff09: {}", (Object)JSON.toJSONString((Object)groupQueryWrapper.getParamNameValuePairs()));
        }
        if (valueMap != null && !valueMap.isEmpty()) {
            o.warn("[desform-sql] \u67e5\u8be2\u503c\uff08valueMap\uff09: {}", (Object)JSON.toJSONString(valueMap));
        }
        String valueKey = "value";
        DesformWidget widget = org.jeecg.modules.online.desform.util.h.a(designForm, fieldModel);
        if (widget != null) {
            SuperQueryItem queryItem = new SuperQueryItem(widget.getType().getType(), fieldModel, "", QueryRuleEnum.EQ);
            org.jeecg.modules.online.desform.datafactory.impl.sql.c.b checker = new org.jeecg.modules.online.desform.datafactory.impl.sql.c.b(queryItem);
            valueKey = checker.a;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select((Object[])new String[]{valueKey});
        queryWrapper.eq((Object)"field_name", (Object)fieldModel);
        if (oConvertUtils.isNotEmpty((Object)sqConditions.getUserDataIdSql())) {
            queryWrapper.inSql((Object)"data_id", sqConditions.getUserDataIdSql());
        }
        if (sortType == null) {
            sortType = org.jeecg.modules.online.desform.constant.d.a;
        }
        String string = sortField = sortType.getField() == null ? valueKey : sortType.getField();
        if (org.jeecg.modules.online.desform.constant.d.c.getField().equals(sortField) || org.jeecg.modules.online.desform.constant.d.e.getField().equals(sortField)) {
            sortField = valueKey;
        }
        if (sortType.b()) {
            queryWrapper.orderByAsc((Object)sortField);
        } else {
            queryWrapper.orderByDesc((Object)sortField);
        }
        List<Map<String, Object>> result = this.columnDataMapper.selectMapsBySuperQuery((Wrapper<DesignFormColumnData>)queryWrapper, valueMap);
        if (CollectionUtils.isEmpty(result)) {
            return Collections.emptyList();
        }
        ArrayList<DictModel> dictModelList = new ArrayList<DictModel>();
        for (Map<String, Object> item : result) {
            Object value = item.get(valueKey);
            if (!oConvertUtils.isNotEmpty((Object)value)) continue;
            DictModel dictModel = new DictModel();
            dictModel.setValue(value.toString());
            dictModel.setText(dictModel.getValue());
            dictModelList.add(dictModel);
        }
        return dictModelList;
    }

    @Override
    public List<DesignFormData> list(DesformQuery desformQuery) {
        String desformCode = desformQuery.getDesformCode();
        if (desformQuery.getSuperQueryGroup() != null) {
            DesignForm designForm = this.desformService.getByCode(desformCode);
            DesformExtentdParam extendParams = new DesformExtentdParam();
            String username = JwtUtil.getUserNameByToken((HttpServletRequest)SpringContextUtils.getHttpServletRequest());
            extendParams.setUsername(username);
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
            if (desformQuery.getQueryDeleted() != null && !desformQuery.getQueryDeleted().booleanValue()) {
                parameterMap.put("del_flag", new String[]{CommonConstant.DEL_FLAG_0.toString()});
            }
            extendParams.setParameterMap(parameterMap);
            SuperQuerySqlConditions sqConditions = (SuperQuerySqlConditions)this.dataDao.generateConditions(designForm, desformQuery.getSuperQueryGroup(), null, extendParams);
            QueryWrapper<DesignFormData> queryWrapper = sqConditions.getQueryWrapper();
            Map<String, Object> valueMap = sqConditions.getValueMap();
            if (queryWrapper != null) {
                o.debug("[desform-sql] \u67e5\u8be2\u6761\u4ef6: {}", (Object)queryWrapper.getCustomSqlSegment());
                o.debug("[desform-sql] \u67e5\u8be2\u503c\uff08paramNameValuePairs\uff09: {}", (Object)JSON.toJSONString((Object)queryWrapper.getParamNameValuePairs()));
            }
            if (valueMap != null && !valueMap.isEmpty()) {
                o.debug("[desform-sql] \u67e5\u8be2\u503c\uff08valueMap\uff09: {}", (Object)JSON.toJSONString(valueMap));
            }
            return this.baseMapper.selectListBySuperQuery((Wrapper<DesignFormData>)queryWrapper, valueMap);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        if (oConvertUtils.isNotEmpty((Object)desformCode)) {
            queryWrapper.eq((Object)"desform_code", (Object)desformCode);
        }
        if (desformQuery.getQueryDeleted() != null && !desformQuery.getQueryDeleted().booleanValue()) {
            queryWrapper.eq((Object)"del_flag", (Object)CommonConstant.DEL_FLAG_0);
        }
        return this.superServ.list((Wrapper)queryWrapper);
    }

    @Override
    public boolean updateWithOldData(String desformCode, DesignFormData newData, DesignFormData oldData) {
        return this.updateWithOldData(desformCode, newData.getDesformData(), oldData.getDesformData());
    }

    @Override
    public boolean updateWithOldData(String desformCode, JSONObject newData, JSONObject oldData) {
        String id = newData.getString("_id");
        if (oConvertUtils.isEmpty((Object)id)) {
            return false;
        }
        for (String key : newData.keySet()) {
            if ("_id".equals(key)) continue;
            oldData.put(key, newData.get((Object)key));
        }
        DesignFormData updateData = new DesignFormData(desformCode, oldData);
        updateData.setId(id);
        return this.superServ.updateById(updateData);
    }

    @Override
    public List<JSONObject> getMainData(String desformCode, String matchMainField, String subTableKey, Set<Object> matchValues) {
        DesformQuery query = new DesformQuery(desformCode);
        query.setQueryDeleted(false);
        DesformSuperQuery superQuery = new DesformSuperQuery();
        List listVal = matchValues.stream().map(Object::toString).collect(Collectors.toList());
        String joinVal = String.join((CharSequence)",", listVal);
        superQuery.add(new SuperQueryItem("string", matchMainField, joinVal, QueryRuleEnum.IN));
        query.setSuperQuery(superQuery);
        return this.list(query).stream().map(data -> {
            JSONObject formData = data.getDesformData();
            formData.put("_id", (Object)data.getId());
            return formData;
        }).collect(Collectors.toList());
    }

    @Override
    protected Long a(String desformCode, String parentField, String parentId) {
        DesignForm designForm = this.desformService.getByCode(desformCode);
        DesformExtentdParam extendParams = new DesformExtentdParam();
        String username = JwtUtil.getUserNameByToken((HttpServletRequest)SpringContextUtils.getHttpServletRequest());
        extendParams.setUsername(username);
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        extendParams.setParameterMap(parameterMap);
        parameterMap.put("del_flag", new String[]{CommonConstant.DEL_FLAG_0.toString()});
        extendParams.setParameterMap(parameterMap);
        DesformSuperQueryGroup superQueryGroup = super.a(parentField, parentId);
        SuperQuerySqlConditions sqConditions = (SuperQuerySqlConditions)this.dataDao.generateConditions(designForm, superQueryGroup, null, extendParams);
        QueryWrapper<DesignFormData> groupQueryWrapper = sqConditions.getQueryWrapper();
        Map<String, Object> valueMap = sqConditions.getValueMap();
        if (groupQueryWrapper != null) {
            o.debug("[desform-sql] \u67e5\u8be2\u6761\u4ef6: {}", (Object)groupQueryWrapper.getCustomSqlSegment());
            o.debug("[desform-sql] \u67e5\u8be2\u503c\uff08paramNameValuePairs\uff09: {}", (Object)JSON.toJSONString((Object)groupQueryWrapper.getParamNameValuePairs()));
        }
        if (valueMap != null && !valueMap.isEmpty()) {
            o.debug("[desform-sql] \u67e5\u8be2\u503c\uff08valueMap\uff09: {}", (Object)JSON.toJSONString(valueMap));
        }
        return this.baseMapper.countBySuperQuery((Wrapper<DesignFormData>)groupQueryWrapper, valueMap);
    }

    @Override
    public List<DesignFormData> list(String desformCode, DesformSuperQuery superQuery) {
        try {
            HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
            String username = JwtUtil.getUserNameByToken((HttpServletRequest)request);
            Result<List<DesignFormData>> res = this.a(desformCode, superQuery, null, username);
            if (res.isSuccess()) {
                return (List)res.getResult();
            }
            o.error("list \u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)res.getMessage());
        }
        catch (Exception e2) {
            o.error(e2.getMessage(), (Throwable)e2);
        }
        return new ArrayList<DesignFormData>();
    }

    @Override
    public Result<Page<DesignFormData>> queryPage(String desformCode, Page<DesignFormData> page, DesformSuperQuery superQuery, String username) throws UnsupportedEncodingException {
        Result result = new Result();
        Result<?> get = this.a(desformCode, page, superQuery, username, false);
        BeanUtils.copyProperties(get, (Object)result);
        return result;
    }

    private Result<List<DesignFormData>> a(String desformCode, DesformSuperQuery superQuery, List<OrderItem> orderItems, String username) throws UnsupportedEncodingException {
        Result result = new Result();
        Page page = new Page();
        if (!CollectionUtils.isEmpty(orderItems)) {
            page.addOrder(orderItems);
        }
        Result<?> get = this.a(desformCode, (Page<DesignFormData>)page, superQuery, username, true);
        BeanUtils.copyProperties(get, (Object)result);
        return result;
    }

    private Result<?> a(String desformCode, Page<DesignFormData> page, DesformSuperQuery superQuery, String username, boolean queryList) throws UnsupportedEncodingException {
        DesformSuperQueryGroup superQueryGroup = DesformQueryUtils.a(superQuery);
        DesformExtentdParam desformExtentdParam = new DesformExtentdParam(superQuery == null ? "" : superQuery.getListViewId(), superQuery != null && superQuery.isQueryLinkField(), null, username, superQuery == null ? new HashMap() : superQuery.getParameterMap());
        desformExtentdParam.setParentField(superQuery.getParentField());
        desformExtentdParam.setParentId(superQuery.getParentId());
        return this.a(desformCode, page, superQueryGroup, desformExtentdParam, queryList);
    }

    private static /* synthetic */ Object a(SerializedLambda lambda) {
        switch (lambda.getImplMethodName()) {
            case "getOnlineFormDataId": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormData") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return DesignFormData::getOnlineFormDataId;
            }
            case "getDelFlag": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormData") || !lambda.getImplMethodSignature().equals("()Ljava/lang/Integer;")) break;
                return DesignFormData::getDelFlag;
            }
            case "getId": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormData") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return DesignFormData::getId;
            }
            case "getDesformCode": {
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormData") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignFormData::getDesformCode;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormData") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignFormData::getDesformCode;
                }
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormData") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return DesignFormData::getDesformCode;
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }
}

