/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.desform.vo.widget;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import lombok.Generated;
import org.jeecg.modules.online.desform.constant.WidgetTypes;
import org.jeecg.modules.online.desform.vo.widget.DesformCheckRule;
import org.jeecg.modules.online.desform.vo.widget.DesformOptions;
import org.jeecg.modules.online.desform.vo.widget.DesformRemoteApi;

public class DesformWidget {
    private WidgetTypes type;
    private String name;
    private boolean hideTitle = false;
    private boolean isSubItem = false;
    private boolean isSubTable = false;
    private boolean isContainer = false;
    private boolean isSummary = false;
    private String key;
    private String model;
    private List<DesformCheckRule> rules;
    private DesformRemoteApi remoteAPI;
    private DesformOptions options;
    private String advancedSetting;

    public void setType(String type) {
        this.type = WidgetTypes.getByValue(type);
    }

    public void setType(WidgetTypes type) {
        this.type = type;
    }

    public DesformWidget() {
    }

    public DesformWidget(String name, String key, WidgetTypes type) {
        this.name = name;
        this.type = type;
        this.model = key;
        this.key = key;
        if ("create_by".equals(key) || "update_by".equals(key)) {
            DesformOptions options = new DesformOptions();
            options.setCustomReturnField("username");
            this.options = options;
        } else if ("create_time".equals(key) || "update_time".equals(key)) {
            DesformOptions options = new DesformOptions();
            options.setType("datetime");
            options.setFormat("yyyy-MM-dd HH:mm:ss");
            this.options = options;
        }
    }

    public static DesformWidget getIdWidget() {
        return new DesformWidget("\u8bb0\u5f55ID", "_id", WidgetTypes.INPUT);
    }

    public static DesformWidget parse(JSONObject widgetJson) {
        if (widgetJson == null) {
            return null;
        }
        DesformWidget widget = (DesformWidget)widgetJson.toJavaObject(DesformWidget.class);
        JSONObject options = widgetJson.getJSONObject("options");
        widget.setType(widgetJson.getString("type"));
        widget.options.setRange(options.getBooleanValue("isRange"));
        return widget;
    }

    @Generated
    public WidgetTypes getType() {
        return this.type;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean isHideTitle() {
        return this.hideTitle;
    }

    @Generated
    public boolean isSubItem() {
        return this.isSubItem;
    }

    @Generated
    public boolean isSubTable() {
        return this.isSubTable;
    }

    @Generated
    public boolean isContainer() {
        return this.isContainer;
    }

    @Generated
    public boolean isSummary() {
        return this.isSummary;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public List<DesformCheckRule> getRules() {
        return this.rules;
    }

    @Generated
    public DesformRemoteApi getRemoteAPI() {
        return this.remoteAPI;
    }

    @Generated
    public DesformOptions getOptions() {
        return this.options;
    }

    @Generated
    public String getAdvancedSetting() {
        return this.advancedSetting;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setHideTitle(boolean hideTitle) {
        this.hideTitle = hideTitle;
    }

    @Generated
    public void setSubItem(boolean isSubItem) {
        this.isSubItem = isSubItem;
    }

    @Generated
    public void setSubTable(boolean isSubTable) {
        this.isSubTable = isSubTable;
    }

    @Generated
    public void setContainer(boolean isContainer) {
        this.isContainer = isContainer;
    }

    @Generated
    public void setSummary(boolean isSummary) {
        this.isSummary = isSummary;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setModel(String model) {
        this.model = model;
    }

    @Generated
    public void setRules(List<DesformCheckRule> rules) {
        this.rules = rules;
    }

    @Generated
    public void setRemoteAPI(DesformRemoteApi remoteAPI) {
        this.remoteAPI = remoteAPI;
    }

    @Generated
    public void setOptions(DesformOptions options) {
        this.options = options;
    }

    @Generated
    public void setAdvancedSetting(String advancedSetting) {
        this.advancedSetting = advancedSetting;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof DesformWidget)) {
            return false;
        }
        DesformWidget other = (DesformWidget)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isHideTitle() != other.isHideTitle()) {
            return false;
        }
        if (this.isSubItem() != other.isSubItem()) {
            return false;
        }
        if (this.isSubTable() != other.isSubTable()) {
            return false;
        }
        if (this.isContainer() != other.isContainer()) {
            return false;
        }
        if (this.isSummary() != other.isSummary()) {
            return false;
        }
        WidgetTypes this$type = this.getType();
        WidgetTypes other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<DesformCheckRule> this$rules = this.getRules();
        List<DesformCheckRule> other$rules = other.getRules();
        if (this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules)) {
            return false;
        }
        DesformRemoteApi this$remoteAPI = this.getRemoteAPI();
        DesformRemoteApi other$remoteAPI = other.getRemoteAPI();
        if (this$remoteAPI == null ? other$remoteAPI != null : !((Object)this$remoteAPI).equals(other$remoteAPI)) {
            return false;
        }
        DesformOptions this$options = this.getOptions();
        DesformOptions other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        String this$advancedSetting = this.getAdvancedSetting();
        String other$advancedSetting = other.getAdvancedSetting();
        return !(this$advancedSetting == null ? other$advancedSetting != null : !this$advancedSetting.equals(other$advancedSetting));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DesformWidget;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHideTitle() ? 79 : 97);
        result = result * 59 + (this.isSubItem() ? 79 : 97);
        result = result * 59 + (this.isSubTable() ? 79 : 97);
        result = result * 59 + (this.isContainer() ? 79 : 97);
        result = result * 59 + (this.isSummary() ? 79 : 97);
        WidgetTypes $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<DesformCheckRule> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        DesformRemoteApi $remoteAPI = this.getRemoteAPI();
        result = result * 59 + ($remoteAPI == null ? 43 : ((Object)$remoteAPI).hashCode());
        DesformOptions $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        String $advancedSetting = this.getAdvancedSetting();
        result = result * 59 + ($advancedSetting == null ? 43 : $advancedSetting.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DesformWidget(type=" + this.getType() + ", name=" + this.getName() + ", hideTitle=" + this.isHideTitle() + ", isSubItem=" + this.isSubItem() + ", isSubTable=" + this.isSubTable() + ", isContainer=" + this.isContainer() + ", isSummary=" + this.isSummary() + ", key=" + this.getKey() + ", model=" + this.getModel() + ", rules=" + this.getRules() + ", remoteAPI=" + this.getRemoteAPI() + ", options=" + this.getOptions() + ", advancedSetting=" + this.getAdvancedSetting() + ")";
    }
}

