/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.desform.service.impl;

import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtil;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.CommonAPI;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLowApp;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.constant.enums.LowAppAopEnum;
import org.jeecg.common.es.JeecgElasticsearchTemplate;
import org.jeecg.common.exception.JeecgBootBizTipException;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.lowapp.model.LowAppCopyMenu;
import org.jeecg.common.lowapp.utils.LowAppCopyUtil;
import org.jeecg.common.online.api.IOnlineBaseExtApi;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.vo.DictModel;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.system.vo.SysUserCacheInfo;
import org.jeecg.common.util.BrowserUtils;
import org.jeecg.common.util.CommonUtils;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.dynamic.db.DbTypeUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.desform.constant.WidgetTypes;
import org.jeecg.modules.online.desform.d.a;
import org.jeecg.modules.online.desform.entity.DesignForm;
import org.jeecg.modules.online.desform.entity.DesignFormAuth;
import org.jeecg.modules.online.desform.entity.DesignFormData;
import org.jeecg.modules.online.desform.mapper.DesignFormDataMapper;
import org.jeecg.modules.online.desform.mapper.DesignFormMapper;
import org.jeecg.modules.online.desform.mongo.service.IDesignFormListViewService;
import org.jeecg.modules.online.desform.mongo.service.IDesignFormSettingService;
import org.jeecg.modules.online.desform.service.IDesignFormDataService;
import org.jeecg.modules.online.desform.service.IDesignFormService;
import org.jeecg.modules.online.desform.service.impl.b;
import org.jeecg.modules.online.desform.util.f;
import org.jeecg.modules.online.desform.util.h;
import org.jeecg.modules.online.desform.vo.DesignFormViewVo;
import org.jeecg.modules.online.desform.vo.GetNameVo;
import org.jeecg.modules.online.desform.vo.excel.DesformWidgetList;
import org.jeecg.modules.online.desform.vo.query.IdOrCodeParam;
import org.jeecg.modules.online.desform.vo.widget.DesformOptions;
import org.jeecg.modules.online.desform.vo.widget.DesformWidget;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Lazy;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="designFormServiceImpl")
public class g
extends ServiceImpl<DesignFormMapper, DesignForm>
implements IDesignFormService {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(g.class);
    @Autowired
    private DesignFormMapper designFormMapper;
    @Autowired
    private ISysBaseAPI sysBaseApi;
    @Autowired
    private IDesignFormDataService designFormDataService;
    @Autowired
    private DesignFormDataMapper designFormDataMapper;
    @Autowired
    private b designFormAuthService;
    @Lazy
    @Autowired
    private IOnlineBaseExtApi onlineBaseExtApi;
    @Autowired
    @Lazy
    private JeecgElasticsearchTemplate jes;
    @Autowired
    public RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IDesignFormListViewService designFormListViewService;
    @Autowired
    private IDesignFormSettingService designFormSettingService;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    @Lazy
    private RedisUtil redisUtil;
    @Lazy
    @Autowired
    a translService;
    @Lazy
    @Autowired
    private CommonAPI commonApi;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveMain(DesignForm designForm) {
        int res;
        SysUserCacheInfo userCacheInfo;
        if (designForm.getUpdateCount() == null) {
            designForm.setUpdateCount(0);
        }
        if (oConvertUtils.isEmpty((Object)designForm.getDesformType())) {
            designForm.setDesformType(org.jeecg.modules.online.desform.constant.b.d);
        }
        if ((userCacheInfo = this.commonApi.getCacheUser(designForm.getCreateBy())) != null) {
            designForm.setSysOrgCode(userCacheInfo.getSysOrgCode());
        }
        if ((res = this.designFormMapper.insert(designForm)) > 0 && oConvertUtils.isNotEmpty((Object)designForm.getDesformDesignJson())) {
            ArrayList authList = new ArrayList();
            f.a(designForm, (WidgetTypes type, JSONObject item, JSONObject parent) -> {
                if (item.getBooleanValue("isContainer")) {
                    return;
                }
                DesignFormAuth auth = new DesignFormAuth();
                auth.setDesformId(designForm.getId());
                auth.setDesformCode(designForm.getDesformCode());
                auth.setAuthTitle(item.getString("name"));
                auth.setAuthComKey(item.getString("key"));
                auth.setAuthField(item.getString("model"));
                auth.setStatus(org.jeecg.modules.online.desform.constant.b.h);
                boolean isSubTable = parent != null && parent.getString("type").equals(WidgetTypes.SUB_TABLE_DESIGN.getType());
                auth.setSubTable(isSubTable);
                authList.addAll(this.designFormAuthService.parseAuths(auth));
            });
            if (authList.size() > 0) {
                this.designFormAuthService.saveBatch(authList);
            }
        }
        if (res > 0) {
            long viewCount = this.designFormListViewService.countView(designForm.getDesformCode());
            if (viewCount > 0L) {
                a.info("\u5f53\u524d\u65b0\u589e\u7684\u8868\u5355\uff08" + designForm.getDesformCode() + "\uff09\u5305\u542b " + viewCount + " \u4e2a\u9057\u7559\u7684\u89c6\u56fe\uff0c\u5df2\u5168\u90e8\u5220\u9664");
                this.designFormListViewService.deleteFormViewData(designForm.getDesformCode());
            }
            this.designFormListViewService.createBaseView(designForm.getDesformCode());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delMain(String id) {
        DesignForm designForm = (DesignForm)((DesignFormMapper)this.baseMapper).selectById((Serializable)((Object)id));
        if (designForm != null) {
            this.designFormDataService.removeByCode(designForm.getDesformCode());
            this.designFormMapper.deleteById((Serializable)((Object)designForm.getId()));
            this.designFormAuthService.removeByCode(designForm.getDesformCode());
            this.designFormListViewService.deleteFormViewData(designForm.getDesformCode());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delBatchMain(Collection<? extends Serializable> idList) {
        List list = ((DesignFormMapper)this.baseMapper).selectList((Wrapper)new LambdaQueryWrapper().in(DesignForm::getId, idList));
        for (DesignForm designForm : list) {
            this.designFormDataService.removeByCode(designForm.getDesformCode());
            this.designFormMapper.deleteById((Serializable)((Object)designForm.getId()));
            this.designFormAuthService.removeByCode(designForm.getDesformCode());
            this.deleteRedisCache(designForm.getDesformCode());
            this.designFormListViewService.deleteFormViewData(designForm.getDesformCode());
        }
    }

    @Override
    @Cacheable(cacheNames={"sys:cache:desform:byCode"}, key="#desformCode", unless="#result == null")
    public DesignForm getByCode(String desformCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DesignForm::getDesformCode, (Object)desformCode);
        DesignForm designForm = (DesignForm)((DesignFormMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
        return designForm;
    }

    @Override
    @Cacheable(cacheNames={"sys:cache:desform:byCode"}, key="#desformId", unless="#result == null")
    public DesignForm getByIdCache(String desformId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DesignForm::getId, (Object)desformId);
        return (DesignForm)((DesignFormMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
    }

    @Override
    public DesignForm getByIdOrCode(@NotNull IdOrCodeParam param) {
        if (param.isId()) {
            return this.getByIdCache(param.getId());
        }
        if (param.isCode()) {
            return this.getByCode(param.getCode());
        }
        throw new JeecgBootException("\u53c2\u6570\u9519\u8bef\uff0cid\u548ccode\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
    }

    @Override
    @Cacheable(cacheNames={"sys:cache:desform:code2id"}, key="#desformCode", unless="#result == null")
    public String getIdByCode(String desformCode) {
        DesignForm designForm = this.getByCode(desformCode);
        if (designForm != null) {
            return designForm.getId();
        }
        return null;
    }

    @Override
    @Cacheable(cacheNames={"sys:cache:desform:id2code"}, key="#desformId", unless="#result == null")
    public String getCodeById(String desformId) {
        DesignForm designForm = this.getByIdCache(desformId);
        if (designForm != null) {
            return designForm.getDesformCode();
        }
        return null;
    }

    @Override
    @Cacheable(cacheNames={"sys:cache:desform:byCode"}, key="#desformCode + ':getName'", unless="#result == null")
    public GetNameVo getName(String desformCode) {
        DesignForm designForm = this.getByCode(desformCode);
        if (designForm == null) {
            return null;
        }
        GetNameVo vo = new GetNameVo();
        vo.setDesformName(designForm.getDesformName());
        String appId = designForm.getLowAppId();
        if (oConvertUtils.isNotEmpty((Object)appId)) {
            vo.setAppId(appId);
            vo.setAppName(((DesignFormMapper)this.baseMapper).getAppNameById(appId));
        }
        return vo;
    }

    @Override
    public void createMongoDBIndex(String desformCode) {
        boolean isExist = this.mongoTemplate.collectionExists(desformCode);
        if (!isExist) {
            this.mongoTemplate.createCollection(desformCode);
        }
        IndexOperations indexOps = this.mongoTemplate.indexOps(desformCode);
        indexOps.ensureIndex((IndexDefinition)new Index().on("create_time", Sort.Direction.DESC));
        indexOps.ensureIndex((IndexDefinition)new Index().on("del_flag", Sort.Direction.ASC));
    }

    @Override
    public void queryFormViewData(DesignForm designForm, String dataId, String onlineDataId, JSONObject content) {
        if (designForm == null) {
            throw new JeecgBootException("\u8868\u5355\u8bbe\u8ba1\u4e0d\u5b58\u5728\uff01");
        }
        content.put("designForm", (Object)this.loadDictOptionsDesignForm(designForm));
        String queryDesformCode = designForm.getDesformCode();
        if (org.jeecg.modules.online.desform.constant.b.e.equals(designForm.getDesformType())) {
            queryDesformCode = designForm.getParentCode();
        }
        content.put("queryDesformCode", (Object)queryDesformCode);
        JSONObject config = null;
        String desformDesignStr = designForm.getDesformDesignJson();
        if (oConvertUtils.isNotEmpty((Object)desformDesignStr)) {
            JSONObject json = JSONObject.parseObject((String)desformDesignStr);
            config = json.getJSONObject("config");
        }
        boolean defaultLoadLargeControls = false;
        if (config != null) {
            defaultLoadLargeControls = config.getBooleanValue("defaultLoadLargeControls");
        }
        content.put("defaultLoadLargeControls", (Object)defaultLoadLargeControls);
        if (!"add".equals(dataId)) {
            DesignFormData designFormData = null;
            if (StringUtil.isNotEmpty((String)onlineDataId)) {
                Object onlineFormObject;
                String tbname = null;
                if (config != null && (onlineFormObject = config.get((Object)"onlineForm")) != null) {
                    tbname = (String)onlineFormObject;
                }
                if (StringUtil.isNotEmpty(tbname)) {
                    designFormData = new DesignFormData();
                    JSONObject allData = this.onlineBaseExtApi.cgformQueryAllDataByTableName(tbname, onlineDataId);
                    if (allData == null) {
                        throw new JeecgBootException("\u8868\u5355\u6570\u636e\u4e0d\u5b58\u5728\uff01");
                    }
                    JSONObject dataMap = allData.getJSONObject("main");
                    JSONObject one2oneData = allData.getJSONObject("one2one");
                    JSONObject one2manyData = allData.getJSONObject("one2many");
                    if (one2oneData != null) {
                        for (String subTableName : one2oneData.keySet()) {
                            JSONObject subData = one2oneData.getJSONObject(subTableName);
                            for (String fieldKey : subData.keySet()) {
                                dataMap.put(subTableName + "#" + fieldKey, subData.get((Object)fieldKey));
                            }
                        }
                    }
                    if (one2manyData != null) {
                        Set one2manyDataKeys = one2manyData.keySet();
                        f.a(designForm, (WidgetTypes type, JSONObject item, JSONObject parent) -> {
                            if (type != WidgetTypes.SUB_TABLE_DESIGN) {
                                return;
                            }
                            JSONObject options = item.getJSONObject("options");
                            String subTableName = options.getString("subTableName");
                            if (oConvertUtils.isEmpty((Object)subTableName)) {
                                return;
                            }
                            if (one2manyDataKeys.contains(subTableName)) {
                                JSONArray subTableData = one2manyData.getJSONArray(subTableName);
                                dataMap.put(item.getString("model"), (Object)subTableData);
                            }
                        });
                    }
                    try {
                        DbType dbType = CommonUtils.getDatabaseTypeEnum();
                        if (DbTypeUtils.dbTypeIsOracle((DbType)dbType)) {
                            designFormData.setDesformDataJson(JSONObject.toJSONString(h.a((Map<String, Object>)dataMap)));
                        } else {
                            designFormData.setDesformDataJson(JSONObject.toJSONString((Object)dataMap));
                        }
                    }
                    catch (Exception e2) {
                        a.error(e2.getMessage(), (Throwable)e2);
                        designFormData.setDesformDataJson(JSONObject.toJSONString((Object)dataMap));
                    }
                    designFormData.setDesformId(designForm.getId());
                    designFormData.setDesformCode(designForm.getDesformCode());
                    designFormData.setDesformName(designForm.getDesformName());
                    designFormData.setOnlineFormCode(tbname);
                    designFormData.setOnlineFormDataId(onlineDataId);
                    DesignFormData mp = this.designFormDataService.getByOnlineDataId(queryDesformCode, onlineDataId);
                    if (mp != null) {
                        designFormData.setId(mp.getId());
                    } else {
                        designFormData.setId("ONLINE-DATA-TEMP-ID");
                    }
                }
            } else {
                designFormData = this.designFormDataService.getById(queryDesformCode, dataId);
            }
            if (designFormData == null) {
                throw new JeecgBootException("\u8868\u5355\u6570\u636e\u4e0d\u5b58\u5728\uff0cdataId=" + dataId);
            }
            content.put("designFormData", (Object)designFormData);
            a.debug(" designFormData: " + designFormData.toString());
            JSONObject translData = this.translService.a(designForm, designFormData);
            content.put("translData", (Object)JSON.toJSONString((Object)translData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
            content.put("encodeDataJson", (Object)URLUtil.encodeAll((String)designFormData.getDesformDataJson()));
        }
        this.updateHasWidgets(designForm.getDesformDesignJson(), content);
    }

    @Override
    public void queryFormViewById(String desformId, String dataId, String onlineDataId, JSONObject content) {
        DesignForm designForm = (DesignForm)this.getById((Serializable)((Object)desformId));
        this.queryFormViewData(designForm, dataId, onlineDataId, content);
    }

    @Override
    public void queryFormViewByCode(IdOrCodeParam idOrCode, String dataId, String onlineDataId, JSONObject content) {
        this.queryFormViewByCode(idOrCode, dataId, onlineDataId, false, content);
    }

    @Override
    public void queryFormAutoViewByCode(String desformCode, String dataId, String onlineDataId, JSONObject content) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DesignForm::getParentCode, (Object)desformCode);
        queryWrapper.eq(DesignForm::getIzMobileView, (Object)org.jeecg.modules.online.desform.constant.b.b);
        List designFormList = super.list((Wrapper)queryWrapper);
        DesignForm mobileForm = null;
        mobileForm = designFormList.size() > 0 ? (DesignForm)designFormList.get(0) : this.getByCode(desformCode);
        if (mobileForm == null) {
            throw new JeecgBootException("\u8868\u5355\u8bbe\u8ba1\u4e0d\u5b58\u5728\uff01");
        }
        this.queryFormViewData(mobileForm, dataId, onlineDataId, content);
    }

    @Override
    public void queryFormViewByCode(IdOrCodeParam idOrCode, String dataId, String onlineDataId, boolean isExternal, JSONObject content) {
        DesignForm designForm = this.getByIdOrCode(idOrCode);
        if (designForm != null && isExternal) {
            JSONObject json = JSON.parseObject((String)designForm.getDesformDesignJson());
            JSONObject config = json.getJSONObject("config");
            boolean allowExternalLink = config.getBooleanValue("allowExternalLink");
            if (!allowExternalLink) {
                throw new JeecgBootException("\u5df2\u7981\u6b62\u8bbf\u95ee\u6b64\u94fe\u63a5");
            }
            Boolean showSaveData = config.getBoolean("externalLinkShowData");
            content.put("showSaveData", (Object)(showSaveData == null || showSaveData != false ? 1 : 0));
            String externalTitle = config.getString("externalTitle");
            if (oConvertUtils.isEmpty((Object)externalTitle)) {
                externalTitle = designForm.getDesformName();
            }
            content.put("externalTitle", (Object)externalTitle);
            String headerImgUrl = config.getString("headerImgUrl");
            boolean showHeaderImg = false;
            if (oConvertUtils.isNotEmpty((Object)headerImgUrl)) {
                showHeaderImg = true;
                content.put("headerImgUrl", (Object)f.b(headerImgUrl));
            }
            content.put("showHeaderImg", (Object)showHeaderImg);
        }
        this.queryFormViewData(designForm, dataId, onlineDataId, content);
    }

    @Override
    public void updateHasWidgets(String designJson, JSONObject content) {
        if (designJson == null) {
            return;
        }
        JSONObject json = JSON.parseObject((String)designJson);
        JSONObject config = json.getJSONObject("config");
        JSONArray hasWidgets = null;
        if (config != null) {
            hasWidgets = config.getJSONArray("hasWidgets");
        }
        if (hasWidgets == null) {
            JSONArray finalHasWidgets = new JSONArray();
            f.a(json.getJSONArray("list"), (WidgetTypes type, JSONObject item, JSONObject parent) -> {
                if (!finalHasWidgets.contains((Object)type.getType())) {
                    finalHasWidgets.add((Object)type.getType());
                }
            });
            hasWidgets = finalHasWidgets;
        }
        HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
        boolean isMobile = BrowserUtils.isMobile((HttpServletRequest)request);
        boolean hasMap = hasWidgets.contains((Object)WidgetTypes.MAP.getType());
        boolean hasLocation = hasWidgets.contains((Object)WidgetTypes.LOCATION.getType());
        content.put("hasMap", (Object)(hasMap || hasLocation ? 1 : 0));
        boolean hasEditor = !isMobile && hasWidgets.contains((Object)WidgetTypes.EDITOR.getType());
        content.put("hasEditor", (Object)hasEditor);
        boolean hasMarkdown = !isMobile && hasWidgets.contains((Object)WidgetTypes.MARKDOWN.getType());
        content.put("hasMarkdown", (Object)hasMarkdown);
    }

    @Override
    public DesignForm loadDictOptionsDesignForm(DesignForm designForm) {
        String designJson = designForm.getDesformDesignJson();
        if (StringUtil.isEmpty((String)designJson)) {
            return designForm;
        }
        JSONObject json = JSONObject.parseObject((String)designJson, (Feature[])new Feature[]{Feature.OrderedField});
        JSONArray list = json.getJSONArray("list");
        for (int i2 = 0; i2 < list.size(); ++i2) {
            JSONObject item = list.getJSONObject(i2);
            String type = item.getString("type");
            if ("grid".equals(type) || "sub-table-design".equals(type)) {
                JSONArray columns = item.getJSONArray("columns");
                for (int j2 = 0; j2 < columns.size(); ++j2) {
                    JSONArray columnList = columns.getJSONObject(j2).getJSONArray("list");
                    for (int k2 = 0; k2 < columnList.size(); ++k2) {
                        JSONObject field = columnList.getJSONObject(k2);
                        this.a(field);
                    }
                }
                continue;
            }
            if ("card".equals(type)) {
                JSONArray columnList = item.getJSONArray("list");
                for (int k3 = 0; k3 < columnList.size(); ++k3) {
                    JSONObject field = columnList.getJSONObject(k3);
                    this.a(field);
                }
                continue;
            }
            this.a(item);
        }
        designForm.setDesformDesignJson(JSON.toJSONString((Object)json, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return designForm;
    }

    @Override
    public DesignForm loadTaskFieldAuthsDesignForm(DesignForm designForm, List<DesignFormAuth> designFormAuthList) {
        String designJson = designForm.getDesformDesignJson();
        if (StringUtil.isEmpty((String)designJson)) {
            return designForm;
        }
        JSONObject json = JSONObject.parseObject((String)designJson, (Feature[])new Feature[]{Feature.OrderedField});
        JSONArray list = json.getJSONArray("list");
        f.a(list, (WidgetTypes type, JSONObject item, JSONObject parent) -> this.a(item, designFormAuthList));
        designForm.setDesformDesignJson(JSON.toJSONString((Object)json, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return designForm;
    }

    private void a(JSONObject item) {
        JSONArray selectOptions;
        String type = item.getString("type");
        if (WidgetTypes.SELECT.getType().equals(type) && (selectOptions = this.b(item)) != null) {
            JSONObject options = item.getJSONObject("options");
            options.put("remote", (Object)false);
            options.put("showLabel", (Object)true);
            options.put("options", (Object)selectOptions);
            options.put("isDictItem", (Object)true);
        }
    }

    private void a(JSONObject field, List<DesignFormAuth> designFormAuthList) {
        String fieldModel = field.getString("model");
        Boolean isEdit = designFormAuthList.stream().anyMatch(e2 -> e2.getAuthField().equals(fieldModel) && e2.getAuthType() != null && "2".equals(e2.getAuthType()));
        Boolean isReadOnly = designFormAuthList.stream().anyMatch(e2 -> e2.getAuthField().equals(fieldModel) && e2.getAuthType() != null && "1".equals(e2.getAuthType()));
        Boolean isRequired = designFormAuthList.stream().anyMatch(e2 -> e2.getAuthField().equals(fieldModel) && e2.getRequired() != null && e2.getRequired() != false);
        JSONObject options = field.getJSONObject("options");
        if (isRequired != null && isRequired.booleanValue()) {
            options.put("readonly", (Object)false);
            options.put("disabled", (Object)false);
            options.put("required", (Object)true);
            options.put("hidden", (Object)false);
            String ruleString = "[{\"required\":true,\"message\":\"${title}\u5fc5\u987b\u586b\u5199\"}]";
            JSONArray rulesArray = JSONArray.parseArray((String)ruleString);
            field.put("rules", (Object)rulesArray);
        } else if (isEdit != null && isEdit.booleanValue()) {
            options.put("hidden", (Object)false);
            options.put("readonly", (Object)false);
            options.put("disabled", (Object)false);
        } else if (isReadOnly != null && isReadOnly.booleanValue()) {
            options.put("hidden", (Object)false);
            options.put("readonly", (Object)true);
            options.put("disabled", (Object)true);
        }
    }

    private JSONArray b(JSONObject item) {
        try {
            JSONObject options = item.getJSONObject("options");
            String remoteType = options.getString("remote");
            if ("dict".equals(remoteType)) {
                String dictCode = options.getString("dictCode");
                List dictItems = oConvertUtils.isNotEmpty((Object)dictCode) ? this.sysBaseApi.queryDictItemsByCode(dictCode) : new ArrayList();
                JSONArray selectOptions = new JSONArray();
                for (DictModel dictModel : dictItems) {
                    JSONObject option = new JSONObject();
                    option.put("label", (Object)dictModel.getText());
                    option.put("value", (Object)dictModel.getValue());
                    option.put("itemColor", (Object)dictModel.getColor());
                    selectOptions.add((Object)option);
                }
                return selectOptions;
            }
        }
        catch (SerializationException serializationException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Result redoAllIndex(String rowIds, Integer pageSize, boolean batchSave) {
        if (pageSize == null) {
            return this.a(rowIds, null, null, batchSave);
        }
        return this.a(rowIds, 1, pageSize, batchSave);
    }

    private Result a(String rowIds, Integer pageNum, Integer pageSize, boolean batchSave) {
        try {
            List dataList;
            if (this.designFormDataService instanceof org.jeecg.modules.online.desform.mongo.service.a.b) {
                throw new JeecgBootException("MongoDB \u4e0b\u65e0\u9700\u91cd\u7f6e\u7d22\u5f15");
            }
            long begin = System.currentTimeMillis();
            a.info("-- \u5df2\u5f00\u59cb\u5feb\u901f\u91cd\u7f6eES\u7d22\u5f15\u6570\u636e");
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            if (oConvertUtils.isNotEmpty((Object)rowIds)) {
                queryWrapper.in(DesignFormData::getDesformId, Arrays.asList(rowIds.split(",")));
            }
            Page pageList = null;
            if (pageNum == null || pageSize == null) {
                dataList = this.designFormDataMapper.selectList((Wrapper)queryWrapper);
            } else {
                batchSave = true;
                pageList = (Page)this.designFormDataMapper.selectPage((IPage)new Page((long)pageNum.intValue(), (long)pageSize.intValue()), (Wrapper)queryWrapper);
                dataList = pageList.getRecords();
                a.info("-- \u5feb\u901f\u5206\u9875\u91cd\u7f6e\uff1a\uff08\u7b2c " + pageList.getCurrent() + " \u9875/\u5171 " + pageList.getPages() + " \u9875\uff09");
            }
            HashMap<String, DesformWidgetList> widgetListMap = new HashMap<String, DesformWidgetList>(10);
            int successCount = 0;
            int failCount = 0;
            if (!batchSave) {
                for (int i2 = 0; i2 < dataList.size(); ++i2) {
                    DesignFormData dataItem = (DesignFormData)dataList.get(i2);
                    String desformCode = dataItem.getDesformCode();
                    a.info("---- \u6b63\u5728\u91cd\u7f6e\uff1a" + desformCode + "\uff08\u7b2c " + (i2 + 1) + " \u4e2a/\u5171 " + dataList.size() + " \u4e2a\uff09");
                    JSONObject dataJson = JSON.parseObject((String)dataItem.getDesformDataJson());
                    this.a(desformCode, widgetListMap, dataJson);
                    org.jeecg.modules.online.desform.es.b.a.a((DesformWidgetList)widgetListMap.get(desformCode), dataJson);
                    if (this.jes.saveOrUpdate(desformCode, "design_form", dataItem.getId(), dataJson)) {
                        ++successCount;
                        continue;
                    }
                    ++failCount;
                }
            } else {
                HashMap<String, JSONArray> saveMap = new HashMap<String, JSONArray>(10);
                for (DesignFormData dataItem : dataList) {
                    String desformCode = dataItem.getDesformCode();
                    JSONObject dataJson = JSON.parseObject((String)dataItem.getDesformDataJson());
                    dataJson.put("id", (Object)dataItem.getId());
                    JSONArray saveDataList = saveMap.computeIfAbsent(desformCode, k2 -> new JSONArray());
                    saveDataList.add((Object)dataJson);
                }
                for (String desformCode : saveMap.keySet()) {
                    JSONArray saveDataList = (JSONArray)saveMap.get(desformCode);
                    for (int i3 = 0; i3 < saveDataList.size(); ++i3) {
                        JSONObject dataJson = saveDataList.getJSONObject(i3);
                        this.a(desformCode, widgetListMap, dataJson);
                        org.jeecg.modules.online.desform.es.b.a.a((DesformWidgetList)widgetListMap.get(desformCode), dataJson);
                    }
                    a.info("---- \u6b63\u5728\u6279\u91cf\u91cd\u7f6e\uff1a" + desformCode + "\uff08\u5171 " + saveDataList.size() + " \u6761\u6570\u636e\uff09");
                    this.jes.saveBatch(desformCode, "design_form", saveDataList);
                }
            }
            long end = System.currentTimeMillis();
            String msg = failCount == 0 ? "\u5feb\u901f\u91cd\u7f6eES\u7d22\u5f15\u5168\u90e8\u6210\u529f!" : String.format("\u5feb\u901f\u91cd\u7f6eES\u7d22\u5f15\uff1a\u6210\u529f\u4e86%s\u6761\uff0c\u5931\u8d25\u4e86%s\u6761", successCount, failCount);
            a.info("-- " + msg);
            a.info("-- \u603b\u8017\u65f6\uff1a" + (end - begin) + " ms");
            if (pageList != null && pageList.hasNext()) {
                pageNum = pageNum + 1;
                return this.a(rowIds, pageNum, pageSize, batchSave);
            }
            return Result.ok();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return Result.error((String)e2.getMessage());
        }
    }

    private void a(String desformCode, Map<String, DesformWidgetList> widgetListMap, JSONObject dataJson) {
        DesformWidgetList widgetList = widgetListMap.get(desformCode);
        if (widgetList == null) {
            DesignForm designForm = this.getByCode(desformCode);
            widgetList = f.e(designForm);
            widgetListMap.put(desformCode, widgetList);
        }
        for (DesformWidget widget : widgetList.main) {
            if (widget.getType() == WidgetTypes.IMGUPLOAD || widget.getType() == WidgetTypes.FILE_UPLOAD) {
                dataJson.remove((Object)widget.getModel());
            }
            if (widget.getType() != WidgetTypes.DATE && widget.getType() != WidgetTypes.TIME || !oConvertUtils.isEmpty((Object)dataJson.get((Object)widget.getModel()))) continue;
            dataJson.remove((Object)widget.getModel());
        }
    }

    @Override
    public Result redoAllIndexForce(String rowIds, Integer pageSize) {
        try {
            a.info("-- \u5df2\u5f00\u59cb\u5f3a\u5236\u91cd\u7f6eES\u7d22\u5f15");
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            if (oConvertUtils.isNotEmpty((Object)rowIds)) {
                queryWrapper.in(DesignForm::getId, Arrays.asList(rowIds.split(",")));
            }
            List allForm = super.list((Wrapper)queryWrapper);
            long begin = System.currentTimeMillis();
            for (int i2 = 0; i2 < allForm.size(); ++i2) {
                DesignForm formItem = (DesignForm)allForm.get(i2);
                String desformCode = formItem.getDesformCode();
                a.info("---- \u6b63\u5728\u91cd\u7f6e\uff1a" + desformCode + "\uff08\u7b2c " + (i2 + 1) + " \u4e2a/\u5171 " + allForm.size() + " \u4e2a\uff09");
                this.jes.removeIndex(desformCode);
                this.jes.createIndex(desformCode);
            }
            long end = System.currentTimeMillis();
            a.info("-- \u5f3a\u5236\u91cd\u7f6eES\u7d22\u5f15\u5b8c\u6210\uff0c\u5373\u5c06\u5f00\u59cb\u5feb\u901f\u91cd\u7f6e\u6570\u636e");
            a.info("-- \u603b\u8017\u65f6\uff1a" + (end - begin) + " ms");
            return this.redoAllIndex(rowIds, pageSize, true);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return Result.error((String)e2.getMessage());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateDefMobileViewStatus(String parentCode, String desformCode) {
        DesignForm updateEntity = new DesignForm();
        QueryWrapper updateWrapper = new QueryWrapper();
        updateEntity.setIzMobileView(org.jeecg.modules.online.desform.constant.b.c);
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)updateWrapper.eq((Object)"iz_mobile_view", (Object)org.jeecg.modules.online.desform.constant.b.b)).eq((Object)"desform_code", (Object)parentCode)).or()).eq((Object)"parent_code", (Object)parentCode);
        super.update((Object)updateEntity, (Wrapper)updateWrapper);
        updateEntity.setIzMobileView(org.jeecg.modules.online.desform.constant.b.b);
        updateWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"desform_code", (Object)desformCode);
        super.update((Object)updateEntity, (Wrapper)updateWrapper);
        return true;
    }

    @Override
    public void deleteRedisCache(String desformCode) {
        List keys = this.redisUtil.scan("sys:cache:desform:byCode::" + desformCode + "*");
        if (keys != null && !keys.isEmpty()) {
            this.redisTemplate.delete((Collection)keys);
        }
    }

    @Override
    @Cacheable(cacheNames={"sys:cache:desform:byCode"}, key="#desformCode + ':e-fields-v3-' + #subTable + '-' + #advancedSetting")
    public JSONObject getEfficientFieldsByCode(String desformCode, boolean subTable, boolean advancedSetting) {
        return this.a(desformCode, subTable, advancedSetting, null);
    }

    private JSONObject a(String desformCode, boolean subTable, boolean advancedSetting, List<String> excludeTypeList) {
        DesignForm designForm = this.getByCode(desformCode);
        if (designForm == null) {
            a.warn("\u8868\u5355\uff1a" + desformCode + " \u4e0d\u5b58\u5728\uff01");
            throw new JeecgBootBizTipException("\u8868\u5355\u8bbe\u8ba1\u4e0d\u5b58\u5728\uff01", CommonConstant.SC_INTERNAL_NOT_FOUND_404.intValue());
        }
        JSONObject json = JSON.parseObject((String)designForm.getDesformDesignJson());
        if (json == null) {
            a.warn("\u8868\u5355\uff1a" + desformCode + " \u8bbe\u8ba1\u5185\u5bb9\u4e3a\u7a7a\uff01");
            throw new JeecgBootBizTipException("\u8868\u5355\u8bbe\u8ba1\u672a\u4fdd\u5b58\uff01");
        }
        JSONObject config = json.getJSONObject("config");
        JSONArray dataList = json.getJSONArray("list");
        JSONObject result = new JSONObject();
        result.put("id", (Object)designForm.getId());
        result.put("desformCode", (Object)designForm.getDesformCode());
        result.put("desformName", (Object)designForm.getDesformName());
        result.put("titleField", (Object)config.getString("titleField"));
        JSONArray fields = new JSONArray();
        HashMap subTableChildren = new HashMap();
        f.a(dataList, (WidgetTypes type, JSONObject item, JSONObject parent) -> {
            if (!subTable && type == WidgetTypes.SUB_TABLE_DESIGN) {
                return;
            }
            if (type != WidgetTypes.SUB_TABLE_DESIGN && org.jeecg.modules.online.desform.constant.b.N.contains((Object)type)) {
                return;
            }
            if (excludeTypeList != null && excludeTypeList.indexOf(type.getType()) >= 0) {
                return;
            }
            JSONObject widget = new JSONObject();
            widget.put("key", (Object)item.getString("key"));
            widget.put("type", (Object)item.getString("type"));
            widget.put("name", (Object)item.getString("name"));
            widget.put("model", (Object)item.getString("model"));
            widget.put("options", (Object)item.getJSONObject("options"));
            widget.put("rules", (Object)item.getJSONArray("rules"));
            if (advancedSetting) {
                widget.put("advancedSetting", (Object)item.getJSONObject("advancedSetting"));
            }
            if (item.containsKey((Object)"isSubTable")) {
                widget.put("isSubTable", (Object)item.getString("isSubTable"));
            }
            if (parent != null && WidgetTypes.SUB_TABLE_DESIGN.getType().equals(parent.getString("type"))) {
                String subTableKey = parent.getString("key");
                JSONArray children = (JSONArray)subTableChildren.get(subTableKey);
                if (children == null) {
                    children = new JSONArray();
                    subTableChildren.put(subTableKey, children);
                }
                children.add((Object)widget);
                return;
            }
            if (type == WidgetTypes.SUB_TABLE_DESIGN) {
                String subTableKey = item.getString("key");
                JSONArray children = (JSONArray)subTableChildren.get(subTableKey);
                if (children == null) {
                    children = new JSONArray();
                    subTableChildren.put(subTableKey, children);
                }
                widget.put("children", (Object)children);
            }
            fields.add((Object)widget);
        });
        result.put("fields", (Object)fields);
        return result;
    }

    @Override
    @Cacheable(cacheNames={"sys:cache:desform:byCode"}, key="#desformCode + ':e-fields-v3-' + #subTable + '-' + #advancedSetting")
    public JSONObject getEfficientFieldsByCodeWithExclude(String desformCode, boolean subTable, boolean advancedSetting, List<String> excludeTypeList) {
        JSONObject result = this.a(desformCode, subTable, advancedSetting, excludeTypeList);
        this.c(result);
        return result;
    }

    private void c(JSONObject result) {
        JSONArray fieldArray = result.getJSONArray("fields");
        HashMap map = new HashMap();
        block0: for (int i2 = 0; i2 < fieldArray.size(); ++i2) {
            JSONObject widget = fieldArray.getJSONObject(i2);
            if (!WidgetTypes.LINK_FIELD.getType().equals(widget.getString("type"))) continue;
            JSONObject optionsJson = widget.getJSONObject("options");
            DesformOptions options = (DesformOptions)JSONObject.parseObject((String)optionsJson.toJSONString(), DesformOptions.class);
            String linkRecordKey = options.getLinkRecordKey();
            String showField = options.getShowField();
            for (int j2 = 0; j2 < fieldArray.size(); ++j2) {
                DesignForm designForm;
                JSONObject widget2 = fieldArray.getJSONObject(j2);
                String widgetKey = widget2.getString("key");
                if (!widgetKey.equals(linkRecordKey) || !WidgetTypes.LINK_RECORD.getType().equals(widget2.getString("type"))) continue;
                JSONObject optionsJson2 = widget2.getJSONObject("options");
                DesformOptions options2 = (DesformOptions)JSONObject.parseObject((String)optionsJson2.toJSONString(), DesformOptions.class);
                String code = options2.getSourceCode();
                List<DesformWidget> widgetList = (List<DesformWidget>)map.get(code);
                if (widgetList == null && (designForm = this.getByCode(code)) != null) {
                    JSONArray dataList = f.b(designForm);
                    DesformWidgetList allWidgetList = f.a(dataList, false);
                    widgetList = allWidgetList.main;
                }
                for (DesformWidget widget3 : widgetList) {
                    if (!widget3.getModel().equals(showField)) continue;
                    JSONObject temp = JSONObject.parseObject((String)JSONObject.toJSONString((Object)widget3.getOptions()));
                    optionsJson.putAll((Map)temp);
                    widget.put("options", (Object)optionsJson);
                    continue block0;
                }
                continue block0;
            }
        }
    }

    @Override
    public boolean addWidgetByDesformCode(String desformCode, JSONObject widget) {
        DesignForm designForm = this.getByCode(desformCode);
        if (designForm == null) {
            throw new JeecgBootException("\u8868\u5355\u4e0d\u5b58\u5728");
        }
        if (widget == null) {
            throw new JeecgBootException("widget\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String designJsonStr = designForm.getDesformDesignJson();
        JSONObject designJson = JSON.parseObject((String)designJsonStr);
        JSONArray list = designJson.getJSONArray("list");
        list.add((Object)widget);
        DesignForm updateEntity = new DesignForm();
        updateEntity.setId(designForm.getId());
        updateEntity.setDesformDesignJson(designJson.toJSONString());
        boolean flag = super.updateById((Object)updateEntity);
        if (flag) {
            this.deleteRedisCache(desformCode);
        }
        return flag;
    }

    @Override
    public boolean updateWidgetByKeyModel(String desformCode, JSONObject setting) {
        Integer formTenantId;
        if (setting == null) {
            throw new JeecgBootException("setting\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DesignForm designForm = this.getByCode(desformCode);
        if (designForm == null) {
            throw new JeecgBootException("\u8868\u5355\u4e0d\u5b58\u5728");
        }
        LoginUser loginUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        if (loginUser == null) {
            throw new JeecgBootException("\u672a\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f");
        }
        String tenantIds = loginUser.getRelTenantIds();
        if (oConvertUtils.isEmpty((Object)tenantIds)) {
            throw new JeecgBootException("\u79df\u6237\u9a8c\u8bc1\u5931\u8d25");
        }
        List<String> tenantIdList = Arrays.asList(tenantIds.split(","));
        if (!tenantIdList.contains((formTenantId = designForm.getTenantId()).toString())) {
            throw new JeecgBootException("\u79df\u6237\u9a8c\u8bc1\u5931\u8d25");
        }
        String widgetKey = setting.getString("key");
        String widgetModel = setting.getString("model");
        boolean isKey = oConvertUtils.isNotEmpty((Object)widgetKey);
        boolean isModel = oConvertUtils.isNotEmpty((Object)widgetModel);
        if (!isKey && !isModel) {
            throw new JeecgBootException("widgetKey\u548cwidgetModel\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
        }
        String designJsonStr = designForm.getDesformDesignJson();
        JSONObject designJson = JSON.parseObject((String)designJsonStr);
        JSONArray list = designJson.getJSONArray("list");
        JSONObject widgetMap = new JSONObject();
        f.a(list, (WidgetTypes type, JSONObject item, JSONObject parent) -> {
            boolean flag2;
            String key = item.getString("key");
            boolean flag1 = isKey && widgetKey.equals(key);
            String model = item.getString("model");
            boolean bl = flag2 = isModel && widgetModel.equals(model);
            if (flag1 || flag2) {
                widgetMap.put("widget", (Object)item);
                ArrayList<JSONArray> arrays = new ArrayList<JSONArray>();
                if (parent != null) {
                    WidgetTypes parentWidget = WidgetTypes.getByValue(parent.getString("type"));
                    if (parent.get((Object)"columns") != null) {
                        JSONArray columns = parent.getJSONArray("columns");
                        for (int j2 = 0; j2 < columns.size(); ++j2) {
                            JSONObject column = columns.getJSONObject(j2);
                            arrays.add(column.getJSONArray("list"));
                        }
                    } else if (WidgetTypes.CARD == parentWidget) {
                        arrays.add(parent.getJSONArray("list"));
                    } else if (WidgetTypes.TABS == parentWidget) {
                        JSONArray panes = parent.getJSONArray("panes");
                        for (int j3 = 0; j3 < panes.size(); ++j3) {
                            JSONObject pane = panes.getJSONObject(j3);
                            arrays.add(pane.getJSONArray("list"));
                        }
                    }
                } else {
                    arrays.add(list);
                }
                widgetMap.put("arrays", arrays);
            }
        });
        JSONObject widget = widgetMap.getJSONObject("widget");
        if (widget == null) {
            throw new JeecgBootBizTipException("\u7ec4\u4ef6\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u64cd\u4f5c");
        }
        String action = setting.getString("action");
        boolean isUpdate = "update".equals(action);
        JSONArray arrays = widgetMap.getJSONArray("arrays");
        for (int i2 = 0; i2 < arrays.size(); ++i2) {
            JSONArray array = arrays.getJSONArray(i2);
            for (int j2 = 0; j2 < array.size(); ++j2) {
                boolean flag2;
                JSONObject item2 = array.getJSONObject(j2);
                String key = item2.getString("key");
                boolean flag1 = isKey && widgetKey.equals(key);
                String model = item2.getString("model");
                boolean bl = flag2 = isModel && widgetModel.equals(model);
                if (!flag1 && !flag2) continue;
                if (isUpdate) {
                    CommonUtils.mergeJSON((JSONObject)item2, (JSONObject)setting.getJSONObject("widget"));
                } else {
                    array.remove(j2);
                }
                DesignForm updateEntity = new DesignForm();
                updateEntity.setId(designForm.getId());
                updateEntity.setDesformDesignJson(designJson.toJSONString());
                boolean flag = super.updateById((Object)updateEntity);
                if (flag) {
                    this.deleteRedisCache(desformCode);
                }
                return flag;
            }
        }
        return false;
    }

    @Override
    @AutoLowApp(action=LowAppAopEnum.DESFORM_SUB2WORK, bizType="desform")
    @Transactional(rollbackFor={Exception.class})
    public boolean subToWorksheet(DesignForm designForm, String subModel, DesignForm parentForm, String parentModel, String originSubCode) {
        if (designForm == null) {
            throw new JeecgBootException("designForm\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String desformCode = designForm.getDesformCode();
        try {
            String parentCode = parentForm.getDesformCode();
            if (oConvertUtils.isNotEmpty((Object)parentForm.getLowAppId())) {
                designForm.setLowAppId(parentForm.getLowAppId());
            }
            if (oConvertUtils.isNotEmpty((Object)parentForm.getTenantId())) {
                designForm.setTenantId(parentForm.getTenantId());
            }
            this.saveMain(designForm);
            List<DesignFormData> dataList = this.designFormDataService.list(parentCode, null);
            for (DesignFormData mainData : dataList) {
                Object subDataObj = mainData.getDesformData().get((Object)originSubCode);
                ArrayList<DesignFormData> subDataList = null;
                if (subDataObj instanceof List) {
                    JSONArray subDataArray = mainData.getDesformData().getJSONArray(originSubCode);
                    subDataList = new ArrayList<DesignFormData>(subDataArray.size());
                    for (int i2 = 0; i2 < subDataArray.size(); ++i2) {
                        JSONObject subData = subDataArray.getJSONObject(i2);
                        subData.put(subModel, Collections.singletonList(mainData.getId()));
                        subDataList.add(new DesignFormData(desformCode, subData));
                    }
                    if (subDataList.size() > 0) {
                        this.designFormDataService.saveBatch(desformCode, subDataList);
                    } else {
                        subDataList = null;
                    }
                }
                if (subDataList == null) continue;
                List ids = subDataList.stream().map(DesignFormData::getId).collect(Collectors.toList());
                JSONObject updateDataJson = new JSONObject();
                updateDataJson.put(parentModel, ids);
                DesignFormData updateData = new DesignFormData(parentCode, updateDataJson);
                updateData.setId(mainData.getId());
                this.designFormDataService.updateById(updateData);
                this.designFormDataService.removeFieldById(parentCode, mainData.getId(), originSubCode);
            }
            return true;
        }
        catch (DuplicateKeyException e2) {
            throw new JeecgBootException(desformCode + "\u5df2\u5b58\u5728");
        }
    }

    @Override
    public boolean deleteAll(String designFormCode) {
        this.designFormListViewService.deleteFormViewData(designFormCode);
        this.designFormDataService.removeByCode(designFormCode);
        this.designFormSettingService.removeByDesformCode(designFormCode);
        LambdaQueryWrapper query = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(DesignForm::getDesformCode, (Object)designFormCode);
        boolean flag = this.remove((Wrapper)query);
        if (flag) {
            this.deleteRedisCache(designFormCode);
        }
        return flag;
    }

    @Override
    public Map<String, List<DesignFormViewVo>> queryFormByAppId(String appId) {
        List<DesignFormViewVo> formList = ((DesignFormMapper)this.baseMapper).queryDesignFormListByAppId(appId);
        String formType = "form";
        String desformType = "desform";
        HashMap<String, List<DesignFormViewVo>> map = new HashMap<String, List<DesignFormViewVo>>();
        if (formList != null && formList.size() > 0) {
            List<String> codeList = formList.stream().map(i2 -> {
                if (desformType.equals(i2.getType())) {
                    return i2.getId();
                }
                if (formType.equals(i2.getType())) {
                    return i2.getCompatibleCode();
                }
                return null;
            }).filter(oConvertUtils::isNotEmpty).collect(Collectors.toList());
            List<DesignFormViewVo> viewList = this.designFormListViewService.queryListViewByCode(codeList);
            map.put("viewList", viewList);
        }
        map.put("formList", formList);
        return map;
    }

    @Override
    public LowAppCopyMenu copyDesignForm(LowAppCopyMenu lowAppCopyMenu) {
        String formKey = lowAppCopyMenu.getOriginFormCode();
        boolean isIdForm = lowAppCopyMenu.isIdForm();
        DesignForm originForm = isIdForm ? this.getByIdCache(formKey) : this.getByCode(formKey);
        if (originForm != null) {
            String designFormCode = originForm.getDesformCode();
            String copyLevel = lowAppCopyMenu.getCopyLevel();
            DesignForm designForm = new DesignForm();
            BeanUtils.copyProperties((Object)originForm, (Object)designForm);
            if ("backup".equals(copyLevel)) {
                String backupKey = lowAppCopyMenu.getBackupKey();
                String newId = LowAppCopyUtil.getBackupValue((String)designForm.getId(), (String)backupKey);
                designForm.setId(newId);
                String newAppId = LowAppCopyUtil.getBackupValue((String)designForm.getLowAppId(), (String)backupKey);
                designForm.setLowAppId(newAppId);
                String newCode = LowAppCopyUtil.getBackupValue((String)designFormCode, (String)backupKey);
                designForm.setDesformCode(newCode);
                this.save(designForm);
                this.designFormListViewService.backupDesignFormMongo(designFormCode, backupKey, "backup");
            } else {
                designForm.setId(null);
                if ("app".equals(copyLevel)) {
                    designForm.setLowAppId(lowAppCopyMenu.getAppId());
                    Integer tenantId = lowAppCopyMenu.getTenantId();
                    if (tenantId != null) {
                        designForm.setTenantId(tenantId);
                    }
                } else {
                    designForm.setDesformName(originForm.getDesformName() + "-\u590d\u5236");
                    Function<?, ?> saveFunc = f.a(designForm, (WidgetTypes type, JSONObject item, JSONObject parent) -> {
                        if (WidgetTypes.LINK_RECORD == type) {
                            item.getJSONObject("options").put("twoWayModel", (Object)"");
                        }
                    });
                    saveFunc.apply(null);
                }
                String copyCode = this.a(designFormCode);
                designForm.setDesformCode(copyCode);
                this.save(designForm);
                Map<String, String> viewIdMapping = this.designFormListViewService.copyDesignFormMongo(designFormCode, copyCode);
                lowAppCopyMenu.setViewIdMapping(viewIdMapping);
                lowAppCopyMenu.setNewFormCode(copyCode);
                lowAppCopyMenu.setOldFormCode(originForm.getDesformCode());
                lowAppCopyMenu.setOldFormId(originForm.getId());
                if (isIdForm) {
                    lowAppCopyMenu.setNewFormId(designForm.getId());
                }
            }
        }
        return lowAppCopyMenu;
    }

    @Override
    @CacheEvict(cacheNames={"sys:cache:desform:byCode"}, key="#desformCode")
    public void updateDesignFormJson(String desformCode, Map<String, String> codeMapping, Map<String, String> appIdMapping, Map<String, String> dictCodeMapping) {
        String jsonStr;
        a.info("\u590d\u5236\u8868\u5355\u7f16\u7801\uff1a {}", (Object)desformCode);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DesignForm::getDesformCode, (Object)desformCode);
        DesignForm designForm = (DesignForm)((DesignFormMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
        if (designForm != null && oConvertUtils.isNotEmpty((Object)(jsonStr = designForm.getDesformDesignJson()))) {
            String chars;
            String rep;
            Pattern pattern;
            Matcher m2;
            String newCode;
            for (String code : codeMapping.keySet()) {
                String tableName;
                newCode = codeMapping.get(code);
                if (newCode == null || jsonStr.indexOf(code) < 0 || !(m2 = (pattern = Pattern.compile(tableName = "([\"'])" + code + "[\"']")).matcher(jsonStr)).find()) continue;
                rep = m2.group(0);
                chars = m2.group(1);
                jsonStr = jsonStr.replaceAll(rep, chars + newCode + chars);
            }
            if (appIdMapping != null) {
                for (String oldAppId : appIdMapping.keySet()) {
                    String patternStr;
                    String newAppId = appIdMapping.get(oldAppId);
                    if (newAppId == null || !jsonStr.contains(oldAppId) || !(m2 = (pattern = Pattern.compile(patternStr = "[\"']dictCodeAppId[\"']\\s*:\\s*([\"'])" + oldAppId + "[\"']")).matcher(jsonStr)).find()) continue;
                    rep = m2.group(0);
                    chars = m2.group(1);
                    String replaceText = chars + "dictCodeAppId" + chars + ":" + chars + newAppId + chars;
                    jsonStr = jsonStr.replaceAll(rep, replaceText);
                }
            }
            if (dictCodeMapping != null) {
                for (String code : dictCodeMapping.keySet()) {
                    String dictCode;
                    newCode = dictCodeMapping.get(code);
                    if (newCode == null || !jsonStr.contains(code) || !(m2 = (pattern = Pattern.compile(dictCode = "([\"'])" + code + "[\"']")).matcher(jsonStr)).find()) continue;
                    rep = m2.group(0);
                    chars = m2.group(1);
                    jsonStr = jsonStr.replaceAll(rep, chars + newCode + chars);
                }
            }
            designForm.setDesformDesignJson(jsonStr);
            ((DesignFormMapper)this.baseMapper).updateById(designForm);
        }
    }

    @Override
    @CacheEvict(cacheNames={"sys:cache:desform:byCode"}, key="#lowAppCopyMenu.originFormCode")
    public void coverDesignForm(LowAppCopyMenu lowAppCopyMenu) {
        String formKey = lowAppCopyMenu.getOriginFormCode();
        boolean isIdForm = lowAppCopyMenu.isIdForm();
        DesignForm backupForm = isIdForm ? this.getByIdCache(formKey) : this.getByCode(formKey);
        if (backupForm != null) {
            DesignForm originForm = new DesignForm();
            BeanUtils.copyProperties((Object)backupForm, (Object)originForm);
            String backupCode = backupForm.getDesformCode();
            String backupKey = lowAppCopyMenu.getBackupKey();
            String designFormCode = LowAppCopyUtil.getOriginValue((String)backupCode, (String)backupKey);
            originForm.setDesformCode(designFormCode);
            String id = LowAppCopyUtil.getOriginValue((String)backupForm.getId(), (String)backupKey);
            originForm.setId(id);
            String newAppId = LowAppCopyUtil.getOriginValue((String)originForm.getLowAppId(), (String)backupKey);
            originForm.setLowAppId(newAppId);
            if (originForm.getUpdateCount() == null) {
                originForm.setUpdateCount(1);
            }
            this.save(originForm);
            this.redisUtil.del(new String[]{String.format("%s::%s", "sys:cache:desform:byCode", originForm.getId())});
            this.redisUtil.del(new String[]{String.format("%s::%s", "sys:cache:desform:byCode", designFormCode)});
            this.designFormListViewService.backupDesignFormMongo(backupCode, backupKey, "cover");
        }
    }

    private String a(String code) {
        String copyCode = null;
        String suffix = "copy";
        String sep = "_";
        String random = oConvertUtils.randomGen((int)4).toLowerCase();
        if (code.endsWith(suffix) && code.indexOf(sep) >= 0) {
            String base = code.substring(0, code.lastIndexOf(sep));
            copyCode = base + sep + random + suffix;
        } else {
            copyCode = code + sep + random + suffix;
        }
        return copyCode;
    }

    @Override
    public String getUserIdByDesformCode(String desformCode) {
        return ((DesignFormMapper)this.baseMapper).queryUserIdByDesformCode(desformCode);
    }

    @Override
    public List<String> queryDeleteLinkRecord(DesignForm designForm) {
        JSONObject designJson = JSON.parseObject((String)designForm.getDesformDesignJson());
        if (designJson == null) {
            return new ArrayList<String>();
        }
        JSONArray list = designJson.getJSONArray("list");
        HashSet codes = new HashSet();
        ArrayList linkRecordList = new ArrayList();
        f.a(list, (WidgetTypes type, JSONObject item, JSONObject parent) -> {
            if (type == WidgetTypes.LINK_RECORD) {
                String sourceCode = item.getJSONObject("options").getString("sourceCode");
                codes.add(sourceCode);
                linkRecordList.add(item);
            }
        });
        if (codes.isEmpty()) {
            return new ArrayList<String>();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(DesignForm::getDesformCode, codes);
        queryWrapper.select(new SFunction[]{DesignForm::getDesformCode});
        List res = super.list((Wrapper)queryWrapper);
        List existCodes = res.stream().map(DesignForm::getDesformCode).collect(Collectors.toList());
        if (existCodes.size() == codes.size()) {
            return new ArrayList<String>();
        }
        ArrayList<String> diffList = new ArrayList<String>(codes);
        diffList.removeAll(existCodes);
        for (JSONObject item2 : linkRecordList) {
            String sourceCode = item2.getJSONObject("options").getString("sourceCode");
            if (!diffList.contains(sourceCode)) continue;
            item2.put("delFlag", (Object)true);
        }
        designForm.setDesformDesignJson(designJson.toJSONString());
        return diffList;
    }

    @Override
    public void disabledOtherTenantLinkRecords(String desformCode, Integer currentTenantId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DesignForm::getDesformCode, (Object)desformCode);
        DesignForm designForm = (DesignForm)this.designFormMapper.selectOne((Wrapper)queryWrapper);
        if (designForm == null) {
            return;
        }
        String designJson = designForm.getDesformDesignJson();
        JSONObject json = JSONObject.parseObject((String)designJson, (Feature[])new Feature[]{Feature.OrderedField});
        JSONArray list = json.getJSONArray("list");
        if (list == null || list.size() == 0) {
            return;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            JSONObject item = list.getJSONObject(i2);
            String type = item.getString("type");
            if ("grid".equals(type) || "sub-table-design".equals(type)) {
                JSONArray columns = item.getJSONArray("columns");
                for (int j2 = 0; j2 < columns.size(); ++j2) {
                    JSONArray columnList = columns.getJSONObject(j2).getJSONArray("list");
                    for (int k2 = 0; k2 < columnList.size(); ++k2) {
                        JSONObject field = columnList.getJSONObject(k2);
                        this.a(field, currentTenantId);
                    }
                }
                continue;
            }
            if ("card".equals(type)) {
                JSONArray columnList = item.getJSONArray("list");
                for (int k3 = 0; k3 < columnList.size(); ++k3) {
                    JSONObject field = columnList.getJSONObject(k3);
                    this.a(field, currentTenantId);
                }
                continue;
            }
            this.a(item, currentTenantId);
        }
        String designJsonResult = JSON.toJSONString((Object)json, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        designForm.setDesformDesignJson(designJsonResult);
        this.designFormMapper.updateById(designForm);
    }

    private void a(JSONObject field, Integer currentTenantId) {
        String type = field.getString("type");
        if ("link-record".equals(type)) {
            JSONObject options = field.getJSONObject("options");
            String sourceCode = options.getString("sourceCode");
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(DesignForm::getDesformCode, (Object)sourceCode);
            DesignForm designForm = (DesignForm)this.designFormMapper.selectOne((Wrapper)queryWrapper);
            if (designForm == null || oConvertUtils.isEmpty((Object)designForm.getTenantId()) || currentTenantId.equals(designForm.getTenantId())) {
                return;
            }
            a.info("\u5173\u8054\u8bb0\u5f55\u7684\u8868\uff1a{} - {} \u662f\u5176\u4ed6\u79df\u6237\u4e0b\u7684\uff0c\u9700\u8981\u8bbe\u7f6e\u4e3a\u4e0d\u53ef\u7528\u63a7\u4ef6\uff01", (Object)designForm.getDesformCode(), (Object)designForm.getDesformName());
            field.put("type", (Object)"text");
            field.put("className", (Object)"form-text");
            options.put("text", (Object)"\u8be5\u63a7\u4ef6\u4e0d\u53ef\u7528~");
            options.put("fontColor", (Object)"#F31818");
        }
    }

    @Override
    public JSONObject getAdaptCfg() {
        JSONObject cfg = new JSONObject();
        try {
            cfg.put("isSQLAdapt", (Object)(SpringContextUtils.getApplicationContext().getBean(org.jeecg.modules.online.desform.datafactory.impl.sql.service.a.g.class) != null ? 1 : 0));
        }
        catch (Exception e2) {
            cfg.put("isSQLAdapt", (Object)false);
        }
        return cfg;
    }

    private static /* synthetic */ Object a(SerializedLambda lambda) {
        switch (lambda.getImplMethodName()) {
            case "getDesformId": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormData") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return DesignFormData::getDesformId;
            }
            case "getId": {
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignForm") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignForm::getId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignForm") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignForm::getId;
                }
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignForm") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return DesignForm::getId;
            }
            case "getDesformCode": {
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignForm") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignForm::getDesformCode;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignForm") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignForm::getDesformCode;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignForm") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignForm::getDesformCode;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignForm") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignForm::getDesformCode;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignForm") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignForm::getDesformCode;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignForm") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignForm::getDesformCode;
                }
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignForm") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return DesignForm::getDesformCode;
            }
            case "getIzMobileView": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignForm") || !lambda.getImplMethodSignature().equals("()Ljava/lang/Integer;")) break;
                return DesignForm::getIzMobileView;
            }
            case "getParentCode": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignForm") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return DesignForm::getParentCode;
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }
}

