/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.desform.vo.widget;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import org.jeecg.modules.online.desform.constant.WidgetTypes;
import org.jeecg.modules.online.desform.vo.widget.DesformCheckRule;
import org.jeecg.modules.online.desform.vo.widget.DesformOptions;
import org.jeecg.modules.online.desform.vo.widget.DesformRemoteApi;

public class DesformWidget {
    private WidgetTypes type;
    private String name;
    private boolean hideTitle = false;
    private boolean isSubItem = false;
    private boolean isSubTable = false;
    private boolean isContainer = false;
    private boolean isSummary = false;
    private String key;
    private String model;
    private List<DesformCheckRule> rules;
    private DesformRemoteApi remoteAPI;
    private DesformOptions options;
    private String advancedSetting;

    public void setType(String type) {
        this.type = WidgetTypes.getByValue(type);
    }

    public void setType(WidgetTypes type) {
        this.type = type;
    }

    public DesformWidget() {
    }

    public DesformWidget(String name, String key, WidgetTypes type) {
        this.name = name;
        this.type = type;
        this.model = key;
        this.key = key;
        if ("create_by".equals(key) || "update_by".equals(key)) {
            DesformOptions desformOptions = new DesformOptions();
            desformOptions.setCustomReturnField("username");
            this.options = desformOptions;
        } else if ("create_time".equals(key) || "update_time".equals(key)) {
            DesformOptions desformOptions = new DesformOptions();
            desformOptions.setType("datetime");
            desformOptions.setFormat("yyyy-MM-dd HH:mm:ss");
            this.options = desformOptions;
        }
    }

    public static DesformWidget getIdWidget() {
        return new DesformWidget("\u8bb0\u5f55ID", "_id", WidgetTypes.INPUT);
    }

    public static DesformWidget parse(JSONObject widgetJson) {
        if (widgetJson == null) {
            return null;
        }
        DesformWidget desformWidget = (DesformWidget)widgetJson.toJavaObject(DesformWidget.class);
        JSONObject jSONObject = widgetJson.getJSONObject("options");
        desformWidget.setType(widgetJson.getString("type"));
        desformWidget.options.setRange(jSONObject.getBooleanValue("isRange"));
        return desformWidget;
    }

    public WidgetTypes getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isHideTitle() {
        return this.hideTitle;
    }

    public boolean isSubItem() {
        return this.isSubItem;
    }

    public boolean isSubTable() {
        return this.isSubTable;
    }

    public boolean isContainer() {
        return this.isContainer;
    }

    public boolean isSummary() {
        return this.isSummary;
    }

    public String getKey() {
        return this.key;
    }

    public String getModel() {
        return this.model;
    }

    public List<DesformCheckRule> getRules() {
        return this.rules;
    }

    public DesformRemoteApi getRemoteAPI() {
        return this.remoteAPI;
    }

    public DesformOptions getOptions() {
        return this.options;
    }

    public String getAdvancedSetting() {
        return this.advancedSetting;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setHideTitle(boolean hideTitle) {
        this.hideTitle = hideTitle;
    }

    public void setSubItem(boolean isSubItem) {
        this.isSubItem = isSubItem;
    }

    public void setSubTable(boolean isSubTable) {
        this.isSubTable = isSubTable;
    }

    public void setContainer(boolean isContainer) {
        this.isContainer = isContainer;
    }

    public void setSummary(boolean isSummary) {
        this.isSummary = isSummary;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setRules(List<DesformCheckRule> rules) {
        this.rules = rules;
    }

    public void setRemoteAPI(DesformRemoteApi remoteAPI) {
        this.remoteAPI = remoteAPI;
    }

    public void setOptions(DesformOptions options) {
        this.options = options;
    }

    public void setAdvancedSetting(String advancedSetting) {
        this.advancedSetting = advancedSetting;
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof DesformWidget)) {
            return false;
        }
        DesformWidget desformWidget = (DesformWidget)o2;
        if (!desformWidget.canEqual(this)) {
            return false;
        }
        if (this.isHideTitle() != desformWidget.isHideTitle()) {
            return false;
        }
        if (this.isSubItem() != desformWidget.isSubItem()) {
            return false;
        }
        if (this.isSubTable() != desformWidget.isSubTable()) {
            return false;
        }
        if (this.isContainer() != desformWidget.isContainer()) {
            return false;
        }
        if (this.isSummary() != desformWidget.isSummary()) {
            return false;
        }
        WidgetTypes widgetTypes = this.getType();
        WidgetTypes widgetTypes2 = desformWidget.getType();
        if (widgetTypes == null ? widgetTypes2 != null : !((Object)((Object)widgetTypes)).equals((Object)widgetTypes2)) {
            return false;
        }
        String string = this.getName();
        String string2 = desformWidget.getName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getKey();
        String string4 = desformWidget.getKey();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        String string5 = this.getModel();
        String string6 = desformWidget.getModel();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            return false;
        }
        List<DesformCheckRule> list = this.getRules();
        List<DesformCheckRule> list2 = desformWidget.getRules();
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        DesformRemoteApi desformRemoteApi = this.getRemoteAPI();
        DesformRemoteApi desformRemoteApi2 = desformWidget.getRemoteAPI();
        if (desformRemoteApi == null ? desformRemoteApi2 != null : !((Object)desformRemoteApi).equals(desformRemoteApi2)) {
            return false;
        }
        DesformOptions desformOptions = this.getOptions();
        DesformOptions desformOptions2 = desformWidget.getOptions();
        if (desformOptions == null ? desformOptions2 != null : !((Object)desformOptions).equals(desformOptions2)) {
            return false;
        }
        String string7 = this.getAdvancedSetting();
        String string8 = desformWidget.getAdvancedSetting();
        return !(string7 == null ? string8 != null : !string7.equals(string8));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DesformWidget;
    }

    public int hashCode() {
        int n2 = 59;
        int n3 = 1;
        n3 = n3 * 59 + (this.isHideTitle() ? 79 : 97);
        n3 = n3 * 59 + (this.isSubItem() ? 79 : 97);
        n3 = n3 * 59 + (this.isSubTable() ? 79 : 97);
        n3 = n3 * 59 + (this.isContainer() ? 79 : 97);
        n3 = n3 * 59 + (this.isSummary() ? 79 : 97);
        WidgetTypes widgetTypes = this.getType();
        n3 = n3 * 59 + (widgetTypes == null ? 43 : ((Object)((Object)widgetTypes)).hashCode());
        String string = this.getName();
        n3 = n3 * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getKey();
        n3 = n3 * 59 + (string2 == null ? 43 : string2.hashCode());
        String string3 = this.getModel();
        n3 = n3 * 59 + (string3 == null ? 43 : string3.hashCode());
        List<DesformCheckRule> list = this.getRules();
        n3 = n3 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        DesformRemoteApi desformRemoteApi = this.getRemoteAPI();
        n3 = n3 * 59 + (desformRemoteApi == null ? 43 : ((Object)desformRemoteApi).hashCode());
        DesformOptions desformOptions = this.getOptions();
        n3 = n3 * 59 + (desformOptions == null ? 43 : ((Object)desformOptions).hashCode());
        String string4 = this.getAdvancedSetting();
        n3 = n3 * 59 + (string4 == null ? 43 : string4.hashCode());
        return n3;
    }

    public String toString() {
        return "DesformWidget(type=" + (Object)((Object)this.getType()) + ", name=" + this.getName() + ", hideTitle=" + this.isHideTitle() + ", isSubItem=" + this.isSubItem() + ", isSubTable=" + this.isSubTable() + ", isContainer=" + this.isContainer() + ", isSummary=" + this.isSummary() + ", key=" + this.getKey() + ", model=" + this.getModel() + ", rules=" + this.getRules() + ", remoteAPI=" + this.getRemoteAPI() + ", options=" + this.getOptions() + ", advancedSetting=" + this.getAdvancedSetting() + ")";
    }
}

