/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.desform.vo;

import java.math.BigDecimal;
import org.bson.types.Decimal128;

public class LinkRecordSummary {
    private Integer emptyCount;
    private Integer notEmptyCount;
    private BigDecimal sum;
    private BigDecimal avg;
    private BigDecimal max;
    private BigDecimal min;

    public void isEmpty(int emptyCount) {
        this.emptyCount = emptyCount;
        this.notEmptyCount = 0;
        this.min = null;
        this.max = null;
        this.avg = null;
        this.sum = null;
    }

    public void setInfo(Integer emptyCount, Integer notEmptyCount, BigDecimal max, BigDecimal min, BigDecimal avg, BigDecimal sum) {
        this.emptyCount = emptyCount;
        this.notEmptyCount = notEmptyCount;
        this.min = min;
        this.max = max;
        this.avg = avg;
        this.sum = sum;
    }

    public Object getSummaryVal(String type) {
        switch (type) {
            case "inner-completed-count": {
                if (this.notEmptyCount == null) {
                    return null;
                }
                return new Decimal128((long)this.notEmptyCount.intValue());
            }
            case "inner-incompletely-count": {
                if (this.emptyCount == null) {
                    return null;
                }
                return new Decimal128((long)this.emptyCount.intValue());
            }
            case "inner-sum": {
                if (this.sum == null) {
                    return null;
                }
                return new Decimal128(this.sum);
            }
            case "inner-average": {
                if (this.avg == null) {
                    return null;
                }
                return new Decimal128(this.avg);
            }
            case "inner-max": {
                if (this.max == null) {
                    return null;
                }
                return new Decimal128(this.max);
            }
            case "inner-min": {
                if (this.min == null) {
                    return null;
                }
                return new Decimal128(this.min);
            }
        }
        return null;
    }

    public Integer getEmptyCount() {
        return this.emptyCount;
    }

    public Integer getNotEmptyCount() {
        return this.notEmptyCount;
    }

    public BigDecimal getSum() {
        return this.sum;
    }

    public BigDecimal getAvg() {
        return this.avg;
    }

    public BigDecimal getMax() {
        return this.max;
    }

    public BigDecimal getMin() {
        return this.min;
    }

    public void setEmptyCount(Integer emptyCount) {
        this.emptyCount = emptyCount;
    }

    public void setNotEmptyCount(Integer notEmptyCount) {
        this.notEmptyCount = notEmptyCount;
    }

    public void setSum(BigDecimal sum) {
        this.sum = sum;
    }

    public void setAvg(BigDecimal avg) {
        this.avg = avg;
    }

    public void setMax(BigDecimal max) {
        this.max = max;
    }

    public void setMin(BigDecimal min) {
        this.min = min;
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof LinkRecordSummary)) {
            return false;
        }
        LinkRecordSummary linkRecordSummary = (LinkRecordSummary)o2;
        if (!linkRecordSummary.canEqual(this)) {
            return false;
        }
        Integer n2 = this.getEmptyCount();
        Integer n3 = linkRecordSummary.getEmptyCount();
        if (n2 == null ? n3 != null : !((Object)n2).equals(n3)) {
            return false;
        }
        Integer n4 = this.getNotEmptyCount();
        Integer n5 = linkRecordSummary.getNotEmptyCount();
        if (n4 == null ? n5 != null : !((Object)n4).equals(n5)) {
            return false;
        }
        BigDecimal bigDecimal = this.getSum();
        BigDecimal bigDecimal2 = linkRecordSummary.getSum();
        if (bigDecimal == null ? bigDecimal2 != null : !((Object)bigDecimal).equals(bigDecimal2)) {
            return false;
        }
        BigDecimal bigDecimal3 = this.getAvg();
        BigDecimal bigDecimal4 = linkRecordSummary.getAvg();
        if (bigDecimal3 == null ? bigDecimal4 != null : !((Object)bigDecimal3).equals(bigDecimal4)) {
            return false;
        }
        BigDecimal bigDecimal5 = this.getMax();
        BigDecimal bigDecimal6 = linkRecordSummary.getMax();
        if (bigDecimal5 == null ? bigDecimal6 != null : !((Object)bigDecimal5).equals(bigDecimal6)) {
            return false;
        }
        BigDecimal bigDecimal7 = this.getMin();
        BigDecimal bigDecimal8 = linkRecordSummary.getMin();
        return !(bigDecimal7 == null ? bigDecimal8 != null : !((Object)bigDecimal7).equals(bigDecimal8));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LinkRecordSummary;
    }

    public int hashCode() {
        int n2 = 59;
        int n3 = 1;
        Integer n4 = this.getEmptyCount();
        n3 = n3 * 59 + (n4 == null ? 43 : ((Object)n4).hashCode());
        Integer n5 = this.getNotEmptyCount();
        n3 = n3 * 59 + (n5 == null ? 43 : ((Object)n5).hashCode());
        BigDecimal bigDecimal = this.getSum();
        n3 = n3 * 59 + (bigDecimal == null ? 43 : ((Object)bigDecimal).hashCode());
        BigDecimal bigDecimal2 = this.getAvg();
        n3 = n3 * 59 + (bigDecimal2 == null ? 43 : ((Object)bigDecimal2).hashCode());
        BigDecimal bigDecimal3 = this.getMax();
        n3 = n3 * 59 + (bigDecimal3 == null ? 43 : ((Object)bigDecimal3).hashCode());
        BigDecimal bigDecimal4 = this.getMin();
        n3 = n3 * 59 + (bigDecimal4 == null ? 43 : ((Object)bigDecimal4).hashCode());
        return n3;
    }

    public String toString() {
        return "LinkRecordSummary(emptyCount=" + this.getEmptyCount() + ", notEmptyCount=" + this.getNotEmptyCount() + ", sum=" + this.getSum() + ", avg=" + this.getAvg() + ", max=" + this.getMax() + ", min=" + this.getMin() + ")";
    }
}

