/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.adapter.delegate.datahandle.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.query.QueryCondition;
import org.jeecg.common.system.query.QueryRuleEnum;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.JeecgBaseConfig;
import org.jeecg.config.vo.DomainUrl;
import org.jeecg.modules.extbpm.process.adapter.mq.utils.MinFlowUtils;
import org.jeecg.modules.extbpm.process.common.WorkFlowGlobals;
import org.jeecg.modules.extbpm.process.entity.ExtActProcess;
import org.jeecg.modules.minides.enums.FormTableTypeEnums;
import org.jeecg.modules.online.desform.entity.DesignFormData;
import org.jeecg.modules.online.desform.service.IDesignFormDataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="messagePushService")
public class MessagePushService {
    private static final Logger log = LoggerFactory.getLogger(MessagePushService.class);
    @Autowired
    private JeecgBaseConfig jeecgBaseConfig;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private IDesignFormDataService designFormDataService;
    @Autowired
    private ISysBaseAPI baseApi;
    public static final String APP_FLOW_PAGE = "/pages/process/my-task-detail";
    public static final String PC_TOKEN_LOGIN_PAGE = "/tokenLogin";

    public String getEmailHrefUrl(Map<String, Object> data) {
        String string = this.getPcDomainUrl();
        String string2 = string + PC_TOKEN_LOGIN_PAGE;
        try {
            string2 = string2 + "?loginToken={LOGIN_TOKEN}";
            Object object = data.get("NOTICE_MSG_SUMMARY");
            if (object != null) {
                string2 = string2 + "&info=" + URLEncoder.encode(object.toString(), "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string2;
    }

    public String getDDMobileHrefUrl(String processInstanceId, String activityId, String taskDefKey, Integer tenantId) {
        String string = this.getAppDomainUrl() + "/pages/lowApp/process/taskDetail?tenantId={0}&procInsId={1}&taskId={2}&taskDefKey={3}";
        return MessageFormat.format(string, tenantId.toString(), processInstanceId, activityId, taskDefKey);
    }

    public String getAppHrefUrl(Map<String, Object> data) {
        String string = this.getAppDomainUrl();
        if (string != null) {
            String string2 = string + APP_FLOW_PAGE;
            Object object = data.get("NOTICE_MSG_SUMMARY");
            if (object != null) {
                try {
                    string2 = string2 + "?info=" + URLEncoder.encode(object.toString(), "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    log.error("\u53c2\u6570\u52a0\u5bc6\u9519\u8bef", (Throwable)unsupportedEncodingException);
                }
            }
            return string2;
        }
        return "";
    }

    public String getPcDomainUrl() {
        DomainUrl domainUrl = this.jeecgBaseConfig.getDomainUrl();
        if (domainUrl == null || oConvertUtils.isEmpty((Object)domainUrl.getPc())) {
            log.error("\u7f3a\u5c11\u914d\u7f6e\uff1ajeecg.domainUrl.pc\uff01");
            return "";
        }
        return domainUrl.getPc();
    }

    public String getAppDomainUrl() {
        DomainUrl domainUrl;
        if (this.jeecgBaseConfig == null) {
            this.jeecgBaseConfig = (JeecgBaseConfig)SpringContextUtils.getBean(JeecgBaseConfig.class);
        }
        if ((domainUrl = this.jeecgBaseConfig.getDomainUrl()) == null || oConvertUtils.isEmpty((Object)domainUrl.getApp())) {
            log.error("\u7f3a\u5c11\u914d\u7f6e\uff1ajeecg.domainUrl.app!");
            return "";
        }
        return domainUrl.getApp();
    }

    public String getFormDetailRouteInfo(ExecutionEntity executionEntity) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("taskId", (Object)executionEntity.getActivityId());
        jSONObject.put("procInsId", (Object)executionEntity.getProcessInstanceId());
        jSONObject.put("taskDetail", (Object)true);
        return jSONObject.toJSONString();
    }

    public String parseContent(ExtActProcess extActProcess, String templateContext, String jsonContext, Map<String, Object> dataMap, String processInstanceId, String executionId) {
        if (ObjectUtils.isNotEmpty(dataMap)) {
            JSONObject jSONObject = JSONObject.parseObject((String)jsonContext);
            return this.replaceCondition(extActProcess, templateContext, jSONObject, dataMap, processInstanceId, executionId);
        }
        return "";
    }

    private String replaceCondition(ExtActProcess extActProcess, String conditionValue, JSONObject jsonObject, Map<String, Object> dataMap, String processInstanceId, String executionId) {
        String string = conditionValue;
        if (string.contains("{{")) {
            String string2 = string.substring(string.indexOf("{{"), string.indexOf("}}") + 2);
            String string3 = string2.replace("{{", "").replace("}}", "");
            if (ObjectUtils.isNotEmpty((Object)string3)) {
                Object object = this.getValue(extActProcess, string3, jsonObject, dataMap, processInstanceId, executionId);
                string = ObjectUtils.isNotEmpty((Object)object) ? string.replace(string2, object.toString()) : string.replace(string2, "");
            }
            string = this.replaceCondition(extActProcess, string, jsonObject, dataMap, processInstanceId, executionId);
        }
        return string;
    }

    public Object getValue(ExtActProcess extActProcess, String objText, JSONObject jsonContext, Map<String, Object> dataMap, String processInstanceId, String executionId) {
        String[] stringArray = objText.split("\\.");
        if (ObjectUtils.isNotEmpty((Object)stringArray)) {
            String string = stringArray[0];
            if (string.contains("_FW_")) {
                for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
                    String string2 = entry.getKey();
                    if (!string2.equals(string)) continue;
                    return entry.getValue();
                }
            } else {
                try {
                    String string3 = jsonContext.getString(string);
                    String string4 = new String(Base64.getDecoder().decode(string3), "utf-8");
                    JSONObject jSONObject = JSONObject.parseObject((String)string4);
                    MinFlowUtils.a(jSONObject, extActProcess);
                    return this.getValueByJsonObject(jSONObject, executionId, processInstanceId, true);
                }
                catch (Exception exception) {
                    log.warn("\u6d88\u606f\u6a21\u677f\u89e3\u6790\u5f02\u5e38\uff1a{}", (Object)exception.getMessage(), (Object)exception);
                }
            }
        }
        return null;
    }

    public Object getValueByJsonObject(JSONObject valueObj, String executionId, String processInstanceId) {
        return this.getValueByJsonObject(valueObj, executionId, processInstanceId, false);
    }

    public Object getValueByJsonObject(JSONObject valueObj, String executionId, String processInstanceId, boolean getDictText) {
        String string = valueObj.getString("formTableCode");
        String string2 = valueObj.getString("nodeId");
        String string3 = valueObj.getString("field");
        String string4 = valueObj.getString("nodeType");
        if (StringUtils.isNotEmpty((CharSequence)string4)) {
            String string5;
            Object object;
            DesignFormData designFormData = null;
            if (FormTableTypeEnums.getUserDeptRole.name().equals(string4) && ObjectUtils.isNotEmpty((Object)(object = (JSONObject)this.runtimeService.getVariable(executionId, string5 = MessageFormat.format("flow:task:get_data:{0}:{1}", processInstanceId, string2), JSONObject.class)))) {
                return this.getJsonValue(getDictText, string3, (JSONObject)object);
            }
            if (FormTableTypeEnums.getMoreUserDeptRole.name().equals(string4) && ObjectUtils.isEmpty(designFormData) && oConvertUtils.isNotEmpty((Object)(object = (String)this.runtimeService.getVariable(executionId, string5 = MessageFormat.format("flow:task:get_data:{0}:{1}", processInstanceId, string2), String.class)))) {
                if ("sys_user".equalsIgnoreCase(string)) {
                    JSONObject jSONObject = this.baseApi.queryUserById((String)object);
                    if (jSONObject != null) {
                        String string6;
                        List list;
                        if ("depart".equals(string3) && (list = this.baseApi.getDepartIdsByUsername(string6 = jSONObject.getString("username"))) != null && list.size() > 0) {
                            jSONObject.put("depart", (Object)oConvertUtils.list2JSONArray((List)list));
                        }
                        designFormData = new DesignFormData();
                        designFormData.setDesformData(jSONObject);
                    }
                } else if ("sys_depart".equalsIgnoreCase(string)) {
                    List list = this.baseApi.queryDepartsByIds((String)object);
                    if (list != null && list.size() > 0) {
                        designFormData = new DesignFormData();
                        designFormData.setDesformData((JSONObject)list.get(0));
                    }
                } else if ("sys_role".equalsIgnoreCase(string)) {
                    ArrayList<QueryCondition> arrayList = new ArrayList<QueryCondition>();
                    QueryCondition queryCondition = new QueryCondition("id", "input", null, QueryRuleEnum.EQ.getValue(), (String)object);
                    arrayList.add(queryCondition);
                    try {
                        String string7 = URLEncoder.encode(JSONObject.toJSONString(arrayList), "UTF-8");
                        List list = this.baseApi.queryRoleBySuperQuery(string7, "and");
                        if (list != null && list.size() > 0) {
                            designFormData = new DesignFormData();
                            designFormData.setDesformData((JSONObject)list.get(0));
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        unsupportedEncodingException.printStackTrace();
                    }
                }
            }
            if (FormTableTypeEnums.userEvent.name().equals(string4) && ObjectUtils.isNotEmpty((Object)(object = this.baseApi.queryUserById(string5 = (String)this.runtimeService.getVariable(executionId, WorkFlowGlobals.BPM_DATA_ID, String.class))))) {
                return this.getJsonValue(getDictText, string3, (JSONObject)object);
            }
            if (FormTableTypeEnums.function.name().equals(string4) && (object = this.runtimeService.getVariable(executionId, string5 = MessageFormat.format("flow:task:get_data:{0}:{1}", processInstanceId, string2))) != null) {
                return object.toString();
            }
            if (FormTableTypeEnums.table.name().equals(string4)) {
                string5 = (String)this.runtimeService.getVariable(executionId, WorkFlowGlobals.BPM_DATA_ID, String.class);
                designFormData = this.designFormDataService.getDataWithDictText(string, string5);
            }
            if (FormTableTypeEnums.search.name().equals(string4)) {
                string5 = MessageFormat.format("flow:task:get_data:{0}:{1}", processInstanceId, string2);
                object = (String)this.runtimeService.getVariable(executionId, string5, String.class);
                designFormData = this.designFormDataService.getDataWithDictText(string, (String)object);
            }
            if (FormTableTypeEnums.plus.name().equals(string4)) {
                string5 = MessageFormat.format("flow:task:form_data:{0}:{1}", processInstanceId, string2);
                object = (String)this.runtimeService.getVariable(executionId, string5, String.class);
                designFormData = this.designFormDataService.getDataWithDictText(string, (String)object);
            }
            if (ObjectUtils.isNotEmpty(designFormData)) {
                string5 = designFormData.getDesformData();
                return this.getJsonValue(getDictText, string3, (JSONObject)string5);
            }
        }
        return null;
    }

    private Object getJsonValue(boolean getDictText, String variableValue, JSONObject sourceJsonObject) {
        if (getDictText) {
            String string = variableValue + "_dictText";
            if (sourceJsonObject.containsKey((Object)string)) {
                return sourceJsonObject.get((Object)string);
            }
            return sourceJsonObject.get((Object)variableValue);
        }
        return sourceJsonObject.get((Object)variableValue);
    }

    public List<String> getListValue(Object value) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (value instanceof JSONArray) {
            JSONArray jSONArray = (JSONArray)value;
            for (int j = 0; j < jSONArray.size(); ++j) {
                arrayList.add(jSONArray.getString(j));
            }
        } else {
            String string = value.toString();
            if (string.startsWith("[") && string.endsWith("]")) {
                JSONArray jSONArray = JSONArray.parseArray((String)string);
                for (int j = 0; j < jSONArray.size(); ++j) {
                    arrayList.add(jSONArray.getString(j));
                }
            } else {
                String[] stringArray;
                for (String string2 : stringArray = string.split(",")) {
                    arrayList.add(string2);
                }
            }
        }
        return arrayList;
    }
}

