/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.common.expression;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.flowable.engine.delegate.DelegateExecution;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.extbpm.util.BranchConditionGroupUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="flowNodeExpression")
public class FlowNodeExpression {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlowNodeExpression.class);
    @Lazy
    @Autowired
    private ISysBaseAPI sysbase;
    @Autowired
    private BranchConditionGroupUtils branchConditionGroupUtils;

    public List<String> getDepartLeaders(String applyUserId) {
        log.info("getDepartLeaders called with applyUserId={}", (Object)applyUserId);
        List depIds = this.sysbase.getDepartIdsByUsername(applyUserId);
        if (CollectionUtils.isEmpty((Collection)depIds)) {
            return null;
        }
        List users = this.sysbase.getDeptHeadByDepId(StringUtils.join((Collection)depIds, (String)","));
        return users;
    }

    public List<String> getApplyDepartLeaders(DelegateExecution execution) {
        String sys_org_code = oConvertUtils.getString((Object)execution.getVariable("sys_org_code"));
        if (oConvertUtils.isEmpty((Object)sys_org_code)) {
            log.warn("\u3010\u67e5\u627e\u5f53\u524d\u90e8\u95e8\u8d1f\u8d23\u4eba\u3011\u6d41\u7a0b\u53d1\u8d77\u53d8\u91cf: sys_org_code \u4e3a\u7a7a\uff0c\u8fd4\u56denull");
            return null;
        }
        String depId = this.sysbase.getDepartIdsByOrgCode(sys_org_code);
        log.info("\u3010\u67e5\u627e\u5f53\u524d\u90e8\u95e8\u8d1f\u8d23\u4eba\u3011 called with sys_org_code={} depId={}", (Object)sys_org_code, (Object)depId);
        if (oConvertUtils.isEmpty((Object)depId)) {
            log.warn("\u3010\u67e5\u627e\u5f53\u524d\u90e8\u95e8\u8d1f\u8d23\u4eba\u3011\u6d41\u7a0b\u53d1\u8d77\u53d8\u91cf sys_org_code - \u90e8\u95e8ID \u4e3a\u7a7a\uff0c\u8fd4\u56denull");
            return null;
        }
        List users = this.sysbase.getDeptHeadByDepId(depId);
        log.info("\u3010\u67e5\u627e\u5f53\u524d\u90e8\u95e8\u8d1f\u8d23\u4eba\u3011 called with sys_org_code={},users={}", (Object)sys_org_code, (Object)users);
        return users;
    }

    public List<String> getFormDepartLeaders(DelegateExecution execution, String fieldName) {
        String fieldVal = this.branchConditionGroupUtils.handleUnknownField(execution, fieldName);
        log.info("\u3010\u67e5\u627e\u8868\u5355\u90e8\u95e8\u5b57\u6bb5\u7684\u8d1f\u8d23\u4eba\u3011 called with fieldName={}, fieldVal={}", (Object)fieldName, (Object)fieldVal);
        if (oConvertUtils.isEmpty((Object)fieldVal)) {
            log.warn("\u3010\u67e5\u627e\u8868\u5355\u90e8\u95e8\u5b57\u6bb5\u7684\u8d1f\u8d23\u4eba\u3011\u8868\u5355\u5b57\u6bb5 {} - \u90e8\u95e8\u4e3a\u7a7a\uff0c\u8fd4\u56denull", (Object)fieldName);
            return null;
        }
        List<String> depIds = this.branchConditionGroupUtils.convertToArray(fieldVal);
        List users = this.sysbase.getDeptHeadByDepId(StringUtils.join(depIds, (String)","));
        log.info("\u3010\u67e5\u627e\u8868\u5355\u90e8\u95e8\u5b57\u6bb5\u7684\u8d1f\u8d23\u4eba\u3011 called with fieldName={},fieldVal={} ,users={}", new Object[]{fieldName, fieldVal, users});
        return users;
    }

    public List<String> getLevel1DepartLeaders(String applyUserId) {
        Set level1DepParentIds = this.sysbase.getDepartParentIdsByUsername(applyUserId);
        int deptCount = level1DepParentIds != null ? level1DepParentIds.size() : 0;
        log.info("\u3010\u67e5\u627e\u4e0a\u4e00\u7ea7\u90e8\u95e8\u8d1f\u8d23\u4eba\u3011\u7528\u6237: {} - \u83b7\u53d6\u5230 {} \u4e2a\u4e0a\u7ea7\u90e8\u95e8: {}", new Object[]{applyUserId, deptCount, level1DepParentIds});
        if (CollectionUtils.isEmpty((Collection)level1DepParentIds) || level1DepParentIds.stream().allMatch(StringUtils::isEmpty)) {
            log.warn("\u3010\u67e5\u627e\u4e0a\u4e00\u7ea7\u90e8\u95e8\u8d1f\u8d23\u4eba\u3011\u7528\u6237: {} - \u4e0a\u7ea7\u90e8\u95e8\u4e3a\u7a7a\uff0c\u8fd4\u56denull", (Object)applyUserId);
            return null;
        }
        List users = this.sysbase.getDeptHeadByDepId(StringUtils.join((Collection)level1DepParentIds, (String)","));
        int userCount = users != null ? users.size() : 0;
        log.info("\u3010\u67e5\u627e\u4e0a\u4e00\u7ea7\u90e8\u95e8\u8d1f\u8d23\u4eba\u3011\u7528\u6237: {} - \u83b7\u53d6\u5230 {} \u4e2a\u90e8\u95e8\u8d1f\u8d23\u4eba: {}", new Object[]{applyUserId, userCount, users});
        return users;
    }

    public List<String> getLevel2DepartLeaders(String applyUserId) {
        Set level1DepParentIds = this.sysbase.getDepartParentIdsByUsername(applyUserId);
        int level1Count = level1DepParentIds != null ? level1DepParentIds.size() : 0;
        log.info("\u3010\u67e5\u627e\u4e0a\u4e8c\u7ea7\u90e8\u95e8\u8d1f\u8d23\u4eba\u3011\u7528\u6237: {} - \u83b7\u53d6\u5230 {} \u4e2a\u4e0a\u4e00\u7ea7\u90e8\u95e8: {}", new Object[]{applyUserId, level1Count, level1DepParentIds});
        if (CollectionUtils.isEmpty((Collection)level1DepParentIds) || level1DepParentIds.stream().allMatch(StringUtils::isEmpty)) {
            log.warn("\u3010\u67e5\u627e\u4e0a\u4e8c\u7ea7\u90e8\u95e8\u8d1f\u8d23\u4eba\u3011\u7528\u6237: {} - \u4e0a\u4e00\u7ea7\u90e8\u95e8\u4e3a\u7a7a\uff0c\u8fd4\u56denull", (Object)applyUserId);
            return null;
        }
        Set level2DepParentIds = this.sysbase.getDepartParentIdsByDepIds(level1DepParentIds);
        int level2Count = level2DepParentIds != null ? level2DepParentIds.size() : 0;
        log.info("\u3010\u67e5\u627e\u4e0a\u4e8c\u7ea7\u90e8\u95e8\u8d1f\u8d23\u4eba\u3011\u7528\u6237: {} - \u83b7\u53d6\u5230 {} \u4e2a\u4e0a\u4e8c\u7ea7\u90e8\u95e8: {}", new Object[]{applyUserId, level2Count, level2DepParentIds});
        if (CollectionUtils.isEmpty((Collection)level2DepParentIds) || level2DepParentIds.stream().allMatch(StringUtils::isEmpty)) {
            log.warn("\u3010\u67e5\u627e\u4e0a\u4e8c\u7ea7\u90e8\u95e8\u8d1f\u8d23\u4eba\u3011\u7528\u6237: {} - \u4e0a\u4e8c\u7ea7\u90e8\u95e8\u4e3a\u7a7a\uff0c\u8fd4\u56denull", (Object)applyUserId);
            return null;
        }
        List users = this.sysbase.getDeptHeadByDepId(StringUtils.join((Collection)level2DepParentIds, (String)","));
        int userCount = users != null ? users.size() : 0;
        log.info("\u3010\u67e5\u627e\u4e0a\u4e8c\u7ea7\u90e8\u95e8\u8d1f\u8d23\u4eba\u3011\u7528\u6237: {} - \u83b7\u53d6\u5230 {} \u4e2a\u90e8\u95e8\u8d1f\u8d23\u4eba: {}", new Object[]{applyUserId, userCount, users});
        return users;
    }

    public List<String> getLevel3DepartLeaders(String applyUserId) {
        Set level1DepParentIds = this.sysbase.getDepartParentIdsByUsername(applyUserId);
        int level1Count = level1DepParentIds != null ? level1DepParentIds.size() : 0;
        log.info("\u3010\u67e5\u627e\u4e0a\u4e09\u7ea7\u90e8\u95e8\u8d1f\u8d23\u4eba\u3011\u7528\u6237: {} - \u83b7\u53d6\u5230 {} \u4e2a\u4e0a\u4e00\u7ea7\u90e8\u95e8: {}", new Object[]{applyUserId, level1Count, level1DepParentIds});
        if (CollectionUtils.isEmpty((Collection)level1DepParentIds) || level1DepParentIds.stream().allMatch(StringUtils::isEmpty)) {
            log.warn("\u3010\u67e5\u627e\u4e0a\u4e09\u7ea7\u90e8\u95e8\u8d1f\u8d23\u4eba\u3011\u7528\u6237: {} - \u4e0a\u4e00\u7ea7\u90e8\u95e8\u4e3a\u7a7a\uff0c\u8fd4\u56denull", (Object)applyUserId);
            return null;
        }
        Set level2DepParentIds = this.sysbase.getDepartParentIdsByDepIds(level1DepParentIds);
        int level2Count = level2DepParentIds != null ? level2DepParentIds.size() : 0;
        log.info("\u3010\u67e5\u627e\u4e0a\u4e09\u7ea7\u90e8\u95e8\u8d1f\u8d23\u4eba\u3011\u7528\u6237: {} - \u83b7\u53d6\u5230 {} \u4e2a\u4e0a\u4e8c\u7ea7\u90e8\u95e8: {}", new Object[]{applyUserId, level2Count, level2DepParentIds});
        if (CollectionUtils.isEmpty((Collection)level2DepParentIds) || level2DepParentIds.stream().allMatch(StringUtils::isEmpty)) {
            log.warn("\u3010\u67e5\u627e\u4e0a\u4e09\u7ea7\u90e8\u95e8\u8d1f\u8d23\u4eba\u3011\u7528\u6237: {} - \u4e0a\u4e8c\u7ea7\u90e8\u95e8\u4e3a\u7a7a\uff0c\u8fd4\u56denull", (Object)applyUserId);
            return null;
        }
        Set level3DepParentIds = this.sysbase.getDepartParentIdsByDepIds(level2DepParentIds);
        int level3Count = level3DepParentIds != null ? level3DepParentIds.size() : 0;
        log.info("\u3010\u67e5\u627e\u4e0a\u4e09\u7ea7\u90e8\u95e8\u8d1f\u8d23\u4eba\u3011\u7528\u6237: {} - \u83b7\u53d6\u5230 {} \u4e2a\u4e0a\u4e09\u7ea7\u90e8\u95e8: {}", new Object[]{applyUserId, level3Count, level3DepParentIds});
        if (CollectionUtils.isEmpty((Collection)level3DepParentIds) || level3DepParentIds.stream().allMatch(StringUtils::isEmpty)) {
            log.warn("\u3010\u67e5\u627e\u4e0a\u4e09\u7ea7\u90e8\u95e8\u8d1f\u8d23\u4eba\u3011\u7528\u6237: {} - \u4e0a\u4e09\u7ea7\u90e8\u95e8\u4e3a\u7a7a\uff0c\u8fd4\u56denull", (Object)applyUserId);
            return null;
        }
        List users = this.sysbase.getDeptHeadByDepId(StringUtils.join((Collection)level3DepParentIds, (String)","));
        int userCount = users != null ? users.size() : 0;
        log.info("\u3010\u67e5\u627e\u4e0a\u4e09\u7ea7\u90e8\u95e8\u8d1f\u8d23\u4eba\u3011\u7528\u6237: {} - \u83b7\u53d6\u5230 {} \u4e2a\u90e8\u95e8\u8d1f\u8d23\u4eba: {}", new Object[]{applyUserId, userCount, users});
        return users;
    }
}

