/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.drag.config.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import org.jeecg.modules.drag.a.a;

public class Result<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean success = true;
    private String message = "";
    private Integer code = 0;
    private T result;
    private long timestamp = System.currentTimeMillis();
    @JsonIgnore
    private String onlTable;

    public Result() {
    }

    public Result(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public Result<T> success(String message) {
        this.message = message;
        this.code = a.e;
        this.success = true;
        return this;
    }

    public static <T> Result<T> ok() {
        Result<T> result = new Result<T>();
        result.setSuccess(true);
        result.setCode(a.e);
        return result;
    }

    public static <T> Result<T> ok(String msg) {
        Result<String> result = new Result<String>();
        result.setSuccess(true);
        result.setCode(a.e);
        result.setResult(msg);
        result.setMessage(msg);
        return result;
    }

    public static <T> Result<T> ok(T data) {
        Result<T> result = new Result<T>();
        result.setSuccess(true);
        result.setCode(a.e);
        result.setResult(data);
        return result;
    }

    public static <T> Result<T> OK() {
        Result<T> result = new Result<T>();
        result.setSuccess(true);
        result.setCode(a.e);
        return result;
    }

    public static <T> Result<T> OK(String msg) {
        Result<String> result = new Result<String>();
        result.setSuccess(true);
        result.setCode(a.e);
        result.setMessage(msg);
        result.setResult(msg);
        return result;
    }

    public static <T> Result<T> OK(T data) {
        Result<T> result = new Result<T>();
        result.setSuccess(true);
        result.setCode(a.e);
        result.setResult(data);
        return result;
    }

    public static <T> Result<T> OK(String msg, T data) {
        Result<T> result = new Result<T>();
        result.setSuccess(true);
        result.setCode(a.e);
        result.setMessage(msg);
        result.setResult(data);
        return result;
    }

    public static <T> Result<T> error(String msg, T data) {
        Result<T> result = new Result<T>();
        result.setSuccess(false);
        result.setCode(a.c);
        result.setMessage(msg);
        result.setResult(data);
        return result;
    }

    public static <T> Result<T> error(String msg) {
        return Result.error(a.c, msg);
    }

    public static <T> Result<T> error(int code, String msg) {
        Result<T> result = new Result<T>();
        result.setCode(code);
        result.setMessage(msg);
        result.setSuccess(false);
        return result;
    }

    public Result<T> error500(String message) {
        this.message = message;
        this.code = a.c;
        this.success = false;
        return this;
    }

    public static <T> Result<T> noauth(String msg) {
        return Result.error(a.f, msg);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getMessage() {
        return this.message;
    }

    public Integer getCode() {
        return this.code;
    }

    public T getResult() {
        return this.result;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getOnlTable() {
        return this.onlTable;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @JsonIgnore
    public void setOnlTable(String onlTable) {
        this.onlTable = onlTable;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result result = (Result)o;
        if (!result.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != result.isSuccess()) {
            return false;
        }
        if (this.getTimestamp() != result.getTimestamp()) {
            return false;
        }
        Integer n2 = this.getCode();
        Integer n3 = result.getCode();
        if (n2 == null ? n3 != null : !((Object)n2).equals(n3)) {
            return false;
        }
        String string = this.getMessage();
        String string2 = result.getMessage();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        T t = this.getResult();
        T t2 = result.getResult();
        if (t == null ? t2 != null : !t.equals(t2)) {
            return false;
        }
        String string3 = this.getOnlTable();
        String string4 = result.getOnlTable();
        return !(string3 == null ? string4 != null : !string3.equals(string4));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int n2 = 59;
        int n3 = 1;
        n3 = n3 * 59 + (this.isSuccess() ? 79 : 97);
        long l2 = this.getTimestamp();
        n3 = n3 * 59 + (int)(l2 >>> 32 ^ l2);
        Integer n4 = this.getCode();
        n3 = n3 * 59 + (n4 == null ? 43 : ((Object)n4).hashCode());
        String string = this.getMessage();
        n3 = n3 * 59 + (string == null ? 43 : string.hashCode());
        T t = this.getResult();
        n3 = n3 * 59 + (t == null ? 43 : t.hashCode());
        String string2 = this.getOnlTable();
        n3 = n3 * 59 + (string2 == null ? 43 : string2.hashCode());
        return n3;
    }

    public String toString() {
        return "Result(success=" + this.isSuccess() + ", message=" + this.getMessage() + ", code=" + this.getCode() + ", result=" + this.getResult() + ", timestamp=" + this.getTimestamp() + ", onlTable=" + this.getOnlTable() + ")";
    }
}

