/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.pay.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.constant.enums.vip.PayVipResourceEnum;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.system.vo.SysPayVipVo;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.TokenUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.pay.entity.SysVipMembership;
import org.jeecg.modules.pay.entity.SysVipPayments;
import org.jeecg.modules.pay.enums.PayVipExtendEnum;
import org.jeecg.modules.pay.service.ISysVipMembershipService;
import org.jeecg.modules.pay.service.ISysVipPaymentsService;
import org.jeecg.modules.pay.vo.PayExtendVo;
import org.jeecg.modules.pay.vo.SysPaymentsUserVo;
import org.jeecg.modules.pay.vo.SysVipMembershipVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f1a\u5458\u8868"})
@RestController
@RequestMapping(value={"/pay/vipMembership"})
public class SysVipMembershipController
extends JeecgController<SysVipMembership, ISysVipMembershipService> {
    private static final Logger log = LoggerFactory.getLogger(SysVipMembershipController.class);
    @Autowired
    private ISysVipMembershipService sysVipMembershipService;
    @Autowired
    private ISysVipPaymentsService sysVipPaymentsService;

    @GetMapping(value={"/verifyVipIdentity"})
    public Result<SysPayVipVo> verifyVipIdentity() {
        SysPayVipVo sysPayVipVo = this.sysVipMembershipService.verifyVipIdentity();
        return Result.ok((Object)sysPayVipVo);
    }

    @ApiOperation(value="\u4f1a\u5458\u8868-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u4f1a\u5458\u8868-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<IPage<SysVipMembership>> queryPageList(SysVipMembership sysVipMembership, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysVipMembership, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.sysVipMembershipService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.OK((Object)pageList);
    }

    @AutoLog(value="\u4f1a\u5458\u8868-\u6dfb\u52a0")
    @ApiOperation(value="\u4f1a\u5458\u8868-\u6dfb\u52a0", notes="\u4f1a\u5458\u8868-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"pay:vipMembership:add"})
    public Result<String> add(@RequestBody SysVipMembership sysVipMembership) {
        if (StringUtils.isNotEmpty((String)sysVipMembership.getUserId())) {
            LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            sysVipMembership.setUserId(user.getId());
        }
        this.sysVipMembershipService.save(sysVipMembership);
        return Result.OK((String)"\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @AutoLog(value="\u4f1a\u5458\u8868-\u7f16\u8f91")
    @ApiOperation(value="\u4f1a\u5458\u8868-\u7f16\u8f91", notes="\u4f1a\u5458\u8868-\u7f16\u8f91")
    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT, RequestMethod.POST})
    @RequiresPermissions(value={"pay:vipMembership:edit"})
    public Result<String> edit(@RequestBody SysVipMembership sysVipMembership) {
        this.sysVipMembershipService.updateById(sysVipMembership);
        return Result.OK((String)"\u7f16\u8f91\u6210\u529f!");
    }

    @AutoLog(value="\u4f1a\u5458\u8868-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u4f1a\u5458\u8868-\u901a\u8fc7id\u5220\u9664", notes="\u4f1a\u5458\u8868-\u901a\u8fc7id\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    @RequiresPermissions(value={"pay:vipMembership:delete"})
    public Result<String> delete(@RequestParam(name="id", required=true) String id) {
        this.sysVipMembershipService.removeById((Serializable)((Object)id));
        return Result.OK((String)"\u5220\u9664\u6210\u529f!");
    }

    @AutoLog(value="\u4f1a\u5458\u8868-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u4f1a\u5458\u8868-\u6279\u91cf\u5220\u9664", notes="\u4f1a\u5458\u8868-\u6279\u91cf\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"pay:vipMembership:deleteBatch"})
    public Result<String> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.sysVipMembershipService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK((String)"\u6279\u91cf\u5220\u9664\u6210\u529f!");
    }

    @ApiOperation(value="\u4f1a\u5458\u8868-\u901a\u8fc7id\u67e5\u8be2", notes="\u4f1a\u5458\u8868-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<SysVipMembership> queryById(@RequestParam(name="id", required=true) String id) {
        SysVipMembership sysVipMembership = (SysVipMembership)this.sysVipMembershipService.getById((Serializable)((Object)id));
        if (sysVipMembership == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        return Result.OK((Object)sysVipMembership);
    }

    @GetMapping(value={"/getVipMember"})
    public Result<SysVipMembershipVo> getVipMember(@RequestParam(name="memberType", required=false) String memberType, HttpServletRequest req) {
        if (oConvertUtils.isEmpty((Object)TokenUtils.getTenantIdByRequest((HttpServletRequest)req))) {
            return Result.error((String)"\u5f53\u524d\u767b\u5f55\u79df\u6237\u4e3a\u7a7a\uff0c\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f\u5931\u8d25\uff01");
        }
        Integer tenantId = oConvertUtils.getInt((String)TokenUtils.getTenantIdByRequest((HttpServletRequest)req));
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysVipMembership::getTenantId, (Object)tenantId);
        if (StringUtils.isNotEmpty((String)memberType)) {
            query.eq(SysVipMembership::getMemberType, (Object)memberType);
        }
        List vipMemberships = this.sysVipMembershipService.list((Wrapper)query);
        SysVipMembership sysVipMembership = new SysVipMembership();
        if (CollectionUtil.isEmpty((Collection)vipMemberships)) {
            sysVipMembership.setMemberType(PayVipResourceEnum.DEFAULT.getCode());
        } else {
            sysVipMembership = (SysVipMembership)vipMemberships.get(0);
        }
        SysVipMembershipVo sysVipMembershipVo = new SysVipMembershipVo();
        BeanUtils.copyProperties((Object)sysVipMembership, (Object)sysVipMembershipVo);
        PayVipResourceEnum payVipResourceEnum = PayVipResourceEnum.valueOfType((String)sysVipMembership.getMemberType());
        sysVipMembershipVo.setMaxAppCount(payVipResourceEnum.getMaxAppCount());
        int maxSmsCount = payVipResourceEnum.getMaxSmsCount();
        if (null != sysVipMembershipVo.getSmsCountBuy()) {
            maxSmsCount += sysVipMembershipVo.getSmsCountBuy().intValue();
        }
        sysVipMembershipVo.setMaxSmsCount(maxSmsCount);
        int maxUploadSize = payVipResourceEnum.getMaxUploadSize();
        if (null != sysVipMembershipVo.getUploadSizeBuy()) {
            maxUploadSize += sysVipMembershipVo.getUploadSizeBuy().intValue();
        }
        sysVipMembershipVo.setMaxUploadSize(maxUploadSize);
        int maxTenantUserCount = payVipResourceEnum.getMaxTenantUserCount();
        Integer userCountBuy = sysVipMembership.getUserCountBuy();
        if (null != userCountBuy) {
            maxTenantUserCount += userCountBuy.intValue();
        }
        sysVipMembershipVo.setMaxTenantUserCount(maxTenantUserCount);
        sysVipMembershipVo.setMaxTableCount(payVipResourceEnum.getMaxTableCount());
        sysVipMembershipVo.setMaxWorkFlowCount(payVipResourceEnum.getMaxWorkFlowCount());
        sysVipMembershipVo.setMaxBigScreenCount(payVipResourceEnum.getMaxBigScreenCount());
        sysVipMembershipVo.setMaxTableControlCount(payVipResourceEnum.getMaxTableControlCount());
        sysVipMembershipVo.setMaxTenantCount(payVipResourceEnum.getMaxTenantCount());
        sysVipMembershipVo.setMemberType(sysVipMembership.getMemberType());
        sysVipMembershipVo.setMaxJmReportCount(payVipResourceEnum.getMaxJmReportCount());
        sysVipMembershipVo.setMaxJmReportSourceCount(payVipResourceEnum.getMaxJmReportSourceCount());
        sysVipMembershipVo.setMaxBigScreenSourceCount(payVipResourceEnum.getMaxBigScreenSourceCount());
        sysVipMembershipVo.setMaxDragPageCount(payVipResourceEnum.getMaxDragPageCount());
        if (null != sysVipMembership.getEndTime()) {
            sysVipMembershipVo.setEndTime(sysVipMembership.getEndTime());
        }
        sysVipMembershipVo = this.sysVipMembershipService.getUseCount(sysVipMembershipVo, sysUser.getUsername(), sysUser.getId());
        return Result.ok((Object)sysVipMembershipVo);
    }

    @GetMapping(value={"/getPayMsgByType"})
    public Result<SysVipMembershipVo> getPayMsgByType(@RequestParam(name="memberType") String memberType, HttpServletRequest req) {
        SysVipMembershipVo sysVipMembershipVo = new SysVipMembershipVo();
        PayVipResourceEnum payVipResourceEnum = PayVipResourceEnum.valueOfType((String)memberType);
        if (null == payVipResourceEnum) {
            return Result.error((String)"\u83b7\u53d6\u652f\u4ed8\u4fe1\u606f\u5931\u8d25");
        }
        sysVipMembershipVo.setPrice(payVipResourceEnum.getPrice());
        if (oConvertUtils.isEmpty((Object)TokenUtils.getTenantIdByRequest((HttpServletRequest)req))) {
            return Result.error((String)"\u5f53\u524d\u767b\u5f55\u79df\u6237\u4e3a\u7a7a\uff0c\u83b7\u53d6\u652f\u4ed8\u4ef7\u683c\u5931\u8d25\uff01");
        }
        Integer tenantId = oConvertUtils.getInt((String)TokenUtils.getTenantIdByRequest((HttpServletRequest)req));
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysVipMembership::getTenantId, (Object)tenantId);
        List sysVipMembership = this.sysVipMembershipService.list((Wrapper)query);
        if (CollectionUtil.isEmpty((Collection)sysVipMembership)) {
            sysVipMembershipVo.setEndTime(new Date());
        } else {
            sysVipMembershipVo.setEndTime(((SysVipMembership)sysVipMembership.get(0)).getEndTime());
        }
        return Result.ok((Object)sysVipMembershipVo);
    }

    @GetMapping(value={"/checkSmsSendLimit"})
    public boolean checkSmsSendLimit() {
        throw new JeecgBootException("\u6b64\u65b9\u6cd5\u5df2\u7981\u7528");
    }

    @GetMapping(value={"/plusSmsCountYearUsed"})
    public boolean plusSmsCountYearUsed() {
        throw new JeecgBootException("\u6b64\u65b9\u6cd5\u5df2\u7981\u7528");
    }

    @RequiresRoles(value={"admin"})
    @ApiOperation(value="sys_vip_payments-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="sys_vip_payments-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/paymentsList"})
    public Result<IPage<SysPaymentsUserVo>> queryPageList(SysPaymentsUserVo sysPaymentsUserVo, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        String startTime = "";
        String entTime = "";
        if (null != sysPaymentsUserVo.getPayTimeBegin() && null != sysPaymentsUserVo.getPayTimeEnd()) {
            startTime = DateUtils.formatDate((Date)sysPaymentsUserVo.getPayTimeBegin(), (String)"yyyy-MM-dd") + " 00:00:00";
            entTime = DateUtils.formatDate((Date)sysPaymentsUserVo.getPayTimeEnd(), (String)"yyyy-MM-dd") + " 23:59:59";
        }
        IPage<SysPaymentsUserVo> pageList = this.sysVipPaymentsService.pagePaymentsList((Page<SysPaymentsUserVo>)page, sysPaymentsUserVo, startTime, entTime);
        return Result.OK(pageList);
    }

    @GetMapping(value={"/getVipExtend"})
    public Result<List<PayExtendVo>> getVipExtend(@RequestParam(name="type") String type) {
        SysPayVipVo sysPayVipVo = this.sysVipMembershipService.verifyVipIdentity();
        if (!sysPayVipVo.getIzVip().booleanValue()) {
            return Result.error((String)"\u975e\u4f1a\u5458\u6682\u4e0d\u652f\u6301\u8d2d\u4e70\u62d3\u5c55\u5305");
        }
        List<PayExtendVo> extendList = PayVipExtendEnum.getExtendList(type);
        if (CollectionUtil.isEmpty(extendList)) {
            return Result.error((String)"\u5f53\u524d\u6269\u5c55\u5305\u4e0d\u652f\u6301\u8d2d\u4e70");
        }
        return Result.ok(extendList);
    }

    @GetMapping(value={"/paymentsUserList"})
    public Result<IPage<SysVipPayments>> paymentsUserList(SysVipPayments sysVipPayments, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (oConvertUtils.isNotEmpty((Object)sysVipPayments.getBuyType())) {
            queryWrapper.eq(SysVipPayments::getBuyType, (Object)sysVipPayments.getBuyType());
        }
        if (oConvertUtils.isNotEmpty((Object)sysVipPayments.getPayTime())) {
            String startTime = DateUtils.formatDate((Date)sysVipPayments.getPayTime(), (String)"yyyy-MM-dd") + " 00:00:00";
            String endTime = DateUtils.formatDate((Date)sysVipPayments.getPayTime(), (String)"yyyy-MM-dd") + " 23:59:59";
            queryWrapper.between(SysVipPayments::getPayTime, (Object)startTime, (Object)endTime);
        }
        String tenantId = TokenUtils.getTenantIdByRequest((HttpServletRequest)req);
        queryWrapper.eq(SysVipPayments::getUserId, (Object)sysUser.getId());
        queryWrapper.eq(SysVipPayments::getPayStatus, (Object)"3");
        queryWrapper.eq(SysVipPayments::getTenantId, (Object)Integer.valueOf(tenantId));
        queryWrapper.select((Object[])new SFunction[]{SysVipPayments::getBuyYears, SysVipPayments::getPayTime, SysVipPayments::getBuyType, SysVipPayments::getTotalAmount});
        queryWrapper.orderByDesc(SysVipPayments::getCreateTime);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.sysVipPaymentsService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.OK((Object)pageList);
    }
}

