/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.workflow.service.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.apache.commons.lang.StringUtils;
import org.jeecgframework.core.annotation.Ehcache;
import org.jeecgframework.core.util.ApplicationContextUtil;
import org.jeecgframework.core.util.StreamUtils;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.workflow.common.WorkFlowGlobals;
import org.jeecgframework.workflow.dao.ActivitiDao;
import org.jeecgframework.workflow.service.ActivitiService;
import org.jeecgframework.workflow.util.XmlActivitiUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="taskJeecgService")
@Transactional
public class TaskJeecgService {
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected RuntimeService runtimeService;
    @Autowired
    protected TaskService taskService;
    @Autowired
    protected HistoryService historyService;
    @Autowired
    private ActivitiService activitiService;
    @Autowired
    private ActivitiDao activitiDao;

    public synchronized void goProcessTaskNode(String taskId, String nextTaskId, Map<String, Object> variables) {
        try {
            List<Task> taskList = this.findTaskListByKey(this.findProcessInstanceByTaskId(taskId).getId(), this.findTaskById(taskId).getTaskDefinitionKey());
            for (Task task : taskList) {
                if (!taskId.equals(task.getId())) continue;
                this.commitProcess(task.getId(), variables, nextTaskId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void goProcessTaskNode(String taskId, String nextTaskId) throws Exception {
        if (StringUtils.isEmpty((String)nextTaskId)) {
            throw new Exception("\u76ee\u6807\u8282\u70b9ID\u4e3a\u7a7a\uff01");
        }
        List<Task> taskList = this.findTaskListByKey(this.findProcessInstanceByTaskId(taskId).getId(), this.findTaskById(taskId).getTaskDefinitionKey());
        for (Task task : taskList) {
            this.commitProcess(task.getId(), null, nextTaskId);
        }
    }

    private List<PvmTransition> clearTransition(ActivityImpl activityImpl) {
        ArrayList<PvmTransition> oriPvmTransitionList = new ArrayList<PvmTransition>();
        List pvmTransitionList = activityImpl.getOutgoingTransitions();
        for (PvmTransition pvmTransition : pvmTransitionList) {
            oriPvmTransitionList.add(pvmTransition);
        }
        pvmTransitionList.clear();
        return oriPvmTransitionList;
    }

    private void commitProcess(String taskId, Map<String, Object> variables, String activityId) throws Exception {
        if (oConvertUtils.isEmpty((Object)activityId)) {
            this.taskService.complete(taskId, variables);
        } else {
            this.turnTransition(taskId, activityId, variables);
        }
    }

    public void endProcess(String taskId) throws Exception {
        ActivityImpl endActivity = this.findActivitiImpl(taskId, "end");
        this.commitProcess(taskId, null, endActivity.getId());
    }

    private ActivityImpl filterNewestActivity(ProcessInstance processInstance, List<ActivityImpl> tempList) {
        while (tempList.size() > 0) {
            ActivityImpl activity_1 = tempList.get(0);
            HistoricActivityInstance activityInstance_1 = this.findHistoricUserTask(processInstance, activity_1.getId());
            if (activityInstance_1 == null) {
                tempList.remove(activity_1);
                continue;
            }
            if (tempList.size() <= 1) break;
            ActivityImpl activity_2 = tempList.get(1);
            HistoricActivityInstance activityInstance_2 = this.findHistoricUserTask(processInstance, activity_2.getId());
            if (activityInstance_2 == null) {
                tempList.remove(activity_2);
                continue;
            }
            if (activityInstance_1.getEndTime().before(activityInstance_2.getEndTime())) {
                tempList.remove(activity_1);
                continue;
            }
            tempList.remove(activity_2);
        }
        if (tempList.size() > 0) {
            return tempList.get(0);
        }
        return null;
    }

    private ActivityImpl findActivitiImpl(String taskId, String activityId) throws Exception {
        ActivityImpl activityImpl2;
        ProcessDefinitionEntity processDefinition = this.findProcessDefinitionEntityByTaskId(taskId);
        if (StringUtils.isEmpty((String)activityId)) {
            activityId = this.findTaskById(taskId).getTaskDefinitionKey();
        }
        if (activityId.toUpperCase().equals("END")) {
            for (ActivityImpl activityImpl2 : processDefinition.getActivities()) {
                List pvmTransitionList = activityImpl2.getOutgoingTransitions();
                if (!pvmTransitionList.isEmpty()) continue;
                return activityImpl2;
            }
        }
        activityImpl2 = processDefinition.findActivity(activityId);
        return activityImpl2;
    }

    public List<ActivityImpl> findBackAvtivity(String taskId) throws Exception {
        List<ActivityImpl> rtnList = this.iteratorBackActivity(taskId, this.findActivitiImpl(taskId, null), new ArrayList<ActivityImpl>(), new ArrayList<ActivityImpl>());
        TaskEntity task = this.findTaskById(taskId);
        ProcessDefinitionEntity pde = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(task.getProcessDefinitionId());
        List activitiList = pde.getActivities();
        for (ActivityImpl activityImpl : activitiList) {
        }
        System.out.println("size====" + rtnList.size());
        return this.reverList(rtnList);
    }

    private HistoricActivityInstance findHistoricUserTask(ProcessInstance processInstance, String activityId) {
        HistoricActivityInstance rtnVal = null;
        List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().activityType("userTask").processInstanceId(processInstance.getId()).activityId(activityId).finished().orderByHistoricActivityInstanceEndTime().desc()).list();
        if (historicActivityInstances.size() > 0) {
            rtnVal = (HistoricActivityInstance)historicActivityInstances.get(0);
        }
        return rtnVal;
    }

    private String findParallelGatewayId(ActivityImpl activityImpl) {
        List incomingTransitions = activityImpl.getOutgoingTransitions();
        for (PvmTransition pvmTransition : incomingTransitions) {
            String gatewayId;
            String gatewayType;
            TransitionImpl transitionImpl = (TransitionImpl)pvmTransition;
            activityImpl = transitionImpl.getDestination();
            String type = (String)activityImpl.getProperty("type");
            if (!"parallelGateway".equals(type) || !"END".equals((gatewayType = (gatewayId = activityImpl.getId()).substring(gatewayId.lastIndexOf("_") + 1)).toUpperCase())) continue;
            return String.valueOf(gatewayId.substring(0, gatewayId.lastIndexOf("_"))) + "_start";
        }
        return null;
    }

    public ProcessDefinitionEntity findProcessDefinitionEntityByTaskId(String taskId) throws Exception {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(this.findTaskById(taskId).getProcessDefinitionId());
        if (processDefinition == null) {
            throw new Exception("\u6d41\u7a0b\u5b9a\u4e49\u672a\u627e\u5230!");
        }
        return processDefinition;
    }

    public ProcessInstance findProcessInstanceByTaskId(String taskId) throws Exception {
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(this.findTaskById(taskId).getProcessInstanceId()).singleResult();
        if (processInstance == null) {
            throw new Exception("\u6d41\u7a0b\u5b9e\u4f8b\u672a\u627e\u5230!");
        }
        return processInstance;
    }

    private TaskEntity findTaskById(String taskId) throws Exception {
        TaskEntity task = (TaskEntity)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        if (task == null) {
            throw new Exception("\u4efb\u52a1\u5b9e\u4f8b\u672a\u627e\u5230!");
        }
        return task;
    }

    private List<Task> findTaskListByKey(String processInstanceId, String key) {
        return this.taskService.createTaskQuery().processInstanceId(processInstanceId).taskDefinitionKey(key).list();
    }

    private List<ActivityImpl> iteratorBackActivity(String taskId, ActivityImpl currActivity, List<ActivityImpl> rtnList, List<ActivityImpl> tempList) throws Exception {
        ProcessInstance processInstance = this.findProcessInstanceByTaskId(taskId);
        List incomingTransitions = currActivity.getIncomingTransitions();
        ArrayList<ActivityImpl> exclusiveGateways = new ArrayList<ActivityImpl>();
        ArrayList<ActivityImpl> parallelGateways = new ArrayList<ActivityImpl>();
        for (PvmTransition pvmTransition : incomingTransitions) {
            TransitionImpl transitionImpl = (TransitionImpl)pvmTransition;
            ActivityImpl activityImpl = transitionImpl.getSource();
            String type = (String)activityImpl.getProperty("type");
            if ("parallelGateway".equals(type)) {
                String gatewayId = activityImpl.getId();
                String gatewayType = gatewayId.substring(gatewayId.lastIndexOf("_") + 1);
                if ("START".equals(gatewayType.toUpperCase())) {
                    return rtnList;
                }
                parallelGateways.add(activityImpl);
                continue;
            }
            if ("startEvent".equals(type)) {
                return rtnList;
            }
            if ("userTask".equals(type)) {
                tempList.add(activityImpl);
                continue;
            }
            if (!"exclusiveGateway".equals(type)) continue;
            currActivity = transitionImpl.getSource();
            exclusiveGateways.add(currActivity);
        }
        for (ActivityImpl activityImpl : exclusiveGateways) {
            this.iteratorBackActivity(taskId, activityImpl, rtnList, tempList);
        }
        for (ActivityImpl activityImpl : parallelGateways) {
            this.iteratorBackActivity(taskId, activityImpl, rtnList, tempList);
        }
        currActivity = this.filterNewestActivity(processInstance, tempList);
        if (currActivity != null) {
            String id = this.findParallelGatewayId(currActivity);
            if (StringUtils.isEmpty((String)id)) {
                rtnList.add(currActivity);
            } else {
                currActivity = this.findActivitiImpl(taskId, id);
            }
            tempList.clear();
            this.iteratorBackActivity(taskId, currActivity, rtnList, tempList);
        }
        return rtnList;
    }

    private void restoreTransition(ActivityImpl activityImpl, List<PvmTransition> oriPvmTransitionList) {
        List pvmTransitionList = activityImpl.getOutgoingTransitions();
        pvmTransitionList.clear();
        for (PvmTransition pvmTransition : oriPvmTransitionList) {
            pvmTransitionList.add(pvmTransition);
        }
    }

    private List<ActivityImpl> reverList(List<ActivityImpl> list) {
        ArrayList<ActivityImpl> rtnList = new ArrayList<ActivityImpl>();
        int i = list.size();
        while (i > 0) {
            if (!rtnList.contains(list.get(i - 1))) {
                rtnList.add(list.get(i - 1));
            }
            --i;
        }
        return rtnList;
    }

    public void transferAssignee(String taskId, String userCode) {
        this.taskService.setAssignee(taskId, userCode);
    }

    private void turnTransition(String taskId, String activityId, Map<String, Object> variables) throws Exception {
        ActivityImpl currActivity = this.findActivitiImpl(taskId, null);
        List<PvmTransition> oriPvmTransitionList = this.clearTransition(currActivity);
        TransitionImpl newTransition = currActivity.createOutgoingTransition();
        ActivityImpl pointActivity = this.findActivitiImpl(taskId, activityId);
        newTransition.setDestination(pointActivity);
        this.taskService.complete(taskId, variables);
        pointActivity.getIncomingTransitions().remove(newTransition);
        this.restoreTransition(currActivity, oriPvmTransitionList);
    }

    public String getTaskIdByProins(String proInsId, String taskDefKey) {
        ActivitiDao activitiDao = (ActivitiDao)ApplicationContextUtil.getContext().getBean(ActivitiDao.class);
        return activitiDao.getTaskIdByProins(proInsId, taskDefKey, 1, 1);
    }

    public boolean checkUserTaskIsHuiQian(String taskId, String taskkey) {
        Task task = this.activitiService.getTask(taskId);
        String processkey = task.getProcessDefinitionId();
        ProcessDefinition pd = this.repositoryService.getProcessDefinition(processkey);
        InputStream resourceAsStream = this.repositoryService.getResourceAsStream(pd.getDeploymentId(), pd.getResourceName());
        String xmlString = StreamUtils.InputStreamTOString((InputStream)resourceAsStream);
        return XmlActivitiUtil.parseXml(xmlString, taskkey);
    }

    public void updateFormDataStatus(DelegateExecution execution) {
        Object bpm_form_key = execution.getVariable(WorkFlowGlobals.BPM_FORM_KEY);
        if (oConvertUtils.isNotEmpty((Object)bpm_form_key)) {
            Object id = execution.getVariable("id");
            this.activitiDao.updateFormDataStatus((String)id, (String)bpm_form_key);
        }
    }

    @Ehcache
    public String getUserRealName(String user_id) {
        if (oConvertUtils.isEmpty((Object)user_id)) {
            return "";
        }
        return this.activitiDao.getUserRealName(user_id.trim());
    }
}

