/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.workflow.service.impl;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.GroupQuery;
import org.activiti.engine.identity.User;
import org.activiti.engine.identity.UserQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.db.DbSqlSessionFactory;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.hibernate.Query;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeecgframework.core.util.ApplicationContextUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.MyClassLoader;
import org.jeecgframework.core.util.ReflectHelper;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.cgform.service.build.DataBaseService;
import org.jeecgframework.web.system.pojo.base.TSBaseUser;
import org.jeecgframework.web.system.pojo.base.TSRole;
import org.jeecgframework.web.system.pojo.base.TSRoleUser;
import org.jeecgframework.web.system.pojo.base.TSUser;
import org.jeecgframework.web.system.service.SystemService;
import org.jeecgframework.workflow.common.WorkFlowGlobals;
import org.jeecgframework.workflow.dao.ActivitiDao;
import org.jeecgframework.workflow.dao.IActivitiCommonDao;
import org.jeecgframework.workflow.model.activiti.ActivitiCom;
import org.jeecgframework.workflow.model.activiti.Process;
import org.jeecgframework.workflow.model.activiti.ProcessHandle;
import org.jeecgframework.workflow.model.activiti.WorkflowUtils;
import org.jeecgframework.workflow.pojo.activiti.ActHiProcinst;
import org.jeecgframework.workflow.pojo.base.TPForm;
import org.jeecgframework.workflow.pojo.base.TPProcess;
import org.jeecgframework.workflow.pojo.base.TPProcessnode;
import org.jeecgframework.workflow.pojo.base.TPProcessnodeFunction;
import org.jeecgframework.workflow.pojo.base.TPProcesspro;
import org.jeecgframework.workflow.pojo.base.TSBusConfig;
import org.jeecgframework.workflow.pojo.base.TSPrjstatus;
import org.jeecgframework.workflow.service.ActivitiService;
import org.jeecgframework.workflow.service.impl.TaskJeecgService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="activitiService")
@Transactional(rollbackFor={Exception.class})
public class ActivitiServiceImpl
extends CommonServiceImpl
implements ActivitiService {
    private static Logger logger = LoggerFactory.getLogger(ActivitiServiceImpl.class);
    private IdentityService identityService;
    private RuntimeService runtimeService;
    protected TaskService taskService;
    protected HistoryService historyService;
    protected RepositoryService repositoryService;
    protected String hql;
    @Autowired
    private TaskJeecgService taskJeecgService;
    private SystemService systemService;
    private IActivitiCommonDao activitiCommonDao;
    @Autowired
    private ActivitiDao activitiDao;
    @Autowired
    private DataBaseService dataBaseService;
    @Autowired
    private ProcessEngine processEngine;

    @Autowired
    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    @Autowired
    public void setRuntimeService(RuntimeService runtimeService) {
        this.runtimeService = runtimeService;
    }

    @Autowired
    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    @Autowired
    public void setHistoryService(HistoryService historyService) {
        this.historyService = historyService;
    }

    @Autowired
    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    @Resource
    public void setActivitiCommonDao(IActivitiCommonDao activitiCommonDao) {
        this.activitiCommonDao = activitiCommonDao;
    }

    public SystemService getSystemService() {
        return this.systemService;
    }

    @Autowired
    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    @Override
    public void save(TSUser user, String roleidstr, Short synToActiviti) {
        if (WorkFlowGlobals.Activiti_Deploy_YES.equals(synToActiviti)) {
            String userId = user.getUserName();
            UserQuery userQuery = this.identityService.createUserQuery();
            List activitiUsers = userQuery.userId(userId).list();
            if (activitiUsers.size() == 1) {
                this.updateActivitiData(user, roleidstr, (User)activitiUsers.get(0));
            } else {
                if (activitiUsers.size() > 1) {
                    String errorMsg = "\u53d1\u73b0\u91cd\u590d\u7528\u6237\uff1aid=" + userId;
                    logger.error(errorMsg);
                    throw new RuntimeException(errorMsg);
                }
                this.newActivitiUser(user, roleidstr);
            }
        }
    }

    private void newActivitiUser(TSUser user, String roleidstr) {
        String userId = user.getUserName();
        this.addActivitiGroup(roleidstr);
        this.saveActivitiUser(user);
        this.addMembershipToIdentify(roleidstr, userId);
    }

    private void addActivitiGroup(String roleidstr) {
        String[] roleIds;
        GroupQuery groupQuery = this.identityService.createGroupQuery();
        String[] stringArray = roleIds = roleidstr.split(",");
        int n = roleIds.length;
        int n2 = 0;
        while (n2 < n) {
            List activitiGroups;
            String string = stringArray[n2];
            TSRole role = (TSRole)this.commonDao.getEntity(TSRole.class, (Serializable)((Object)string));
            if (role != null && (activitiGroups = groupQuery.groupId(role.getRoleCode()).list()).size() <= 0) {
                this.saveActivitiGroup(role);
            }
            ++n2;
        }
    }

    private void saveActivitiGroup(TSRole role) {
        Group activitiGroup = this.identityService.newGroup(role.getRoleCode());
        activitiGroup.setId(role.getRoleCode());
        activitiGroup.setName(role.getRoleName());
        this.identityService.saveGroup(activitiGroup);
    }

    private void saveActivitiUser(TSUser user) {
        String userId = oConvertUtils.getString((String)user.getUserName());
        User activitiUser = this.identityService.newUser(userId);
        this.cloneAndSaveActivitiUser(user, activitiUser);
    }

    private void cloneAndSaveActivitiUser(TSUser user, User activitiUser) {
        activitiUser.setFirstName(user.getRealName());
        activitiUser.setLastName(user.getRealName());
        activitiUser.setPassword(user.getPassword());
        activitiUser.setEmail(user.getEmail());
        this.identityService.saveUser(activitiUser);
    }

    private void addMembershipToIdentify(String roleidstr, String userId) {
        String[] roleIds;
        String[] stringArray = roleIds = roleidstr.split(",");
        int n = roleIds.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            TSRole role = (TSRole)this.commonDao.getEntity(TSRole.class, (Serializable)((Object)string));
            logger.debug("add role to activit: {}", (Object)role);
            if (role != null) {
                this.identityService.createMembership(userId, role.getRoleCode());
            }
            ++n2;
        }
    }

    private void updateActivitiData(TSUser user, String roleidstr, User activitiUser) {
        String[] roleIds = roleidstr.split(",");
        String userId = user.getUserName();
        if (roleIds.length > 0) {
            this.addActivitiGroup(roleidstr);
        }
        this.cloneAndSaveActivitiUser(user, activitiUser);
        List activitiGroups = this.identityService.createGroupQuery().groupMember(userId).list();
        for (Group group : activitiGroups) {
            logger.debug("delete group from activit: {}", (Object)group);
            this.identityService.deleteMembership(userId, group.getId());
        }
        this.addMembershipToIdentify(roleidstr, userId);
    }

    @Override
    public void delete(TSUser user) {
        List roleUserList;
        if (user == null) {
            logger.debug("\u5220\u9664\u7528\u6237\u5f02\u5e38");
        }
        if ((roleUserList = this.findByProperty(TSRoleUser.class, "TSUser.id", user.getId())).size() >= 1) {
            for (TSRoleUser tRoleUser : roleUserList) {
                TSRole role = tRoleUser.getTSRole();
                if (role == null) continue;
                this.identityService.deleteMembership(user.getUserName(), role.getRoleCode());
            }
        }
        this.identityService.deleteUser(user.getUserName());
    }

    @Override
    public ProcessInstance startWorkflow(Object entity, String businessKey, Map<String, Object> variables, TSBusConfig tsBusbase) {
        ReflectHelper reflectHelper = new ReflectHelper(entity);
        TSUser tsUser = (TSUser)reflectHelper.getMethodValue("TSUser");
        this.identityService.setAuthenticatedUserId(tsUser.getUserName());
        variables.put(WorkFlowGlobals.BPM_DATA_ID, businessKey);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(tsBusbase.getTPProcess().getProcesskey(), businessKey, variables);
        return processInstance;
    }

    @Override
    public ProcessInstance startOnlineWorkflow(String create_by, String businessKey, Map<String, Object> variables, TSBusConfig tsBusbase) {
        this.identityService.setAuthenticatedUserId(create_by);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(tsBusbase.getTPProcess().getProcesskey(), businessKey, variables);
        return processInstance;
    }

    @Override
    public void startOnlineProcess(String create_by, String businessKey, Map<String, Object> dataForm, TSBusConfig tsBusbase) {
        String data_id = businessKey;
        this.startOnlineWorkflow(create_by, data_id, dataForm, tsBusbase);
        dataForm.put(WorkFlowGlobals.BPM_STATUS, WorkFlowGlobals.BPM_BUS_STATUS_2);
        String configId = dataForm.get(WorkFlowGlobals.BPM_FORM_KEY).toString();
        this.dataBaseService.updateTable(configId, (Object)data_id, dataForm);
        HashMap<String, Object> mp = new HashMap<String, Object>();
        mp.put("id", data_id);
        mp.put("userid", dataForm.get("create_by"));
        mp.put("prjstateid", 2);
        mp.put("busconfigid", tsBusbase.getId());
        this.activitiDao.insert(mp);
    }

    @Override
    public void startUserDefinedProcess(String create_by, String businessKey, Map<String, Object> dataForm, TSBusConfig tsBusbase) {
        String data_id = businessKey;
        this.startOnlineWorkflow(create_by, data_id, dataForm, tsBusbase);
        String tableName = dataForm.get(WorkFlowGlobals.BPM_FORM_KEY).toString();
        String update_status_sql = "update " + tableName + " set bpm_status = " + WorkFlowGlobals.BPM_BUS_STATUS_2 + " where id=" + "'" + data_id + "'";
        this.systemService.executeSql(update_status_sql, new Object[0]);
        HashMap<String, Object> mp = new HashMap<String, Object>();
        mp.put("id", data_id);
        mp.put("userid", dataForm.get("create_by"));
        mp.put("prjstateid", 2);
        mp.put("busconfigid", tsBusbase.getId());
        this.activitiDao.insert(mp);
    }

    @Override
    public List findTodoTasks(String userId, List<TSBusConfig> tsBusConfigs) {
        ArrayList<Object> results = new ArrayList<Object>();
        ArrayList tasks = new ArrayList();
        HashMap<String, String> classMap = new HashMap<String, String>();
        String busentity = "";
        if (tsBusConfigs.size() > 0) {
            for (TSBusConfig busConfig : tsBusConfigs) {
                try {
                    String processKey = busConfig.getTPProcess().getProcesskey();
                    busentity = busConfig.getTSTable().getEntityName();
                    List todoList = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey(processKey).taskAssignee(userId).orderByTaskPriority().desc()).orderByTaskCreateTime().desc()).list();
                    List unsignedTasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey(processKey).taskCandidateUser(userId).orderByTaskPriority().desc()).orderByTaskCreateTime().desc()).list();
                    ArrayList tempList = new ArrayList(0);
                    tempList.addAll(todoList);
                    tempList.addAll(unsignedTasks);
                    for (Task task : tempList) {
                        classMap.put(task.getId(), busentity);
                    }
                    tasks.addAll(tempList);
                }
                catch (Exception e) {
                    logger.info(e.getMessage());
                    e.printStackTrace();
                }
            }
            for (Task task : tasks) {
                String processInstanceId = task.getProcessInstanceId();
                ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
                String businessKey = this.getBusinessKeyByTask(task);
                Class entityClass = MyClassLoader.getClassByScn((String)((String)classMap.get(task.getId())));
                Object entityObj = this.getEntity(entityClass, (Serializable)((Object)businessKey));
                if (entityObj != null) {
                    ReflectHelper reflectHelper = new ReflectHelper(entityObj);
                    Process process = (Process)reflectHelper.getMethodValue("Process");
                    process.setTask(task);
                    process.setProcessInstance(processInstance);
                    process.setProcessDefinition(this.getProcessDefinition(processInstance.getProcessDefinitionId()));
                    results.add(entityObj);
                    continue;
                }
                return tasks;
            }
        }
        return results;
    }

    @Override
    public ProcessDefinition getProcessDefinition(String processDefinitionId) {
        return (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
    }

    @Override
    public List<Map<String, Object>> traceProcess(String processInstanceId) throws Exception {
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().executionId(processInstanceId).singleResult();
        Object property = PropertyUtils.getProperty((Object)execution, (String)"activityId");
        String activityId = "";
        if (property != null) {
            activityId = property.toString();
        }
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processInstance.getProcessDefinitionId());
        List activitiList = processDefinition.getActivities();
        ArrayList<Map<String, Object>> activityInfos = new ArrayList<Map<String, Object>>();
        for (ActivityImpl activity : activitiList) {
            boolean currentActiviti = false;
            String id = activity.getId();
            if (id.equals(activityId)) {
                currentActiviti = true;
            }
            Map<String, Object> activityImageInfo = this.packageSingleActivitiInfo(activity, processInstance, currentActiviti);
            activityInfos.add(activityImageInfo);
        }
        return activityInfos;
    }

    private Map<String, Object> packageSingleActivitiInfo(ActivityImpl activity, ProcessInstance processInstance, boolean currentActiviti) throws Exception {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        HashMap<String, Object> activityInfo = new HashMap<String, Object>();
        activityInfo.put("currentActiviti", currentActiviti);
        this.setPosition(activity, activityInfo);
        this.setWidthAndHeight(activity, activityInfo);
        Map properties = activity.getProperties();
        vars.put("\u4efb\u52a1\u7c7b\u578b", WorkflowUtils.parseToZhType(properties.get("type").toString()));
        ActivityBehavior activityBehavior = activity.getActivityBehavior();
        logger.debug("activityBehavior={}", (Object)activityBehavior);
        if (activityBehavior instanceof UserTaskActivityBehavior) {
            UserTaskActivityBehavior userTaskActivityBehavior;
            TaskDefinition taskDefinition;
            Set candidateGroupIdExpressions;
            Task currentTask = null;
            if (currentActiviti) {
                currentTask = this.getCurrentTaskInfo(processInstance);
            }
            if (!(candidateGroupIdExpressions = (taskDefinition = (userTaskActivityBehavior = (UserTaskActivityBehavior)activityBehavior).getTaskDefinition()).getCandidateGroupIdExpressions()).isEmpty()) {
                this.setTaskGroup(vars, candidateGroupIdExpressions);
                if (currentTask != null) {
                    this.setCurrentTaskAssignee(vars, currentTask);
                }
            }
        }
        vars.put("\u8282\u70b9\u8bf4\u660e", properties.get("documentation"));
        String description = activity.getProcessDefinition().getDescription();
        vars.put("\u63cf\u8ff0", description);
        logger.debug("trace variables: {}", vars);
        activityInfo.put("vars", vars);
        return activityInfo;
    }

    private void setTaskGroup(Map<String, Object> vars, Set<Expression> candidateGroupIdExpressions) {
        String roles = "";
        for (Expression expression : candidateGroupIdExpressions) {
            String expressionText = expression.getExpressionText();
            if (expressionText.startsWith("$")) {
                expressionText = expressionText.replace("${insuranceType}", "life");
            }
            String roleName = ((Group)this.identityService.createGroupQuery().groupId(expressionText).singleResult()).getName();
            roles = String.valueOf(roles) + roleName;
        }
        vars.put("\u4efb\u52a1\u6240\u5c5e\u89d2\u8272", roles);
    }

    private void setCurrentTaskAssignee(Map<String, Object> vars, Task currentTask) {
        String assignee = currentTask.getAssignee();
        if (assignee != null) {
            User assigneeUser = (User)this.identityService.createUserQuery().userId(assignee).singleResult();
            String userInfo = String.valueOf(assigneeUser.getFirstName()) + " " + assigneeUser.getLastName();
            vars.put("\u5f53\u524d\u5904\u7406\u4eba", userInfo);
        }
    }

    private Task getCurrentTaskInfo(ProcessInstance processInstance) {
        Task currentTask = null;
        try {
            String activitiId = (String)PropertyUtils.getProperty((Object)processInstance, (String)"activityId");
            logger.debug("current activity id: {}", (Object)activitiId);
            currentTask = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).taskDefinitionKey(activitiId).singleResult();
            logger.debug("current task for processInstance: {}", (Object)ToStringBuilder.reflectionToString((Object)currentTask));
        }
        catch (Exception e) {
            logger.error("can not get property activityId from processInstance: {}", (Object)processInstance);
        }
        return currentTask;
    }

    private void setWidthAndHeight(ActivityImpl activity, Map<String, Object> activityInfo) {
        activityInfo.put("width", activity.getWidth());
        activityInfo.put("height", activity.getHeight());
    }

    private void setPosition(ActivityImpl activity, Map<String, Object> activityInfo) {
        activityInfo.put("x", activity.getX());
        activityInfo.put("y", activity.getY());
    }

    @Override
    public ActivityImpl getProcessMap(String processInstanceId) {
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().executionId(processInstanceId).singleResult();
        if (execution == null) {
            return null;
        }
        Object property = null;
        try {
            property = PropertyUtils.getProperty((Object)execution, (String)"activityId");
        }
        catch (IllegalAccessException e) {
            logger.error("\u53cd\u5c04\u5f02\u5e38", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        String activityId = "";
        if (property != null) {
            activityId = property.toString();
        }
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        ProcessDefinitionImpl pdImpl = (ProcessDefinitionImpl)processDefinition;
        String processDefinitionId = pdImpl.getId();
        ProcessDefinitionEntity def = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processInstance.getProcessDefinitionId());
        ActivityImpl actImpl = null;
        List activitiIds = this.runtimeService.getActiveActivityIds(execution.getId());
        List<String> a = this.highLight(processInstanceId);
        List activitiList = def.getActivities();
        for (ActivityImpl activityImpl : activitiList) {
            String id = activityImpl.getId();
            if (!id.equals(activityId)) continue;
            actImpl = activityImpl;
            break;
        }
        return actImpl;
    }

    @Override
    public List<String> highLight(String processInstanceId) {
        ArrayList<String> highLihth = new ArrayList<String>();
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).list();
        for (Execution execution : executions) {
            ExecutionEntity entity = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(execution.getId()).singleResult();
            highLihth.add(entity.getActivityId());
        }
        return highLihth;
    }

    public String oldgetBusinessKeyByTask(Task task) {
        String businessKey = "";
        TaskEntity taskEntity = (TaskEntity)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        ExecutionEntity executionEntity = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(taskEntity.getExecutionId()).singleResult();
        if (executionEntity.getSuperExecutionId() == null) {
            businessKey = executionEntity.getBusinessKey();
        } else {
            ExecutionEntity executionEntity2 = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(executionEntity.getSuperExecutionId()).singleResult();
            ExecutionEntity executionEntity3 = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(executionEntity2.getParentId()).singleResult();
            businessKey = executionEntity3.getBusinessKey();
        }
        return businessKey;
    }

    @Override
    public String getBusinessKeyByTask(Task task) {
        String businessKey = "";
        TaskEntity taskEntity = (TaskEntity)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        HistoricProcessInstance hiproins = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(taskEntity.getProcessInstanceId()).singleResult();
        if (hiproins != null) {
            if (hiproins.getSuperProcessInstanceId() != null && hiproins.getBusinessKey() == null) {
                hiproins = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(hiproins.getSuperProcessInstanceId()).singleResult();
                businessKey = hiproins.getBusinessKey();
            } else {
                businessKey = hiproins.getBusinessKey();
            }
        }
        return businessKey;
    }

    @Override
    public HistoricProcessInstance getHiProcInstByBusKey(String businessKey) {
        HistoricProcessInstance hiproins = null;
        hiproins = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).singleResult();
        return hiproins;
    }

    public HistoricProcessInstance getHiProcInstByParprocInstId(String parprocInstId) {
        return (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId(parprocInstId).singleResult();
    }

    @Override
    public void updateHiProcInstBusKey(String parBusKey, String subBusKey) {
        HistoricProcessInstance parhiproins = this.getHiProcInstByBusKey(parBusKey);
        HistoricProcessInstance subhiproins = this.getHiProcInstByParprocInstId(parhiproins.getId());
        if (subhiproins != null) {
            HistoricProcessInstanceEntity historicProcessInstanceEntity = (HistoricProcessInstanceEntity)subhiproins;
            ActHiProcinst actHiProcinst = (ActHiProcinst)this.getEntity(ActHiProcinst.class, (Serializable)((Object)historicProcessInstanceEntity.getId()));
            actHiProcinst.setBusinessKey(subBusKey);
            this.updateEntitie(actHiProcinst);
        }
    }

    @Override
    public ActivitiCom complete(String taskId, Map<String, Object> map) {
        ActivitiCom activitiCom = new ActivitiCom();
        String msg = "";
        Boolean complete = false;
        try {
            String businessKey = this.getBusinessKeyByTask(taskId);
            try {
                String USER_SELECT_TASK_NODE = oConvertUtils.getString((Object)map.get(WorkFlowGlobals.USER_SELECT_TASK_NODE));
                this.taskJeecgService.goProcessTaskNode(taskId, USER_SELECT_TASK_NODE, map);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            List list = this.historyService.createHistoricProcessInstanceQuery().finished().processInstanceBusinessKey(businessKey).list();
            if (list != null && list.size() == 1) {
                this.commonDao.updateBySqlString("update t_s_basebus set prjstateid = '3' where id ='" + businessKey + "'");
            }
            complete = true;
            msg = "\u529e\u7406\u6210\u529f";
        }
        catch (ActivitiException e) {
            if (e.getMessage().indexOf("no processes deployed with key") != -1) {
                msg = "\u6ca1\u6709\u90e8\u7f72\u5b50\u6d41\u7a0b!,\u8bf7\u5728\u6d41\u7a0b\u914d\u7f6e\u4e2d\u90e8\u7f72\u6d41\u7a0b";
                complete = false;
                e.printStackTrace();
            } else {
                msg = "\u542f\u52a8\u6d41\u7a0b\u5931\u8d25!,\u5185\u90e8\u9519\u8bef";
                complete = false;
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            msg = "\u5185\u90e8\u9519\u8bef";
            complete = false;
            e.printStackTrace();
        }
        activitiCom.setComplete(complete);
        activitiCom.setMsg(msg);
        return activitiCom;
    }

    @Override
    public String getBusinessKeyByTask(String taskId) {
        Task task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        return this.getBusinessKeyByTask(task);
    }

    @Override
    public TPProcessnode getTPProcessnode(String taskDefinitionKey, String processkey) {
        TPProcessnode processnode = null;
        this.hql = "from TPProcessnode t where t.TPProcess.processkey='" + processkey + "' and t.processnodecode='" + taskDefinitionKey + "'";
        List processnodeList = this.commonDao.findByQueryString(this.hql);
        if (processnodeList.size() > 0) {
            processnode = (TPProcessnode)processnodeList.get(0);
        }
        return processnode;
    }

    @Override
    @Transactional(readOnly=true)
    public List processDefinitionList() {
        return this.repositoryService.createProcessDefinitionQuery().list();
    }

    @Override
    @Transactional(readOnly=true)
    public List processDefinitionListByProcesskey(String processkey) {
        return this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processkey).list();
    }

    @Override
    public Task getTask(String taskId) {
        return (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
    }

    @Override
    public ProcessHandle getProcessHandle(String taskId) {
        ProcessHandle processHandle = new ProcessHandle();
        Task task = this.getTask(taskId);
        String businessKey = this.getBusinessKeyByTask(taskId);
        String processDefinitionKey = this.getProcessDefinition(task.getProcessDefinitionId()).getKey();
        String taskDefinitionKey = task.getTaskDefinitionKey();
        TPProcess tpProcess = (TPProcess)this.findUniqueByProperty(TPProcess.class, "processkey", processDefinitionKey);
        TPProcessnode tpProcessnode = this.getTPProcessnode(taskDefinitionKey, processDefinitionKey);
        TPForm tpForm = tpProcessnode.getTPForm();
        List<TPProcesspro> tpProcesspros = tpProcessnode.getTPProcesspros();
        processHandle.setProcessDefinitionKey(processDefinitionKey);
        processHandle.setTaskDefinitionKey(taskDefinitionKey);
        processHandle.setBusinessKey(businessKey);
        processHandle.setTaskId(taskId);
        processHandle.setTpForm(tpForm);
        processHandle.setTpProcess(tpProcess);
        processHandle.setTpProcessnode(tpProcessnode);
        processHandle.setTpProcesspros(tpProcesspros);
        return processHandle;
    }

    @Override
    public TPProcessnode getProcessStartNode(String taskId) {
        Task task = this.getTask(taskId);
        String processDefinitionKey = this.getProcessDefinition(task.getProcessDefinitionId()).getKey();
        TPProcessnode tpProcessnode = this.getTPProcessnode("start", processDefinitionKey);
        return tpProcessnode;
    }

    private static SqlSession getSqlSession() {
        Object processEngine = null;
        DbSqlSessionFactory dbSqlSessionFactory = (DbSqlSessionFactory)processEngine.getProcessEngineConfiguration().getSessionFactories().get(DbSqlSession.class);
        SqlSessionFactory sqlSessionFactory = dbSqlSessionFactory.getSqlSessionFactory();
        return sqlSessionFactory.openSession();
    }

    @Override
    public TSPrjstatus getTBPrjstatusByCode(String prjstate, String rolecode) {
        List tbPrjstatuList;
        TSPrjstatus tsPrjstatus = null;
        String[] rolecodes = rolecode.split(",");
        String search = "";
        int i = 0;
        while (i < rolecodes.length) {
            search = String.valueOf(search) + "'" + rolecodes[i] + "'";
            if (i < rolecodes.length - 1) {
                search = String.valueOf(search) + ",";
            }
            ++i;
        }
        if (search != "" && (tbPrjstatuList = this.commonDao.findByQueryString("from TSPrjstatus p where p.code = '" + prjstate + "' and p.executerole in(" + search + ")")).size() > 0) {
            tsPrjstatus = (TSPrjstatus)tbPrjstatuList.get(0);
        }
        return tsPrjstatus;
    }

    @Override
    public TSBusConfig getTSBusConfig(Class classname, String processkey) {
        TSBusConfig tsBusConfig = null;
        String hql = "from TSBusConfig where TSTable.entityName='" + classname.getName() + "' and TPProcess.processkey='" + processkey + "'";
        List tsBusConfigList = this.commonDao.findByQueryString(hql);
        if (tsBusConfigList.size() > 0) {
            tsBusConfig = (TSBusConfig)tsBusConfigList.get(0);
        }
        return tsBusConfig;
    }

    @Override
    public <T> void batchDelete(Class<T> entityClass) {
        this.activitiCommonDao.batchDelete(entityClass);
    }

    private List findBaseTodoTasks(boolean isPri, String id, HttpServletRequest request) {
        ArrayList<Object> results = new ArrayList<Object>();
        ArrayList tasks = new ArrayList();
        Integer page = Integer.parseInt(request.getParameter("page"));
        Integer rows = Integer.parseInt(request.getParameter("rows"));
        Integer start = (page - 1) * rows;
        Integer end = page * rows - 1;
        try {
            ArrayList tempList = new ArrayList();
            if (isPri) {
                TaskService taskService = this.processEngine.getTaskService();
                List todoListtemp = ((TaskQuery)taskService.createTaskQuery().taskCandidateUser(id).orderByTaskCreateTime().desc()).active().list();
                tempList.addAll(todoListtemp);
                TaskQuery tq = (TaskQuery)((TaskQuery)taskService.createTaskQuery().taskAssignee(id).orderByTaskCreateTime().desc()).orderByTaskPriority().desc();
                tq = this.installQueryParam(tq, request);
                List todoList = tq.listPage(start.intValue(), end.intValue());
                tempList.addAll(todoList);
            } else {
                TaskQuery tq = (TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskCandidateGroupIn(Arrays.asList(id.split(","))).orderByTaskCreateTime().desc()).orderByTaskPriority().desc();
                tq = this.installQueryParam(tq, request);
                List unsignedTasks = tq.listPage(start.intValue(), end.intValue());
                tempList.addAll(unsignedTasks);
            }
            tasks.addAll(tempList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (Task task : tasks) {
            TSBaseUser baseUser;
            String assigneeUserId;
            TSBaseUser baseUser2;
            String processInstanceId = task.getProcessInstanceId();
            ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            String businessKey = this.getBusinessKeyByTask(task);
            Class entityClass = MyClassLoader.getClassByScn((String)"org.jeecgframework.workflow.pojo.base.TSBaseBusQuery");
            Object entityObj = this.getEntity(entityClass, (Serializable)((Object)businessKey));
            Object obj = null;
            try {
                obj = entityClass.newInstance();
                MyBeanUtils.copyBeanNotNull2Bean((Object)entityObj, obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (obj == null) continue;
            ReflectHelper reflectHelper = new ReflectHelper(obj);
            Process process = new Process();
            process.setTask(task);
            process.setProcessInstance(processInstance);
            process.setProcessDefinition(this.getProcessDefinition(processInstance.getProcessDefinitionId()));
            reflectHelper.setMethodValue("Process", (Object)process);
            String userid = (String)reflectHelper.getMethodValue("userid");
            if (userid != null && (baseUser2 = (TSBaseUser)this.activitiCommonDao.findUniqueByProperty(TSBaseUser.class, "userName", userid)) != null) {
                reflectHelper.setMethodValue("userRealName", (Object)baseUser2.getRealName());
            }
            if ((assigneeUserId = task.getAssignee()) != null && (baseUser = (TSBaseUser)this.activitiCommonDao.findUniqueByProperty(TSBaseUser.class, "userName", assigneeUserId)) != null) {
                reflectHelper.setMethodValue("assigneeName", (Object)baseUser.getRealName());
            }
            results.add(obj);
        }
        return results;
    }

    @Override
    public List findPriTodoTasks(String userId, HttpServletRequest request) {
        return this.findBaseTodoTasks(true, userId, request);
    }

    @Override
    public List findGroupTodoTasks(List<TSRoleUser> roles, HttpServletRequest request) {
        StringBuilder roleIds = new StringBuilder();
        for (TSRoleUser role : roles) {
            roleIds.append(role.getTSRole().getRoleCode()).append(",");
        }
        roleIds.deleteCharAt(roleIds.length() - 1);
        List resulttemp = this.findBaseTodoTasks(false, roleIds.toString(), request);
        return resulttemp;
    }

    @Override
    public List findHistoryTasks(String userName, HttpServletRequest request) {
        Integer page = Integer.parseInt(request.getParameter("page"));
        Integer rows = Integer.parseInt(request.getParameter("rows"));
        Integer start = (page - 1) * rows;
        Query query = this.getSession().createQuery(this.installQueryParamH("from ActHiTaskinst o where o.duration>0 and o.assignee = ? order by startTime desc", request));
        query.setFirstResult(start.intValue());
        query.setMaxResults(rows.intValue());
        query.setString(0, userName);
        this.installQueryParamHV(query, request);
        List result = query.list();
        return result;
    }

    @Override
    public Long countPriTodaoTask(String userName, HttpServletRequest request) {
        String procDefId = request.getParameter("Process.processDefinition.id");
        String procName = request.getParameter("Process.processDefinition.name");
        Long size = 0L;
        TaskQuery tq = (TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskAssignee(userName).orderByTaskPriority().desc()).orderByTaskCreateTime().desc();
        this.installQueryParam(tq, request);
        size = tq.count();
        return size;
    }

    @Override
    public Long countGroupTodoTasks(List<TSRoleUser> roles, HttpServletRequest request) {
        String procDefId = request.getParameter("Process.processDefinition.id");
        String procName = request.getParameter("Process.processDefinition.name");
        Long size = 0L;
        StringBuilder roleIds = new StringBuilder();
        for (TSRoleUser role : roles) {
            roleIds.append(role.getTSRole().getRoleCode()).append(",");
        }
        roleIds.deleteCharAt(roleIds.length() - 1);
        TaskQuery tq = (TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskCandidateGroupIn(Arrays.asList(roleIds.toString().split(","))).orderByTaskPriority().desc()).orderByTaskCreateTime().desc();
        this.installQueryParam(tq, request);
        size = tq.count();
        return size;
    }

    @Override
    public Long countHistoryTasks(String userName, HttpServletRequest request) {
        Map r = this.systemService.findOneForJdbc(this.installCountH("select count(1) as hsize  from act_hi_taskinst o inner join act_re_procdef ap on ap.id_ = o.proc_def_id_ and o.duration_>0 and  o.assignee_ = ?", request), this.installCountHv(userName, request));
        Long size = Long.parseLong(r.get("hsize").toString());
        return size;
    }

    private TaskQuery installQueryParam(TaskQuery tq, HttpServletRequest request) {
        String procDefId = request.getParameter("Process.processDefinition.id");
        String procName = request.getParameter("Process.processDefinition.name");
        if (StringUtil.isNotEmpty((Object)procDefId)) {
            tq = tq.processDefinitionId(procDefId);
        }
        if (StringUtil.isNotEmpty((Object)procName)) {
            tq = tq.processDefinitionName(procName);
        }
        return tq;
    }

    private String installQueryParamH(String sql, HttpServletRequest request) {
        String procDefId = request.getParameter("procDefId");
        String procName = request.getParameter("prodef.name");
        StringBuilder s = new StringBuilder(sql);
        if (StringUtil.isNotEmpty((Object)procDefId)) {
            s.append(" and o.procDefId = ? ");
        }
        if (StringUtil.isNotEmpty((Object)procName)) {
            s.append(" and o.prodef.name = ? ");
        }
        return s.toString();
    }

    private void installQueryParamHV(Query query, HttpServletRequest request) {
        String procDefId = request.getParameter("procDefId");
        String procName = request.getParameter("prodef.name");
        if (StringUtil.isNotEmpty((Object)procDefId)) {
            query.setParameter(1, (Object)procDefId);
        }
        if (StringUtil.isNotEmpty((Object)procName)) {
            query.setParameter(2, (Object)procName);
        }
    }

    private String installCountH(String sql, HttpServletRequest request) {
        String procDefId = request.getParameter("procDefId");
        String procName = request.getParameter("prodef.name");
        StringBuilder s = new StringBuilder(sql);
        if (StringUtil.isNotEmpty((Object)procDefId)) {
            s.append(" and o.proc_def_id_ = ? ");
        }
        if (StringUtil.isNotEmpty((Object)procName)) {
            s.append(" and ap.name_ = ? ");
        }
        return s.toString();
    }

    private Object[] installCountHv(String userName, HttpServletRequest request) {
        ArrayList<String> reList = new ArrayList<String>(0);
        reList.add(userName);
        String procDefId = request.getParameter("procDefId");
        String procName = request.getParameter("prodef.name");
        if (StringUtil.isNotEmpty((Object)procDefId)) {
            reList.add(procDefId);
        }
        if (StringUtil.isNotEmpty((Object)procName)) {
            reList.add(procName);
        }
        return reList.toArray();
    }

    @Override
    public List<PvmTransition> getOutgoingTransitions(String taskId) {
        List outTransitions = null;
        Task task = this.getTask(taskId);
        ProcessDefinitionEntity def = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
        List activitiList = def.getActivities();
        String excId = task.getExecutionId();
        ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(excId).singleResult();
        String activitiId = execution.getActivityId();
        for (ActivityImpl activityImpl : activitiList) {
            String id = activityImpl.getId();
            if (!activitiId.equals(id)) continue;
            System.out.println("\u5f53\u524d\u4efb\u52a1\uff1a" + activityImpl.getProperty("name"));
            outTransitions = activityImpl.getOutgoingTransitions();
            for (PvmTransition tr : outTransitions) {
                System.out.println("\u7ebf\u8def\u540d\uff1a" + tr.getProperty("name"));
                PvmActivity ac = tr.getDestination();
                System.out.println("\u4e0b\u4e00\u6b65\u4efb\u52a1\u4efb\u52a1\uff1a" + ac.getProperty("name"));
            }
        }
        return outTransitions;
    }

    @Override
    public List findBpmLogsByBpmID(String bpm_id) {
        this.hql = "from TPBpmLog t where t.bpm_id='" + bpm_id + "' order by op_time";
        List logList = this.commonDao.findByQueryString(this.hql);
        return logList;
    }

    @Override
    public List getOutTransitions(String taskId) {
        List outTransitions = null;
        ArrayList trans = new ArrayList();
        Task task = this.getTask(taskId);
        ProcessDefinitionEntity def = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
        List activitiList = def.getActivities();
        String excId = task.getExecutionId();
        ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(excId).singleResult();
        String activitiId = execution.getActivityId();
        for (ActivityImpl activityImpl : activitiList) {
            String id = activityImpl.getId();
            if (!activitiId.equals(id)) continue;
            outTransitions = activityImpl.getOutgoingTransitions();
            for (PvmTransition tr : outTransitions) {
                HashMap<String, String> m = new HashMap<String, String>();
                String name = (String)(oConvertUtils.isNotEmpty((Object)tr.getProperty("name")) ? tr.getProperty("name") : tr.getId());
                m.put("Transition", name);
                PvmActivity ac = tr.getDestination();
                m.put("nextnode", ac.getId());
                trans.add(m);
            }
        }
        return trans;
    }

    @Override
    public List<Map<String, Object>> getHistTaskNodeList(String proceInsId) {
        ActivitiDao activitiDao = (ActivitiDao)ApplicationContextUtil.getContext().getBean(ActivitiDao.class);
        List<Map<String, Object>> list = activitiDao.getHistTaskNodeList(proceInsId);
        return list;
    }

    @Override
    public List getAllTaskNode(String taskId) {
        ArrayList list = new ArrayList();
        Task task = this.getTask(taskId);
        ProcessDefinitionEntity def = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
        List activitiList = def.getActivities();
        for (ActivityImpl activityImpl : activitiList) {
            HashMap<String, String> m = new HashMap<String, String>();
            String id = activityImpl.getId();
            m.put("taskKey", id);
            String name = (String)activityImpl.getProperty("name");
            m.put("name", name);
            list.add(m);
        }
        return list;
    }

    @Override
    public Set<String> getNodeOperaCodesByNodeIdAndFunctionId(String nodeId, String functionId) {
        TPProcessnodeFunction tsNodeFunction;
        HashSet<String> operationCodes = new HashSet<String>();
        TPProcessnode proNode = (TPProcessnode)this.commonDao.get(TPProcessnode.class, (Serializable)((Object)nodeId));
        CriteriaQuery cq1 = new CriteriaQuery(TPProcessnodeFunction.class);
        cq1.eq("TPProcessnode.id", (Object)proNode.getId());
        cq1.eq("TSFunction.id", (Object)functionId);
        cq1.add();
        List rFunctions = this.getListByCriteriaQuery(cq1, false);
        if (rFunctions != null && rFunctions.size() > 0 && (tsNodeFunction = (TPProcessnodeFunction)rFunctions.get(0)).getOperation() != null) {
            String[] operationArry = tsNodeFunction.getOperation().split(",");
            int i = 0;
            while (i < operationArry.length) {
                operationCodes.add(operationArry[i]);
                ++i;
            }
        }
        return operationCodes;
    }

    @Override
    public Set<String> getOperationCodesByNodeIdAndruleDataId(String nodeId, String functionId) {
        TPProcessnodeFunction tsNodeFunction;
        HashSet<String> operationCodes = new HashSet<String>();
        TPProcessnode proNode = (TPProcessnode)this.commonDao.get(TPProcessnode.class, (Serializable)((Object)nodeId));
        CriteriaQuery cq1 = new CriteriaQuery(TPProcessnodeFunction.class);
        cq1.eq("TPProcessnode.id", (Object)proNode.getId());
        cq1.eq("TSFunction.id", (Object)functionId);
        cq1.add();
        List rFunctions = this.getListByCriteriaQuery(cq1, false);
        if (rFunctions != null && rFunctions.size() > 0 && (tsNodeFunction = (TPProcessnodeFunction)rFunctions.get(0)).getDataRule() != null) {
            String[] operationArry = tsNodeFunction.getDataRule().split(",");
            int i = 0;
            while (i < operationArry.length) {
                operationCodes.add(operationArry[i]);
                ++i;
            }
        }
        return operationCodes;
    }
}

