/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.workflow.model.diagram;

import java.util.ArrayList;
import java.util.List;
import org.jeecgframework.workflow.model.diagram.Edge;
import org.jeecgframework.workflow.model.diagram.Node;

public class Graph {
    private Node initial;

    public Node getInitial() {
        return this.initial;
    }

    public void setInitial(Node initial) {
        this.initial = initial;
    }

    public List<Node> getNodes() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        this.visitNode(this.initial, nodes);
        return nodes;
    }

    public void visitNode(Node node, List<Node> nodes) {
        nodes.add(node);
        for (Edge edge : node.getEdges()) {
            Node nextNode = edge.getDest();
            this.visitNode(nextNode, nodes);
        }
    }

    public List<Edge> getEdges() {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        this.visitEdge(this.initial, edges);
        return edges;
    }

    public void visitEdge(Node node, List<Edge> edges) {
        for (Edge edge : node.getEdges()) {
            edges.add(edge);
            Node nextNode = edge.getDest();
            this.visitEdge(nextNode, edges);
        }
    }

    public Node findById(String id) {
        for (Node node : this.getNodes()) {
            if (!id.equals(node.getId())) continue;
            return node;
        }
        return null;
    }
}

