/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.workflow.controller.process;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.pojo.base.TSRoleUser;
import org.jeecgframework.web.system.pojo.base.TSUser;
import org.jeecgframework.web.system.service.SystemService;
import org.jeecgframework.workflow.common.WorkFlowGlobals;
import org.jeecgframework.workflow.dao.ActivitiDao;
import org.jeecgframework.workflow.model.activiti.ProcessHandle;
import org.jeecgframework.workflow.pojo.base.TPProcessnode;
import org.jeecgframework.workflow.service.ActivitiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/taskController"})
public class TaskController {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected RuntimeService runtimeService;
    @Autowired
    private ActivitiService activitiService;
    @Autowired
    protected TaskService taskService;
    @Autowired
    protected IdentityService identityService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private ActivitiDao activitiDao;

    @RequestMapping(params={"goTaskListTab"})
    public ModelAndView goTaskListTab(HttpServletRequest request) {
        return new ModelAndView("workflow/task/taskList-tab");
    }

    @RequestMapping(params={"goMyTaskList"})
    public ModelAndView goMyTaskList(HttpServletRequest request) {
        return new ModelAndView("workflow/task/taskList-person");
    }

    @RequestMapping(params={"goGroupTaskList"})
    public ModelAndView goGroupTaskList(HttpServletRequest request) {
        return new ModelAndView("workflow/task/taskList-group");
    }

    @RequestMapping(params={"goHistoryTaskList"})
    public ModelAndView goHistoryTaskList(HttpServletRequest request) {
        return new ModelAndView("workflow/task/taskList-history");
    }

    @RequestMapping(params={"goTaskTab"})
    public ModelAndView goTaskTab(HttpServletRequest request) {
        String taskId = request.getParameter("taskId");
        request.setAttribute("taskId", (Object)taskId);
        String processInstanceId = this.activitiService.getTask(taskId).getProcessInstanceId();
        request.setAttribute("processInstanceId", (Object)processInstanceId);
        return new ModelAndView("workflow/task/task-tab");
    }

    @RequestMapping(params={"goProcessHisTab"})
    public ModelAndView goProcessHisTab(HttpServletRequest request) {
        String processInstanceId = request.getParameter("processInstanceId");
        request.setAttribute("processInstanceId", (Object)processInstanceId);
        return new ModelAndView("workflow/task/process-his-tab");
    }

    @RequestMapping(params={"goTaskForm"})
    public ModelAndView goTaskForm(HttpServletRequest request) {
        String taskId = request.getParameter("taskId");
        Task task = this.activitiService.getTask(taskId);
        String CONTENT_URL = null;
        String insId = task.getProcessInstanceId();
        ProcessHandle processHandle = this.activitiService.getProcessHandle(taskId);
        CONTENT_URL = oConvertUtils.getString((String)processHandle.getTpProcessnode().getModelandview());
        if (oConvertUtils.isNotEmpty((Object)CONTENT_URL)) {
            CONTENT_URL = String.valueOf(CONTENT_URL) + "&id=" + this.runtimeService.getVariable(insId, "id");
        } else {
            TPProcessnode startNode;
            CONTENT_URL = oConvertUtils.getString((Object)this.runtimeService.getVariable(insId, WorkFlowGlobals.BPM_FORM_CONTENT_URL));
            if (oConvertUtils.isEmpty((Object)CONTENT_URL) && (startNode = this.activitiService.getProcessStartNode(taskId)) != null) {
                CONTENT_URL = startNode.getModelandview();
                CONTENT_URL = String.valueOf(CONTENT_URL) + "&id=" + this.runtimeService.getVariable(insId, WorkFlowGlobals.BPM_DATA_ID);
                this.runtimeService.setVariable(insId, WorkFlowGlobals.BPM_FORM_CONTENT_URL, (Object)CONTENT_URL);
            }
        }
        String processnodeId = "";
        if (processHandle.getTpProcessnode() != null) {
            processnodeId = processHandle.getTpProcessnode().getId();
        }
        CONTENT_URL = String.valueOf(CONTENT_URL) + "&processnodeId=" + processnodeId;
        request.setAttribute(WorkFlowGlobals.ProcNode_Start, (Object)CONTENT_URL);
        return new ModelAndView("workflow/task/task-form");
    }

    @RequestMapping(params={"goProcessHisForm"})
    public ModelAndView goProcessHisForm(HttpServletRequest request) {
        String insId = request.getParameter("processInstanceId");
        String CONTENT_URL = this.activitiDao.getHisVarinst(WorkFlowGlobals.BPM_FORM_CONTENT_URL, insId);
        request.setAttribute(WorkFlowGlobals.ProcNode_Start, (Object)CONTENT_URL);
        return new ModelAndView("workflow/task/task-form");
    }

    @RequestMapping(params={"goTaskOperate"})
    public ModelAndView goTaskOperate(HttpServletRequest request) {
        List bpmLogList;
        String taskId = request.getParameter("taskId");
        Task task = this.activitiService.getTask(taskId);
        int fromIndex = 0;
        int toIndex = 0;
        List transList = this.activitiService.getOutTransitions(taskId);
        if (transList.size() == 1) {
            for (Map t : transList) {
                t.put("Transition", "\u786e\u8ba4\u63d0\u4ea4");
            }
        }
        if ((bpmLogList = this.activitiService.findBpmLogsByBpmID(task.getProcessInstanceId())).size() - 3 > 0) {
            fromIndex = bpmLogList.size() - 3;
            toIndex = bpmLogList.size();
        } else {
            fromIndex = 0;
            toIndex = bpmLogList.size();
        }
        List bpmLogNewList = bpmLogList.subList(fromIndex, toIndex);
        request.setAttribute("bpmLogList", (Object)bpmLogList);
        request.setAttribute("taskId", (Object)taskId);
        request.setAttribute("taskName", (Object)task.getName());
        request.setAttribute("task", (Object)task);
        request.setAttribute("transitionList", (Object)transList);
        request.setAttribute("nextCodeCount", (Object)(transList == null ? 0 : transList.size()));
        request.setAttribute("bpmLogListCount", (Object)bpmLogList.size());
        request.setAttribute("bpmLogNewList", bpmLogNewList);
        request.setAttribute("bpmLogNewListCount", (Object)bpmLogNewList.size());
        List<Map<String, Object>> histListNode = this.activitiService.getHistTaskNodeList(task.getProcessInstanceId());
        request.setAttribute("histListNode", histListNode);
        request.setAttribute("histListSize", (Object)histListNode.size());
        return new ModelAndView("workflow/task/task-operate");
    }

    @RequestMapping(params={"goProcessHisOperate"})
    public ModelAndView goProcessHisOperate(HttpServletRequest request) {
        String insId = request.getParameter("processInstanceId");
        int fromIndex = 0;
        int toIndex = 0;
        List bpmLogList = this.activitiService.findBpmLogsByBpmID(insId);
        if (bpmLogList.size() - 3 > 0) {
            fromIndex = bpmLogList.size() - 3;
            toIndex = bpmLogList.size();
        } else {
            fromIndex = 0;
            toIndex = bpmLogList.size();
        }
        List bpmLogNewList = bpmLogList.subList(fromIndex, toIndex);
        request.setAttribute("bpmLogList", (Object)bpmLogList);
        request.setAttribute("bpmLogListCount", (Object)bpmLogList.size());
        request.setAttribute("bpmLogNewList", bpmLogNewList);
        request.setAttribute("bpmLogNewListCount", (Object)bpmLogNewList.size());
        return new ModelAndView("workflow/task/task-operate");
    }

    @RequestMapping(params={"goTaskMap"})
    public ModelAndView goTaskMap(HttpServletRequest request) {
        String taskId = request.getParameter("taskId");
        String mapUrl = "activitiController.do?openProcessPic&tag=task&taskId=" + taskId;
        request.setAttribute("mapUrl", (Object)mapUrl);
        return new ModelAndView("workflow/task/task-map");
    }

    @RequestMapping(params={"taskAllList"})
    public void taskAllList(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        TSUser user = ResourceUtil.getSessionUserName();
        List taskList = this.activitiService.findPriTodoTasks(user.getUserName(), request);
        Long taskSize = this.activitiService.countPriTodaoTask(user.getUserName(), request);
        dataGrid.setTotal(taskSize.intValue());
        dataGrid.setResults(taskList);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"taskGroupList"})
    public void taskGroupList(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        TSUser user = ResourceUtil.getSessionUserName();
        List roles = this.systemService.findByProperty(TSRoleUser.class, "TSUser", (Object)user);
        List taskList = this.activitiService.findGroupTodoTasks(roles, request);
        Long taskSize = this.activitiService.countGroupTodoTasks(roles, request);
        dataGrid.setTotal(taskSize.intValue());
        dataGrid.setResults(taskList);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"taskHistoryList"})
    public void taskHistoryList(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        TSUser user = ResourceUtil.getSessionUserName();
        List taskList = this.activitiService.findHistoryTasks(user.getUserName(), request);
        Long taskSize = this.activitiService.countHistoryTasks(user.getUserName(), request);
        dataGrid.setTotal(taskSize.intValue());
        dataGrid.setResults(taskList);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }
}

