/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.workflow.controller.process;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricProcessInstanceQuery;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.pojo.base.TSUser;
import org.jeecgframework.web.system.service.UserService;
import org.jeecgframework.workflow.model.activiti.ProcessHandle;
import org.jeecgframework.workflow.model.activiti.Variable;
import org.jeecgframework.workflow.service.ActivitiService;
import org.jeecgframework.workflow.service.impl.TaskJeecgService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/processInstanceController"})
public class ProcessInstanceController {
    @Autowired
    private ActivitiService activitiService;
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private UserService userService;
    @Autowired
    private TaskJeecgService taskJeecgService;

    @RequestMapping(params={"runningProcessList"})
    public ModelAndView runningProcessList(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        return new ModelAndView("workflow/activiti/runninglist");
    }

    @RequestMapping(params={"myRunningProcessListDataGrid"})
    public void myRunningProcessListDataGrid(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        String currentUserName = ResourceUtil.getSessionUserName().getUserName();
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery().startedBy(currentUserName);
        List list = ((HistoricProcessInstanceQuery)historicProcessInstanceQuery.orderByProcessInstanceEndTime().desc()).listPage((dataGrid.getPage() - 1) * dataGrid.getRows(), dataGrid.getRows());
        StringBuffer rows = new StringBuffer();
        for (HistoricProcessInstance hi : list) {
            String starttime = DateFormatUtils.format((Date)hi.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            String endtime = hi.getEndTime() == null ? "" : DateFormatUtils.format((Date)hi.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss");
            long totalTimes = hi.getEndTime() == null ? Calendar.getInstance().getTimeInMillis() - hi.getStartTime().getTime() : hi.getEndTime().getTime() - hi.getStartTime().getTime();
            long dayCount = totalTimes / 86400000L;
            long restTimes = totalTimes % 86400000L;
            long hourCount = restTimes / 3600000L;
            long minuteCount = (restTimes %= 3600000L) / 60000L;
            String spendTimes = String.valueOf(dayCount) + "\u5929" + hourCount + "\u5c0f\u65f6" + minuteCount + "\u5206";
            ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(hi.getProcessDefinitionId()).singleResult();
            rows.append("{'id':" + hi.getId() + ",'prcocessDefinitionName':'" + StringUtils.trimToEmpty((String)processDefinition.getName()) + "','startUserId':'" + hi.getStartUserId() + "','starttime':'" + starttime + "','endtime':'" + endtime + "','spendTimes':'" + spendTimes + "','processDefinitionId':'" + hi.getProcessDefinitionId() + "','processInstanceId':'" + hi.getId() + "'},");
        }
        String rowStr = StringUtils.substringBeforeLast((String)rows.toString(), (String)",");
        JSONObject jObject = JSONObject.fromObject((Object)("{'total':" + historicProcessInstanceQuery.count() + ",'rows':[" + rowStr + "]}"));
        this.responseDatagrid(response, jObject);
    }

    @RequestMapping(params={"invalidProcess"})
    @ResponseBody
    public AjaxJson invalidProcess(@RequestParam(value="processInstanceId") String processInstanceId, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        this.runtimeService.deleteProcessInstance(processInstanceId, "\u53d1\u8d77\u4eba\u6d41\u7a0b\u4f5c\u5e9f");
        String message = "\u4f5c\u5e9f\u6d41\u7a0b\u6210\u529f";
        j.setMsg(message);
        return j;
    }

    @RequestMapping(params={"callBackProcess"})
    @ResponseBody
    public AjaxJson callBackProcess(@RequestParam(value="processInstanceId") String processInstanceId, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        this.runtimeService.deleteProcessInstance(processInstanceId, "\u53d1\u8d77\u4eba\u6d41\u7a0b\u8ffd\u56de");
        String message = "\u6d41\u7a0b\u8ffd\u56de\u6210\u529f";
        j.setMsg(message);
        return j;
    }

    @RequestMapping(params={"reassignInit"})
    public ModelAndView reassignInit(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        String taskId = request.getParameter("taskId");
        request.setAttribute("taskId", (Object)taskId);
        return new ModelAndView("workflow/activiti/reassignInit");
    }

    @RequestMapping(params={"reassign"})
    @ResponseBody
    public AjaxJson reassign(@RequestParam(value="taskId") String taskId, @RequestParam(value="userName") String assignUserId, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        Task task = this.activitiService.getTask(taskId);
        String currentUserName = ResourceUtil.getSessionUserName().getUserName();
        this.taskService.setOwner(task.getId(), currentUserName);
        this.taskService.setAssignee(task.getId(), assignUserId);
        String message = "\u59d4\u6d3e\u6210\u529f";
        j.setMsg(message);
        return j;
    }

    @RequestMapping(params={"reassignUsers"})
    public String reassignUsers() {
        return "workflow/activiti/reassignUsers";
    }

    @RequestMapping(params={"datagridUsers"})
    public void datagridUsers(TSUser tsuser, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(TSUser.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)tsuser, (Map)request.getParameterMap());
        this.userService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"runningProcessDataGrid"})
    public void runningProcessDataGrid(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        if (StringUtils.isNotEmpty((CharSequence)request.getParameter("startUserId"))) {
            historicProcessInstanceQuery = historicProcessInstanceQuery.startedBy(request.getParameter("startUserId"));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getParameter("processInstanceId"))) {
            historicProcessInstanceQuery = historicProcessInstanceQuery.processInstanceId(request.getParameter("processInstanceId"));
        }
        String starttime_begin = request.getParameter("starttime_begin");
        String starttime_end = request.getParameter("starttime_end");
        if (StringUtils.isNotEmpty((CharSequence)starttime_begin)) {
            try {
                historicProcessInstanceQuery.startedAfter(DateUtils.parseDate((String)starttime_begin, (String[])new String[]{"yyyy-MM-dd"}));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)starttime_end)) {
            try {
                historicProcessInstanceQuery.startedBefore(DateUtils.parseDate((String)starttime_end, (String[])new String[]{"yyyy-MM-dd"}));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        String endtime_begin = request.getParameter("endtime_begin");
        String endtime_end = request.getParameter("endtime_end");
        if (StringUtils.isNotEmpty((CharSequence)endtime_begin)) {
            try {
                historicProcessInstanceQuery.finishedAfter(DateUtils.parseDate((String)endtime_begin, (String[])new String[]{"yyyy-MM-dd"}));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)endtime_end)) {
            try {
                historicProcessInstanceQuery.finishedBefore(DateUtils.parseDate((String)endtime_end, (String[])new String[]{"yyyy-MM-dd"}));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        List list = ((HistoricProcessInstanceQuery)historicProcessInstanceQuery.unfinished().orderByProcessInstanceStartTime().desc()).listPage((dataGrid.getPage() - 1) * dataGrid.getRows(), dataGrid.getRows());
        long count = historicProcessInstanceQuery.unfinished().count();
        StringBuffer rows = new StringBuffer();
        for (HistoricProcessInstance hi : list) {
            String starttime = DateFormatUtils.format((Date)hi.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            String endtime = hi.getEndTime() == null ? "" : DateFormatUtils.format((Date)hi.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss");
            long totalTimes = hi.getEndTime() == null ? Calendar.getInstance().getTimeInMillis() - hi.getStartTime().getTime() : hi.getEndTime().getTime() - hi.getStartTime().getTime();
            long dayCount = totalTimes / 86400000L;
            long restTimes = totalTimes % 86400000L;
            long hourCount = restTimes / 3600000L;
            long minuteCount = (restTimes %= 3600000L) / 60000L;
            String spendTimes = String.valueOf(dayCount) + "\u5929" + hourCount + "\u5c0f\u65f6" + minuteCount + "\u5206";
            ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(hi.getProcessDefinitionId()).singleResult();
            String isSuspended = "finished";
            String activityName = "";
            String activityUser = "";
            String taskId = "";
            if (hi.getEndTime() != null) continue;
            ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(hi.getId()).singleResult();
            List tasks = this.taskService.createTaskQuery().processInstanceId(hi.getId()).list();
            if (tasks.size() > 1) {
                isSuspended = "" + pi.isSuspended();
                activityName = StringUtils.trimToEmpty((String)((Task)tasks.get(0)).getName());
                activityUser = StringUtils.trimToEmpty((String)((Task)tasks.get(0)).getAssignee());
                taskId = oConvertUtils.getString((String)((Task)tasks.get(0)).getId());
                rows.append("{'id':'" + hi.getId() + "','iconCls':'icon-comturn','state':'closed','text':'" + processDefinition.getName() + "','_parentId':'','taskId':'" + taskId + "','activityName':'" + activityName + "','activityUser':'','prcocessDefinitionName':'" + processDefinition.getName() + "','startUserId':'" + hi.getStartUserId() + "','starttime':'" + starttime + "','endtime':'" + endtime + "','spendTimes':'" + spendTimes + "','isSuspended':'','processDefinitionId':'" + hi.getProcessDefinitionId() + "','processInstanceId':'" + hi.getId() + "'},");
                int i = 1;
                for (Task task : tasks) {
                    isSuspended = "" + pi.isSuspended();
                    activityName = StringUtils.trimToEmpty((String)task.getName());
                    activityUser = StringUtils.trimToEmpty((String)task.getAssignee());
                    taskId = oConvertUtils.getString((String)task.getId());
                    rows.append("{'id':'taskid:" + hi.getId() + ":" + i++ + "','iconCls':'icon-comturn','text':'" + processDefinition.getName() + "','_parentId':'" + hi.getId() + "','taskId':'" + taskId + "','activityName':'" + activityName + "','activityUser':'" + activityUser + "','prcocessDefinitionName':'" + processDefinition.getName() + "','startUserId':'" + hi.getStartUserId() + "','starttime':'" + starttime + "','endtime':'" + endtime + "','spendTimes':'" + spendTimes + "','isSuspended':'" + isSuspended + "','processDefinitionId':'" + hi.getProcessDefinitionId() + "','processInstanceId':'" + hi.getId() + "'},");
                }
                continue;
            }
            for (Task task : tasks) {
                isSuspended = "" + pi.isSuspended();
                activityName = StringUtils.trimToEmpty((String)task.getName());
                activityUser = StringUtils.trimToEmpty((String)task.getAssignee());
                taskId = oConvertUtils.getString((String)task.getId());
                rows.append("{'id':'" + hi.getId() + "','text':'" + processDefinition.getName() + "','iconCls':'icon-comturn','_parentId':'','taskId':'" + taskId + "','activityName':'" + activityName + "','activityUser':'" + activityUser + "','prcocessDefinitionName':'" + processDefinition.getName() + "','startUserId':'" + hi.getStartUserId() + "','starttime':'" + starttime + "','endtime':'" + endtime + "','spendTimes':'" + spendTimes + "','isSuspended':'" + isSuspended + "','processDefinitionId':'" + hi.getProcessDefinitionId() + "','processInstanceId':'" + hi.getId() + "'},");
            }
        }
        String rowStr = StringUtils.substringBeforeLast((String)rows.toString(), (String)",");
        JSONObject jObject = JSONObject.fromObject((Object)("{'total':" + count + ",'rows':[" + rowStr + "]}"));
        this.responseDatagrid(response, jObject);
    }

    @RequestMapping(params={"suspend"})
    @ResponseBody
    public AjaxJson suspend(@RequestParam(value="processInstanceId") String processInstanceId, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        String message = "\u6682\u505c\u6210\u529f";
        j.setMsg(message);
        return j;
    }

    @RequestMapping(params={"restart"})
    @ResponseBody
    public AjaxJson restart(@RequestParam(value="processInstanceId") String processInstanceId, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.runtimeService.activateProcessInstanceById(processInstanceId);
        String message = "\u542f\u52a8\u6210\u529f";
        j.setMsg(message);
        return j;
    }

    @RequestMapping(params={"close"})
    @ResponseBody
    public AjaxJson close(@RequestParam(value="processInstanceId") String processInstanceId, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.runtimeService.deleteProcessInstance(processInstanceId, "\u4e3b\u52a8\u4f5c\u5e9f\u6d41\u7a0b");
        String message = "\u4f5c\u5e9f\u6210\u529f";
        j.setMsg(message);
        return j;
    }

    @RequestMapping(params={"myRunningProcessList"})
    public String myRunningProcessList() {
        return "workflow/activiti/myRunningProcessList";
    }

    @RequestMapping(params={"skipNodeInit"})
    public ModelAndView skipNodeInit(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        String taskId = request.getParameter("taskId");
        List taskList = this.activitiService.getAllTaskNode(taskId);
        request.setAttribute("taskId", (Object)taskId);
        request.setAttribute("taskList", (Object)taskList);
        return new ModelAndView("workflow/activiti/skipNodeInit");
    }

    @RequestMapping(params={"skipNode"})
    @ResponseBody
    public AjaxJson skipNode(@RequestParam(value="taskId") String taskId, @RequestParam(value="skipTaskNode") String skipNode, HttpServletRequest request, Variable var) throws Exception {
        AjaxJson j = new AjaxJson();
        ProcessHandle processHandle = this.activitiService.getProcessHandle(taskId);
        Map<String, Object> map = var.getVariableMap(processHandle.getTpProcesspros());
        if ("end".equals(skipNode)) {
            this.taskJeecgService.endProcess(taskId);
        } else {
            this.taskJeecgService.goProcessTaskNode(taskId, skipNode, map);
        }
        String message = "\u8df3\u8f6c\u6210\u529f";
        j.setMsg(message);
        return j;
    }

    public void responseDatagrid(HttpServletResponse response, JSONObject jObject) {
        response.setContentType("application/json");
        response.setHeader("Cache-Control", "no-store");
        try {
            PrintWriter pw = response.getWriter();
            pw.write(jObject.toString());
            pw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

