/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.workflow.controller.process;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.RepositoryService;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.common.UploadFile;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.ComboBox;
import org.jeecgframework.core.common.model.json.ComboTree;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.ExceptionUtil;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.MutiLangUtil;
import org.jeecgframework.core.util.NumberComparator;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StreamUtils;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.tag.vo.easyui.ComboTreeModel;
import org.jeecgframework.web.cgform.service.migrate.MigrateForm;
import org.jeecgframework.web.system.pojo.base.TSDataRule;
import org.jeecgframework.web.system.pojo.base.TSFunction;
import org.jeecgframework.web.system.pojo.base.TSOperation;
import org.jeecgframework.web.system.pojo.base.TSType;
import org.jeecgframework.web.system.pojo.base.TSTypegroup;
import org.jeecgframework.web.system.service.SystemService;
import org.jeecgframework.web.system.service.UserService;
import org.jeecgframework.workflow.common.WorkFlowGlobals;
import org.jeecgframework.workflow.pojo.base.TPForm;
import org.jeecgframework.workflow.pojo.base.TPFormpro;
import org.jeecgframework.workflow.pojo.base.TPListerer;
import org.jeecgframework.workflow.pojo.base.TPProcess;
import org.jeecgframework.workflow.pojo.base.TPProcessListener;
import org.jeecgframework.workflow.pojo.base.TPProcessnode;
import org.jeecgframework.workflow.pojo.base.TPProcessnodeFunction;
import org.jeecgframework.workflow.pojo.base.TPProcesspro;
import org.jeecgframework.workflow.pojo.base.TSBusConfig;
import org.jeecgframework.workflow.pojo.base.TSTable;
import org.jeecgframework.workflow.service.ActivitiService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/processController"})
public class ProcessController
extends BaseController {
    private static final Logger logger = Logger.getLogger(ProcessController.class);
    private UserService userService;
    private SystemService systemService;
    private String message;
    private ActivitiService activitiService;
    protected RepositoryService repositoryService;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Autowired
    public void setActivitiService(ActivitiService activitiService) {
        this.activitiService = activitiService;
    }

    @Autowired
    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    @Autowired
    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @Autowired
    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    @RequestMapping(params={"processDesigner"})
    public ModelAndView processDesigner(HttpServletRequest request) {
        String processid = oConvertUtils.getString((String)request.getParameter("id"), (String)"0");
        request.setAttribute("processid", (Object)processid);
        return new ModelAndView("designer/index");
    }

    @RequestMapping(params={"processProperties"})
    public ModelAndView processProperties(HttpServletRequest request) {
        String turn = oConvertUtils.getString((String)request.getParameter("turn"));
        String id = oConvertUtils.getString((String)request.getParameter("id"));
        String checkbox = oConvertUtils.getString((String)request.getParameter("checkbox"));
        String processId = oConvertUtils.getString((String)request.getParameter("processId"));
        TPProcess tProcess = (TPProcess)this.systemService.findUniqueByProperty(TPProcess.class, "id", (Object)processId);
        if (tProcess == null) {
            tProcess = (TPProcess)this.systemService.findUniqueByProperty(TPProcess.class, "processkey", (Object)processId);
        }
        if (tProcess != null) {
            request.setAttribute("processDefinitionId", (Object)tProcess.getId());
            if (tProcess.getTSType() != null) {
                request.setAttribute("typeId", (Object)tProcess.getTSType().getId());
            }
        }
        TSTypegroup typegroup = (TSTypegroup)this.systemService.findUniqueByProperty(TSTypegroup.class, "typegroupcode", (Object)"process");
        List proTypeList = this.systemService.findByProperty(TSType.class, "TSTypegroup.id", (Object)typegroup.getId());
        request.setAttribute("checkbox", (Object)checkbox);
        request.setAttribute("id", (Object)id);
        request.setAttribute("proTypeList", (Object)proTypeList);
        request.setAttribute("processId", (Object)processId);
        return new ModelAndView("designer/" + turn);
    }

    @RequestMapping(params={"processIframe"})
    public ModelAndView processIframe(HttpServletRequest request) {
        String typeid = request.getParameter("typeid");
        request.setAttribute("typeid", (Object)typeid);
        List typegroupList = this.systemService.findByProperty(TSTypegroup.class, "typegroupcode", (Object)"process");
        request.setAttribute("typegroupList", (Object)typegroupList);
        return new ModelAndView("workflow/process/processIframe");
    }

    @RequestMapping(params={"processComboBox"})
    @ResponseBody
    public List<ComboBox> processComboBox(HttpServletResponse response, HttpServletRequest request) {
        ComboBox comboBox = new ComboBox();
        comboBox.setId("typecode");
        comboBox.setText("typename");
        ArrayList<ComboBox> comboBoxs = new ArrayList();
        TSTypegroup typegroup = (TSTypegroup)this.systemService.findUniqueByProperty(TSTypegroup.class, "typegroupcode", (Object)"process");
        List proTypeList = this.systemService.findByProperty(TSType.class, "TSTypegroup.id", (Object)typegroup.getId());
        comboBoxs = TagUtil.getComboBox((List)proTypeList, null, (ComboBox)comboBox);
        return comboBoxs;
    }

    @RequestMapping(params={"processTypeTree"})
    @ResponseBody
    public List<ComboTree> processTypeTree(HttpServletRequest request, ComboTree comboTree) {
        CriteriaQuery cq = new CriteriaQuery(TSType.class);
        if (comboTree.getId() != null) {
            cq.eq("TSType.id", (Object)comboTree.getId());
        }
        if (comboTree.getId() == null) {
            cq.isNull("TSType");
        }
        cq.add();
        List typeList = this.systemService.getListByCriteriaQuery(cq, Boolean.valueOf(false));
        ArrayList<ComboTree> comboTrees = new ArrayList();
        ComboTreeModel comboTreeModel = new ComboTreeModel("id", "typename", "TSTypes", "typecode");
        comboTrees = this.systemService.ComboTree(typeList, comboTreeModel, null, true);
        return comboTrees;
    }

    @RequestMapping(params={"processList"})
    public ModelAndView processList(HttpServletRequest request) {
        String typeid = request.getParameter("typeid");
        request.setAttribute("typeid", (Object)typeid);
        return new ModelAndView("workflow/process/processList");
    }

    @RequestMapping(params={"getProcessXml"})
    @ResponseBody
    public void getProcessXml(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("text/xml;charset=UTF-8");
        String processId = oConvertUtils.getString((String)request.getParameter("processId"));
        TPProcess tProcess = (TPProcess)this.systemService.getEntity(TPProcess.class, (Serializable)((Object)processId));
        try {
            String retstr = StreamUtils.InputStreamTOString((InputStream)StreamUtils.byteTOInputStream((byte[])tProcess.getProcessxml()));
            response.getWriter().write(retstr);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    @RequestMapping(params={"saveProcess"})
    @ResponseBody
    public AjaxJson saveProcess(HttpServletRequest request) {
        TPProcess tProcess;
        AjaxJson j = new AjaxJson();
        String processDefinitionId = oConvertUtils.getString((String)request.getParameter("processDefinitionId"));
        String processDescriptor = oConvertUtils.getString((String)request.getParameter("processDescriptor"));
        String processName = oConvertUtils.getString((String)request.getParameter("processName"));
        String processkey = oConvertUtils.getString((String)request.getParameter("processkey"));
        String params = oConvertUtils.getString((String)request.getParameter("params"));
        String nodes = oConvertUtils.getString((String)request.getParameter("nodes"));
        String typeid = oConvertUtils.getString((String)request.getParameter("typeid"));
        TSType tsType = null;
        if (oConvertUtils.isNotEmpty((Object)typeid)) {
            tsType = (TSType)this.systemService.getEntity(TSType.class, (Serializable)((Object)typeid));
        }
        if ((tProcess = (TPProcess)this.systemService.getEntity(TPProcess.class, (Serializable)((Object)processDefinitionId))) == null) {
            tProcess = (TPProcess)this.systemService.findUniqueByProperty(TPProcess.class, "processkey", (Object)processkey);
        }
        if (tProcess != null) {
            tProcess.setProcessname(processName);
            if (tsType != null) {
                tProcess.setTSType(tsType);
            }
            tProcess.setProcesskey(processkey);
            if (!processDescriptor.equals("")) {
                tProcess.setProcessxml(StreamUtils.StringTObyte((String)processDescriptor));
            }
            this.systemService.updateEntitie((Object)tProcess);
            j.setMsg("\u6d41\u7a0b\u4fee\u6539\u6210\u529f");
        } else {
            List processes = this.systemService.findByProperty(TPProcess.class, "processkey", (Object)processkey);
            if (processes.size() == 0) {
                tProcess = new TPProcess();
                tProcess.setProcessname(processName);
                tProcess.setProcessstate(WorkFlowGlobals.Process_Deploy_NO);
                if (tsType != null) {
                    tProcess.setTSType(tsType);
                }
                tProcess.setProcesskey(processkey);
                if (!processDescriptor.equals("")) {
                    tProcess.setProcessxml(StreamUtils.StringTObyte((String)processDescriptor));
                }
                this.systemService.save((Object)tProcess);
                j.setMsg("\u6d41\u7a0b\u521b\u5efa\u6210\u529f");
                j.setObj((Object)tProcess.getId());
            } else {
                j.setMsg("\u6d41\u7a0bID\u5df2\u5b58\u5728");
            }
        }
        if (nodes != null && nodes.length() > 3) {
            String[] temp = nodes.split("@@@");
            int i = 0;
            while (i < temp.length) {
                TPProcessnode tProcessnode = null;
                String[] fileds = temp[i].split("###");
                String tid = fileds[0].substring(3);
                String name = fileds[1].substring(9);
                tProcessnode = this.activitiService.getTPProcessnode(tid, processkey);
                if (tProcessnode == null) {
                    tProcessnode = new TPProcessnode();
                    tProcessnode.setProcessnodecode(tid);
                    tProcessnode.setProcessnodename(name);
                    tProcessnode.setTPProcess(tProcess);
                    tProcessnode.setTPForm(null);
                    this.systemService.save((Object)tProcessnode);
                } else {
                    tProcessnode.setProcessnodecode(tid);
                    tProcessnode.setProcessnodename(name);
                    tProcessnode.setTPProcess(tProcess);
                    tProcessnode.setTPForm(null);
                    this.systemService.updateEntitie((Object)tProcessnode);
                }
                ++i;
            }
        }
        return j;
    }

    @RequestMapping(params={"addOrupdateVariable"})
    public ModelAndView addOrupdateVariable(TPProcesspro processpro, HttpServletRequest request) {
        TPProcessnode processnode = null;
        String processproid = ResourceUtil.getParameter((String)"processproid");
        String processId = ResourceUtil.getParameter((String)"processId");
        String processNode = request.getParameter("processNode");
        String processDefinitionId = request.getParameter("processDefinitionId");
        request.setAttribute("processid", (Object)processId);
        if (processpro.getId() != null) {
            processpro = (TPProcesspro)this.systemService.getEntity(TPProcesspro.class, (Serializable)((Object)processpro.getId()));
            processnode = processpro.getTPProcessnode();
            request.setAttribute("processpro", (Object)processpro);
            request.setAttribute("processnode", (Object)processnode);
        }
        request.setAttribute("processId", (Object)processId);
        request.setAttribute("processNode", (Object)processNode);
        request.setAttribute("processDefinitionId", (Object)processDefinitionId);
        return new ModelAndView("designer/processpro");
    }

    @RequestMapping(params={"saveVariable"})
    @ResponseBody
    public AjaxJson saveVariable(TPProcesspro tProcesspro, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String processproId = ResourceUtil.getParameter((String)"processproid");
        String processId = ResourceUtil.getParameter((String)"processId");
        String processNode = ResourceUtil.getParameter((String)"procesnode");
        String processDefinitionId = ResourceUtil.getParameter((String)"processDefinitionId");
        TPProcess tProcess = null;
        TPProcessnode tProcessnode = null;
        if (StringUtil.isNotEmpty((Object)processDefinitionId)) {
            tProcess = (TPProcess)this.systemService.getEntity(TPProcess.class, (Serializable)((Object)oConvertUtils.getString((String)processDefinitionId)));
        } else if (StringUtil.isNotEmpty((Object)processId)) {
            tProcess = (TPProcess)this.systemService.findUniqueByProperty(TPProcess.class, "processkey", (Object)processId);
            if (tProcess == null) {
                tProcess = new TPProcess();
                tProcess.setProcesskey(processId);
                this.systemService.save((Object)tProcess);
            } else {
                this.systemService.updateEntitie((Object)tProcess);
            }
        }
        if (StringUtil.isNotEmpty((Object)processNode)) {
            tProcessnode = (TPProcessnode)this.systemService.findUniqueByProperty(TPProcessnode.class, "processnodecode", (Object)processNode);
            if (tProcessnode == null) {
                tProcessnode = new TPProcessnode();
                tProcessnode.setTPProcess(tProcess);
                tProcessnode.setTPForm(null);
                tProcessnode.setProcessnodecode(processNode);
                this.systemService.save((Object)tProcessnode);
            } else {
                tProcessnode.setTPProcess(tProcess);
                tProcessnode.setTPForm(null);
                tProcessnode.setProcessnodecode(processNode);
                this.systemService.updateEntitie((Object)tProcessnode);
            }
        }
        if (StringUtil.isNotEmpty((Object)processproId)) {
            tProcesspro.setTPProcess(tProcess);
            this.systemService.updateEntitie((Object)tProcesspro);
        } else {
            tProcesspro.setTPProcess(tProcess);
            tProcesspro.setTPProcessnode(tProcessnode);
            this.systemService.save((Object)tProcesspro);
        }
        j.setMsg("\u53d8\u91cf\u4fdd\u5b58\u6210\u529f!");
        return j;
    }

    @RequestMapping(params={"deleteVariable"})
    @ResponseBody
    public AjaxJson deleteVariable(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String variableId = oConvertUtils.getString((String)request.getParameter("variableId"));
        this.systemService.deleteEntityById(TPProcesspro.class, (Serializable)((Object)variableId));
        j.setMsg("\u53d8\u91cf\u5220\u9664\u6210\u529f!");
        return j;
    }

    @RequestMapping(params={"getVariables"})
    @ResponseBody
    public void getVariables(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        String processNode = oConvertUtils.getString((String)request.getParameter("processNode"));
        String processId = oConvertUtils.getString((String)request.getParameter("processId"));
        TPProcess tProcess = null;
        if (StringUtil.isNotEmpty((Object)processId)) {
            tProcess = (TPProcess)this.systemService.findUniqueByProperty(TPProcess.class, "processkey", (Object)processId);
        }
        if (tProcess != null) {
            CriteriaQuery cq = new CriteriaQuery(TPProcesspro.class, dataGrid);
            cq.createAlias("TPProcessnode", "TPProcessnode");
            cq.eq("TPProcessnode.processnodecode", (Object)processNode);
            cq.eq("TPProcess.id", (Object)tProcess.getId());
            cq.add();
            this.systemService.getDataGridReturn(cq, true);
            TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
        }
    }

    @RequestMapping(params={"getVariable"})
    @ResponseBody
    public void getVariable(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        String variableId = oConvertUtils.getString((String)request.getParameter("variableId"));
        CriteriaQuery cq = new CriteriaQuery(TPProcesspro.class, dataGrid);
        cq.eq("processproid", (Object)variableId);
        cq.add();
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"processTabs"})
    public ModelAndView processTabs(HttpServletRequest request) {
        String processid = request.getParameter("processid");
        request.setAttribute("processid", (Object)processid);
        return new ModelAndView("workflow/process/processTabs");
    }

    @RequestMapping(params={"processpro"})
    public ModelAndView processpro(HttpServletRequest request) {
        String processid = request.getParameter("processid");
        request.setAttribute("processid", (Object)processid);
        return new ModelAndView("workflow/process/processproList");
    }

    @RequestMapping(params={"busbase"})
    public ModelAndView busbase(HttpServletRequest request) {
        String processid = request.getParameter("processid");
        request.setAttribute("processid", (Object)processid);
        return new ModelAndView("workflow/process/busbaseList");
    }

    @RequestMapping(params={"processtype"})
    public ModelAndView processtype() {
        return new ModelAndView("workflow/process/processtypeList");
    }

    @RequestMapping(params={"processnode"})
    public ModelAndView processnode(HttpServletRequest request) {
        String processid = request.getParameter("processid");
        request.setAttribute("processid", (Object)processid);
        return new ModelAndView("workflow/processnode/processnodeList");
    }

    @RequestMapping(params={"processGrid"})
    public void processGrid(TPProcess tPProcess, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        String typeid = oConvertUtils.getString((String)request.getParameter("typeid"));
        CriteriaQuery cq = new CriteriaQuery(TPProcess.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)tPProcess, (Map)request.getParameterMap());
        if (StringUtil.isNotEmpty((Object)typeid)) {
            cq.eq("TSType.id", (Object)typeid);
            cq.add();
        }
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"processproList"})
    public void processproList(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        String processid = request.getParameter("processid");
        CriteriaQuery cq = new CriteriaQuery(TPProcesspro.class, dataGrid);
        if (StringUtil.isNotEmpty((Object)processid)) {
            cq.eq("TPProcess.id", (Object)processid);
            cq.add();
        }
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"datagridBus"})
    public void datagridBus(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        String processid = request.getParameter("processid");
        CriteriaQuery cq = new CriteriaQuery(TSBusConfig.class, dataGrid);
        if (StringUtil.isNotEmpty((Object)processid)) {
            cq.eq("TPProcess.id", (Object)processid);
            cq.add();
        }
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"datagridtype"})
    public void datagridtype(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(TSType.class, dataGrid);
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"datagridNode"})
    public void datagridNode(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        String processid = request.getParameter("processid");
        CriteriaQuery cq = new CriteriaQuery(TPProcessnode.class, dataGrid);
        if (StringUtil.isNotEmpty((Object)processid)) {
            cq.eq("TPProcess.id", (Object)processid);
            cq.add();
        }
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"delType"})
    @ResponseBody
    public AjaxJson delType(TSType processtype, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        processtype = (TSType)this.systemService.getEntity(TSType.class, (Serializable)((Object)processtype.getId()));
        this.message = "\u6d41\u7a0b\u7c7b\u522b: " + processtype.getTypename() + "\u88ab\u5220\u9664 \u6210\u529f";
        this.systemService.delete((Object)processtype);
        this.systemService.addLog(this.message, WorkFlowGlobals.Log_Type_DEL, WorkFlowGlobals.Log_Leavel_INFO);
        return j;
    }

    @RequestMapping(params={"delBus"})
    @ResponseBody
    public AjaxJson delBus(TSBusConfig busbase, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        busbase = (TSBusConfig)this.systemService.getEntity(TSBusConfig.class, (Serializable)((Object)busbase.getId()));
        this.message = "\u6d41\u7a0b\u7c7b\u522b: " + busbase.getBusname() + "\u88ab\u5220\u9664 \u6210\u529f";
        this.systemService.delete((Object)busbase);
        this.systemService.addLog(this.message, WorkFlowGlobals.Log_Type_DEL, WorkFlowGlobals.Log_Leavel_INFO);
        return j;
    }

    @RequestMapping(params={"delprocess"})
    @ResponseBody
    public AjaxJson delprocess(TPProcess process, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        process = (TPProcess)this.systemService.getEntity(TPProcess.class, (Serializable)((Object)process.getId()));
        this.message = "\u6d41\u7a0b: " + process.getProcessname() + "\u88ab\u5220\u9664 \u6210\u529f";
        this.systemService.delete((Object)process);
        this.systemService.addLog(this.message, WorkFlowGlobals.Log_Type_DEL, WorkFlowGlobals.Log_Leavel_INFO);
        return j;
    }

    @RequestMapping(params={"delPro"})
    @ResponseBody
    public AjaxJson delPro(TPProcesspro processpro, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        processpro = (TPProcesspro)this.systemService.getEntity(TPProcesspro.class, (Serializable)((Object)processpro.getId()));
        this.message = "\u6d41\u7a0b\u7c7b\u522b: " + processpro.getProcessproname() + "\u88ab\u5220\u9664 \u6210\u529f";
        this.systemService.delete((Object)processpro);
        this.systemService.addLog(this.message, WorkFlowGlobals.Log_Type_DEL, WorkFlowGlobals.Log_Leavel_INFO);
        return j;
    }

    @RequestMapping(params={"delNode"})
    @ResponseBody
    public AjaxJson delNode(TPProcessnode processnode, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        processnode = (TPProcessnode)this.systemService.getEntity(TPProcessnode.class, (Serializable)((Object)processnode.getId()));
        this.message = "\u6d41\u7a0b\u8282\u70b9: " + processnode.getProcessnodename() + "\u88ab\u5220\u9664 \u6210\u529f";
        this.systemService.delete((Object)processnode);
        this.systemService.addLog(this.message, WorkFlowGlobals.Log_Type_DEL, WorkFlowGlobals.Log_Leavel_INFO);
        return j;
    }

    @RequestMapping(params={"saveType"})
    @ResponseBody
    public AjaxJson saveType(TSType processtype, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (processtype.getId() != null) {
            this.message = "\u6d41\u7a0b\u7c7b\u578b: " + processtype.getTypename() + "\u88ab\u66f4\u65b0\u6210\u529f";
            this.userService.saveOrUpdate((Object)processtype);
            this.systemService.addLog(this.message, WorkFlowGlobals.Log_Type_UPDATE, WorkFlowGlobals.Log_Leavel_INFO);
        } else {
            this.message = "\u6d41\u7a0b\u7c7b\u578b: " + processtype.getTypename() + "\u88ab\u6dfb\u52a0\u6210\u529f";
            this.userService.saveOrUpdate((Object)processtype);
            this.systemService.addLog(this.message, WorkFlowGlobals.Log_Type_INSERT, WorkFlowGlobals.Log_Leavel_INFO);
        }
        return j;
    }

    @RequestMapping(params={"saveBus"})
    @ResponseBody
    public AjaxJson saveBus(TSBusConfig busbase, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((Object)busbase.getId())) {
            this.message = "\u4e1a\u52a1\u53c2\u6570: " + busbase.getBusname() + "\u88ab\u66f4\u65b0\u6210\u529f";
            this.userService.saveOrUpdate((Object)busbase);
            this.systemService.addLog(this.message, WorkFlowGlobals.Log_Type_UPDATE, WorkFlowGlobals.Log_Leavel_INFO);
        } else {
            this.message = "\u4e1a\u52a1\u53c2\u6570: " + busbase.getBusname() + "\u88ab\u6dfb\u52a0\u6210\u529f";
            this.userService.save((Object)busbase);
            this.systemService.addLog(this.message, WorkFlowGlobals.Log_Type_INSERT, WorkFlowGlobals.Log_Leavel_INFO);
        }
        return j;
    }

    @RequestMapping(params={"savePro"})
    @ResponseBody
    public AjaxJson savePro(TPProcesspro processpro, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((Object)processpro.getId())) {
            this.message = "\u6d41\u7a0b\u53c2\u6570: " + processpro.getProcessproname() + "\u88ab\u66f4\u65b0\u6210\u529f";
            this.userService.saveOrUpdate((Object)processpro);
            this.systemService.addLog(this.message, WorkFlowGlobals.Log_Type_UPDATE, WorkFlowGlobals.Log_Leavel_INFO);
        } else {
            this.message = "\u6d41\u7a0b\u53c2\u6570: " + processpro.getProcessproname() + "\u88ab\u6dfb\u52a0\u6210\u529f";
            this.userService.save((Object)processpro);
            this.systemService.addLog(this.message, WorkFlowGlobals.Log_Type_INSERT, WorkFlowGlobals.Log_Leavel_INFO);
        }
        return j;
    }

    @RequestMapping(params={"saveNode"})
    @ResponseBody
    public AjaxJson saveNode(TPProcessnode processnode, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String formid = oConvertUtils.getString((Object)request.getAttribute("fromid"));
        TPForm form = (TPForm)this.systemService.getEntity(TPForm.class, (Serializable)((Object)formid));
        processnode.setTPForm(form);
        if (StringUtil.isNotEmpty((Object)processnode.getId())) {
            this.message = "\u6d41\u7a0b\u8282\u70b9: " + processnode.getProcessnodename() + "\u88ab\u66f4\u65b0\u6210\u529f";
            this.userService.saveOrUpdate((Object)processnode);
            this.systemService.addLog(this.message, WorkFlowGlobals.Log_Type_UPDATE, WorkFlowGlobals.Log_Leavel_INFO);
        } else {
            this.message = "\u6d41\u7a0b\u8282\u70b9: " + processnode.getProcessnodename() + "\u88ab\u6dfb\u52a0\u6210\u529f";
            this.userService.save((Object)processnode);
            this.systemService.addLog(this.message, WorkFlowGlobals.Log_Type_INSERT, WorkFlowGlobals.Log_Leavel_INFO);
        }
        return j;
    }

    @RequestMapping(params={"addorupdateType"})
    public ModelAndView addorupdateType(TSType processtype, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)processtype.getId())) {
            processtype = (TSType)this.systemService.getEntity(TSType.class, (Serializable)((Object)processtype.getId()));
            req.setAttribute("processtype", (Object)processtype);
        }
        return new ModelAndView("workflow/process/processtype");
    }

    @RequestMapping(params={"addorupdateBus"})
    public ModelAndView addorupdateBus(TSBusConfig busbase, HttpServletRequest req) {
        String processid = req.getParameter("processid");
        TSType type = (TSType)this.systemService.findUniqueByProperty(TSType.class, "typecode", (Object)WorkFlowGlobals.DataBase_Bus);
        if (type != null) {
            List tableList = this.systemService.findByProperty(TSTable.class, "TSType.id", (Object)type.getId());
            req.setAttribute("tableList", (Object)tableList);
        }
        if (StringUtil.isNotEmpty((Object)busbase.getId())) {
            busbase = (TSBusConfig)this.systemService.getEntity(TSBusConfig.class, (Serializable)((Object)busbase.getId()));
            req.setAttribute("busbase", (Object)busbase);
        }
        req.setAttribute("processid", (Object)processid);
        return new ModelAndView("workflow/process/busbase");
    }

    @RequestMapping(params={"addorupdatePro"})
    public ModelAndView addorupdatePro(TPProcesspro processpro, HttpServletRequest request) {
        String processid = request.getParameter("processid");
        request.setAttribute("processid", (Object)processid);
        List nodeList = this.systemService.findByProperty(TPProcessnode.class, "TPProcess.id", (Object)processid);
        request.setAttribute("nodeList", (Object)nodeList);
        List typeList = this.systemService.loadAll(TSType.class);
        request.setAttribute("typeList", (Object)typeList);
        List forms = this.systemService.loadAll(TPForm.class);
        request.setAttribute("forms", (Object)forms);
        if (StringUtil.isNotEmpty((Object)processpro.getId())) {
            processpro = (TPProcesspro)this.systemService.getEntity(TPProcesspro.class, (Serializable)((Object)processpro.getId()));
            request.setAttribute("processpro", (Object)processpro);
        }
        return new ModelAndView("workflow/process/processpro");
    }

    @RequestMapping(params={"addorupdateNode"})
    public ModelAndView addorupdateNode(TPProcessnode processnode, HttpServletRequest request) {
        String processid = request.getParameter("processid");
        request.setAttribute("processid", (Object)processid);
        List processList = this.systemService.loadAll(TPProcess.class);
        request.setAttribute("processList", (Object)processList);
        List formList = this.systemService.loadAll(TPForm.class);
        request.setAttribute("formList", (Object)formList);
        if (processnode.getId() != null) {
            processnode = (TPProcessnode)this.systemService.getEntity(TPProcessnode.class, (Serializable)((Object)processnode.getId()));
            request.setAttribute("processnode", (Object)processnode);
        }
        return new ModelAndView("workflow/processnode/processnode");
    }

    @RequestMapping(params={"deployProcess"})
    @ResponseBody
    public AjaxJson deployProcess(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String processid = request.getParameter("processid");
        TPProcess process = (TPProcess)this.systemService.getEntity(TPProcess.class, (Serializable)((Object)processid));
        if (process != null) {
            try {
                this.repositoryService.createDeployment().addInputStream(String.valueOf(process.getProcesskey()) + ".bpmn", StreamUtils.byteTOInputStream((byte[])process.getProcessxml())).name(process.getProcesskey()).deploy();
                process.setProcessstate(WorkFlowGlobals.Process_Deploy_YES);
                this.systemService.updateEntitie((Object)process);
                this.message = "\u53d1\u5e03\u6210\u529f";
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u53d1\u5e03\u5931\u8d25";
            }
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"form"})
    public ModelAndView form(HttpServletRequest request) {
        return new ModelAndView("workflow/form/formsList");
    }

    @RequestMapping(params={"formpro"})
    public ModelAndView formpro(HttpServletRequest request) {
        String formid = request.getParameter("formid");
        TPForm form = (TPForm)this.systemService.get(TPForm.class, (Serializable)((Object)formid));
        request.setAttribute("form", (Object)form);
        return new ModelAndView("workflow/form/formproList");
    }

    @RequestMapping(params={"datagridForm"})
    public void datagridForm(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(TPForm.class, dataGrid);
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"datagridFPro"})
    public void datagridFPro(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        String formid = request.getParameter("formid");
        CriteriaQuery cq = new CriteriaQuery(TPFormpro.class, dataGrid);
        if (StringUtil.isNotEmpty((Object)formid)) {
            cq.eq("TPForm.id", (Object)formid);
            cq.add();
        }
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"addorupdateForm"})
    public ModelAndView addorupdateForm(TPForm form, HttpServletRequest req) {
        List processList = this.systemService.loadAll(TPProcess.class);
        req.setAttribute("processList", (Object)processList);
        List typeList = this.systemService.loadAll(TSType.class);
        req.setAttribute("typeList", (Object)typeList);
        if (form.getId() != null) {
            form = (TPForm)this.systemService.getEntity(TPForm.class, (Serializable)((Object)form.getId()));
            req.setAttribute("form", (Object)form);
        }
        return new ModelAndView("workflow/form/form");
    }

    @RequestMapping(params={"addorupdateFPro"})
    public ModelAndView addorupdateFPro(TPFormpro formpro, HttpServletRequest req) {
        String formid = req.getParameter("formid");
        req.setAttribute("formid", (Object)formid);
        String processid = req.getParameter("processid");
        req.setAttribute("processid", (Object)processid);
        List typeList = this.systemService.loadAll(TSType.class);
        req.setAttribute("typeList", (Object)typeList);
        if (formpro.getId() != null) {
            formpro = (TPFormpro)this.systemService.getEntity(TPFormpro.class, (Serializable)((Object)formpro.getId()));
            req.setAttribute("formpro", (Object)formpro);
        }
        return new ModelAndView("workflow/form/formpro");
    }

    @RequestMapping(params={"saveForm"})
    @ResponseBody
    public AjaxJson saveForm(TPForm form, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((Object)form.getId())) {
            this.message = "\u8868\u5355: " + form.getFormname() + "\u88ab\u66f4\u65b0\u6210\u529f";
            this.systemService.saveOrUpdate((Object)form);
            this.systemService.addLog(this.message, WorkFlowGlobals.Log_Type_UPDATE, WorkFlowGlobals.Log_Leavel_INFO);
        } else {
            this.message = "\u8868\u5355: " + form.getFormname() + "\u88ab\u6dfb\u52a0\u6210\u529f";
            this.userService.save((Object)form);
            this.systemService.addLog(this.message, WorkFlowGlobals.Log_Type_INSERT, WorkFlowGlobals.Log_Leavel_INFO);
        }
        return j;
    }

    @RequestMapping(params={"saveFPro"})
    @ResponseBody
    public AjaxJson saveFPro(TPFormpro formpro, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((Object)formpro.getId())) {
            this.message = "\u8868\u5355\u53c2\u6570: " + formpro.getFormproname() + "\u88ab\u66f4\u65b0\u6210\u529f";
            this.systemService.saveOrUpdate((Object)formpro);
            this.systemService.addLog(this.message, WorkFlowGlobals.Log_Type_UPDATE, WorkFlowGlobals.Log_Leavel_INFO);
        } else {
            this.message = "\u8868\u5355\u53c2\u6570: " + formpro.getFormproname() + "\u88ab\u6dfb\u52a0\u6210\u529f";
            this.userService.save((Object)formpro);
            this.systemService.addLog(this.message, WorkFlowGlobals.Log_Type_INSERT, WorkFlowGlobals.Log_Leavel_INFO);
        }
        return j;
    }

    @RequestMapping(params={"delForm"})
    @ResponseBody
    public AjaxJson delForm(TPForm form, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        form = (TPForm)this.systemService.getEntity(TPForm.class, (Serializable)((Object)form.getId()));
        this.message = "\u8868\u5355: " + form.getFormname() + "\u88ab\u5220\u9664 \u6210\u529f";
        this.systemService.delete((Object)form);
        this.systemService.addLog(this.message, WorkFlowGlobals.Log_Type_DEL, WorkFlowGlobals.Log_Leavel_INFO);
        return j;
    }

    @RequestMapping(params={"delFPro"})
    @ResponseBody
    public AjaxJson delFPro(TPFormpro formpro, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        formpro = (TPFormpro)this.systemService.getEntity(TPFormpro.class, (Serializable)((Object)formpro.getId()));
        this.message = "\u8868\u5355\u53c2\u6570: " + formpro.getFormproname() + "\u88ab\u5220\u9664 \u6210\u529f";
        this.systemService.delete((Object)formpro);
        this.systemService.addLog(this.message, WorkFlowGlobals.Log_Type_DEL, WorkFlowGlobals.Log_Leavel_INFO);
        return j;
    }

    @RequestMapping(params={"addpro"})
    public ModelAndView addpro(HttpServletRequest request) {
        String typeid = request.getParameter("id");
        request.setAttribute("typeid", (Object)typeid);
        return new ModelAndView("workflow/process/process");
    }

    @RequestMapping(params={"choosePro"})
    public ModelAndView choosePro(HttpServletRequest request) {
        List formList = this.systemService.loadAll(TPForm.class);
        request.setAttribute("formList", (Object)formList);
        return new ModelAndView("workflow/process/process");
    }

    @RequestMapping(params={"chooseListener"})
    public ModelAndView chooseListener(HttpServletRequest request) {
        String typeid = oConvertUtils.getString((String)request.getParameter("typeid"));
        return new ModelAndView("designer/listenerList", "typeid", (Object)typeid);
    }

    @RequestMapping(params={"listenerGrid"})
    @ResponseBody
    public void listenerGrid(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        Short listenerstate = oConvertUtils.getShort((String)request.getParameter("status"));
        Short typeid = oConvertUtils.getShort((String)request.getParameter("typeid"));
        CriteriaQuery cq = new CriteriaQuery(TPListerer.class, dataGrid);
        if (StringUtil.isNotEmpty((Object)listenerstate)) {
            cq.eq("listenerstate", (Object)listenerstate);
        }
        if (StringUtil.isNotEmpty((Object)typeid)) {
            cq.eq("typeid", (Object)typeid);
        }
        cq.add();
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"listenerGridYouXiao"})
    @ResponseBody
    public void listenerGridYouXiao(TPListerer tplisterer, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        String ids = oConvertUtils.getString((String)request.getParameter("ids"));
        if (oConvertUtils.isNotEmpty((Object)ids)) {
            tplisterer.setId(ids);
        } else {
            tplisterer.setId("\u4e0d\u8fd4\u56de\u503c");
        }
        CriteriaQuery cq = new CriteriaQuery(TPListerer.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)tplisterer);
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"saveListener"})
    @ResponseBody
    public AjaxJson saveListener(TPListerer tpListerer, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String event = "";
        Short typeid = oConvertUtils.getShort((String)request.getParameter("typeid"));
        event = typeid.equals(WorkFlowGlobals.Listener_Type_Excution) ? oConvertUtils.getString((String)request.getParameter("executioneven")) : oConvertUtils.getString((String)request.getParameter("taskeven"));
        tpListerer.setListenereven(event);
        if (StringUtil.isNotEmpty((Object)tpListerer.getId())) {
            this.message = "\u76d1\u542c: " + tpListerer.getListenername() + "\u66f4\u65b0\u6210\u529f";
            this.userService.saveOrUpdate((Object)tpListerer);
            this.systemService.addLog(this.message, WorkFlowGlobals.Log_Type_UPDATE, WorkFlowGlobals.Log_Leavel_INFO);
        } else {
            this.message = "\u76d1\u542c: " + tpListerer.getListenername() + "\u6dfb\u52a0\u6210\u529f";
            tpListerer.setListenerstate(WorkFlowGlobals.Listener_No);
            this.userService.save((Object)tpListerer);
            this.systemService.addLog(this.message, WorkFlowGlobals.Log_Type_INSERT, WorkFlowGlobals.Log_Leavel_INFO);
        }
        return j;
    }

    @RequestMapping(params={"delListeren"})
    @ResponseBody
    public AjaxJson delListeren(TPListerer tpListerer, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if ((tpListerer = (TPListerer)this.systemService.getEntity(TPListerer.class, (Serializable)((Object)tpListerer.getId()))).getTProcessListeners().size() == 0) {
            this.message = "\u76d1\u542c: " + tpListerer.getListenername() + " \u5220\u9664\u6210\u529f";
            this.systemService.delete((Object)tpListerer);
            this.systemService.addLog(this.message, WorkFlowGlobals.Log_Type_DEL, WorkFlowGlobals.Log_Leavel_INFO);
        } else {
            this.message = "\u76d1\u542c: " + tpListerer.getListenername() + "\u5df2\u7ecf\u5728\u8fd0\u884c\u4e2d\u65e0\u6cd5\u5220\u9664";
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"processUpload"})
    public ModelAndView processUpload(String id, HttpServletRequest req) {
        req.setAttribute("id", (Object)id);
        return new ModelAndView("workflow/process/processUpload");
    }

    @ResponseBody
    @RequestMapping(params={"doProcessUpload"})
    public AjaxJson doProcessUpload(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        String ls_file = "";
        UploadFile uploadFile = new UploadFile(request, (Object)ls_file);
        uploadFile.setCusPath("");
        uploadFile.setSwfpath("");
        String uploadbasepath = uploadFile.getBasePath();
        if (uploadbasepath == null) {
            uploadbasepath = ResourceUtil.getConfigByName((String)"uploadpath");
        }
        String path = String.valueOf(uploadbasepath) + "\\";
        String realPath = String.valueOf(uploadFile.getMultipartRequest().getSession().getServletContext().getRealPath("\\")) + path;
        this.message = null;
        try {
            File file = new File(realPath);
            if (!file.exists()) {
                file.mkdir();
            }
            uploadFile.getMultipartRequest().setCharacterEncoding("UTF-8");
            MultipartHttpServletRequest multipartRequest = uploadFile.getMultipartRequest();
            Map fileMap = multipartRequest.getFileMap();
            String fileName = "";
            for (Map.Entry entity : fileMap.entrySet()) {
                MultipartFile mf = (MultipartFile)entity.getValue();
                fileName = mf.getOriginalFilename();
                String savePath = String.valueOf(realPath) + fileName;
                File savefile = new File(savePath);
                String ls_tmp = savefile.getName();
                FileCopyUtils.copy((byte[])mf.getBytes(), (File)savefile);
                MigrateForm.unzip((String)savePath, (String)"");
                String sqlFileDir = String.valueOf(realPath) + ls_tmp.substring(0, ls_tmp.lastIndexOf("."));
                File sqlDirFile = new File(sqlFileDir);
                String bpmfilename = String.valueOf(sqlDirFile.getPath()) + "/";
                if (sqlDirFile.isDirectory()) {
                    bpmfilename = String.valueOf(bpmfilename) + sqlDirFile.list()[0];
                }
                File bpm = new File(bpmfilename);
                FileInputStream in = new FileInputStream(bpm);
                String id = request.getParameter("id");
                TPProcess tProcess = (TPProcess)this.systemService.getEntity(TPProcess.class, (Serializable)((Object)id));
                tProcess.setProcessxml(StreamUtils.InputStreamTOByte((InputStream)in));
                this.systemService.updateEntitie((Object)tProcess);
            }
        }
        catch (Exception e1) {
            LogUtil.error((String)e1.toString());
            this.message = e1.toString();
        }
        if (StringUtil.isNotEmpty((Object)this.message)) {
            j.setMsg("\u6d41\u7a0b\u5bfc\u5165\u5931\u8d25," + this.message);
        } else {
            j.setMsg("\u6d41\u7a0b\u6587\u4ef6\u5bfc\u5165\u6210\u529f");
        }
        return j;
    }

    @RequestMapping(params={"setListeren"})
    @ResponseBody
    public AjaxJson setListeren(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String id = request.getParameter("id");
        Short status = oConvertUtils.getShort((String)request.getParameter("status"));
        TPListerer tpListerer = (TPListerer)this.systemService.getEntity(TPListerer.class, (Serializable)((Object)id));
        if (tpListerer != null) {
            tpListerer.setListenerstate(status);
            this.systemService.updateEntitie((Object)tpListerer);
            if (status.equals(WorkFlowGlobals.Listener_No)) {
                j.setMsg("\u76d1\u542c\u5df2\u7981\u7528");
            } else {
                j.setMsg("\u76d1\u542c\u5df2\u542f\u7528");
            }
        }
        return j;
    }

    @RequestMapping(params={"setProcessListener"})
    @ResponseBody
    public AjaxJson setProcessListener(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String id = request.getParameter("id");
        TPProcessListener tpProcessListener = (TPProcessListener)this.systemService.getEntity(TPProcessListener.class, (Serializable)((Object)id));
        if (tpProcessListener != null) {
            Short status = WorkFlowGlobals.Process_Listener_NO.equals(tpProcessListener.getStatus()) ? WorkFlowGlobals.Process_Listener_YES : WorkFlowGlobals.Process_Listener_NO;
            tpProcessListener.setStatus(status);
            this.systemService.updateEntitie((Object)tpProcessListener);
            if (status.equals(WorkFlowGlobals.Process_Listener_NO)) {
                j.setSuccess(false);
                j.setMsg("\u76d1\u542c\u5df2\u7981\u7528");
            } else {
                j.setMsg("\u76d1\u542c\u5df2\u542f\u7528");
            }
        }
        return j;
    }

    @RequestMapping(params={"delProcesListeren"})
    @ResponseBody
    public AjaxJson delProcesListeren(TPProcessListener tpProcessListener, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        tpProcessListener = (TPProcessListener)this.systemService.getEntity(TPProcessListener.class, (Serializable)((Object)tpProcessListener.getId()));
        this.message = "\u76d1\u542c: " + tpProcessListener.getTPListerer().getListenername() + " \u5220\u9664\u6210\u529f";
        this.systemService.delete((Object)tpProcessListener);
        this.systemService.addLog(this.message, WorkFlowGlobals.Log_Type_DEL, WorkFlowGlobals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"getNodelisteners"})
    @ResponseBody
    public void getNodelisteners(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        Short type = oConvertUtils.getShort((String)request.getParameter("type"));
        String processNode = oConvertUtils.getString((String)request.getParameter("processNode"));
        String processkey = oConvertUtils.getString((String)request.getParameter("processId"));
        CriteriaQuery cq = new CriteriaQuery(TPProcessListener.class, dataGrid);
        if (type.equals(WorkFlowGlobals.Listener_Type_Task)) {
            TPProcessnode tProcessnode = this.activitiService.getTPProcessnode(processNode, processkey);
            if (tProcessnode != null) {
                cq.eq("TPProcessnode.id", (Object)tProcessnode.getId());
            }
        } else {
            cq.eq("nodename", (Object)processNode);
        }
        cq.add();
        this.systemService.getDataGridReturn(cq, false);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"saveProcessListener"})
    @ResponseBody
    public AjaxJson saveProcessListener(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        Short type = oConvertUtils.getShort((String)request.getParameter("type"));
        String listenerid = oConvertUtils.getString((String)request.getParameter("listenerid"));
        String processkey = oConvertUtils.getString((String)request.getParameter("processkey"));
        String taskDefinitionKey = ResourceUtil.getParameter((String)"processNode");
        TPProcess tProcess = null;
        TPProcessnode tProcessnode = null;
        if (StringUtil.isNotEmpty((Object)processkey) && (tProcess = (TPProcess)this.systemService.findUniqueByProperty(TPProcess.class, "processkey", (Object)processkey)) == null) {
            tProcess = new TPProcess();
            tProcess.setProcesskey(processkey);
            this.systemService.save((Object)tProcess);
        }
        if (type.equals(WorkFlowGlobals.Listener_Type_Task) && StringUtil.isNotEmpty((Object)taskDefinitionKey)) {
            tProcessnode = this.activitiService.getTPProcessnode(taskDefinitionKey, processkey);
            if (tProcessnode == null) {
                tProcessnode = new TPProcessnode();
                tProcessnode.setTPProcess(tProcess);
                tProcessnode.setTPForm(null);
                tProcessnode.setProcessnodecode(taskDefinitionKey);
                this.systemService.save((Object)tProcessnode);
            } else {
                tProcessnode.setTPProcess(tProcess);
                tProcessnode.setTPForm(null);
                tProcessnode.setProcessnodecode(taskDefinitionKey);
                this.systemService.updateEntitie((Object)tProcessnode);
            }
        }
        if (StringUtil.isNotEmpty((Object)listenerid)) {
            String[] listens = listenerid.split(",");
            int len = listens.length;
            int i = 0;
            while (i < len) {
                TPProcessListener tPProcessListener = new TPProcessListener();
                TPListerer tPListerer = (TPListerer)this.systemService.getEntity(TPListerer.class, (Serializable)((Object)listens[i]));
                tPProcessListener.setTPListerer(tPListerer);
                if (type.equals(WorkFlowGlobals.Listener_Type_Task)) {
                    tPProcessListener.setTPProcessnode(tProcessnode);
                }
                if (type.equals(WorkFlowGlobals.Listener_Type_Excution)) {
                    tPProcessListener.setTPProcess(tProcess);
                    tPProcessListener.setNodename(taskDefinitionKey);
                }
                tPProcessListener.setStatus(WorkFlowGlobals.Process_Deploy_NO);
                this.systemService.save((Object)tPProcessListener);
                ++i;
            }
        }
        return j;
    }

    @RequestMapping(params={"busConfigGrid"})
    public void busConfigGrid(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(TSBusConfig.class, dataGrid);
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"listenerList"})
    public ModelAndView listenerList(HttpServletRequest request) {
        return new ModelAndView("workflow/listener/listenerList");
    }

    @RequestMapping(params={"aouListener"})
    public ModelAndView aouListener(TPListerer tpListerer, HttpServletRequest request) {
        if (tpListerer.getId() != null) {
            tpListerer = (TPListerer)this.systemService.getEntity(TPListerer.class, (Serializable)((Object)tpListerer.getId()));
            request.setAttribute("tpListerer", (Object)tpListerer);
        }
        return new ModelAndView("workflow/listener/listener");
    }

    @RequestMapping(params={"nodeFun"})
    public ModelAndView nodeFun(HttpServletRequest request) {
        String id = request.getParameter("nodeId");
        request.setAttribute("nodeId", (Object)id);
        return new ModelAndView("workflow/processnode/nodeRoleSet");
    }

    @RequestMapping(params={"setNodeAuthority"})
    @ResponseBody
    public List<ComboTree> setNodeAuthority(TPProcessnode node, HttpServletRequest request, ComboTree comboTree) {
        List proFunctionList;
        CriteriaQuery cq = new CriteriaQuery(TSFunction.class);
        if (comboTree.getId() != null) {
            cq.eq("TSFunction.id", (Object)comboTree.getId());
        }
        if (comboTree.getId() == null) {
            cq.isNull("TSFunction");
        }
        cq.notEq("functionLevel", (Object)Short.parseShort("-1"));
        cq.add();
        List functionList = this.systemService.getListByCriteriaQuery(cq, Boolean.valueOf(false));
        Collections.sort(functionList, new NumberComparator());
        ArrayList<ComboTree> comboTrees = new ArrayList();
        String nodeId = request.getParameter("nodeId");
        ArrayList<TSFunction> loginActionlist = new ArrayList<TSFunction>();
        node = (TPProcessnode)this.systemService.get(TPProcessnode.class, (Serializable)((Object)nodeId));
        if (node != null && (proFunctionList = this.systemService.findByProperty(TPProcessnodeFunction.class, "TPProcessnode.id", (Object)node.getId())).size() > 0) {
            for (TPProcessnodeFunction proFunction : proFunctionList) {
                TSFunction function = proFunction.getTSFunction();
                loginActionlist.add(function);
            }
        }
        ComboTreeModel comboTreeModel = new ComboTreeModel("id", "functionName", "TSFunctions");
        comboTrees = this.systemService.ComboTree(functionList, comboTreeModel, loginActionlist, false);
        MutiLangUtil.setMutiTree(comboTrees);
        return comboTrees;
    }

    @RequestMapping(params={"updateNodeAuthority"})
    @ResponseBody
    public AjaxJson updateNodeAuthority(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            String nodeId = request.getParameter("nodeId");
            String nodefunctions = request.getParameter("nodefunctions");
            TPProcessnode node = (TPProcessnode)this.systemService.get(TPProcessnode.class, (Serializable)((Object)nodeId));
            List nodeFunctionList = this.systemService.findByProperty(TPProcessnodeFunction.class, "TPProcessnode.id", (Object)node.getId());
            HashMap<String, TPProcessnodeFunction> map = new HashMap<String, TPProcessnodeFunction>();
            for (TPProcessnodeFunction functionOfNode : nodeFunctionList) {
                map.put(functionOfNode.getTSFunction().getId(), functionOfNode);
            }
            String[] nodeFunctions = nodefunctions.split(",");
            HashSet<String> set = new HashSet<String>();
            String[] stringArray = nodeFunctions;
            int n = nodeFunctions.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                set.add(s);
                ++n2;
            }
            this.updateNodeCompare(set, node, map);
            j.setMsg("\u6743\u9650\u66f4\u65b0\u6210\u529f");
        }
        catch (Exception e) {
            logger.error((Object)ExceptionUtil.getExceptionMessage((Exception)e));
            j.setMsg("\u6743\u9650\u66f4\u65b0\u5931\u8d25");
        }
        return j;
    }

    private void updateNodeCompare(Set<String> set, TPProcessnode node, Map<String, TPProcessnodeFunction> map) {
        ArrayList<TPProcessnodeFunction> entitys = new ArrayList<TPProcessnodeFunction>();
        ArrayList<TPProcessnodeFunction> deleteEntitys = new ArrayList<TPProcessnodeFunction>();
        for (String s : set) {
            if (map.containsKey(s)) {
                map.remove(s);
                continue;
            }
            TPProcessnodeFunction rf = new TPProcessnodeFunction();
            TSFunction f = (TSFunction)this.systemService.get(TSFunction.class, (Serializable)((Object)s));
            rf.setTSFunction(f);
            rf.setTPProcessnode(node);
            entitys.add(rf);
        }
        Collection<TPProcessnodeFunction> collection = map.values();
        Iterator<TPProcessnodeFunction> it = collection.iterator();
        while (it.hasNext()) {
            deleteEntitys.add(it.next());
        }
        this.systemService.batchSave(entitys);
        this.systemService.deleteAllEntitie(deleteEntitys);
    }

    @RequestMapping(params={"nodeOperaListForFunction"})
    public ModelAndView nodeOperaListForFunction(HttpServletRequest request, String functionId, String nodeId) {
        CriteriaQuery cq = new CriteriaQuery(TSOperation.class);
        cq.eq("TSFunction.id", (Object)functionId);
        cq.eq("status", (Object)Short.valueOf("0"));
        cq.add();
        List operationList = this.systemService.getListByCriteriaQuery(cq, Boolean.valueOf(false));
        Set<String> operationCodes = this.activitiService.getNodeOperaCodesByNodeIdAndFunctionId(nodeId, functionId);
        request.setAttribute("operationList", (Object)operationList);
        request.setAttribute("operationcodes", operationCodes);
        request.setAttribute("functionId", (Object)functionId);
        return new ModelAndView("workflow/processnode/nodeOperaListForFunction");
    }

    @RequestMapping(params={"updateNodeOperation"})
    @ResponseBody
    public AjaxJson updateNodeOperation(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String nodeId = request.getParameter("nodeId");
        String functionId = request.getParameter("functionId");
        String operationcodes = null;
        try {
            operationcodes = URLDecoder.decode(request.getParameter("operationcodes"), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        CriteriaQuery cq1 = new CriteriaQuery(TPProcessnodeFunction.class);
        cq1.eq("TPProcessnode.id", (Object)nodeId);
        cq1.eq("TSFunction.id", (Object)functionId);
        cq1.add();
        List rFunctions = this.systemService.getListByCriteriaQuery(cq1, Boolean.valueOf(false));
        if (rFunctions != null && rFunctions.size() > 0) {
            TPProcessnodeFunction tsProFunction = (TPProcessnodeFunction)rFunctions.get(0);
            tsProFunction.setOperation(operationcodes);
            this.systemService.saveOrUpdate((Object)tsProFunction);
        }
        j.setMsg("\u6309\u94ae\u6743\u9650\u66f4\u65b0\u6210\u529f");
        return j;
    }

    @RequestMapping(params={"nodeDataRuleListForFunction"})
    public ModelAndView nodeDataRuleListForFunction(HttpServletRequest request, String functionId, String nodeId) {
        CriteriaQuery cq = new CriteriaQuery(TSDataRule.class);
        cq.eq("TSFunction.id", (Object)functionId);
        cq.add();
        List dataRuleList = this.systemService.getListByCriteriaQuery(cq, Boolean.valueOf(false));
        Set<String> dataRulecodes = this.activitiService.getOperationCodesByNodeIdAndruleDataId(nodeId, functionId);
        request.setAttribute("dataRuleList", (Object)dataRuleList);
        request.setAttribute("dataRulecodes", dataRulecodes);
        request.setAttribute("functionId", (Object)functionId);
        return new ModelAndView("workflow/processnode/nodeDateRuleListForFunction");
    }

    @RequestMapping(params={"updateNodeDataRule"})
    @ResponseBody
    public AjaxJson updateNodeDataRule(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String nodeId = request.getParameter("nodeId");
        String functionId = request.getParameter("functionId");
        String dataRulecodes = null;
        try {
            dataRulecodes = URLDecoder.decode(request.getParameter("dataRulecodes"), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        CriteriaQuery cq1 = new CriteriaQuery(TPProcessnodeFunction.class);
        cq1.eq("TPProcessnode.id", (Object)nodeId);
        cq1.eq("TSFunction.id", (Object)functionId);
        cq1.add();
        List rFunctions = this.systemService.getListByCriteriaQuery(cq1, Boolean.valueOf(false));
        if (rFunctions != null && rFunctions.size() > 0) {
            TPProcessnodeFunction tsNodeFunction = (TPProcessnodeFunction)rFunctions.get(0);
            tsNodeFunction.setDataRule(dataRulecodes);
            this.systemService.saveOrUpdate((Object)tsNodeFunction);
        }
        j.setMsg("\u6570\u636e\u6743\u9650\u66f4\u65b0\u6210\u529f");
        return j;
    }
}

