/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.workflow.controller.process;

import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.common.DBTable;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.pojo.base.TSType;
import org.jeecgframework.web.system.pojo.base.TSTypegroup;
import org.jeecgframework.web.system.service.SystemService;
import org.jeecgframework.workflow.common.WorkFlowGlobals;
import org.jeecgframework.workflow.pojo.base.TSTable;
import org.jeecgframework.workflow.service.ActivitiService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/dbController"})
public class DataBaseController
extends BaseController {
    private static final Logger logger = Logger.getLogger(DataBaseController.class);
    private SystemService systemService;
    @Autowired
    private ActivitiService activitiService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Autowired
    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    @RequestMapping(params={"tableTypeTabs"})
    public ModelAndView tableTypeTabs(HttpServletRequest request) {
        this.loadTables(request);
        return new ModelAndView("workflow/database/tableTypeTabs");
    }

    private void loadTables(HttpServletRequest request) {
        Integer tableSize = this.systemService.getAllDbTableSize();
        List tsTableList = this.systemService.loadAll(TSTable.class);
        if (tableSize > tsTableList.size()) {
            TSTypegroup tsTypegroup = this.systemService.getTypeGroup(WorkFlowGlobals.TypeGroup_Database, "\u6570\u636e\u8868");
            TSType actType = this.systemService.getType(WorkFlowGlobals.DataBase_Activiti, "\u5de5\u4f5c\u6d41\u5f15\u64ce\u8868", tsTypegroup);
            TSType baseType = this.systemService.getType(WorkFlowGlobals.DataBase_Base, "\u7cfb\u7edf\u57fa\u7840\u8868", tsTypegroup);
            TSType busType = this.systemService.getType(WorkFlowGlobals.DataBase_Bus, "\u4e1a\u52a1\u8868", tsTypegroup);
            TSType proType = this.systemService.getType(WorkFlowGlobals.DataBase_Process, "\u81ea\u5b9a\u4e49\u5f15\u64ce\u8868", tsTypegroup);
            TSType otherType = this.systemService.getType(WorkFlowGlobals.DataBase_Other, "\u5176\u4ed6\u8868", tsTypegroup);
            List dbTables = this.systemService.getAllDbTableName();
            for (DBTable dbTable : dbTables) {
                TSTable oldTable;
                TSTable tsTable = new TSTable();
                Class<?> c = dbTable.getClass();
                tsTable.setTableTitle(dbTable.getTableTitle());
                tsTable.setEntityName(dbTable.getEntityName());
                tsTable.setTableName(dbTable.getTableName());
                tsTable.setEntityKey(dbTable.getTableName().substring(dbTable.getTableName().lastIndexOf("_") + 1));
                if (dbTable.getTableName().indexOf(WorkFlowGlobals.DataBase_Activiti) >= 0) {
                    tsTable.setTSType(actType);
                }
                if (dbTable.getTableName().indexOf(WorkFlowGlobals.DataBase_Base) >= 0) {
                    tsTable.setTSType(baseType);
                }
                if (dbTable.getTableName().indexOf(WorkFlowGlobals.DataBase_Bus) >= 0) {
                    tsTable.setTSType(busType);
                }
                if (dbTable.getTableName().indexOf(WorkFlowGlobals.DataBase_Process) >= 0) {
                    tsTable.setTSType(proType);
                }
                if (dbTable.getTableName().indexOf(WorkFlowGlobals.DataBase_Process) < 0 && dbTable.getTableName().indexOf(WorkFlowGlobals.DataBase_Bus) < 0 && dbTable.getTableName().indexOf(WorkFlowGlobals.DataBase_Base) < 0 && dbTable.getTableName().indexOf(WorkFlowGlobals.DataBase_Activiti) < 0) {
                    tsTable.setTSType(otherType);
                }
                if ((oldTable = (TSTable)this.systemService.findUniqueByProperty(TSTable.class, "tableName", (Object)dbTable.getTableName())) != null) continue;
                this.systemService.save((Object)tsTable);
            }
        }
        TSTypegroup tsTypeList = (TSTypegroup)this.systemService.findUniqueByProperty(TSTypegroup.class, "typegroupcode", (Object)WorkFlowGlobals.TypeGroup_Database);
        request.setAttribute("tsTypeList", (Object)tsTypeList.getTSTypes());
    }

    @RequestMapping(params={"reloadData"})
    @ResponseBody
    public AjaxJson reloadData(HttpServletRequest request) {
        AjaxJson json = new AjaxJson();
        this.activitiService.batchDelete(TSTable.class);
        this.loadTables(request);
        json.setMsg("\u91cd\u65b0\u52a0\u8f7d\u6210\u529f");
        json.setSuccess(true);
        return json;
    }

    @RequestMapping(params={"tableList"})
    public ModelAndView tableList(HttpServletRequest request) {
        String typeid = oConvertUtils.getString((String)request.getParameter("typeid"));
        TSType type = (TSType)this.systemService.getEntity(TSType.class, (Serializable)((Object)typeid));
        request.setAttribute("type", (Object)type);
        return new ModelAndView("workflow/database/tableList");
    }

    @RequestMapping(params={"aouTable"})
    public ModelAndView aouTable(TSTable table, HttpServletRequest req) {
        table = (TSTable)this.systemService.getEntity(TSTable.class, (Serializable)((Object)table.getId()));
        req.setAttribute("table", (Object)table);
        return new ModelAndView("workflow/database/datatable");
    }

    @RequestMapping(params={"saveTable"})
    @ResponseBody
    public AjaxJson saveTable(TSTable table, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((Object)table.getId())) {
            this.message = "\u6570\u636e\u8868: " + table.getTableName() + "\u66f4\u65b0\u6210\u529f";
            this.systemService.saveOrUpdate((Object)table);
            this.systemService.addLog(this.message, WorkFlowGlobals.Log_Type_UPDATE, WorkFlowGlobals.Log_Leavel_INFO);
        } else {
            this.message = "\u6570\u636e\u8868: " + table.getTableName() + "\u6dfb\u52a0\u6210\u529f";
            this.systemService.save((Object)table);
            this.systemService.addLog(this.message, WorkFlowGlobals.Log_Type_INSERT, WorkFlowGlobals.Log_Leavel_INFO);
        }
        return j;
    }

    @RequestMapping(params={"tableGrid"})
    public void tableGrid(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        String typeid = oConvertUtils.getString((String)request.getParameter("typeid"));
        CriteriaQuery cq = new CriteriaQuery(TSTable.class, dataGrid);
        cq.eq("TSType.id", (Object)typeid);
        cq.add();
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }
}

