/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.workflow.controller.process;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.identity.User;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.task.Task;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.hibernate.qbc.PagerUtil;
import org.jeecgframework.core.common.model.common.UploadFile;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.DataUtils;
import org.jeecgframework.core.util.MyClassLoader;
import org.jeecgframework.core.util.ReflectHelper;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.cgform.service.build.DataBaseService;
import org.jeecgframework.web.system.pojo.base.TSUser;
import org.jeecgframework.web.system.service.SystemService;
import org.jeecgframework.workflow.common.WorkFlowGlobals;
import org.jeecgframework.workflow.dao.ActivitiDao;
import org.jeecgframework.workflow.model.activiti.ProcessHandle;
import org.jeecgframework.workflow.model.activiti.Variable;
import org.jeecgframework.workflow.model.diagram.HistoryProcessInstanceDiagramCmd;
import org.jeecgframework.workflow.model.diagram.HistoryProcessInstanceDiagramPositionCmd;
import org.jeecgframework.workflow.pojo.activiti.ActHiProcinst;
import org.jeecgframework.workflow.pojo.activiti.ActIdUser;
import org.jeecgframework.workflow.pojo.activiti.ActRuTask;
import org.jeecgframework.workflow.pojo.base.TPBpmFile;
import org.jeecgframework.workflow.pojo.base.TPBpmLog;
import org.jeecgframework.workflow.pojo.base.TPForm;
import org.jeecgframework.workflow.pojo.base.TPFormpro;
import org.jeecgframework.workflow.pojo.base.TPProcess;
import org.jeecgframework.workflow.pojo.base.TSBusConfig;
import org.jeecgframework.workflow.pojo.base.TSPrjstatus;
import org.jeecgframework.workflow.pojo.base.TSTable;
import org.jeecgframework.workflow.service.ActivitiService;
import org.jeecgframework.workflow.service.impl.TaskJeecgService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/activitiController"})
public class ActivitiController {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    private ActivitiService activitiService;
    protected TaskService taskService;
    protected IdentityService identityService;
    private SystemService systemService;
    private String message;
    private ModelAndView modelAndView = null;
    private HistoryService historyService;
    @Autowired
    private DataBaseService dataBaseService;
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private ActivitiDao activitiDao;
    @Autowired
    private TaskJeecgService taskJeecgService;

    @Autowired
    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    @Autowired
    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    @Autowired
    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    @Autowired
    public void setRuntimeService(RuntimeService runtimeService) {
        this.runtimeService = runtimeService;
    }

    @Autowired
    public void setActivitiService(ActivitiService activitiService) {
        this.activitiService = activitiService;
    }

    @Autowired
    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    @Autowired
    public void setHistoryService(HistoryService historyService) {
        this.historyService = historyService;
    }

    @RequestMapping(params={"deploymentList"})
    public ModelAndView deploymentList() {
        return new ModelAndView("workflow/deployment/deploymentList");
    }

    @RequestMapping(params={"deploymentListByProcesskey"})
    public ModelAndView deploymentListByProcesskey(HttpServletRequest request) {
        String processkey = request.getParameter("processkey");
        if (StringUtils.isEmpty((String)processkey)) {
            processkey = "";
        }
        request.setAttribute("processkey", (Object)processkey);
        return new ModelAndView("workflow/deployment/deploymentInProcesskeyList");
    }

    @RequestMapping(params={"processDeploymentGrid"})
    public void processDeploymentGrid(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        ArrayList<Object[]> objects = new ArrayList<Object[]>();
        List processDefinitionList = this.activitiService.processDefinitionList();
        for (ProcessDefinition processDefinition : processDefinitionList) {
            String deploymentId = processDefinition.getDeploymentId();
            Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult();
            objects.add(new Object[]{processDefinition, deployment});
        }
        dataGrid.setTotal(processDefinitionList.size());
        dataGrid.setResults(processDefinitionList);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"processDeploymentInProcesskeyGrid"})
    public void processDeploymentInProcesskeyGrid(@RequestParam(value="processkey") String processkey, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        ArrayList<Object[]> objects = new ArrayList<Object[]>();
        List processDefinitionList = new ArrayList();
        if (StringUtils.isNotEmpty((String)processkey)) {
            processDefinitionList = this.activitiService.processDefinitionListByProcesskey(processkey);
            for (ProcessDefinition processDefinition : processDefinitionList) {
                String deploymentId = processDefinition.getDeploymentId();
                Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult();
                objects.add(new Object[]{processDefinition, deployment});
            }
        }
        dataGrid.setTotal(processDefinitionList.size());
        dataGrid.setResults(processDefinitionList);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"openDeployProcess"})
    public ModelAndView openDeployProcess() {
        return new ModelAndView("workflow/deployment/deploypro");
    }

    @RequestMapping(params={"deployProcess"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson deployProcess(HttpServletRequest request) {
        UploadFile uploadFile = new UploadFile(request);
        AjaxJson j = new AjaxJson();
        Map fileMap = uploadFile.getMultipartRequest().getFileMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            String fileName = file.getOriginalFilename();
            try {
                InputStream fileInputStream = file.getInputStream();
                String extension = FilenameUtils.getExtension((String)fileName);
                if (extension.equals("zip") || extension.equals("bar")) {
                    ZipInputStream zip = new ZipInputStream(fileInputStream);
                    this.repositoryService.createDeployment().addZipInputStream(zip).deploy();
                    continue;
                }
                if (extension.equals("png")) {
                    this.repositoryService.createDeployment().addInputStream(fileName, fileInputStream).deploy();
                    continue;
                }
                if (extension.indexOf("bpmn20.xml") != -1) {
                    this.repositoryService.createDeployment().addInputStream(fileName, fileInputStream).deploy();
                    continue;
                }
                if (extension.equals("bpmn")) {
                    String baseName = FilenameUtils.getBaseName((String)fileName);
                    this.repositoryService.createDeployment().addInputStream(String.valueOf(baseName) + ".bpmn20.xml", fileInputStream).deploy();
                    continue;
                }
                throw new ActivitiException("\u9519\u8bef\u4fe1\u606f:\u4e0d\u652f\u6539\u6587\u4ef6\u7c7b\u578b" + extension);
            }
            catch (Exception e) {
                this.logger.error("\u9519\u8bef\u4fe1\u606f:\u5728\u90e8\u7f72\u8fc7\u7a0b\u4e2d,\u6587\u4ef6\u8f93\u5165\u6d41\u5f02\u5e38" + e.toString());
            }
        }
        return j;
    }

    @RequestMapping(params={"startBusProcess"})
    @ResponseBody
    public AjaxJson startBusProcess(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            String businessKey = oConvertUtils.getString((String)request.getParameter("businessKey"));
            String busconfigId = oConvertUtils.getString((String)request.getParameter("busconfigKey"));
            String busTableId = oConvertUtils.getString((String)request.getParameter("busTableId"));
            TSBusConfig tsBusbase = (TSBusConfig)this.systemService.getEntity(TSBusConfig.class, (Serializable)((Object)busconfigId));
            if (tsBusbase != null) {
                Class entityClass = MyClassLoader.getClassByScn((String)tsBusbase.getTSTable().getEntityName());
                Object objbus = this.systemService.getEntity(entityClass, (Serializable)((Object)businessKey));
                TSPrjstatus prjstatus = (TSPrjstatus)this.systemService.findUniqueByProperty(TSPrjstatus.class, "code", (Object)"doing");
                ReflectHelper reflectHelper = new ReflectHelper(objbus);
                TSPrjstatus busPrjstatus = (TSPrjstatus)reflectHelper.getMethodValue("TSPrjstatus");
                String objbusstate = busPrjstatus.getCode();
                if (!prjstatus.getCode().equals(objbusstate)) {
                    HashMap<String, Object> variables = new HashMap<String, Object>();
                    variables.put(WorkFlowGlobals.BPM_DATA_ID, businessKey);
                    variables.put(WorkFlowGlobals.BPM_FORM_KEY, busTableId);
                    variables.put(WorkFlowGlobals.BPM_FORM_CONTENT_URL, "cgFormBuildController.do?ftlForm&tableName=" + busTableId + "&mode=read&load=detail&id=" + businessKey);
                    this.activitiService.startWorkflow(objbus, businessKey, variables, tsBusbase);
                    reflectHelper.setMethodValue("TSPrjstatus", (Object)prjstatus);
                    this.systemService.saveOrUpdate(objbus);
                    this.message = "\u63d0\u4ea4\u6210\u529f,\u5df2\u8fdb\u5165\u529e\u7406\u6d41\u7a0b";
                } else {
                    this.message = "\u5df2\u63d0\u4ea4,\u6b63\u5728\u529e\u7406\u4e2d";
                }
            } else {
                this.message = busconfigId.equals("undefined") ? "busconfigKey\u53c2\u6570\u672a\u8bbe\u7f6e,\u8bf7\u5728\u4e1a\u52a1\u5217\u8868\u8bbe\u7f6e\u53c2\u6570" : "\u6d41\u7a0b\u672a\u5173\u8054,\u8bf7\u5728\u6d41\u7a0b\u914d\u7f6e\u4e2d\u914d\u7f6e\u4e1a\u52a1";
            }
        }
        catch (ActivitiException e) {
            this.message = e.getMessage().indexOf("no processes deployed with key") != -1 ? "\u6ca1\u6709\u90e8\u7f72\u6d41\u7a0b!,\u8bf7\u5728\u6d41\u7a0b\u914d\u7f6e\u4e2d\u90e8\u7f72\u6d41\u7a0b" : "\u542f\u52a8\u6d41\u7a0b\u5931\u8d25!,\u5185\u90e8\u9519\u8bef";
        }
        catch (Exception e) {
            this.message = "\u542f\u52a8\u6d41\u7a0b\u5931\u8d25!,\u5185\u90e8\u9519\u8bef";
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"startOnlineProcess"})
    @ResponseBody
    public AjaxJson startOnlineProcess(String configId, String id, HttpServletRequest request) {
        this.message = "\u542f\u52a8\u6d41\u7a0b,\u6210\u529f!";
        TSBusConfig tsBusbase = (TSBusConfig)this.systemService.findUniqueByProperty(TSBusConfig.class, "onlineId", (Object)configId);
        Map dataForm = this.dataBaseService.findOneForJdbc(configId, id);
        dataForm.put(WorkFlowGlobals.BPM_DATA_ID, id);
        String BPM_FORM_CONTENT_URL = this.activitiDao.getProcessStartNodeView(tsBusbase.getTPProcess().getId());
        if (oConvertUtils.isEmpty((Object)BPM_FORM_CONTENT_URL)) {
            BPM_FORM_CONTENT_URL = "cgFormBuildController.do?ftlForm&tableName=" + configId + "&mode=read&load=detail&id=" + id;
        }
        dataForm.put(WorkFlowGlobals.BPM_FORM_CONTENT_URL, BPM_FORM_CONTENT_URL);
        dataForm.put(WorkFlowGlobals.BPM_FORM_KEY, configId);
        String create_by = dataForm.get("create_by").toString();
        String data_id = id;
        AjaxJson j = new AjaxJson();
        try {
            this.activitiService.startOnlineProcess(create_by, data_id, dataForm, tsBusbase);
        }
        catch (ActivitiException e) {
            this.message = e.getMessage().indexOf("no processes deployed with key") != -1 ? "\u6ca1\u6709\u90e8\u7f72\u6d41\u7a0b!,\u8bf7\u5728\u6d41\u7a0b\u914d\u7f6e\u4e2d\u90e8\u7f72\u6d41\u7a0b!" : "\u542f\u52a8\u6d41\u7a0b\u5931\u8d25!\u8bf7\u786e\u8ba4\u6d41\u7a0b\u548c\u8868\u5355\u662f\u5426\u5173\u8054!";
        }
        catch (Exception e) {
            this.message = "\u542f\u52a8\u6d41\u7a0b\u5931\u8d25!,\u8bf7\u786e\u8ba4\u6d41\u7a0b\u548c\u8868\u5355\u662f\u5426\u5173\u8054!";
            e.printStackTrace();
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"startUserDefinedProcess"})
    @ResponseBody
    public AjaxJson startUserDefinedProcess(String tableName, String id, String formUrl, HttpServletRequest request) {
        this.message = "\u6d41\u7a0b\u53d1\u8d77\u6210\u529f!";
        Map dataForm = this.dataBaseService.findOneForJdbc(tableName, id);
        dataForm.put(WorkFlowGlobals.BPM_DATA_ID, id);
        dataForm.put(WorkFlowGlobals.BPM_FORM_CONTENT_URL, String.valueOf(formUrl) + "&id=" + id);
        dataForm.put(WorkFlowGlobals.BPM_FORM_KEY, tableName);
        String create_by = dataForm.get("create_by").toString();
        String data_id = id;
        TSBusConfig tsBusbase = (TSBusConfig)this.systemService.findUniqueByProperty(TSBusConfig.class, "onlineId", (Object)tableName);
        AjaxJson j = new AjaxJson();
        try {
            this.activitiService.startUserDefinedProcess(create_by, data_id, dataForm, tsBusbase);
        }
        catch (ActivitiException e) {
            this.message = e.getMessage().indexOf("no processes deployed with key") != -1 ? "\u6ca1\u6709\u90e8\u7f72\u6d41\u7a0b!,\u8bf7\u5728\u6d41\u7a0b\u914d\u7f6e\u4e2d\u90e8\u7f72\u6d41\u7a0b!" : "\u542f\u52a8\u6d41\u7a0b\u5931\u8d25!\u8bf7\u786e\u8ba4\u6d41\u7a0b\u548c\u8868\u5355\u662f\u5426\u5173\u8054!";
        }
        catch (Exception e) {
            this.message = "\u542f\u52a8\u6d41\u7a0b\u5931\u8d25!,\u8bf7\u786e\u8ba4\u6d41\u7a0b\u548c\u8868\u5355\u662f\u5426\u5173\u8054!";
            e.printStackTrace();
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"claim"})
    @ResponseBody
    public AjaxJson claim(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String userId = ResourceUtil.getSessionUserName().getUserName().toString();
        String taskId = oConvertUtils.getString((String)request.getParameter("taskId"));
        this.taskService.claim(taskId, userId);
        j.setMsg("\u7b7e\u6536\u5b8c\u6210");
        return j;
    }

    @RequestMapping(params={"goEntrust"})
    public ModelAndView goEntrust(HttpServletRequest request) {
        return new ModelAndView("business/demobus/entruster");
    }

    @RequestMapping(params={"goEntrustAdd"})
    public ModelAndView goEntrustAdd(HttpServletRequest request) {
        String taskId = request.getParameter("taskId");
        request.setAttribute("taskId", (Object)taskId);
        return new ModelAndView("business/demobus/entruster-add");
    }

    @RequestMapping(params={"datagridEntruster"})
    public void datagridEntruster(ActIdUser actIdUser, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(ActIdUser.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)actIdUser, (Map)request.getParameterMap());
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"doEntrust"})
    @ResponseBody
    public AjaxJson doEntrust(ActIdUser actIdUser, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String message = "\u59d4\u6258\u6210\u529f!";
        String taskId = request.getParameter("taskId");
        try {
            ActRuTask ruTask = (ActRuTask)this.systemService.get(ActRuTask.class, (Serializable)((Object)taskId));
            ruTask.setAssignee(actIdUser.getId());
            this.systemService.saveOrUpdate((Object)ruTask);
            this.systemService.addLog(message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            message = "\u59d4\u6258\u5931\u8d25!";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(message);
        return j;
    }

    @RequestMapping(params={"openProcessPic"})
    public ModelAndView openProcessPic(HttpServletRequest request) {
        String tag = oConvertUtils.getString((String)request.getParameter("tag"));
        if (tag.equals("task")) {
            String taskId = oConvertUtils.getString((String)request.getParameter("taskId"));
            Task task = this.activitiService.getTask(taskId);
            String processInstanceId = task.getProcessInstanceId();
            ActivityImpl activityImpl = this.activitiService.getProcessMap(processInstanceId);
            request.setAttribute("activityImpl", (Object)activityImpl);
            request.setAttribute("processInstanceId", (Object)processInstanceId);
        } else if (tag.equals("deployment")) {
            request.setAttribute("resourceName", (Object)oConvertUtils.getString((String)request.getParameter("resourceName")));
            request.setAttribute("deploymentId", (Object)oConvertUtils.getString((String)request.getParameter("deploymentId")));
        } else if (tag.equals("project")) {
            String businessKey = oConvertUtils.getString((String)request.getParameter("businessKey"));
            HistoricProcessInstance historicProcessInstance = this.activitiService.getHiProcInstByBusKey(businessKey);
            String processInstanceId = historicProcessInstance.getId();
            ActivityImpl activityImpl = this.activitiService.getProcessMap(processInstanceId);
            request.setAttribute("activityImpl", (Object)activityImpl);
            request.setAttribute("processInstanceId", (Object)processInstanceId);
        }
        request.setAttribute("tag", (Object)tag);
        return new ModelAndView("workflow/process/processPic");
    }

    @RequestMapping(params={"processPic"})
    public void processPic(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("UTF-8");
        response.setCharacterEncoding("UTF-8");
        String processInstanceId = oConvertUtils.getString((String)request.getParameter("processInstanceId"));
        HistoryProcessInstanceDiagramCmd cmd = new HistoryProcessInstanceDiagramCmd(processInstanceId);
        ProcessEngine processEngine = ProcessEngines.getDefaultProcessEngine();
        InputStream is = (InputStream)processEngine.getManagementService().executeCommand((Command)cmd);
        int len = 0;
        byte[] b = new byte[1024];
        while ((len = is.read(b, 0, 1024)) != -1) {
            response.getOutputStream().write(b, 0, len);
        }
    }

    @RequestMapping(params={"processPicByDeploy"})
    public void processPicByDeploy(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String deploymentId = oConvertUtils.getString((String)request.getParameter("deploymentId"));
        String resourceName = oConvertUtils.getString((String)request.getParameter("resourceName"));
        InputStream resourceAsStream = this.repositoryService.getResourceAsStream(deploymentId, resourceName);
        byte[] b = new byte[1024];
        int len = -1;
        while ((len = resourceAsStream.read(b, 0, 1024)) != -1) {
            response.getOutputStream().write(b, 0, len);
        }
        response.getOutputStream().flush();
        response.getOutputStream().close();
    }

    @RequestMapping(params={"processBpmXmlByDeploy"})
    public void processBpmXmlByDeploy(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String deploymentId = oConvertUtils.getString((String)request.getParameter("deploymentId"));
        String resourceName = oConvertUtils.getString((String)request.getParameter("resourceName"));
        InputStream resourceAsStream = this.repositoryService.getResourceAsStream(deploymentId, resourceName);
        File file = new File(resourceName);
        String filename = file.getName();
        response.reset();
        response.setContentType("text/html;charset=utf-8");
        request.setCharacterEncoding("UTF-8");
        response.addHeader("Content-Length", "" + file.length());
        BufferedOutputStream toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-disposition", "attachment;filename=" + new String(filename.getBytes("utf-8"), "ISO8859-1"));
        int bytesRead = 0;
        byte[] buffer = new byte[1024];
        while ((bytesRead = resourceAsStream.read(buffer, 0, 1024)) != -1) {
            ((OutputStream)toClient).write(buffer, 0, bytesRead);
        }
        ((OutputStream)toClient).flush();
        ((OutputStream)toClient).close();
    }

    @RequestMapping(params={"taskList"})
    public void taskList(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        TSUser user = ResourceUtil.getSessionUserName();
        String buscode = oConvertUtils.getString((String)request.getParameter("busCode"));
        TSTable table = (TSTable)this.systemService.findUniqueByProperty(TSTable.class, "entityKey", (Object)buscode);
        if (table != null) {
            List tsBusConfigs = this.systemService.findByProperty(TSBusConfig.class, "TSTable.id", (Object)table.getId());
            List taskList = this.activitiService.findTodoTasks(user.getUserName(), tsBusConfigs);
            dataGrid.setTotal(taskList.size());
            dataGrid.setResults(taskList);
            TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
        }
    }

    @RequestMapping(params={"openProcessHandle"})
    public ModelAndView openProcessHandle(HttpServletRequest request) {
        String taskId = oConvertUtils.getString((String)request.getParameter("taskId"));
        ProcessHandle processHandle = this.activitiService.getProcessHandle(taskId);
        List<PvmTransition> pvmTransitionList = this.activitiService.getOutgoingTransitions(taskId);
        request.setAttribute("PvmTransition", pvmTransitionList);
        if (processHandle.getTpForm() != null) {
            TPForm tForm = processHandle.getTpForm();
            List<TPFormpro> formpros = tForm.getTPFormpros();
            request.setAttribute("formpros", formpros);
            request.setAttribute("action", (Object)tForm.getFormaction());
            this.modelAndView = new ModelAndView("workflow/processHandle/dynamicHandle");
        } else {
            String modelandview = oConvertUtils.getString((String)processHandle.getTpProcessnode().getModelandview(), (String)"activitiController.do?processHandle");
            this.modelAndView = new ModelAndView((View)new RedirectView(modelandview), "taskId", (Object)taskId);
        }
        return this.modelAndView;
    }

    @RequestMapping(params={"openNewProcessHandle"})
    public ModelAndView openNewProcessHandle(HttpServletRequest request) {
        String taskId = oConvertUtils.getString((String)request.getParameter("taskId"));
        List<PvmTransition> pvmTransitionList = this.activitiService.getOutgoingTransitions(taskId);
        request.setAttribute("PvmTransition", pvmTransitionList);
        this.modelAndView = new ModelAndView((View)new RedirectView("activitiController.do?processHandle"), "taskId", (Object)taskId);
        return this.modelAndView;
    }

    @RequestMapping(params={"processHandle"})
    public ModelAndView processHandle(HttpServletRequest request) {
        String taskId = oConvertUtils.getString((String)request.getParameter("taskId"));
        request.setAttribute("taskId", (Object)taskId);
        return new ModelAndView("workflow/processhandle/processHandle");
    }

    @RequestMapping(params={"processComplete"})
    @ResponseBody
    public AjaxJson processComplete(HttpServletRequest request, Variable var) throws Exception {
        AjaxJson j = new AjaxJson();
        String taskId = oConvertUtils.getString((String)request.getParameter("taskId"));
        String nextnode = oConvertUtils.getString((String)request.getParameter("nextnode"));
        Integer nextCodeCount = oConvertUtils.getInt((String)request.getParameter("nextCodeCount"));
        String way = oConvertUtils.getString((String)request.getParameter("way"));
        ProcessHandle processHandle = this.activitiService.getProcessHandle(taskId);
        String model = oConvertUtils.getString((String)request.getParameter("model"));
        String nextUser = oConvertUtils.getString((String)request.getParameter("id"));
        String rejectNode = oConvertUtils.getString((String)request.getParameter("rejectModelNode"));
        Map<String, Object> map = var.getVariableMap(processHandle.getTpProcesspros());
        Task task = this.activitiService.getTask(taskId);
        String processInstanceId = task.getProcessInstanceId();
        boolean bflag = this.taskJeecgService.checkUserTaskIsHuiQian(taskId, nextnode);
        if (bflag) {
            if (oConvertUtils.isEmpty((Object)nextUser)) {
                j.setSuccess(false);
                j.setMsg("\u63d0\u4ea4\u5931\u8d25\uff0c\u4e0b\u4e00\u4efb\u52a1\u662f\u4f1a\u7b7e\u8282\u70b9\uff0c\u8bf7\u9009\u62e9\u4f1a\u7b7e\u4eba\u5458");
                return j;
            }
            map.put(WorkFlowGlobals.ASSIGNEE_USER_ID_LIST, nextUser);
        }
        try {
            String nextTskId;
            if ("1".equals(model)) {
                if ("end".equals(nextnode)) {
                    this.taskJeecgService.endProcess(taskId);
                } else {
                    if (nextCodeCount == 1) {
                        this.taskService.complete(taskId, map);
                    } else {
                        this.taskJeecgService.goProcessTaskNode(taskId, nextnode, map);
                    }
                    if (!bflag) {
                        nextTskId = this.taskJeecgService.getTaskIdByProins(processInstanceId, nextnode);
                        if (oConvertUtils.isNotEmpty((Object)nextUser)) {
                            if (nextUser.indexOf(",") < 0) {
                                this.taskService.setAssignee(nextTskId, nextUser);
                            } else {
                                this.taskService.setAssignee(nextTskId, "");
                                this.taskService.addCandidateUser(nextTskId, nextUser);
                            }
                        }
                    }
                }
            } else if ("2".equals(model)) {
                this.taskService.complete(taskId, map);
            } else {
                this.taskJeecgService.goProcessTaskNode(taskId, rejectNode, map);
                nextTskId = this.taskJeecgService.getTaskIdByProins(processInstanceId, rejectNode);
                if (oConvertUtils.isNotEmpty((Object)nextUser)) {
                    if (nextUser.indexOf(",") < 0) {
                        this.taskService.setAssignee(nextTskId, nextUser);
                    } else {
                        this.taskService.setAssignee(nextTskId, "");
                        this.taskService.addCandidateUser(nextTskId, nextUser);
                    }
                }
            }
            String reason = oConvertUtils.getString((String)request.getParameter("reason"));
            TPBpmLog tpbpmLog = new TPBpmLog();
            TSUser user = ResourceUtil.getSessionUserName();
            tpbpmLog.setBpm_id(task.getProcessInstanceId());
            tpbpmLog.setTask_name(processHandle.getTpProcess().getProcessname());
            tpbpmLog.setTask_node(processHandle.getTpProcessnode().getProcessnodename());
            tpbpmLog.setOp_code(user.getUserKey());
            tpbpmLog.setOp_name(user.getRealName());
            tpbpmLog.setOp_time(DataUtils.gettimestamp());
            tpbpmLog.setMemo(reason);
            this.systemService.save((Object)tpbpmLog);
            j.setMsg("\u4efb\u52a1\u6267\u884c\u6210\u529f");
            j.setObj((Object)tpbpmLog);
        }
        catch (Exception e) {
            j.setMsg("\u4efb\u52a1\u6267\u884c\u5931\u8d25");
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(params={"deleteProcess"})
    @ResponseBody
    public AjaxJson deleteProcess(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String deploymentId = oConvertUtils.getString((String)request.getParameter("deploymentId"));
        String key = oConvertUtils.getString((String)request.getParameter("key"));
        TPProcess process = (TPProcess)this.systemService.findUniqueByProperty(TPProcess.class, "processkey", (Object)key);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deploymentId).processDefinitionKey(key).singleResult();
        List actHiProcinsts = this.systemService.findByProperty(ActHiProcinst.class, "procDefId", (Object)processDefinition.getId());
        if (actHiProcinsts.size() <= 0) {
            this.repositoryService.deleteDeployment(deploymentId, true);
            process.setProcessstate(WorkFlowGlobals.Process_Deploy_NO);
            this.systemService.updateEntitie((Object)process);
            this.message = "\u6d41\u7a0b\u5220\u9664\u6210\u529f";
        } else {
            this.message = "\u6d41\u7a0b\u8ddf\u4e1a\u52a1\u5df2\u5173\u8054\u65e0\u6cd5\u5220\u9664";
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"setProcessState"})
    @ResponseBody
    public AjaxJson setProcessState(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String state = oConvertUtils.getString((String)request.getParameter("state"));
        String processDefinitionId = oConvertUtils.getString((String)request.getParameter("processDefinitionId"));
        if (state.equals("active")) {
            this.repositoryService.activateProcessDefinitionById(processDefinitionId, true, null);
            this.message = "\u6d41\u7a0b\u5df2\u6fc0\u6d3b";
        } else {
            this.repositoryService.suspendProcessDefinitionById(processDefinitionId, true, null);
            this.message = "\u6d41\u7a0b\u5df2\u6302\u8d77";
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"getUsers"})
    @ResponseBody
    public void getUsers(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(User.class, dataGrid);
        List userList = this.identityService.createUserQuery().list();
        dataGrid.setTotal(userList.size());
        dataGrid.setResults(userList);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"getGroups"})
    @ResponseBody
    public void getGroups(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        List groupList = this.identityService.createGroupQuery().list();
        dataGrid.setTotal(groupList.size());
        dataGrid.setResults(groupList);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"taskRunningList"})
    public ModelAndView taskRunningList(HttpServletRequest request) {
        return new ModelAndView("business/demobus/taskRunningList");
    }

    @RequestMapping(params={"taskRunningGrid"})
    public void taskRunningGrid(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        int allCounts = (int)this.runtimeService.createProcessInstanceQuery().count();
        int pageSize = dataGrid.getRows();
        int curPageNO = PagerUtil.getcurPageNo((int)allCounts, (int)dataGrid.getPage(), (int)pageSize);
        int offset = PagerUtil.getOffset((int)allCounts, (int)curPageNO, (int)pageSize);
        List list = this.runtimeService.createProcessInstanceQuery().listPage(offset, pageSize);
        dataGrid.setResults(list);
        dataGrid.setTotal(list.size());
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"taskFinishedList"})
    public ModelAndView taskFinishedList(HttpServletRequest request) {
        return new ModelAndView("business/demobus/taskFinishedList");
    }

    @RequestMapping(params={"taskFinishedGrid"})
    public void taskFinishedGrid(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        int allCounts = (int)this.historyService.createHistoricProcessInstanceQuery().count();
        int pageSize = dataGrid.getRows();
        int curPageNO = PagerUtil.getcurPageNo((int)allCounts, (int)dataGrid.getPage(), (int)pageSize);
        int offset = PagerUtil.getOffset((int)allCounts, (int)curPageNO, (int)pageSize);
        List list = this.historyService.createHistoricProcessInstanceQuery().finished().listPage(offset, pageSize);
        dataGrid.setResults(list);
        dataGrid.setTotal(allCounts);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"traceImage"})
    public void traceImage(@RequestParam(value="processInstanceId") String processInstanceId, HttpServletResponse response) throws Exception {
        HistoryProcessInstanceDiagramCmd cmd = new HistoryProcessInstanceDiagramCmd(processInstanceId);
        ProcessEngine processEngine = ProcessEngines.getDefaultProcessEngine();
        InputStream is = (InputStream)processEngine.getManagementService().executeCommand((Command)cmd);
        int len = 0;
        byte[] b = new byte[1024];
        while ((len = is.read(b, 0, 1024)) != -1) {
            response.getOutputStream().write(b, 0, len);
        }
    }

    @RequestMapping(params={"viewProcessInstanceHistory"})
    public ModelAndView viewProcessInstanceHistory(@RequestParam(value="processInstanceId") String processInstanceId, HttpServletRequest request, HttpServletResponse respone, Model model) {
        model.addAttribute("processInstanceId", (Object)processInstanceId);
        List historicTasks = this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId).list();
        model.addAttribute((Object)historicTasks);
        request.setAttribute("historicTasks", (Object)historicTasks);
        HistoryProcessInstanceDiagramPositionCmd cmd = new HistoryProcessInstanceDiagramPositionCmd(processInstanceId);
        ProcessEngine processEngine = ProcessEngines.getDefaultProcessEngine();
        List is = (List)processEngine.getManagementService().executeCommand((Command)cmd);
        request.setAttribute("listIs", (Object)is);
        return new ModelAndView("workflow/activiti/viewProcessInstanceHistory");
    }

    @RequestMapping(params={"taskHistoryList"})
    public void taskHistoryList(@RequestParam(value="processInstanceId") String processInstanceId, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        List<Map<String, Object>> startAndEndlist = this.activitiDao.getActHiActinst(processInstanceId);
        List historicTasks = this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId).list();
        String start_user_id = this.activitiDao.getProcessStartUserId(processInstanceId);
        String end_user_id = "";
        List<Map<String, Object>> taskinstList = this.activitiDao.getProcessEndUserId(processInstanceId, 1, 1);
        if (taskinstList != null) {
            Map<String, Object> map = taskinstList.get(0);
            end_user_id = map.get("ASSIGNEE_") == null ? "" : (String)map.get("ASSIGNEE_");
        }
        StringBuffer rows = new StringBuffer();
        for (Map<String, Object> m : startAndEndlist) {
            if (!"startEvent".equals(m.get("ACT_TYPE_"))) continue;
            rows.append("{'name':'" + m.get("ACT_ID_") + "','processInstanceId':'" + m.get("EXECUTION_ID_") + "','startTime':'" + m.get("START_TIME_") + "','endTime':'" + m.get("END_TIME_") + "','assignee':'" + this.taskJeecgService.getUserRealName(start_user_id) + "','deleteReason':'" + StringUtils.trimToEmpty((String)"\u5df2\u5b8c\u6210") + "'},");
        }
        for (HistoricTaskInstance hi : historicTasks) {
            String starttime = hi.getStartTime() == null ? "" : DateFormatUtils.format((Date)hi.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            String endtime = hi.getEndTime() == null ? "" : DateFormatUtils.format((Date)hi.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss");
            rows.append("{'name':'" + hi.getName() + "','processInstanceId':'" + hi.getProcessInstanceId() + "','startTime':'" + starttime + "','endTime':'" + endtime + "','assignee':'" + this.taskJeecgService.getUserRealName(hi.getAssignee()) + "','deleteReason':'" + ("completed".equals(StringUtils.trimToEmpty((String)hi.getDeleteReason())) ? "\u5df2\u5b8c\u6210" : StringUtils.trimToEmpty((String)hi.getDeleteReason())) + "'},");
        }
        for (Map<String, Object> m : startAndEndlist) {
            if (!"endEvent".equals(m.get("ACT_TYPE_"))) continue;
            rows.append("{'name':'" + m.get("ACT_ID_") + "','processInstanceId':'" + m.get("EXECUTION_ID_") + "','startTime':'" + m.get("START_TIME_") + "','endTime':'" + m.get("END_TIME_") + "','assignee':'" + this.taskJeecgService.getUserRealName(end_user_id) + "','deleteReason':'" + StringUtils.trimToEmpty((String)"\u5df2\u5b8c\u6210") + "'},");
        }
        String rowStr = StringUtils.substringBeforeLast((String)rows.toString(), (String)",");
        JSONObject jObject = JSONObject.fromObject((Object)("{'total':" + (historicTasks.size() + startAndEndlist.size()) + ",'rows':[" + rowStr + "]}"));
        this.responseDatagrid(response, jObject);
    }

    public void responseDatagrid(HttpServletResponse response, JSONObject jObject) {
        response.setContentType("application/json");
        response.setHeader("Cache-Control", "no-store");
        try {
            PrintWriter pw = response.getWriter();
            pw.write(jObject.toString());
            pw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"waitingClaimTask"})
    public ModelAndView waitingClaimTask() {
        return new ModelAndView("workflow/activiti/waitingClaimTask");
    }

    @RequestMapping(params={"waitingClaimTaskDataGrid"})
    public void waitingClaimTaskDataGrid(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        String userId = ResourceUtil.getSessionUserName().getUserName();
        TaskService taskService = this.processEngine.getTaskService();
        List tasks = taskService.createTaskQuery().taskCandidateUser(userId).active().list();
        StringBuffer rows = new StringBuffer();
        for (Task t : tasks) {
            rows.append("{'name':'" + t.getName() + "','taskId':'" + t.getId() + "','processDefinitionId':'" + t.getProcessDefinitionId() + "'},");
        }
        String rowStr = StringUtils.substringBeforeLast((String)rows.toString(), (String)",");
        JSONObject jObject = JSONObject.fromObject((Object)("{'total':" + tasks.size() + ",'rows':[" + rowStr + "]}"));
        this.responseDatagrid(response, jObject);
    }

    @RequestMapping(params={"claimedTask"})
    public ModelAndView claimedTask() {
        return new ModelAndView("workflow/activiti/claimedTask");
    }

    @RequestMapping(params={"claimedTaskDataGrid"})
    public void claimedTaskDataGrid(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        String userId = ResourceUtil.getSessionUserName().getUserName();
        TaskService taskService = this.processEngine.getTaskService();
        List tasks = taskService.createTaskQuery().taskAssignee(userId).list();
        StringBuffer rows = new StringBuffer();
        for (Task t : tasks) {
            rows.append("{'name':'" + t.getName() + "','description':'" + t.getDescription() + "','taskId':'" + t.getId() + "','processDefinitionId':'" + t.getProcessDefinitionId() + "','processInstanceId':'" + t.getProcessInstanceId() + "'},");
        }
        String rowStr = StringUtils.substringBeforeLast((String)rows.toString(), (String)",");
        JSONObject jObject = JSONObject.fromObject((Object)("{'total':" + tasks.size() + ",'rows':[" + rowStr + "]}"));
        this.responseDatagrid(response, jObject);
    }

    @RequestMapping(params={"finishedTask"})
    public ModelAndView finishedTask() {
        return new ModelAndView("workflow/activiti/finishedTask");
    }

    @RequestMapping(params={"finishedTaskDataGrid"})
    public void finishedTask(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        String userId = ResourceUtil.getSessionUserName().getUserName();
        List historicTasks = this.historyService.createHistoricTaskInstanceQuery().taskAssignee(userId).finished().list();
        StringBuffer rows = new StringBuffer();
        for (HistoricTaskInstance t : historicTasks) {
            rows.append("{'name':'" + t.getName() + "','description':'" + t.getDescription() + "','taskId':'" + t.getId() + "','processDefinitionId':'" + t.getProcessDefinitionId() + "','processInstanceId':'" + t.getProcessInstanceId() + "'},");
        }
        String rowStr = StringUtils.substringBeforeLast((String)rows.toString(), (String)",");
        JSONObject jObject = JSONObject.fromObject((Object)("{'total':" + historicTasks.size() + ",'rows':[" + rowStr + "]}"));
        this.responseDatagrid(response, jObject);
    }

    @RequestMapping(params={"claimTask"})
    @ResponseBody
    public AjaxJson claimTask(@RequestParam(value="taskId") String taskId, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String userId = ResourceUtil.getSessionUserName().getUserName();
        TaskService taskService = this.processEngine.getTaskService();
        taskService.claim(taskId, userId);
        String message = "\u7b7e\u6536\u6210\u529f";
        j.setMsg(message);
        return j;
    }

    @RequestMapping(params={"saveBpmFiles"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveBpmFiles(HttpServletRequest request, HttpServletResponse response, TPBpmFile tpbpmFile) {
        AjaxJson j = new AjaxJson();
        HashMap<String, String> attributes = new HashMap<String, String>();
        String fileKey = oConvertUtils.getString((String)request.getParameter("fileKey"));
        String bpmLogId = oConvertUtils.getString((String)request.getParameter("bpmlogId"));
        if (oConvertUtils.isNotEmpty((Object)fileKey)) {
            tpbpmFile.setId(fileKey);
            tpbpmFile = (TPBpmFile)this.systemService.getEntity(TPBpmFile.class, (Serializable)((Object)fileKey));
        }
        TPBpmLog bpmlog = (TPBpmLog)this.systemService.getEntity(TPBpmLog.class, (Serializable)((Object)bpmLogId));
        tpbpmFile.setBpmlog(bpmlog);
        tpbpmFile.setCreatedate(DataUtils.gettimestamp());
        tpbpmFile.setFile_name("");
        tpbpmFile.setPath("");
        UploadFile uploadFile = new UploadFile(request, (Object)tpbpmFile);
        uploadFile.setCusPath("files");
        uploadFile.setSwfpath("swfpath");
        uploadFile.setByteField(null);
        tpbpmFile = (TPBpmFile)this.systemService.uploadFile(uploadFile);
        attributes.put("fileKey", tpbpmFile.getId());
        attributes.put("viewhref", "commonController.do?objfileList&fileKey=" + tpbpmFile.getId());
        attributes.put("delurl", "commonController.do?delObjFile&fileKey=" + tpbpmFile.getId());
        j.setMsg("\u5904\u7406\u6210\u529f");
        j.setAttributes(attributes);
        return j;
    }
}

