<#assign CACHE_VERSION = "cv=1.1.4">
<#assign base = springMacroRequestContext.getContextUrl("")>

<!DOCTYPE html>
<html lang="zh-Hans">

<head>
  <title></title>
  <#include "ftl/generate/head.ftl">
</head>

<body style="background-color: transparent;">

	<div id="app" style="opacity: 0" :style="{opacity: '1'}">
		<#include "ftl/generate/template.ftl">
	</div>

	<#-- importJmForm 导入编译后的表单设计器 -->
	<#--noinspection HtmlUnknownTarget,JSUnresolvedVariable,FtlReferencesInspection-->
	<script src="${baseJmForm}/JmForm.umd.js?${CACHE_VERSION}"></script>
	<#--noinspection FtlReferencesInspection-->
	<script src="${base}/desform/utils.js?${CACHE_VERSION}"></script>
	<script>

		// vuex 缓存
		var store = JmForm.default.store
		// 日期 moment
		var moment = JmForm.default.moment
		// 设备类型混入
		var DeviceMixins = JmForm.default.mixins.DeviceMixins
		// 常量
		var constant = JmForm.default.constant

	</script>

	<script>

		// 从配置里读取主题颜色
		window['THEME_COLOR'] = '${themeColor}'
		// 从配置里读取上传方式
		window['UPLOAD_TYPE'] = '${uploadType}'
		// 从配置里读取签名秘钥
		window['SIGNATURE_SECRET']= '${signatureSecret}'

		// 获取token等参数
		var token = getQueryParams("token")
		var messageId = getQueryParams("messageId")
		var tenantId = getQueryParams("tenantId")

		// 是否在内部发送请求
		var innerRequest = getQueryParams("innerRequest")
		innerRequest = !(innerRequest === 'false')
		// 是否在内部展示对话框，如果此项为 true 则 innerRequest如论如何都为 true
		var innerDialog = getQueryParams("innerDialog")
		innerDialog = (innerDialog === 'true')
		innerRequest = innerDialog === true ? true : innerRequest

    //默认跳转模式（跳转成功页面）
    var skip = getQueryParams("skip")
    skip = !(skip === 'false')

		// 判断是否禁止滚动
		var disableScroll = getQueryParams("disableScroll")
		if (!!(disableScroll === 'true')) {
			document.body.style.overflow = 'hidden'
		}

		Vue.ls.set(constant.BASE_URL, '${baseURL}')
		Vue.ls.set(constant.ACCESS_TOKEN, token)
		Vue.ls.set(constant.TENANT_ID, tenantId)

		var isExternal = false
    var ExternalMixins = {
      data: function () {
        return { isExternal: false, externalSavedList: [] }
      },
    }

	</script>

	<#include "ftl/generate/script.ftl" >

</body>

</html>