/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.adapter.delegate.datahandle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.MatchTypeEnum;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.modules.extbpm.process.adapter.entity.ChildAttr;
import org.jeecg.modules.extbpm.process.entity.ExtActProcess;
import org.jeecg.modules.extbpm.process.entity.ExtActProcessNode;
import org.jeecg.modules.joa.util.ProcessUtils;
import org.jeecg.modules.online.desform.entity.DesignFormData;
import org.jeecg.modules.online.desform.service.IDesignFormDataService;
import org.jeecg.modules.online.desform.vo.query.DesformSuperQuery;
import org.jeecg.modules.online.desform.vo.query.SuperQueryItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseDataDelegate {
    private static final Logger log = LoggerFactory.getLogger(BaseDataDelegate.class);
    @Autowired
    public IDesignFormDataService designFormDataService;
    @Autowired
    public RedisUtil redisUtil;
    public String processInstanceId;
    public String processDefinitionKey;
    public ExtActProcess extActProcess;
    public String processId;
    public String activityId;
    public ProcessUtils processUtils;
    public ExtActProcessNode extActProcessNode;
    public ChildAttr childAttr;
    public DelegateExecution delegateExecution;

    public Boolean init(DelegateExecution delegateExecution) {
        ExecutionEntity executionEntity = (ExecutionEntity)delegateExecution;
        this.delegateExecution = delegateExecution;
        this.processInstanceId = delegateExecution.getProcessInstanceId();
        this.processUtils = (ProcessUtils)SpringContextUtils.getBean((String)"processUtils");
        this.processDefinitionKey = executionEntity.getProcessDefinitionKey();
        this.extActProcess = this.processUtils.getExtActProcessByProcessKey(this.processDefinitionKey);
        if (ObjectUtils.isNotEmpty((Object)this.extActProcess)) {
            this.processId = this.extActProcess.getId();
            this.activityId = executionEntity.getActivityId();
            if (ObjectUtils.isNotEmpty((Object)this.extActProcess)) {
                String string;
                this.extActProcessNode = this.processUtils.getExtActProcessNodeByIdAndCode(this.processId, this.activityId);
                if (ObjectUtils.isNotEmpty((Object)this.extActProcessNode) && StringUtils.isNotEmpty((CharSequence)(string = this.extActProcessNode.getNodeConfigJson()))) {
                    this.childAttr = (ChildAttr)JSON.parseObject((String)string, ChildAttr.class);
                    return true;
                }
            }
        }
        return false;
    }

    public void executeAdd() {
        if (ObjectUtils.isNotEmpty((Object)this.childAttr)) {
            String string = this.childAttr.getFormModel();
            String string2 = this.childAttr.getFormTableCode();
            DesignFormData designFormData = new DesignFormData();
            designFormData.setDesformCode(string2);
            designFormData.setDesformData(JSON.parseObject((String)string));
            Result result = this.designFormDataService.addOne(designFormData);
            if (result.isSuccess()) {
                JSONObject jSONObject = (JSONObject)result.getResult();
                String string3 = MessageFormat.format("flow:task:form_data:{0}:{1}", this.processInstanceId, this.activityId);
                String string4 = jSONObject.getString("dataId");
                log.debug("------------\u6dfb\u52a0\u6570\u636e\u8282\u70b9: {}--------------", (Object)string4);
                this.delegateExecution.setVariable(string3, (Object)string4);
            }
        }
    }

    public DesformSuperQuery initSuperQuery() {
        DesformSuperQuery desformSuperQuery = new DesformSuperQuery();
        JSONArray jSONArray = JSONArray.parseArray((String)this.childAttr.getSearchFieldGroup());
        if (ObjectUtils.isNotEmpty((Object)jSONArray)) {
            JSONObject jSONObject = jSONArray.getJSONObject(0);
            String string = StringUtils.isEmpty((CharSequence)jSONObject.getString("matchType")) ? MatchTypeEnum.AND.name() : jSONObject.getString("matchType");
            String string2 = jSONObject.getString("queryItems");
            List list = JSONArray.parseArray((String)string2, SuperQueryItem.class);
            desformSuperQuery.setMatchType(MatchTypeEnum.getByValue((String)string));
            desformSuperQuery.setQueryItems(list);
        }
        return desformSuperQuery;
    }

    public List<DesignFormData> executeQuery() {
        if (ObjectUtils.isNotEmpty((Object)this.childAttr)) {
            Boolean bl;
            String string;
            Object object;
            String string2 = this.childAttr.getFormTableCode();
            DesformSuperQuery desformSuperQuery = this.initSuperQuery();
            Page page = new Page();
            if (ObjectUtils.isNotEmpty((Object)desformSuperQuery)) {
                object = this.childAttr.getSortField();
                string = this.childAttr.getSortType();
                bl = this.childAttr.getIgnoreSortRule();
                if (StringUtils.isNotEmpty((CharSequence)object) && !bl.booleanValue()) {
                    List<OrderItem> list = BaseDataDelegate.getQueryConditionOrders((String)object, string);
                    page.setOrders(list);
                }
            }
            if (ObjectUtils.isNotEmpty((Object)(object = this.childAttr.getLimitNum()))) {
                page.setSize(((Long)object).longValue());
            }
            string = this.designFormDataService.pageList(string2, page, desformSuperQuery);
            bl = (IPage)string.getResult();
            return bl.getRecords();
        }
        return null;
    }

    private static List<OrderItem> getQueryConditionOrders(String sortField, String sortType) {
        ArrayList<OrderItem> arrayList = new ArrayList<OrderItem>();
        if ("desc".equals(sortType)) {
            arrayList.add(OrderItem.desc((String)sortField));
        } else {
            arrayList.add(OrderItem.asc((String)sortField));
        }
        return arrayList;
    }
}

