/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.inf.iis.bcs.policy;

import com.baidu.inf.iis.bcs.model.BCSClientException;
import com.baidu.inf.iis.bcs.model.Pair;
import com.baidu.inf.iis.bcs.policy.PolicyAction;
import com.baidu.inf.iis.bcs.policy.PolicyEffect;
import com.baidu.inf.iis.bcs.policy.PolicyIP;
import com.baidu.inf.iis.bcs.policy.PolicyTime;
import com.baidu.inf.iis.bcs.policy.Statement;
import flexjson.JSONDeserializer;
import flexjson.JSONSerializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Policy {
    private static final Log log = LogFactory.getLog(Policy.class);
    List<Statement> statements = new ArrayList<Statement>();
    private String originalJsonStr;

    public static void main(String[] stringArray) {
        Policy policy = new Policy();
        Statement statement = new Statement();
        statement.addAction(PolicyAction.get_bucket_policy).addAction(PolicyAction.put_bucket_policy).addAction(PolicyAction.all);
        statement.addResource("/1").addResource("/2").addResource("/3");
        statement.addUser("user1").addUser("user2");
        statement.setEffect(PolicyEffect.allow);
        PolicyTime policyTime = new PolicyTime();
        policyTime.addSingleTime("2012-01-04D12:12:1").addSingleTime("2012-01-04D12:12:2").addTimeRange(new Pair<String>("2012-01-04D12:12:3", "2012-01-04D12:12:4"));
        statement.setTime(policyTime);
        PolicyIP policyIP = new PolicyIP();
        policyIP.addSingleIp("1.1.1.1").addCidrIp("2.2.2.2/16").addIpRange(new Pair<String>("3.3.3.3", "4.4.4.4"));
        statement.setIp(policyIP);
        Statement statement2 = new Statement();
        statement2.addAction(PolicyAction.get_bucket_policy).addAction(PolicyAction.put_bucket_policy);
        statement2.addResource("/1").addResource("/2").addResource("/3");
        statement2.addUser("user1").addUser("user2");
        statement2.setEffect(PolicyEffect.deny);
        policy.addStatements(statement);
        policy.addStatements(statement2);
        String string = policy.toJson();
        log.info((Object)("Policy object to json str:\n" + string));
        policy = new Policy().buildJsonStr(string);
        String string2 = policy.toJson();
        log.info((Object)("Json str 2 policy object 2 json str:\n" + string2));
        if (string.equals(string2)) {
            log.info((Object)"Correct");
        } else {
            log.info((Object)"Invalid");
        }
    }

    public Policy addStatements(Statement statement) {
        this.statements.add(statement);
        return this;
    }

    public Policy buildJsonStr(String string) {
        this.originalJsonStr = string;
        JSONDeserializer jSONDeserializer = new JSONDeserializer();
        HashMap hashMap = (HashMap)jSONDeserializer.deserialize(string);
        ArrayList arrayList = (ArrayList)hashMap.get("statements");
        for (HashMap hashMap2 : arrayList) {
            Object e;
            Object object;
            Iterator iterator2;
            Statement statement = new Statement();
            for (Iterator iterator2 : (ArrayList)hashMap2.get("action")) {
                statement.addAction(PolicyAction.toPolicyAction((String)((Object)iterator2)));
            }
            for (Iterator iterator2 : (ArrayList)hashMap2.get("user")) {
                statement.addUser((String)((Object)iterator2));
            }
            for (Iterator iterator2 : (ArrayList)hashMap2.get("resource")) {
                statement.addResource((String)((Object)iterator2));
            }
            statement.setEffect(PolicyEffect.valueOf((String)hashMap2.get("effect")));
            if (null != hashMap2.get("time")) {
                object = new PolicyTime();
                iterator2 = ((ArrayList)hashMap2.get("time")).iterator();
                while (iterator2.hasNext()) {
                    e = iterator2.next();
                    if (e instanceof String) {
                        ((PolicyTime)object).addSingleTime((String)e);
                        continue;
                    }
                    if (e instanceof List) {
                        ((PolicyTime)object).addTimeRange(new Pair<String>((String)((List)e).get(0), (String)((List)e).get(1)));
                        continue;
                    }
                    throw new BCSClientException("Analyze policy time failed.");
                }
                statement.setTime((PolicyTime)object);
            }
            if (null != hashMap2.get("ip")) {
                object = new PolicyIP();
                iterator2 = ((ArrayList)hashMap2.get("ip")).iterator();
                while (iterator2.hasNext()) {
                    e = iterator2.next();
                    if (e instanceof String) {
                        if (((String)e).indexOf("/") != -1) {
                            ((PolicyIP)object).addCidrIp((String)e);
                            continue;
                        }
                        ((PolicyIP)object).addSingleIp((String)e);
                        continue;
                    }
                    if (e instanceof List) {
                        ((PolicyIP)object).addIpRange(new Pair<String>((String)((List)e).get(0), (String)((List)e).get(1)));
                        continue;
                    }
                    throw new BCSClientException("Analyze policy time failed.");
                }
                statement.setIp((PolicyIP)object);
            }
            this.addStatements(statement);
        }
        return this;
    }

    public String getOriginalJsonStr() {
        return this.originalJsonStr;
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public void setStatements(List<Statement> list) {
        this.statements = list;
    }

    public String toJson() {
        if (this.statements.size() == 0) {
            return "";
        }
        JSONSerializer jSONSerializer = new JSONSerializer();
        HashMap hashMap = new HashMap();
        hashMap.put("statements", new ArrayList());
        for (Statement statement : this.statements) {
            ArrayList<String> arrayList;
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            hashMap2.put("user", statement.getUser());
            hashMap2.put("resource", statement.getResource());
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (PolicyAction policyAction : statement.getAction()) {
                arrayList2.add(policyAction.toString());
            }
            hashMap2.put("action", arrayList2);
            hashMap2.put("effect", statement.getEffect().toString());
            if (null != statement.getTime() && !statement.getTime().isEmpty()) {
                arrayList = new ArrayList();
                arrayList.addAll(statement.getTime().getSingleTimeList());
                for (Pair<String> pair : statement.getTime().getTimeRangeList()) {
                    arrayList.add((String)((Object)pair.toArrayList()));
                }
                hashMap2.put("time", arrayList);
            }
            if (null != statement.getIp() && !statement.getIp().isEmpty()) {
                arrayList = new ArrayList<String>();
                arrayList.addAll(statement.getIp().getSingleIpList());
                arrayList.addAll(statement.getIp().getCidrIpList());
                for (Pair<String> pair : statement.getIp().getIpRangeList()) {
                    arrayList.add((String)((Object)pair.toArrayList()));
                }
                hashMap2.put("ip", arrayList);
            }
            ((ArrayList)hashMap.get("statements")).add(hashMap2);
        }
        return jSONSerializer.deepSerialize(hashMap);
    }
}

