/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.inf.iis.bcs.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepeatableFileInputStream
extends InputStream {
    private static final Log log = LogFactory.getLog(RepeatableFileInputStream.class);
    private File file = null;
    private FileInputStream fis = null;
    private long bytesReadPastMarkPoint = 0L;
    private long markPoint = 0L;

    public RepeatableFileInputStream(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        this.fis = new FileInputStream(file);
        this.file = file;
    }

    public int available() throws IOException {
        return this.fis.available();
    }

    public void close() throws IOException {
        this.fis.close();
    }

    public InputStream getWrappedInputStream() {
        return this.fis;
    }

    public void mark(int n) {
        this.markPoint += this.bytesReadPastMarkPoint;
        this.bytesReadPastMarkPoint = 0L;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Input stream marked at " + this.markPoint + " bytes"));
        }
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        int n = this.fis.read();
        if (n != -1) {
            ++this.bytesReadPastMarkPoint;
            return n;
        }
        return -1;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.fis.read(byArray, n, n2);
        this.bytesReadPastMarkPoint += (long)n3;
        return n3;
    }

    public void reset() throws IOException {
        this.fis.close();
        this.fis = new FileInputStream(this.file);
        long l = 0L;
        for (long i = this.markPoint; i > 0L; i -= l) {
            l = this.fis.skip(i);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reset to mark point " + this.markPoint + " after returning " + this.bytesReadPastMarkPoint + " bytes"));
        }
        this.bytesReadPastMarkPoint = 0L;
    }

    public long skip(long l) throws IOException {
        long l2 = this.fis.skip(l);
        this.bytesReadPastMarkPoint += l2;
        return l2;
    }
}

