/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.inf.iis.bcs.http;

import com.baidu.inf.iis.bcs.http.BCSHttpRequest;
import com.baidu.inf.iis.bcs.http.ClientConfiguration;
import com.baidu.inf.iis.bcs.http.HttpMethodName;
import com.baidu.inf.iis.bcs.http.RepeatableInputStreamRequestEntity;
import com.baidu.inf.iis.bcs.model.BCSClientException;
import com.baidu.inf.iis.bcs.utils.Constants;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class HttpRequestFactory {
    private static final Log log = LogFactory.getLog(HttpRequestFactory.class);

    public HttpRequestBase createHttpRequestBase(ClientConfiguration clientConfiguration, BCSHttpRequest bCSHttpRequest) {
        HttpGet httpGet;
        String string = this.buildUri(clientConfiguration, bCSHttpRequest);
        log.debug((Object)(bCSHttpRequest.getHttpMethod().toString() + "  " + string));
        if (bCSHttpRequest.getHttpMethod() == HttpMethodName.GET) {
            httpGet = new HttpGet(string);
        } else if (bCSHttpRequest.getHttpMethod() == HttpMethodName.PUT) {
            HttpPut httpPut = new HttpPut(string);
            httpGet = httpPut;
            if (null != bCSHttpRequest.getContent()) {
                RepeatableInputStreamRequestEntity object = new RepeatableInputStreamRequestEntity(bCSHttpRequest);
                httpPut.setEntity((HttpEntity)object);
            }
        } else if (bCSHttpRequest.getHttpMethod() == HttpMethodName.DELETE) {
            httpGet = new HttpDelete(string);
        } else if (bCSHttpRequest.getHttpMethod() == HttpMethodName.HEAD) {
            httpGet = new HttpHead(string);
        } else {
            throw new BCSClientException("Unknown HTTP method name:" + bCSHttpRequest.getHttpMethod().toString());
        }
        for (Map.Entry entry : bCSHttpRequest.getHeaders().entrySet()) {
            if (((String)entry.getKey()).equalsIgnoreCase("Content-Length")) continue;
            httpGet.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        if (httpGet.getHeaders("Content-Type") == null || httpGet.getHeaders("Content-Type").length == 0) {
            httpGet.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + Constants.DEFAULT_ENCODING.toLowerCase());
        }
        return httpGet;
    }

    public String buildUri(ClientConfiguration clientConfiguration, BCSHttpRequest bCSHttpRequest) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(clientConfiguration.getProtocol().toString());
        stringBuilder.append("://");
        stringBuilder.append(bCSHttpRequest.getEndpoint());
        if (bCSHttpRequest.getResourcePath() != null && bCSHttpRequest.getResourcePath().length() > 0) {
            if (!bCSHttpRequest.getResourcePath().startsWith("/")) {
                stringBuilder.append("/");
            }
            stringBuilder.append(bCSHttpRequest.getResourcePath());
        }
        String string = this.encodeParameters(bCSHttpRequest);
        stringBuilder.append("?").append(string);
        return stringBuilder.toString();
    }

    private String encodeParameters(BCSHttpRequest bCSHttpRequest) {
        ArrayList<BasicNameValuePair> arrayList = null;
        if (bCSHttpRequest.getParameters().size() > 0) {
            arrayList = new ArrayList<BasicNameValuePair>(bCSHttpRequest.getParameters().size());
            for (Map.Entry entry : bCSHttpRequest.getParameters().entrySet()) {
                arrayList.add(new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue()));
            }
        }
        Object object = null;
        if (arrayList != null) {
            object = URLEncodedUtils.format(arrayList, (String)Constants.DEFAULT_ENCODING);
        }
        return object;
    }
}

