/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.inf.iis.bcs.http;

import com.baidu.inf.iis.bcs.http.ClientConfiguration;
import com.baidu.inf.iis.bcs.model.BCSClientException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.LayeredSchemeSocketFactory;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public class HttpClientFactory {
    public HttpClient createHttpClient(ClientConfiguration clientConfiguration) {
        BasicHttpParams basicHttpParams = new BasicHttpParams();
        HttpProtocolParams.setUserAgent((HttpParams)basicHttpParams, (String)clientConfiguration.getUserAgent());
        HttpProtocolParams.setVersion((HttpParams)basicHttpParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpConnectionParams.setConnectionTimeout((HttpParams)basicHttpParams, (int)clientConfiguration.getConnectionTimeout());
        HttpConnectionParams.setSoTimeout((HttpParams)basicHttpParams, (int)clientConfiguration.getSocketTimeout());
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)basicHttpParams, (boolean)true);
        HttpConnectionParams.setTcpNoDelay((HttpParams)basicHttpParams, (boolean)true);
        int n = clientConfiguration.getSocketBufferSizeHints()[0];
        int n2 = clientConfiguration.getSocketBufferSizeHints()[1];
        if (n > 0 || n2 > 0) {
            HttpConnectionParams.setSocketBufferSize((HttpParams)basicHttpParams, (int)Math.max(n, n2));
        }
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            schemeRegistry.register(new Scheme("https", (SocketFactory)new TrustAllSSLSocketFactory(keyStore), 443));
        }
        catch (Exception exception) {
            throw new BCSClientException("Can not enable ssl.", exception);
        }
        ConnManagerParams.setMaxTotalConnections((HttpParams)basicHttpParams, (int)clientConfiguration.getMaxConnections());
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)basicHttpParams, (ConnPerRoute)new ConnPerRouteBean(clientConfiguration.getMaxConnectionsPerRoute()));
        ThreadSafeClientConnManager threadSafeClientConnManager = new ThreadSafeClientConnManager((HttpParams)basicHttpParams, schemeRegistry);
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient((ClientConnectionManager)threadSafeClientConnManager, (HttpParams)basicHttpParams);
        String string = clientConfiguration.getProxyHost();
        int n3 = clientConfiguration.getProxyPort();
        if (string != null && n3 > 0) {
            HttpHost httpHost = new HttpHost(string, n3);
            defaultHttpClient.getParams().setParameter("http.route.default-proxy", (Object)httpHost);
            String string2 = clientConfiguration.getProxyUsername();
            String string3 = clientConfiguration.getProxyPassword();
            String string4 = clientConfiguration.getProxyDomain();
            String string5 = clientConfiguration.getProxyWorkstation();
            if (string2 != null && string3 != null) {
                defaultHttpClient.getCredentialsProvider().setCredentials(new AuthScope(string, n3), (Credentials)new NTCredentials(string2, string3, string5, string4));
            }
        }
        return defaultHttpClient;
    }

    private class TrustAllSSLSocketFactory
    extends SSLSocketFactory {
        SSLContext sslContext;

        public TrustAllSSLSocketFactory(KeyStore keyStore) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
            super(keyStore);
            this.sslContext = SSLContext.getInstance("TLS");
            TrustingX509TrustManager trustingX509TrustManager = new TrustingX509TrustManager();
            this.sslContext.init(null, new TrustManager[]{trustingX509TrustManager}, null);
        }

        public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException, UnknownHostException {
            return this.sslContext.getSocketFactory().createSocket(socket, string, n, bl);
        }

        public Socket createSocket() throws IOException {
            return this.sslContext.getSocketFactory().createSocket();
        }
    }

    private static class TrustingX509TrustManager
    implements X509TrustManager {
        private static final X509Certificate[] X509_CERTIFICATES = new X509Certificate[0];

        private TrustingX509TrustManager() {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return X509_CERTIFICATES;
        }

        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }
    }

    private static class TrustingSocketFactory
    implements SchemeSocketFactory,
    LayeredSchemeSocketFactory {
        private SSLContext sslcontext = null;

        private TrustingSocketFactory() {
        }

        private static SSLContext createSSLContext() throws IOException {
            try {
                SSLContext sSLContext = SSLContext.getInstance("TLS");
                sSLContext.init(null, new TrustManager[]{new TrustingX509TrustManager()}, null);
                return sSLContext;
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
        }

        private SSLContext getSSLContext() throws IOException {
            if (this.sslcontext == null) {
                this.sslcontext = TrustingSocketFactory.createSSLContext();
            }
            return this.sslcontext;
        }

        public Socket createSocket(HttpParams httpParams) throws IOException {
            return this.getSSLContext().getSocketFactory().createSocket();
        }

        public Socket connectSocket(Socket socket, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, HttpParams httpParams) throws IOException, UnknownHostException, ConnectTimeoutException {
            int n = HttpConnectionParams.getConnectionTimeout((HttpParams)httpParams);
            int n2 = HttpConnectionParams.getSoTimeout((HttpParams)httpParams);
            SSLSocket sSLSocket = (SSLSocket)(socket != null ? socket : this.createSocket(httpParams));
            if (inetSocketAddress2 != null) {
                sSLSocket.bind(inetSocketAddress2);
            }
            sSLSocket.connect(inetSocketAddress, n);
            sSLSocket.setSoTimeout(n2);
            return sSLSocket;
        }

        public boolean isSecure(Socket socket) throws IllegalArgumentException {
            return true;
        }

        public Socket createLayeredSocket(Socket socket, String string, int n, boolean bl) throws IOException, UnknownHostException {
            return this.getSSLContext().getSocketFactory().createSocket();
        }
    }
}

