/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.dyndb.util;

import cn.hutool.core.util.ObjectUtil;
import java.text.MessageFormat;
import java.util.Map;
import org.jeecg.modules.jmreport.dyndb.JmreportDataSourceCachePool;
import org.jeecg.modules.jmreport.dyndb.vo.JmreportDynamicDataSourceVo;

public class JmreportSqlUtils {
    public static final String DATABSE_TYPE_MYSQL = "mysql";
    public static final String DATABSE_TYPE_POSTGRE = "postgresql";
    public static final String DATABSE_TYPE_ORACLE = "oracle";
    public static final String DATABSE_TYPE_SQLSERVER = "sqlserver";
    public static final String MYSQL_SQL = "select * from ( {0}) sel_tab00 limit {1},{2}";
    public static final String POSTGRE_SQL = "select * from ( {0}) sel_tab00 limit {2} offset {1}";
    public static final String ORACLE_SQL = "select * from (select row_.*,rownum rownum_ from ({0}) row_ where rownum <= {1}) where rownum_>{2}";
    public static final String SQLSERVER_SQL = "select * from ( select row_number() over(order by tempColumn) tempRowNumber, * from (select top {1} tempColumn = 0, {0}) t ) tt where tempRowNumber > {2}";
    public static final String MYSQL_ALLTABLES_SQL = "select distinct table_name from information_schema.columns where table_schema = {0}";
    public static final String POSTGRE__ALLTABLES_SQL = "SELECT distinct c.relname AS  table_name FROM pg_class c";
    public static final String ORACLE__ALLTABLES_SQL = "select distinct colstable.table_name as  table_name from user_tab_cols colstable";
    public static final String SQLSERVER__ALLTABLES_SQL = "select distinct c.name as  table_name from sys.objects c";
    public static final String MYSQL_ALLCOLUMNS_SQL = "select column_name from information_schema.columns where table_name = {0} and table_schema = {1}";
    public static final String POSTGRE_ALLCOLUMNS_SQL = "select column_name from information_schema.columns  where table_name={0}";
    public static final String ORACLE_ALLCOLUMNS_SQL = "select column_name from all_tab_columns where table_name ={0}";
    public static final String SQLSERVER_ALLCOLUMNS_SQL = "select name from syscolumns where id={0}";
    public static final String MYSQL_ALLTABLES_COMMENT_SQL = "show table status";
    public static final String POSTGRE_ALLTABLES_COMMENT_SQL = "select relname as name,cast(obj_description(relfilenode,'pg_class') as varchar) as comment from pg_class c  where  relkind = 'r' and relname not like 'pg_%' and relname not like 'sql_%' order by relname";
    public static final String ORACLE_ALLTABLES_COMMENT_SQL = "select table_name Name,comments Comments from user_tab_comments";
    public static final String SQLSERVER_ALLTABLES_COMMENT_SQL = "SELECT DISTINCT CAST(d.name AS varchar(500)) Name,CAST(f.value AS varchar(500)) Comment FROM syscolumns a\nLEFT JOIN systypes b ON a.xusertype= b.xusertype\nINNER JOIN sysobjects d ON a.id= d.id\nAND d.xtype= 'U'\nAND d.name<> 'dtproperties'\nLEFT JOIN syscomments e ON a.cdefault= e.id\nLEFT JOIN sys.extended_properties g ON a.id= G.major_id\nAND a.colid= g.minor_id\nLEFT JOIN sys.extended_properties f ON d.id= f.major_id\nAND f.minor_id= 0 ;";

    public static boolean dbTypeIsMySQL(String dbType) {
        return JmreportSqlUtils.dbTypeIf(dbType, DATABSE_TYPE_MYSQL, "1");
    }

    public static boolean dbTypeIsOracle(String dbType) {
        return JmreportSqlUtils.dbTypeIf(dbType, DATABSE_TYPE_ORACLE, "2");
    }

    public static boolean dbTypeIsSQLServer(String dbType) {
        return JmreportSqlUtils.dbTypeIf(dbType, DATABSE_TYPE_SQLSERVER, "3");
    }

    public static boolean dbTypeIsPostgre(String dbType) {
        return JmreportSqlUtils.dbTypeIf(dbType, DATABSE_TYPE_POSTGRE, "4");
    }

    public static boolean dbTypeIf(String dbType, String ... correctTypes) {
        for (String string : correctTypes) {
            if (dbType.toLowerCase().indexOf(string.toLowerCase()) < 0) continue;
            return true;
        }
        return false;
    }

    public static String getFullSql(String sql, Map params) {
        return JmreportSqlUtils.getFullSql(sql, params, null, null);
    }

    public static String getFullSql(String sql, Map params, String orderColumn, String orderBy) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT t.* FROM ( ").append(sql).append(" ) t ");
        if (params != null && params.size() >= 1) {
            stringBuilder.append("WHERE 1=1 ");
            for (Object k : params.keySet()) {
                String string = String.valueOf(params.get(k));
                if (!ObjectUtil.isNotEmpty((Object)string)) continue;
                stringBuilder.append(" AND (").append(k).append(" = N'").append(string).append("')");
            }
            if (ObjectUtil.isNotEmpty((Object)orderColumn) && ObjectUtil.isNotEmpty((Object)orderBy)) {
                stringBuilder.append("ORDER BY ").append(orderColumn).append(" ").append("DESC".equalsIgnoreCase(orderBy) ? "DESC" : "ASC");
            }
        }
        return stringBuilder.toString();
    }

    public static String getCountSql(String sql) {
        return String.format("SELECT COUNT(1) \"total\" FROM ( %s ) temp_count", sql);
    }

    public static String createPageSqlByDBType(String dbType, String sql, int page, int rows) {
        int n = (page - 1) * rows;
        Object[] objectArray = new Object[]{sql, String.valueOf(n), String.valueOf(rows)};
        if (JmreportSqlUtils.dbTypeIsMySQL(dbType)) {
            sql = MessageFormat.format(MYSQL_SQL, objectArray);
        } else if (JmreportSqlUtils.dbTypeIsPostgre(dbType)) {
            sql = MessageFormat.format(POSTGRE_SQL, objectArray);
        } else {
            int n2 = (page - 1) * rows;
            int n3 = n2 + rows;
            objectArray[2] = Integer.toString(n2);
            objectArray[1] = Integer.toString(n3);
            if (JmreportSqlUtils.dbTypeIsOracle(dbType)) {
                sql = MessageFormat.format(ORACLE_SQL, objectArray);
            } else if (JmreportSqlUtils.dbTypeIsSQLServer(dbType)) {
                objectArray[0] = sql.substring(JmreportSqlUtils.getAfterSelectInsertPoint(sql));
                sql = MessageFormat.format(SQLSERVER_SQL, objectArray);
            }
        }
        return sql;
    }

    public static String createPageSqlByDBKey(String dbKey, String sql, int page, int rows) {
        JmreportDynamicDataSourceVo jmreportDynamicDataSourceVo = JmreportDataSourceCachePool.getCacheDynamicDataSourceModel(dbKey);
        String string = jmreportDynamicDataSourceVo.getDbType();
        return JmreportSqlUtils.createPageSqlByDBType(string, sql, page, rows);
    }

    private static int getAfterSelectInsertPoint(String sql) {
        int n = sql.toLowerCase().indexOf("select");
        int n2 = sql.toLowerCase().indexOf("select distinct");
        return n + (n2 == n ? 15 : 6);
    }

    public static String getAllTableSql(String dbType, Object ... params) {
        if (ObjectUtil.isNotEmpty((Object)dbType)) {
            if (JmreportSqlUtils.dbTypeIsMySQL(dbType)) {
                return MessageFormat.format(MYSQL_ALLTABLES_SQL, params);
            }
            if (JmreportSqlUtils.dbTypeIsOracle(dbType)) {
                return ORACLE__ALLTABLES_SQL;
            }
            if (JmreportSqlUtils.dbTypeIsPostgre(dbType)) {
                return POSTGRE__ALLTABLES_SQL;
            }
            if (JmreportSqlUtils.dbTypeIsSQLServer(dbType)) {
                return SQLSERVER__ALLTABLES_SQL;
            }
        }
        return null;
    }

    public static String getAllTableSql(String dbType) {
        if (ObjectUtil.isNotEmpty((Object)dbType)) {
            if (JmreportSqlUtils.dbTypeIsMySQL(dbType)) {
                return MYSQL_ALLTABLES_COMMENT_SQL;
            }
            if (JmreportSqlUtils.dbTypeIsOracle(dbType)) {
                return ORACLE_ALLTABLES_COMMENT_SQL;
            }
            if (JmreportSqlUtils.dbTypeIsPostgre(dbType)) {
                return POSTGRE_ALLTABLES_COMMENT_SQL;
            }
            if (JmreportSqlUtils.dbTypeIsSQLServer(dbType)) {
                return SQLSERVER_ALLTABLES_COMMENT_SQL;
            }
        }
        return null;
    }

    public static String getAllColumnSQL(String dbType, Object ... params) {
        if (ObjectUtil.isNotEmpty((Object)dbType)) {
            if (JmreportSqlUtils.dbTypeIsMySQL(dbType)) {
                return MessageFormat.format(MYSQL_ALLCOLUMNS_SQL, params);
            }
            if (JmreportSqlUtils.dbTypeIsOracle(dbType)) {
                return MessageFormat.format(ORACLE_ALLCOLUMNS_SQL, params);
            }
            if (JmreportSqlUtils.dbTypeIsPostgre(dbType)) {
                return MessageFormat.format(POSTGRE_ALLCOLUMNS_SQL, params);
            }
            if (JmreportSqlUtils.dbTypeIsSQLServer(dbType)) {
                return MessageFormat.format(SQLSERVER_ALLCOLUMNS_SQL, params);
            }
        }
        return null;
    }
}

