/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.dyndb.query;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jeecg.modules.jmreport.common.util.CommonUtils;
import org.jeecg.modules.jmreport.common.util.SqlInjectionUtil;
import org.jeecg.modules.jmreport.common.util.oConvertUtils;
import org.jeecg.modules.jmreport.dyndb.query.MatchTypeEnum;
import org.jeecg.modules.jmreport.dyndb.query.QueryCondition;
import org.jeecg.modules.jmreport.dyndb.query.QueryRuleEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryGenerator {
    private static final Logger log = LoggerFactory.getLogger(QueryGenerator.class);
    public static final String SQL_RULES_COLUMN = "SQL_RULES_COLUMN";
    private static final String BEGIN = "_begin";
    private static final String END = "_end";
    private static final String MULTI = "_MultiString";
    private static final String STAR = "*";
    private static final String COMMA = ",";
    private static final String NOT_EQUAL = "!";
    private static final String QUERY_SEPARATE_KEYWORD = " ";
    private static final String SUPER_QUERY_PARAMS = "superQueryParams";
    private static final String SUPER_QUERY_MATCH_TYPE = "superQueryMatchType";
    public static final String SQL_SQ = "'";
    private static final String ORDER_COLUMN = "column";
    private static final String ORDER_TYPE = "order";
    private static final String ORDER_TYPE_ASC = "ASC";
    public static final String LIKE_MYSQL_SPECIAL_STRS = "_,%";
    private static final ThreadLocal<SimpleDateFormat> local = new ThreadLocal();
    private static String DB_TYPE;

    private static SimpleDateFormat getTime() {
        SimpleDateFormat simpleDateFormat = local.get();
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            local.set(simpleDateFormat);
        }
        return simpleDateFormat;
    }

    private static void doIntervalQuery(QueryWrapper<?> queryWrapper, Map<String, String[]> parameterMap, String type, String filedName, String columnName) throws ParseException {
        String string = null;
        String string2 = null;
        if (parameterMap != null && parameterMap.containsKey(filedName + BEGIN)) {
            string2 = parameterMap.get(filedName + BEGIN)[0].trim();
            QueryGenerator.addQueryByRule(queryWrapper, columnName, type, string2, QueryRuleEnum.GE);
        }
        if (parameterMap != null && parameterMap.containsKey(filedName + END)) {
            string = parameterMap.get(filedName + END)[0].trim();
            QueryGenerator.addQueryByRule(queryWrapper, columnName, type, string, QueryRuleEnum.LE);
        }
        if (parameterMap != null && parameterMap.containsKey(filedName + MULTI)) {
            string = parameterMap.get(filedName + MULTI)[0].trim();
            QueryGenerator.addQueryByRule(queryWrapper, columnName.replace(MULTI, ""), type, string, QueryRuleEnum.IN);
        }
    }

    public static void doMultiFieldsOrder(QueryWrapper<?> queryWrapper, Map<String, String[]> parameterMap) {
        String string = null;
        String string2 = null;
        if (parameterMap != null && parameterMap.containsKey(ORDER_COLUMN)) {
            string = parameterMap.get(ORDER_COLUMN)[0];
        }
        if (parameterMap != null && parameterMap.containsKey(ORDER_TYPE)) {
            string2 = parameterMap.get(ORDER_TYPE)[0];
        }
        log.debug("\u6392\u5e8f\u89c4\u5219>>\u5217:" + string + ",\u6392\u5e8f\u65b9\u5f0f:" + string2);
        if (oConvertUtils.isNotEmpty(string) && oConvertUtils.isNotEmpty(string2)) {
            if (string.endsWith("_dictText")) {
                string = string.substring(0, string.lastIndexOf("_dictText"));
            }
            SqlInjectionUtil.filterContent(string);
            if (string2.toUpperCase().indexOf(ORDER_TYPE_ASC) >= 0) {
                queryWrapper.orderByAsc((Object)oConvertUtils.camelToUnderline(string));
            } else {
                queryWrapper.orderByDesc((Object)oConvertUtils.camelToUnderline(string));
            }
        }
    }

    public static void doSuperQuery(QueryWrapper<?> queryWrapper, Map<String, String[]> parameterMap, Map<String, String> fieldColumnMap) {
        if (parameterMap != null && parameterMap.containsKey(SUPER_QUERY_PARAMS)) {
            String string = parameterMap.get(SUPER_QUERY_PARAMS)[0];
            String string2 = parameterMap.get(SUPER_QUERY_MATCH_TYPE) != null ? parameterMap.get(SUPER_QUERY_MATCH_TYPE)[0] : MatchTypeEnum.AND.getValue();
            MatchTypeEnum matchTypeEnum = MatchTypeEnum.getByValue(string2);
            try {
                string = URLDecoder.decode(string, "UTF-8");
                List list = JSON.parseArray((String)string, QueryCondition.class);
                if (list == null || list.size() == 0) {
                    return;
                }
                log.info("---\u9ad8\u7ea7\u67e5\u8be2\u53c2\u6570-->" + list.toString());
                queryWrapper.and(andWrapper -> {
                    for (int k = 0; k < list.size(); ++k) {
                        QueryCondition queryCondition = (QueryCondition)list.get(k);
                        if (!oConvertUtils.isNotEmpty(queryCondition.getField()) || !oConvertUtils.isNotEmpty(queryCondition.getRule()) || !oConvertUtils.isNotEmpty(queryCondition.getVal())) continue;
                        log.debug("SuperQuery ==> " + queryCondition.toString());
                        QueryGenerator.addEasyQuery(andWrapper, (String)fieldColumnMap.get(queryCondition.getField()), QueryRuleEnum.getByValue(queryCondition.getRule()), queryCondition.getVal());
                        if (MatchTypeEnum.OR != matchTypeEnum || k >= list.size() - 1) continue;
                        andWrapper.or();
                    }
                });
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                log.error("--\u9ad8\u7ea7\u67e5\u8be2\u53c2\u6570\u8f6c\u7801\u5931\u8d25\uff1a" + string, (Throwable)unsupportedEncodingException);
            }
            catch (Exception exception) {
                log.error("--\u9ad8\u7ea7\u67e5\u8be2\u62fc\u63a5\u5931\u8d25\uff1a" + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    private static QueryRuleEnum convert2Rule(Object value) {
        if (value == null) {
            return null;
        }
        String string = (value + "").toString().trim();
        if (string.length() == 0) {
            return null;
        }
        QueryRuleEnum queryRuleEnum = null;
        if (queryRuleEnum == null && string.length() >= 3 && QUERY_SEPARATE_KEYWORD.equals(string.substring(2, 3))) {
            queryRuleEnum = QueryRuleEnum.getByValue(string.substring(0, 2));
        }
        if (queryRuleEnum == null && string.length() >= 2 && QUERY_SEPARATE_KEYWORD.equals(string.substring(1, 2))) {
            queryRuleEnum = QueryRuleEnum.getByValue(string.substring(0, 1));
        }
        if (queryRuleEnum == null && string.contains(STAR)) {
            if (string.startsWith(STAR) && string.endsWith(STAR)) {
                queryRuleEnum = QueryRuleEnum.LIKE;
            } else if (string.startsWith(STAR)) {
                queryRuleEnum = QueryRuleEnum.LEFT_LIKE;
            } else if (string.endsWith(STAR)) {
                queryRuleEnum = QueryRuleEnum.RIGHT_LIKE;
            }
        }
        if (queryRuleEnum == null && string.contains(COMMA)) {
            queryRuleEnum = QueryRuleEnum.IN;
        }
        if (queryRuleEnum == null && string.startsWith(NOT_EQUAL)) {
            queryRuleEnum = QueryRuleEnum.NE;
        }
        return queryRuleEnum != null ? queryRuleEnum : QueryRuleEnum.EQ;
    }

    private static Object replaceValue(QueryRuleEnum rule, Object value) {
        if (rule == null) {
            return null;
        }
        if (!(value instanceof String)) {
            return value;
        }
        String string = (value + "").toString().trim();
        if (rule == QueryRuleEnum.LIKE) {
            value = string.substring(1, string.length() - 1);
            value = QueryGenerator.specialStrConvert(value.toString());
        } else if (rule == QueryRuleEnum.LEFT_LIKE || rule == QueryRuleEnum.NE) {
            value = string.substring(1);
            value = QueryGenerator.specialStrConvert(value.toString());
        } else if (rule == QueryRuleEnum.RIGHT_LIKE) {
            value = string.substring(0, string.length() - 1);
            value = QueryGenerator.specialStrConvert(value.toString());
        } else if (rule == QueryRuleEnum.IN) {
            value = string.split(COMMA);
        } else if (string.startsWith(rule.getValue())) {
            value = string.replaceFirst(rule.getValue(), "");
        } else if (string.startsWith(rule.getCondition() + QUERY_SEPARATE_KEYWORD)) {
            value = string.replaceFirst(rule.getCondition() + QUERY_SEPARATE_KEYWORD, "").trim();
        }
        return value;
    }

    private static void addQueryByRule(QueryWrapper<?> queryWrapper, String name, String type, String value, QueryRuleEnum rule) throws ParseException {
        if (oConvertUtils.isNotEmpty(value)) {
            Object object;
            if (value.indexOf(COMMA) != -1) {
                String string = value;
                QueryGenerator.addEasyQuery(queryWrapper, name, rule, string);
                return;
            }
            switch (type) {
                case "class java.lang.Integer": {
                    object = Integer.parseInt(value);
                    break;
                }
                case "class java.math.BigDecimal": {
                    object = new BigDecimal(value);
                    break;
                }
                case "class java.lang.Short": {
                    object = Short.parseShort(value);
                    break;
                }
                case "class java.lang.Long": {
                    object = Long.parseLong(value);
                    break;
                }
                case "class java.lang.Float": {
                    object = Float.valueOf(Float.parseFloat(value));
                    break;
                }
                case "class java.lang.Double": {
                    object = Double.parseDouble(value);
                    break;
                }
                case "class java.util.Date": {
                    object = QueryGenerator.getDateQueryByRule(value, rule);
                    break;
                }
                default: {
                    object = value;
                }
            }
            QueryGenerator.addEasyQuery(queryWrapper, name, rule, object);
        }
    }

    private static Date getDateQueryByRule(String value, QueryRuleEnum rule) throws ParseException {
        Date date = null;
        if (value.length() == 10) {
            if (rule == QueryRuleEnum.GE) {
                date = QueryGenerator.getTime().parse(value + " 00:00:00");
            } else if (rule == QueryRuleEnum.LE) {
                date = QueryGenerator.getTime().parse(value + " 23:59:59");
            }
        }
        if (date == null) {
            date = QueryGenerator.getTime().parse(value);
        }
        return date;
    }

    private static void addEasyQuery(QueryWrapper<?> queryWrapper, String name, QueryRuleEnum rule, Object value) {
        if (value == null || rule == null || oConvertUtils.isEmpty(value)) {
            return;
        }
        name = oConvertUtils.camelToUnderline(name);
        log.info("--\u67e5\u8be2\u89c4\u5219-->" + name + QUERY_SEPARATE_KEYWORD + rule.getValue() + QUERY_SEPARATE_KEYWORD + value);
        switch (rule) {
            case GT: {
                queryWrapper.gt((Object)name, value);
                break;
            }
            case GE: {
                queryWrapper.ge((Object)name, value);
                break;
            }
            case LT: {
                queryWrapper.lt((Object)name, value);
                break;
            }
            case LE: {
                queryWrapper.le((Object)name, value);
                break;
            }
            case EQ: {
                queryWrapper.eq((Object)name, value);
                break;
            }
            case NE: {
                queryWrapper.ne((Object)name, value);
                break;
            }
            case IN: {
                if (value instanceof String) {
                    queryWrapper.in((Object)name, (Object[])value.toString().split(COMMA));
                    break;
                }
                if (value instanceof String[]) {
                    queryWrapper.in((Object)name, (Object[])value);
                    break;
                }
                if (value.getClass().isArray()) {
                    queryWrapper.in((Object)name, (Object[])value);
                    break;
                }
                queryWrapper.in((Object)name, new Object[]{value});
                break;
            }
            case LIKE: {
                queryWrapper.like((Object)name, value);
                break;
            }
            case LEFT_LIKE: {
                queryWrapper.likeLeft((Object)name, value);
                break;
            }
            case RIGHT_LIKE: {
                queryWrapper.likeRight((Object)name, value);
                break;
            }
            default: {
                log.info("--\u67e5\u8be2\u89c4\u5219\u672a\u5339\u914d\u5230---");
            }
        }
    }

    private static boolean judgedIsUselessField(String name) {
        return "class".equals(name) || "ids".equals(name) || "page".equals(name) || "rows".equals(name) || "sort".equals(name) || ORDER_TYPE.equals(name);
    }

    public static String trimSingleQuote(String ruleValue) {
        if (oConvertUtils.isEmpty(ruleValue)) {
            return "";
        }
        if (ruleValue.startsWith(SQL_SQ)) {
            ruleValue = ruleValue.substring(1);
        }
        if (ruleValue.endsWith(SQL_SQ)) {
            ruleValue = ruleValue.substring(0, ruleValue.length() - 1);
        }
        return ruleValue;
    }

    public static Set<String> getSqlRuleParams(String sql) {
        if (oConvertUtils.isEmpty(sql)) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        String string = "\\#\\{\\w+\\}";
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher(sql);
        while (matcher.find()) {
            String string2 = matcher.group();
            hashSet.add(string2.substring(string2.indexOf("{") + 1, string2.indexOf("}")));
        }
        return hashSet;
    }

    public static String getSingleQueryConditionSql(String field, String alias, Object value, boolean isString) {
        if (value == null) {
            return "";
        }
        field = alias + oConvertUtils.camelToUnderline(field);
        QueryRuleEnum queryRuleEnum = QueryGenerator.convert2Rule(value);
        return QueryGenerator.getSingleSqlByRule(queryRuleEnum, field, value, isString);
    }

    public static String getSingleSqlByRule(QueryRuleEnum rule, String field, Object value, boolean isString) {
        String string = "";
        switch (rule) {
            case GT: {
                string = field + rule.getValue() + QueryGenerator.getFieldConditionValue(value, isString);
                break;
            }
            case GE: {
                string = field + rule.getValue() + QueryGenerator.getFieldConditionValue(value, isString);
                break;
            }
            case LT: {
                string = field + rule.getValue() + QueryGenerator.getFieldConditionValue(value, isString);
                break;
            }
            case LE: {
                string = field + rule.getValue() + QueryGenerator.getFieldConditionValue(value, isString);
                break;
            }
            case EQ: {
                string = field + rule.getValue() + QueryGenerator.getFieldConditionValue(value, isString);
                break;
            }
            case NE: {
                string = field + " <> " + QueryGenerator.getFieldConditionValue(value, isString);
                break;
            }
            case IN: {
                string = field + " in " + QueryGenerator.getInConditionValue(value, isString);
                break;
            }
            case LIKE: {
                string = field + " like " + QueryGenerator.getLikeConditionValue(value);
                break;
            }
            case LEFT_LIKE: {
                string = field + " like " + QueryGenerator.getLikeConditionValue(value);
                break;
            }
            case RIGHT_LIKE: {
                string = field + " like " + QueryGenerator.getLikeConditionValue(value);
                break;
            }
            default: {
                string = field + " = " + QueryGenerator.getFieldConditionValue(value, isString);
            }
        }
        return string;
    }

    private static String getFieldConditionValue(Object value, boolean isString) {
        String string = value.toString().trim();
        if (string.startsWith(NOT_EQUAL)) {
            string = string.substring(1);
        } else if (string.startsWith(">=")) {
            string = string.substring(2);
        } else if (string.startsWith("<=")) {
            string = string.substring(2);
        } else if (string.startsWith(">")) {
            string = string.substring(1);
        } else if (string.startsWith("<")) {
            string = string.substring(1);
        }
        if (isString) {
            if ("SQLSERVER".equals(QueryGenerator.getDbType())) {
                return " N'" + string + "' ";
            }
            return " '" + string + "' ";
        }
        if ("SQLSERVER".equals(QueryGenerator.getDbType()) && string.endsWith(SQL_SQ) && string.startsWith(SQL_SQ)) {
            return " N" + string;
        }
        return value.toString();
    }

    private static String getInConditionValue(Object value, boolean isString) {
        if (isString) {
            String[] stringArray = value.toString().split(COMMA);
            String string = "";
            for (String string2 : stringArray) {
                string = "SQLSERVER".equals(QueryGenerator.getDbType()) ? string + ",N'" + string2 + SQL_SQ : string + ",'" + string2 + SQL_SQ;
            }
            return "(" + string.substring(1) + ")";
        }
        return "(" + value.toString() + ")";
    }

    private static String getLikeConditionValue(Object value) {
        String string = value.toString().trim();
        if (string.startsWith(STAR) && string.endsWith(STAR)) {
            if ("SQLSERVER".equals(QueryGenerator.getDbType())) {
                return "N'%" + string.substring(1, string.length() - 1) + "%'";
            }
            return "'%" + string.substring(1, string.length() - 1) + "%'";
        }
        if (string.startsWith(STAR)) {
            if ("SQLSERVER".equals(QueryGenerator.getDbType())) {
                return "N'%" + string.substring(1) + SQL_SQ;
            }
            return "'%" + string.substring(1) + SQL_SQ;
        }
        if (string.endsWith(STAR)) {
            if ("SQLSERVER".equals(QueryGenerator.getDbType())) {
                return "N'" + string.substring(0, string.length() - 1) + "%'";
            }
            return SQL_SQ + string.substring(0, string.length() - 1) + "%'";
        }
        if (string.indexOf("%") >= 0) {
            if ("SQLSERVER".equals(QueryGenerator.getDbType())) {
                if (string.startsWith(SQL_SQ) && string.endsWith(SQL_SQ)) {
                    return "N" + string;
                }
                return "N'" + string + SQL_SQ;
            }
            if (string.startsWith(SQL_SQ) && string.endsWith(SQL_SQ)) {
                return string;
            }
            return SQL_SQ + string + SQL_SQ;
        }
        if ("SQLSERVER".equals(QueryGenerator.getDbType())) {
            return "N'%" + string + "%'";
        }
        return "'%" + string + "%'";
    }

    private static String getDbType() {
        return CommonUtils.getDatabaseType();
    }

    private static List<Field> getClassFields(Class<?> clazz) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        do {
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int k = 0; k < fieldArray.length; ++k) {
                arrayList.add(fieldArray[k]);
            }
        } while ((clazz = clazz.getSuperclass()) != Object.class && clazz != null);
        return arrayList;
    }

    private static String getTableFieldName(Class<?> clazz, String name) {
        try {
            TableField tableField;
            Object object;
            Field field = null;
            try {
                field = clazz.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (field == null && (object = (tableField = QueryGenerator.getClassFields(clazz)).stream().filter(a2 -> a2.getName().equals(name)).collect(Collectors.toList())) != null && object.size() > 0) {
                field = (Field)object.get(0);
            }
            if (field != null && (tableField = field.getAnnotation(TableField.class)) != null) {
                if (!tableField.exist()) {
                    return null;
                }
                object = tableField.value();
                if (!"".equals(object)) {
                    return object;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return name;
    }

    private static String specialStrConvert(String value) {
        if ("MYSQL".equals(QueryGenerator.getDbType())) {
            String[] stringArray;
            for (String string : stringArray = LIKE_MYSQL_SPECIAL_STRS.split(COMMA)) {
                if (value.indexOf(string) == -1) continue;
                value = value.replace(string, "\\" + string);
            }
        }
        return value;
    }
}

