/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.common.util;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class oConvertUtils {
    private static final Logger log = LoggerFactory.getLogger(oConvertUtils.class);

    public static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if ("".equals(object)) {
            return true;
        }
        return "null".equals(object);
    }

    public static boolean isNotEmpty(Object object) {
        return object != null && !object.equals("") && !object.equals("null");
    }

    public static String decode(String strIn, String sourceCode, String targetCode) {
        String string = oConvertUtils.code2code(strIn, sourceCode, targetCode);
        return string;
    }

    private static String code2code(String strIn, String sourceCode, String targetCode) {
        String string = null;
        if (strIn == null || strIn.trim().equals("")) {
            return strIn;
        }
        try {
            byte[] byArray = strIn.getBytes(sourceCode);
            for (int k = 0; k < byArray.length; ++k) {
                System.out.print(byArray[k] + "  ");
            }
            string = new String(byArray, targetCode);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return string;
    }

    public static int getInt(String s, int defval) {
        if (s == null || s == "") {
            return defval;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return defval;
        }
    }

    public static int getInt(String s) {
        if (s == null || s == "") {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static int getInt(String s, Integer df) {
        if (s == null || s == "") {
            return df;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static int getInt(Object object, int defval) {
        if (oConvertUtils.isEmpty(object)) {
            return defval;
        }
        try {
            return Integer.parseInt(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return defval;
        }
    }

    public static Integer getInt(Object object) {
        if (oConvertUtils.isEmpty(object)) {
            return null;
        }
        try {
            return Integer.parseInt(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static int getInt(BigDecimal s, int defval) {
        if (s == null) {
            return defval;
        }
        return s.intValue();
    }

    public static String getString(String s) {
        return oConvertUtils.getString(s, "");
    }

    public static String getString(Object object) {
        if (oConvertUtils.isEmpty(object)) {
            return "";
        }
        return object.toString().trim();
    }

    public static String getString(int i2) {
        return String.valueOf(i2);
    }

    public static String getString(float i2) {
        return String.valueOf(i2);
    }

    public static String getString(String s, String defval) {
        if (oConvertUtils.isEmpty(s)) {
            return defval;
        }
        return s.trim();
    }

    public static String getString(Object s, String defval) {
        if (oConvertUtils.isEmpty(s)) {
            return defval;
        }
        return s.toString().trim();
    }

    public static String getIp() {
        String string = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        return string;
    }

    public static String camelToUnderline(String para) {
        if (para.length() < 3) {
            return para.toLowerCase();
        }
        StringBuilder stringBuilder = new StringBuilder(para);
        int n = 0;
        for (int k = 2; k < para.length(); ++k) {
            if (!Character.isUpperCase(para.charAt(k))) continue;
            stringBuilder.insert(k + n, "_");
            ++n;
        }
        return stringBuilder.toString().toLowerCase();
    }

    public static Field[] getAllFields(Object object) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            arrayList.addAll(new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields())));
        }
        Field[] fieldArray = new Field[arrayList.size()];
        arrayList.toArray(fieldArray);
        return fieldArray;
    }

    public static boolean listIsEmpty(Collection list) {
        return list == null || list.size() == 0;
    }
}

