/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectHelper {
    private static final Logger log = LoggerFactory.getLogger(ReflectHelper.class);
    private Class cls;
    private Object obj;
    private Hashtable<String, Method> getMethods = null;
    private Hashtable<String, Method> setMethods = null;

    public ReflectHelper(Object o) {
        this.obj = o;
        this.initMethods();
    }

    public void initMethods() {
        this.getMethods = new Hashtable();
        this.setMethods = new Hashtable();
        this.cls = this.obj.getClass();
        Method[] methodArray = this.cls.getMethods();
        String string = "get(\\w+)";
        Pattern pattern = Pattern.compile(string);
        String string2 = "set(\\w+)";
        Pattern pattern2 = Pattern.compile(string2);
        String string3 = "$1";
        for (int k = 0; k < methodArray.length; ++k) {
            String string4;
            Method method = methodArray[k];
            String string5 = method.getName();
            if (Pattern.matches(string, string5)) {
                string4 = pattern.matcher(string5).replaceAll(string3).toLowerCase();
                this.getMethods.put(string4, method);
                continue;
            }
            if (!Pattern.matches(string2, string5)) continue;
            string4 = pattern2.matcher(string5).replaceAll(string3).toLowerCase();
            this.setMethods.put(string4, method);
        }
    }

    public boolean setMethodValue(String property, Object object) {
        Method method = this.setMethods.get(property.toLowerCase());
        if (method != null) {
            try {
                method.invoke(this.obj, object);
                return true;
            }
            catch (Exception exception) {
                log.info("invoke getter on " + property + " error: " + exception.toString());
                return false;
            }
        }
        return false;
    }

    public Object getMethodValue(String property) {
        Object object = null;
        Method method = this.getMethods.get(property.toLowerCase());
        if (method != null) {
            try {
                object = method.invoke(this.obj, new Object[0]);
            }
            catch (Exception exception) {
                log.info("invoke getter on " + property + " error: " + exception.toString());
            }
        }
        return object;
    }

    public Object setAll(Map<String, Object> data) {
        if (data == null || data.keySet().size() <= 0) {
            return null;
        }
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            this.setMethodValue(entry.getKey(), entry.getValue());
        }
        return this.obj;
    }

    public static Object setAll(Object o, Map<String, Object> data) {
        ReflectHelper reflectHelper = new ReflectHelper(o);
        reflectHelper.setAll(data);
        return o;
    }

    public static <T> T setAll(Class<T> clazz, Map<String, Object> data) {
        T t = null;
        try {
            t = clazz.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            t = null;
            return t;
        }
        return (T)ReflectHelper.setAll(t, data);
    }

    public static <T> List<T> transList2Entrys(List<Map<String, Object>> mapist, Class<T> clazz) {
        ArrayList<T> arrayList = new ArrayList<T>();
        if (mapist != null && mapist.size() > 0) {
            for (Map<String, Object> map : mapist) {
                arrayList.add(ReflectHelper.setAll(clazz, map));
            }
        }
        return arrayList;
    }

    public static Object getFieldValueByName(String fieldName, Object o) {
        try {
            String string = fieldName.substring(0, 1).toUpperCase();
            String string2 = "get" + string + fieldName.substring(1);
            Method method = o.getClass().getMethod(string2, new Class[0]);
            Object object = method.invoke(o, new Object[0]);
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String[] getFiledName(Object o) {
        Field[] fieldArray = o.getClass().getDeclaredFields();
        String[] stringArray = new String[fieldArray.length];
        for (int k = 0; k < fieldArray.length; ++k) {
            stringArray[k] = fieldArray[k].getName();
        }
        return stringArray;
    }

    public static List<Map> getFiledsInfo(Object o) {
        Field[] fieldArray = o.getClass().getDeclaredFields();
        String[] stringArray = new String[fieldArray.length];
        ArrayList<Map> arrayList = new ArrayList<Map>();
        HashMap<String, Object> hashMap = null;
        for (int k = 0; k < fieldArray.length; ++k) {
            hashMap = new HashMap<String, Object>();
            hashMap.put("type", fieldArray[k].getType().toString());
            hashMap.put("name", fieldArray[k].getName());
            hashMap.put("value", ReflectHelper.getFieldValueByName(fieldArray[k].getName(), o));
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    public static Object[] getFiledValues(Object o) {
        String[] stringArray = ReflectHelper.getFiledName(o);
        Object[] objectArray = new Object[stringArray.length];
        for (int k = 0; k < stringArray.length; ++k) {
            objectArray[k] = ReflectHelper.getFieldValueByName(stringArray[k], o);
        }
        return objectArray;
    }
}

