/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.common.util;

import cn.hutool.core.util.ObjectUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFSimpleShape;
import org.jeecg.modules.jmreport.common.constant.CommonConstant;
import org.jeecg.modules.jmreport.common.util.oConvertUtils;

public class ExcelUtil {
    public static boolean isHave(String[] strs, String s) {
        for (int k = 0; k < strs.length; ++k) {
            if (!oConvertUtils.isNotEmpty(s) || !s.contains(strs[k])) continue;
            return true;
        }
        return false;
    }

    public static Map<String, Object> isExistence(List<String> list, String[] text, String[] symbols, Integer n) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            String string = list.get(n);
            String string2 = ExcelUtil.ifHaveEnglish(text, string);
            String string3 = ExcelUtil.ifHaveSysbom(symbols, string);
            if (oConvertUtils.isEmpty(string3)) {
                return null;
            }
            if (string.contains(string2)) {
                String string4 = string.replace(string2, "");
                String[] stringArray = string3.split("__");
                for (String string5 : stringArray) {
                    string4 = string4.replace(string5, "");
                }
                String string6 = string4.replaceAll("[^A-Z]", "");
                String string7 = "";
                for (int k = 0; k < string6.length(); ++k) {
                    string7 = string7 + string6.charAt(k) + ",";
                }
                hashMap.put("newFirstWord", string7.substring(0, string7.lastIndexOf(",")));
                hashMap.put("english", string2);
                hashMap.put("sysbom", string3);
                return hashMap;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    public static String ifHaveSysbom(String[] strs, String s) {
        String string = "";
        for (int k = 0; k < strs.length; ++k) {
            if (!s.contains(strs[k])) continue;
            string = string + strs[k] + "__";
        }
        if (oConvertUtils.isNotEmpty(string)) {
            string = string.substring(0, string.lastIndexOf("__"));
        }
        return string;
    }

    public static String ifHaveEnglish(String[] strs, String s) {
        for (int k = 0; k < strs.length; ++k) {
            if (!s.contains(strs[k].split("=")[1])) continue;
            return strs[k].split("=")[1];
        }
        return "";
    }

    public static String getCellValueByCell(Cell cell) {
        if (cell == null || cell.toString().trim().equals("")) {
            return "";
        }
        String string = "";
        CellType cellType = cell.getCellTypeEnum();
        switch (cellType) {
            case STRING: {
                string = cell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                string = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case NUMERIC: {
                string = String.valueOf(cell.getNumericCellValue());
                break;
            }
            case FORMULA: {
                string = String.valueOf(cell.getCellFormula());
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public static String isHaveText(String[] strs, String s) {
        for (int k = 0; k < strs.length; ++k) {
            if (!oConvertUtils.isNotEmpty(s) || !s.contains(strs[k])) continue;
            return strs[k];
        }
        return "";
    }

    public static SimpleDateFormat getFormat(String dataText) {
        SimpleDateFormat simpleDateFormat = null;
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy/MM/dd");
        SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        SimpleDateFormat simpleDateFormat4 = new SimpleDateFormat("HH:mm:ss");
        SimpleDateFormat simpleDateFormat5 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        switch (dataText) {
            case "date": {
                simpleDateFormat = simpleDateFormat2;
                break;
            }
            case "date2": {
                simpleDateFormat = simpleDateFormat3;
                break;
            }
            case "time": {
                simpleDateFormat = simpleDateFormat4;
                break;
            }
            case "datetime": {
                simpleDateFormat = simpleDateFormat5;
                break;
            }
            default: {
                simpleDateFormat = null;
            }
        }
        return simpleDateFormat;
    }

    public static SimpleDateFormat getDataFormat(String text) {
        SimpleDateFormat simpleDateFormat = null;
        if (text.contains("-") && text.contains(":")) {
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        } else if (text.contains("-")) {
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        } else if (ExcelUtil.isHave(CommonConstant.ABBREVIATION, text) && text.contains("PM") || text.contains("AM")) {
            simpleDateFormat = new SimpleDateFormat("MMM d, yyyy K:m:s a", Locale.ENGLISH);
        } else if (text.contains(":") && text.contains("PM") || text.contains("AM")) {
            simpleDateFormat = new SimpleDateFormat("K:m:s a", Locale.ENGLISH);
        } else if (text.contains(":")) {
            simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
        } else if (ExcelUtil.isHave(CommonConstant.ABBREVIATION, text)) {
            simpleDateFormat = new SimpleDateFormat("MMM d, yyyy", Locale.ENGLISH);
        }
        return simpleDateFormat;
    }

    public static byte[] getImage(String text, String lineStart, Integer width, Integer height) throws FileNotFoundException, IOException {
        int n = 4;
        String[] stringArray = text.split("\\|");
        int n2 = stringArray.length - 1;
        if (n2 > 4) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, n);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, width, height);
        graphics2D.setColor(Color.BLACK);
        float f2 = 1.0f;
        graphics2D.setStroke(new BasicStroke(f2));
        if (lineStart.equals("lefttop")) {
            ExcelUtil.formTopToBottom(width, height, stringArray, graphics2D);
            ExcelUtil.paintingTopFont(width, height, stringArray, graphics2D);
        } else {
            ExcelUtil.formBottomToTop(width, height, stringArray, graphics2D);
            ExcelUtil.paintingBottomFont(width, height, stringArray, graphics2D);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "jpeg", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static void formTopToBottom(Integer width, Integer height, String[] split, Graphics2D pen) {
        int n = 0;
        int n2 = 0;
        int n3 = width;
        int n4 = split.length - 1;
        int n5 = split.length;
        int n6 = height / n4;
        int n7 = width / n5;
        int n8 = 0;
        int n9 = 0;
        for (int k = 1; k < split.length; ++k) {
            n8 = n6 * k;
            if (n5 > 2) {
                n8 = n8 + n6 / n4 - 10;
            }
            if (k > 1) {
                n8 = height;
            }
            if (k == n5 - 1) {
                n3 = n7 * (n5 - n9);
            }
            pen.drawLine(n, n2, n3, n8);
            ++n9;
        }
    }

    public static void formBottomToTop(Integer width, Integer height, String[] split, Graphics2D pen) {
        int n = 0;
        int n2 = height;
        int n3 = width;
        int n4 = split.length - 1;
        int n5 = split.length;
        int n6 = height / n4;
        int n7 = width / n5;
        int n8 = 0;
        int n9 = 0;
        for (int k = 1; k < split.length; ++k) {
            if (n5 > 2) {
                n8 = height - n6 - n6 / n4;
            }
            if (k > 1) {
                n8 = 0;
            }
            if (k == n5 - 1) {
                n3 = n7 * (n5 - n9);
            }
            pen.drawLine(n, n2, n3, n8);
            ++n9;
        }
    }

    public static void paintingTopFont(Integer width, Integer height, String[] split, Graphics2D pen) {
        int n = split.length - 1;
        int n2 = split.length;
        int n3 = width / n2;
        if (n2 == 2) {
            pen.setColor(Color.BLACK);
            Font font = new Font("Microsoft YaHei", 0, 12);
            pen.setFont(font);
            double d2 = (double)height.intValue() * 0.3;
            pen.drawString(split[1], n3, (int)d2);
            double d3 = (double)height.intValue() * 0.8;
            pen.drawString(split[0], 4, (int)d3);
        } else if (n2 == 3) {
            pen.setColor(Color.BLACK);
            Font font = new Font("Microsoft YaHei", 0, 12);
            pen.setFont(font);
            double d4 = (double)height.intValue() * 0.3;
            double d5 = (double)width.intValue() / 1.5;
            pen.drawString(split[2], (int)d5, (int)d4);
            pen.setColor(Color.BLACK);
            double d6 = (double)height.intValue() * 0.9;
            pen.drawString(split[1], (int)d5, (int)d6);
            double d7 = (double)height.intValue() * 0.8;
            pen.drawString(split[0], 4, (int)d7);
        }
    }

    public static void paintingBottomFont(Integer width, Integer height, String[] split, Graphics2D pen) {
        int n = split.length - 1;
        int n2 = split.length;
        int n3 = width / n2;
        if (n2 == 2) {
            pen.setColor(Color.BLACK);
            Font font = new Font("Microsoft YaHei", 0, 12);
            pen.setFont(font);
            double d2 = (double)height.intValue() * 0.8;
            pen.drawString(split[1], n3, (int)d2);
            pen.setColor(Color.BLACK);
            double d3 = (double)height.intValue() * 0.4;
            pen.drawString(split[0], 4, (int)d3);
        } else if (n2 == 3) {
            pen.setColor(Color.BLACK);
            Font font = new Font("Microsoft YaHei", 0, 12);
            pen.setFont(font);
            double d4 = (double)height.intValue() * 0.4;
            pen.drawString(split[2], 4, (int)d4);
            pen.setColor(Color.BLACK);
            double d5 = (double)height.intValue() * 0.24;
            double d6 = (double)width.intValue() / 1.5;
            pen.drawString(split[1], (int)d6, (int)d5);
            double d7 = (double)height.intValue() * 0.8;
            pen.drawString(split[0], (int)d6, (int)d7);
        }
    }

    public static void paintLine(Drawing drawing, ClientAnchor anchor, String lineType, String color) {
        XSSFDrawing xSSFDrawing = (XSSFDrawing)drawing;
        XSSFClientAnchor xSSFClientAnchor = (XSSFClientAnchor)anchor;
        XSSFSimpleShape xSSFSimpleShape = xSSFDrawing.createSimpleShape(xSSFClientAnchor);
        xSSFSimpleShape.setShapeType(1);
        xSSFSimpleShape.setFillColor(0, 0, 0);
        xSSFSimpleShape.setLineStyle(0);
        if (ObjectUtil.isNotEmpty((Object)color)) {
            int n = Integer.parseInt(color.substring(1, 3), 16);
            int n2 = Integer.parseInt(color.substring(3, 5), 16);
            int n3 = Integer.parseInt(color.substring(5, 7), 16);
            xSSFSimpleShape.setLineStyleColor(n, n2, n3);
        } else {
            xSSFSimpleShape.setLineStyleColor(0, 0, 0);
        }
        if (!lineType.equals("lefttop")) {
            xSSFSimpleShape.getCTShape().getSpPr().getXfrm().setFlipV(true);
        }
        xSSFSimpleShape.setLineWidth(1.0);
    }
}

