/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.common.util;

import cn.hutool.core.util.ObjectUtil;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.jeecg.modules.jmreport.common.expetion.JimuReportException;
import org.jeecg.modules.jmreport.common.util.JimuSpringContextUtils;
import org.jeecg.modules.jmreport.common.util.MinioUtil;
import org.jeecg.modules.jmreport.common.util.OssBootUtil;
import org.jeecg.modules.jmreport.common.util.oConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class CommonUtils {
    private static final Logger log = LoggerFactory.getLogger(CommonUtils.class);
    private static String DB_TYPE = "";

    public static String getFileName(String fileName) {
        int n;
        int n2 = fileName.lastIndexOf(47);
        int n3 = fileName.lastIndexOf(92);
        int n4 = n = n3 > n2 ? n3 : n2;
        if (n != -1) {
            fileName = fileName.substring(n + 1);
        }
        fileName = fileName.replace("=", "").replace(",", "").replace("&", "").replace("#", "");
        return fileName;
    }

    public static String upload(MultipartFile file, String bizPath, String uploadType) {
        String string = "";
        string = "minio".equals(uploadType) ? MinioUtil.upload(file, bizPath) : OssBootUtil.upload(file, bizPath);
        return string;
    }

    public static String upload(MultipartFile file, String bizPath, String uploadType, String customBucket) {
        String string = "";
        string = "minio".equals(uploadType) ? MinioUtil.upload(file, bizPath, customBucket) : OssBootUtil.upload(file, bizPath, customBucket);
        return string;
    }

    public static String getDatabaseType() {
        if (oConvertUtils.isNotEmpty(DB_TYPE)) {
            return DB_TYPE;
        }
        DataSource dataSource = (DataSource)JimuSpringContextUtils.getApplicationContext().getBean(DataSource.class);
        try {
            return CommonUtils.getDatabaseTypeByDataSource(dataSource);
        }
        catch (SQLException sQLException) {
            log.warn(sQLException.getMessage());
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDatabaseTypeByDataSource(DataSource dataSource) throws SQLException {
        block10: {
            if ("".equals(DB_TYPE)) {
                try (Connection connection = dataSource.getConnection();){
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    String string = databaseMetaData.getDatabaseProductName().toLowerCase();
                    if (string.indexOf("mysql") >= 0) {
                        DB_TYPE = "MYSQL";
                        break block10;
                    }
                    if (string.indexOf("oracle") >= 0) {
                        DB_TYPE = "ORACLE";
                        break block10;
                    }
                    if (string.indexOf("sqlserver") >= 0 || string.indexOf("sql server") >= 0) {
                        DB_TYPE = "SQLSERVER";
                        break block10;
                    }
                    if (string.indexOf("postgresql") >= 0) {
                        DB_TYPE = "POSTGRESQL";
                        break block10;
                    }
                    throw new JimuReportException("\u6570\u636e\u5e93\u7c7b\u578b:[" + string + "]\u4e0d\u8bc6\u522b!");
                }
            }
        }
        return DB_TYPE;
    }

    public static Integer getIntParameter(String params, Integer def) {
        HttpServletRequest httpServletRequest = JimuSpringContextUtils.getHttpServletRequest();
        String string = httpServletRequest.getParameter(params);
        if (CommonUtils.isNotEmpty(string)) {
            return Integer.parseInt(string.toString());
        }
        return def;
    }

    public static Integer getIntParameter(HttpServletRequest request, String params, Integer def) {
        String string = request.getParameter(params);
        if (CommonUtils.isNotEmpty(string)) {
            return Integer.parseInt(string.toString());
        }
        return def;
    }

    public static String filter(String str) throws PatternSyntaxException {
        String string = "[`_\u300a\u300b~!@#$%^&*()+=|{}':;',\\[\\].<>?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher(str);
        return matcher.replaceAll("").trim();
    }

    public static boolean anyOneIsNull(Object ... objs) {
        for (Object object : objs) {
            if (!CommonUtils.isEmpty(object)) continue;
            return true;
        }
        return false;
    }

    public static boolean anyOneIsNotNull(Object ... objs) {
        for (Object object : objs) {
            if (!CommonUtils.isNotEmpty(object)) continue;
            return true;
        }
        return false;
    }

    public static boolean allIsNull(Object ... objs) {
        int n = objs.length;
        int n2 = 0;
        for (int k = 0; k < n; ++k) {
            Object object = objs[k];
            if (!CommonUtils.isEmpty(object)) continue;
            ++n2;
        }
        return n2 == n;
    }

    public static <T> Long[] listToLong(List<T> list) {
        Long[] longArray = list.toArray(new Long[list.size()]);
        return longArray;
    }

    public static Boolean gt(BigDecimal v1, BigDecimal v2) {
        Boolean bl = false;
        if (v1.compareTo(v2) == 1) {
            bl = true;
        }
        return bl;
    }

    public static Boolean ge(BigDecimal v1, BigDecimal v2) {
        Boolean bl = false;
        if (v1.compareTo(v2) == 1) {
            bl = true;
        }
        if (v1.compareTo(v2) == 0) {
            bl = true;
        }
        return bl;
    }

    public static Boolean lt(BigDecimal v1, BigDecimal v2) {
        Boolean bl = false;
        if (v1.compareTo(v2) == -1) {
            bl = true;
        }
        return bl;
    }

    public static Boolean eq(BigDecimal v1, BigDecimal v2) {
        Boolean bl = false;
        if (CommonUtils.isNotEmpty(v1) && v1.compareTo(v2) == 0) {
            bl = true;
        }
        return bl;
    }

    public static Boolean le(BigDecimal v1, BigDecimal v2) {
        Boolean bl = false;
        if (CommonUtils.isNotEmpty(v1)) {
            if (v1.compareTo(v2) == -1) {
                bl = true;
            }
            if (v1.compareTo(v2) == 0) {
                bl = true;
            }
        }
        return bl;
    }

    public static Boolean gtzero(BigDecimal v) {
        Boolean bl = false;
        if (CommonUtils.isNotEmpty(v) && v.doubleValue() > 0.0) {
            bl = true;
        }
        return bl;
    }

    public static Boolean gezero(BigDecimal v) {
        Boolean bl = false;
        if (CommonUtils.isNotEmpty(v) && (v.compareTo(BigDecimal.ZERO) == 0 || v.compareTo(BigDecimal.ZERO) == 1)) {
            bl = true;
        }
        return bl;
    }

    public static Boolean eqzero(BigDecimal v) {
        Boolean bl = false;
        if (CommonUtils.isNotEmpty(v) && v.compareTo(BigDecimal.ZERO) == 0) {
            bl = true;
        }
        return bl;
    }

    public static Boolean nezero(BigDecimal v) {
        Boolean bl = true;
        if (CommonUtils.isNotEmpty(v) && v.compareTo(BigDecimal.ZERO) == 0) {
            bl = false;
        }
        return bl;
    }

    public static Boolean ltzero(BigDecimal v) {
        Boolean bl = false;
        if (CommonUtils.isNotEmpty(v) && v.doubleValue() < 0.0) {
            bl = true;
        }
        return bl;
    }

    public static Boolean lezero(BigDecimal v) {
        Boolean bl = false;
        if (CommonUtils.isNotEmpty(v)) {
            if (v.compareTo(BigDecimal.ZERO) == 0) {
                bl = true;
            }
            if (v.compareTo(BigDecimal.ZERO) == -1) {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean contains(String[] stringArray, String source) {
        List<String> list = Arrays.asList(stringArray);
        return list.contains(source);
    }

    public static boolean contains(List<String> stringArray, String source) {
        return stringArray.contains(source);
    }

    public static boolean allNotNull(Object ... obj) {
        return !CommonUtils.anyOneIsNull(obj);
    }

    public static boolean isNotEmpty(Object obj) {
        return !CommonUtils.isEmpty(obj);
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length() == 0;
        }
        if (obj instanceof String) {
            return ((String)obj).trim().equals("");
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        return obj instanceof Map ? ((Map)obj).isEmpty() : false;
    }

    public static String renamePic(String fileName) {
        String string = fileName.substring(fileName.lastIndexOf("."));
        return UUID.randomUUID().toString().replace("-", "") + string;
    }

    public static BigDecimal getBigDecimal(BigDecimal v, String def) {
        if (CommonUtils.isEmpty(v)) {
            return new BigDecimal(def);
        }
        return v;
    }

    public static BigDecimal getBigDecimal(BigDecimal v, BigDecimal def) {
        if (CommonUtils.isEmpty(v)) {
            return def;
        }
        return v;
    }

    public static String getString(String v) {
        if (CommonUtils.isEmpty(v)) {
            return "";
        }
        return v;
    }

    public static String getString(String v, String defval) {
        if (CommonUtils.isEmpty(v)) {
            return defval;
        }
        return v;
    }

    public static Integer getInteger(Integer v, Integer defval) {
        if (CommonUtils.isEmpty(v)) {
            return defval;
        }
        return v;
    }

    public static Integer getInteger(String v, Integer defval) {
        if (CommonUtils.isEmpty(v)) {
            return defval;
        }
        return Integer.parseInt(v);
    }

    public static String chineseNumber2Int(String chineseNumber) {
        String[] stringArray = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
        String[] stringArray2 = new String[]{"\u5341", "\u767e", "\u5343", "\u4e07", "\u5341", "\u767e", "\u5343", "\u4ebf", "\u5341", "\u767e", "\u5343"};
        String string = "";
        int n = chineseNumber.length();
        for (int k = 0; k < n; ++k) {
            int n2 = chineseNumber.charAt(k) - 48;
            string = k != n - 1 && n2 != 0 ? string + stringArray[n2] + stringArray2[n - 2 - k] : string + stringArray[n2];
            System.out.println("  " + string);
        }
        return string;
    }

    public static String getAlias(String tableName) {
        String[] stringArray = tableName.split("_");
        String string = "";
        if (stringArray.length > 2) {
            for (String string2 : stringArray) {
                string = string + string2.substring(0, 1);
            }
        } else {
            string = stringArray[stringArray.length - 1];
        }
        return string;
    }

    public static String string2Unicode(String string) {
        String string2 = "";
        if (CommonUtils.isNotEmpty(string)) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int k = 0; k < string.length(); ++k) {
                char c2 = string.charAt(k);
                stringBuffer.append("\\u" + Integer.toHexString(c2));
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    public static Long[] StringArray2LongArray(String[] stringArray) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (String string : stringArray) {
            try {
                arrayList.add(Long.parseLong(string));
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        Object[] objectArray = arrayList.toArray(new Long[arrayList.size()]);
        return objectArray;
    }

    public static String getString(Object obj, String def) {
        return ObjectUtil.isNotEmpty((Object)obj) ? obj.toString() : def;
    }

    public static Long getLong(Object obj, Long def) {
        return ObjectUtil.isNotEmpty((Object)obj) ? Long.parseLong(obj.toString()) : def;
    }
}

