/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.dyndb.util;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmreportFreemarkerParseFactory {
    private static final Logger log = LoggerFactory.getLogger(JmreportFreemarkerParseFactory.class);
    private static final String ENCODE = "utf-8";
    private static final Configuration _tplConfig = new Configuration();
    private static final Configuration _sqlConfig = new Configuration();
    private static StringTemplateLoader stringTemplateLoader = new StringTemplateLoader();
    private static final Pattern p = Pattern.compile("(?ms)/\\*.*?\\*/|^\\s*//.*?$");

    public static boolean isExistTemplate(String tplName) throws Exception {
        try {
            Template template = _tplConfig.getTemplate(tplName, "UTF-8");
            if (template == null) {
                return false;
            }
        }
        catch (Exception exception) {
            if (exception instanceof ParseException) {
                log.error(exception.getMessage(), exception.fillInStackTrace());
                throw new Exception(exception);
            }
            log.debug("----isExistTemplate----" + exception.toString());
            return false;
        }
        return true;
    }

    public static String parseTemplateContent(String tplContent, Map<String, Object> paras) {
        try {
            StringWriter stringWriter = new StringWriter();
            if (stringTemplateLoader.findTemplateSource("sql_" + tplContent.hashCode()) == null) {
                stringTemplateLoader.putTemplate("sql_" + tplContent.hashCode(), tplContent);
            }
            Template template = _sqlConfig.getTemplate("sql_" + tplContent.hashCode(), ENCODE);
            template.process(paras, (Writer)stringWriter);
            String string = JmreportFreemarkerParseFactory.getSqlText(stringWriter.toString());
            return string;
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), exception.fillInStackTrace());
            log.error("\u53d1\u9001\u4e00\u6b21\u7684\u6a21\u677fkey:{ " + tplContent + " }");
            throw new RuntimeException("\u89e3\u6790SQL\u6a21\u677f\u5f02\u5e38");
        }
    }

    private static String getSqlText(String sql) {
        sql = p.matcher(sql).replaceAll("");
        if ((sql = sql.replaceAll("\\n", " ").replaceAll("\\t", " ").replaceAll("\\s{1,}", " ").trim()).endsWith("where") || sql.endsWith("where ")) {
            sql = sql.substring(0, sql.lastIndexOf("where"));
        }
        int n = 0;
        while ((n = StringUtils.indexOfIgnoreCase((CharSequence)sql, (CharSequence)"where and", (int)n)) != -1) {
            sql = sql.substring(0, n + 5) + sql.substring(n + 9, sql.length());
        }
        n = 0;
        while ((n = StringUtils.indexOfIgnoreCase((CharSequence)sql, (CharSequence)", where", (int)n)) != -1) {
            sql = sql.substring(0, n) + sql.substring(n + 1, sql.length());
        }
        if (sql.endsWith(",") || sql.endsWith(", ")) {
            sql = sql.substring(0, sql.lastIndexOf(","));
        }
        return sql;
    }

    static {
        _tplConfig.setClassForTemplateLoading(new JmreportFreemarkerParseFactory().getClass(), "/");
        _tplConfig.setNumberFormat("0.#####################");
        _sqlConfig.setTemplateLoader((TemplateLoader)stringTemplateLoader);
        _sqlConfig.setNumberFormat("0.#####################");
        _sqlConfig.setClassicCompatible(true);
    }
}

