/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.dyndb;

import com.alibaba.druid.pool.DruidDataSource;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.ArrayUtils;
import org.jeecg.modules.jmreport.common.expetion.JimuReportException;
import org.jeecg.modules.jmreport.common.util.ReflectHelper;
import org.jeecg.modules.jmreport.common.util.oConvertUtils;
import org.jeecg.modules.jmreport.dyndb.JmreportDataSourceCachePool;
import org.jeecg.modules.jmreport.dyndb.util.JmreportFreemarkerParseFactory;
import org.jeecg.modules.jmreport.dyndb.vo.JmreportDynamicDataSourceVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Component;

@Component(value="JmreportDynamicDbUtil")
public class JmreportDynamicDbUtil {
    private static final Logger log = LoggerFactory.getLogger(JmreportDynamicDbUtil.class);

    @Deprecated
    private DruidDataSource getDruidDataSource(JmreportDynamicDataSourceVo dbSource) {
        DruidDataSource druidDataSource = new DruidDataSource();
        String string = dbSource.getDbDriver();
        String string2 = dbSource.getDbUrl();
        String string3 = dbSource.getDbUsername();
        String string4 = dbSource.getDbPassword();
        druidDataSource.setDriverClassName(string);
        druidDataSource.setUrl(string2);
        druidDataSource.setTestWhileIdle(true);
        druidDataSource.setTestOnBorrow(false);
        druidDataSource.setTestOnReturn(false);
        druidDataSource.setBreakAfterAcquireFailure(true);
        druidDataSource.setConnectionErrorRetryAttempts(0);
        druidDataSource.setUsername(string3);
        druidDataSource.setMaxWait(60000L);
        druidDataSource.setPassword(string4);
        log.info("******************************************");
        log.info("*                                        *");
        log.info("*====\u3010" + dbSource.getCode() + "\u3011=====Druid\u8fde\u63a5\u6c60\u5df2\u542f\u7528 ====*");
        log.info("*                                        *");
        log.info("******************************************");
        return druidDataSource;
    }

    private HikariDataSource getHikariDataSource(JmreportDynamicDataSourceVo dbSource) {
        HikariDataSource hikariDataSource = new HikariDataSource();
        String string = dbSource.getDbDriver();
        String string2 = dbSource.getDbUrl();
        String string3 = dbSource.getDbUsername();
        String string4 = dbSource.getDbPassword();
        hikariDataSource.setDriverClassName(string);
        hikariDataSource.setJdbcUrl(string2);
        hikariDataSource.setUsername(string3);
        hikariDataSource.setPassword(string4);
        log.info("******************************************");
        log.info("*                                        *");
        log.info("*====\u3010" + dbSource.getCode() + "\u3011=====Hikari\u8fde\u63a5\u6c60\u5df2\u542f\u7528 ====*");
        log.info("*                                        *");
        log.info("******************************************");
        return hikariDataSource;
    }

    public DataSource getDbSourceByDbKey(String dbKey) {
        log.info("----\u81ea\u5b9a\u4e49\u52a8\u6001\u6570\u636e\u6e90----------dbKey------: " + dbKey);
        DataSource dataSource = JmreportDataSourceCachePool.getCacheBasicDataSource(dbKey);
        try {
            if (dataSource != null) {
                log.info("--------getDbSourceBydbKey------------------\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6DB\u8fde\u63a5-------------------");
                return dataSource;
            }
            JmreportDynamicDataSourceVo jmreportDynamicDataSourceVo = JmreportDataSourceCachePool.getCacheDynamicDataSourceModel(dbKey);
            if (jmreportDynamicDataSourceVo == null) {
                throw new JimuReportException("\u52a8\u6001\u6570\u636e\u6e90\u8fde\u63a5\u4e0d\u5b58\u5728\uff0cdbKey\uff1a" + dbKey);
            }
            HikariDataSource hikariDataSource = this.getHikariDataSource(jmreportDynamicDataSourceVo);
            if (hikariDataSource == null) {
                throw new JimuReportException("\u52a8\u6001\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff0cdbKey\uff1a" + dbKey);
            }
            JmreportDataSourceCachePool.putCacheBasicDataSource(dbKey, (DataSource)hikariDataSource);
            log.info("--------getDbSourceBydbKey------------------\u521b\u5efaDB\u6570\u636e\u5e93\u8fde\u63a5-------------------");
            return hikariDataSource;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return dataSource;
        }
    }

    public void closeDbKey(String dbKey) {
        DataSource dataSource = this.getDbSourceByDbKey(dbKey);
        try {
            if (dataSource != null && !dataSource.getConnection().isClosed()) {
                dataSource.getConnection().commit();
                dataSource.getConnection().close();
                dataSource.getConnection().close();
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private JdbcTemplate getJdbcTemplate(String dbKey) {
        DataSource dataSource = this.getDbSourceByDbKey(dbKey);
        return new JdbcTemplate(dataSource);
    }

    public int update(String dbKey, String sql, Object ... param) {
        JdbcTemplate jdbcTemplate = this.getJdbcTemplate(dbKey);
        int n = ArrayUtils.isEmpty((Object[])param) ? jdbcTemplate.update(sql) : jdbcTemplate.update(sql, param);
        return n;
    }

    public int updateByHash(String dbKey, String sql, HashMap<String, Object> data) {
        JdbcTemplate jdbcTemplate = this.getJdbcTemplate(dbKey);
        sql = JmreportFreemarkerParseFactory.parseTemplateContent(sql, data);
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate.getDataSource());
        int n = namedParameterJdbcTemplate.update(sql, data);
        return n;
    }

    public Object findOne(String dbKey, String sql, Object ... param) {
        List<Map<String, Object>> list = this.findList(dbKey, sql, param);
        if (oConvertUtils.listIsEmpty(list)) {
            log.error("Except one, but not find actually");
        }
        if (list.size() > 1) {
            log.error("Except one, but more than one actually");
        }
        return list.get(0);
    }

    public Object findOneByHash(String dbKey, String sql, HashMap<String, Object> data) {
        List<Map<String, Object>> list = this.findListByHash(dbKey, sql, data);
        if (oConvertUtils.listIsEmpty(list)) {
            log.error("Except one, but not find actually");
        }
        if (list.size() > 1) {
            log.error("Except one, but more than one actually");
        }
        return list.get(0);
    }

    public <T> Object findOne(String dbKey, String sql, Class<T> clazz, Object ... param) {
        Map map = (Map)this.findOne(dbKey, sql, param);
        return ReflectHelper.setAll(clazz, (Map<String, Object>)map);
    }

    public <T> Object findOneByHash(String dbKey, String sql, Class<T> clazz, HashMap<String, Object> data) {
        Map map = (Map)this.findOneByHash(dbKey, sql, data);
        return ReflectHelper.setAll(clazz, (Map<String, Object>)map);
    }

    public List<Map<String, Object>> findList(String dbKey, String sql, Object ... param) {
        JdbcTemplate jdbcTemplate = this.getJdbcTemplate(dbKey);
        List list = ArrayUtils.isEmpty((Object[])param) ? jdbcTemplate.queryForList(sql) : jdbcTemplate.queryForList(sql, param);
        return list;
    }

    public List<Map<String, Object>> findListByHash(String dbKey, String sql, HashMap<String, Object> data) {
        JdbcTemplate jdbcTemplate = this.getJdbcTemplate(dbKey);
        sql = JmreportFreemarkerParseFactory.parseTemplateContent(sql, data);
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate.getDataSource());
        List list = namedParameterJdbcTemplate.queryForList(sql, data);
        return list;
    }

    public <T> List<T> findList(String dbKey, String sql, Class<T> clazz, Object ... param) {
        JdbcTemplate jdbcTemplate = this.getJdbcTemplate(dbKey);
        List list = ArrayUtils.isEmpty((Object[])param) ? jdbcTemplate.queryForList(sql, clazz) : jdbcTemplate.queryForList(sql, clazz, param);
        return list;
    }

    public <T> List<T> findListByHash(String dbKey, String sql, Class<T> clazz, HashMap<String, Object> data) {
        JdbcTemplate jdbcTemplate = this.getJdbcTemplate(dbKey);
        sql = JmreportFreemarkerParseFactory.parseTemplateContent(sql, data);
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate.getDataSource());
        List list = namedParameterJdbcTemplate.queryForList(sql, data, clazz);
        return list;
    }

    public <T> List<T> findListEntities(String dbKey, String sql, Class<T> clazz, Object ... param) {
        List<Map<String, Object>> list = this.findList(dbKey, sql, param);
        return ReflectHelper.transList2Entrys(list, clazz);
    }

    public <T> List<T> findListEntitiesByHash(String dbKey, String sql, Class<T> clazz, HashMap<String, Object> data) {
        List<Map<String, Object>> list = this.findListByHash(dbKey, sql, data);
        return ReflectHelper.transList2Entrys(list, clazz);
    }
}

