/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.common.util;

import io.minio.MinioClient;
import io.minio.errors.InvalidEndpointException;
import io.minio.errors.InvalidPortException;
import java.io.InputStream;
import java.net.URLDecoder;
import org.jeecg.modules.jmreport.common.util.CommonUtils;
import org.jeecg.modules.jmreport.common.util.oConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class MinioUtil {
    private static final Logger log = LoggerFactory.getLogger(MinioUtil.class);
    private static String minioUrl;
    private static String minioName;
    private static String minioPass;
    private static String bucketName;
    private static MinioClient minioClient;

    public static void setMinioUrl(String minioUrl) {
        MinioUtil.minioUrl = minioUrl;
    }

    public static void setMinioName(String minioName) {
        MinioUtil.minioName = minioName;
    }

    public static void setMinioPass(String minioPass) {
        MinioUtil.minioPass = minioPass;
    }

    public static void setBucketName(String bucketName) {
        MinioUtil.bucketName = bucketName;
    }

    public static String getMinioUrl() {
        return minioUrl;
    }

    public static String getBucketName() {
        return bucketName;
    }

    public static String upload(MultipartFile file, String bizPath, String customBucket) {
        String string = "";
        bizPath = CommonUtils.filter(bizPath);
        String string2 = bucketName;
        if (oConvertUtils.isNotEmpty(customBucket)) {
            string2 = customBucket;
        }
        try {
            MinioUtil.initMinio(minioUrl, minioName, minioPass);
            if (minioClient.bucketExists(string2)) {
                log.info("Bucket already exists.");
            } else {
                minioClient.makeBucket(string2);
                log.info("create a new bucket.");
            }
            InputStream inputStream = file.getInputStream();
            String string3 = file.getOriginalFilename();
            if ("".equals(string3)) {
                string3 = file.getName();
            }
            string3 = CommonUtils.getFileName(string3);
            String string4 = bizPath + "/" + string3.substring(0, string3.lastIndexOf(".")) + "_" + System.currentTimeMillis() + string3.substring(string3.indexOf("."));
            if (string4.startsWith("/")) {
                string4 = string4.substring(1);
            }
            minioClient.putObject(string2, string4, inputStream, (long)inputStream.available(), "application/octet-stream");
            inputStream.close();
            string = minioUrl + string2 + "/" + string4;
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
        }
        return string;
    }

    public static String upload(MultipartFile file, String bizPath) {
        return MinioUtil.upload(file, bizPath, null);
    }

    public static InputStream getMinioFile(String bucketName, String objectName) {
        InputStream inputStream = null;
        try {
            MinioUtil.initMinio(minioUrl, minioName, minioPass);
            inputStream = minioClient.getObject(bucketName, objectName);
        }
        catch (Exception exception) {
            log.info("\u6587\u4ef6\u83b7\u53d6\u5931\u8d25" + exception.getMessage());
        }
        return inputStream;
    }

    public static void removeObject(String bucketName, String objectName) {
        try {
            MinioUtil.initMinio(minioUrl, minioName, minioPass);
            minioClient.removeObject(bucketName, objectName);
        }
        catch (Exception exception) {
            log.info("\u6587\u4ef6\u5220\u9664\u5931\u8d25" + exception.getMessage());
        }
    }

    public static String getObjectURL(String bucketName, String objectName, Integer expires) {
        MinioUtil.initMinio(minioUrl, minioName, minioPass);
        try {
            String string = minioClient.presignedGetObject(bucketName, objectName, expires);
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (Exception exception) {
            log.info("\u6587\u4ef6\u8def\u5f84\u83b7\u53d6\u5931\u8d25" + exception.getMessage());
            return null;
        }
    }

    private static MinioClient initMinio(String minioUrl, String minioName, String minioPass) {
        if (minioClient == null) {
            try {
                minioClient = new MinioClient(minioUrl, minioName, minioPass);
            }
            catch (InvalidEndpointException invalidEndpointException) {
                invalidEndpointException.printStackTrace();
            }
            catch (InvalidPortException invalidPortException) {
                invalidPortException.printStackTrace();
            }
        }
        return minioClient;
    }

    public static String upload(InputStream stream, String relativePath) throws Exception {
        MinioUtil.initMinio(minioUrl, minioName, minioPass);
        if (minioClient.bucketExists(bucketName)) {
            log.info("Bucket already exists.");
        } else {
            minioClient.makeBucket(bucketName);
            log.info("create a new bucket.");
        }
        minioClient.putObject(bucketName, relativePath, stream, (long)stream.available(), "application/octet-stream");
        stream.close();
        return minioUrl + bucketName + "/" + relativePath;
    }

    static {
        minioClient = null;
    }
}

