/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.common.util;

import cn.hutool.core.util.ObjectUtil;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.jeecg.modules.jmreport.common.expetion.JimuReportException;
import org.jeecg.modules.jmreport.common.util.JimuSpringContextUtils;
import org.jeecg.modules.jmreport.common.util.MinioUtil;
import org.jeecg.modules.jmreport.common.util.OssBootUtil;
import org.jeecg.modules.jmreport.common.util.oConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class CommonUtils {
    private static final Logger log = LoggerFactory.getLogger(CommonUtils.class);
    private static String DB_TYPE = "";

    public static String getFileName(String fileName) {
        int n;
        int n2 = fileName.lastIndexOf(47);
        int n3 = fileName.lastIndexOf(92);
        int n4 = n = n3 > n2 ? n3 : n2;
        if (n != -1) {
            fileName = fileName.substring(n + 1);
        }
        fileName = fileName.replace("=", "").replace(",", "").replace("&", "").replace("#", "");
        return fileName;
    }

    public static String upload(MultipartFile file, String bizPath, String uploadType) {
        String string = "";
        string = "minio".equals(uploadType) ? MinioUtil.upload(file, bizPath) : OssBootUtil.upload(file, bizPath);
        return string;
    }

    public static String upload(MultipartFile file, String bizPath, String uploadType, String customBucket) {
        String string = "";
        string = "minio".equals(uploadType) ? MinioUtil.upload(file, bizPath, customBucket) : OssBootUtil.upload(file, bizPath, customBucket);
        return string;
    }

    public static String getDatabaseType() {
        if (oConvertUtils.isNotEmpty(DB_TYPE)) {
            return DB_TYPE;
        }
        DataSource dataSource = (DataSource)JimuSpringContextUtils.getApplicationContext().getBean(DataSource.class);
        try {
            return CommonUtils.getDatabaseTypeByDataSource(dataSource);
        }
        catch (SQLException sQLException) {
            log.warn(sQLException.getMessage());
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDatabaseTypeByDataSource(DataSource dataSource) throws SQLException {
        block10: {
            if ("".equals(DB_TYPE)) {
                try (Connection connection = dataSource.getConnection();){
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    String string = databaseMetaData.getDatabaseProductName().toLowerCase();
                    if (string.indexOf("mysql") >= 0) {
                        DB_TYPE = "MYSQL";
                        break block10;
                    }
                    if (string.indexOf("oracle") >= 0) {
                        DB_TYPE = "ORACLE";
                        break block10;
                    }
                    if (string.indexOf("sqlserver") >= 0 || string.indexOf("sql server") >= 0) {
                        DB_TYPE = "SQLSERVER";
                        break block10;
                    }
                    if (string.indexOf("postgresql") >= 0) {
                        DB_TYPE = "POSTGRESQL";
                        break block10;
                    }
                    throw new JimuReportException("\u6570\u636e\u5e93\u7c7b\u578b:[" + string + "]\u4e0d\u8bc6\u522b!");
                }
            }
        }
        return DB_TYPE;
    }

    public static Integer getIntParameter(String params, Integer def) {
        HttpServletRequest httpServletRequest = JimuSpringContextUtils.getHttpServletRequest();
        String string = httpServletRequest.getParameter(params);
        if (CommonUtils.isNotEmpty(string)) {
            return Integer.parseInt(string.toString());
        }
        return def;
    }

    public static Integer getIntParameter(HttpServletRequest request, String params, Integer def) {
        String string = request.getParameter(params);
        if (CommonUtils.isNotEmpty(string)) {
            return Integer.parseInt(string.toString());
        }
        return def;
    }

    public static String filter(String str) throws PatternSyntaxException {
        String string = "[`_\u300a\u300b~!@#$%^&*()+=|{}':;',\\[\\].<>?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher(str);
        return matcher.replaceAll("").trim();
    }

    public static boolean isNotEmpty(Object obj) {
        return !CommonUtils.isEmpty(obj);
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length() == 0;
        }
        if (obj instanceof String) {
            return ((String)obj).trim().equals("");
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        return obj instanceof Map ? ((Map)obj).isEmpty() : false;
    }

    public static String getString(Object obj, String def) {
        return ObjectUtil.isNotEmpty((Object)obj) ? obj.toString() : def;
    }

    public static Long getLong(Object obj, Long def) {
        return ObjectUtil.isNotEmpty((Object)obj) ? Long.parseLong(obj.toString()) : def;
    }
}

