/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.common.interceptor;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.modules.jmreport.common.annotation.JimuLoginRequired;
import org.jeecg.modules.jmreport.common.util.oConvertUtils;
import org.jeecg.modules.jmreport.common.vo.Result;
import org.jeecg.modules.jmreport.config.client.JmReportTokenClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class JimuReportInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(JimuReportInterceptor.class);
    @Autowired
    private JmReportTokenClient jimuTokenClient;
    @Value(value="${jeecg.jmreport.customPrePath:}")
    private String customPrePath;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        request.setAttribute("customPrePath", (Object)this.customPrePath);
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Method method = handlerMethod.getMethod();
        JimuLoginRequired jimuLoginRequired = method.getAnnotation(JimuLoginRequired.class);
        String string = this.filterUrl(request.getRequestURI().substring(request.getContextPath().length()));
        log.debug("JimuReportInterceptor check requestPath = " + string);
        if (ObjectUtil.isNotEmpty((Object)jimuLoginRequired) && jimuLoginRequired.required() && !this.verifyToken(request)) {
            log.info("\u8bf7\u6c42\u65e0\u6743\u9650(" + request.getMethod() + ")\uff1a" + string);
            this.backError(response);
            return false;
        }
        return true;
    }

    private boolean verifyToken(HttpServletRequest request) {
        return this.jimuTokenClient.verifyToken(request);
    }

    private String filterUrl(String requestPath) {
        String string = "";
        if (oConvertUtils.isNotEmpty(requestPath)) {
            string = requestPath.replace("\\", "/");
            string = requestPath.replace("//", "/");
            if (string.indexOf("//") >= 0) {
                string = this.filterUrl(string);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backError(HttpServletResponse response) {
        PrintWriter printWriter = null;
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        response.setHeader("auth", "fail");
        try {
            printWriter = response.getWriter();
            Result<Object> result = Result.error("Token\u6821\u9a8c\u5931\u8d25\uff0c\u65e0\u6743\u9650\u8bbf\u95ee\uff01");
            printWriter.print(JSON.toJSON(result));
        }
        catch (IOException iOException) {
            log.error(iOException.getMessage());
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }
}

