/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.rp.sdk.http.utils;

import com.gexin.rp.sdk.base.uitls.StringUtils;
import com.gexin.rp.sdk.http.GtHttpProxy;
import com.gexin.rp.sdk.http.client.GtHttpClient;
import com.gexin.rp.sdk.http.utils.GTConfig;
import com.gexin.rp.sdk.http.utils.OSDomainWrapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class PushDomainManager {
    private static final GtHttpClient client = new GtHttpClient(GTConfig.getHttpConnectionTimeOut(), GTConfig.getHttpSoTimeOut(), 1);
    private static final Map<String, OSDomainWrapper> domainMap = new ConcurrentHashMap<String, OSDomainWrapper>();
    private static final Set<String> domainPool = new HashSet<String>();
    private static AtomicBoolean isRunning = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cycleTest() {
        try {
            Map<String, Long> rankMap = PushDomainManager.rankDomain();
            PushDomainManager.updateFastestDomain(rankMap);
        }
        catch (Exception exception) {
        }
        finally {
            isRunning.compareAndSet(true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Long> rankDomain() {
        HashMap<String, Long> rankMap = new HashMap<String, Long>();
        if (domainPool.isEmpty()) {
            return rankMap;
        }
        Set<String> set = domainPool;
        synchronized (set) {
            for (String url : domainPool) {
                long responseTime = PushDomainManager.getResponseTime(url);
                if (responseTime == Long.MAX_VALUE) continue;
                rankMap.put(url, responseTime);
            }
        }
        return rankMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateFastestDomain(Map<String, Long> rankMap) {
        Map<String, OSDomainWrapper> map = domainMap;
        synchronized (map) {
            for (OSDomainWrapper wrapper : domainMap.values()) {
                if (!rankMap.isEmpty()) {
                    String fastUrl = PushDomainManager.getMinResponseTimeUrl(rankMap, wrapper);
                    if (StringUtils.isNotBlank((CharSequence)fastUrl)) {
                        wrapper.setFasterUrl(fastUrl);
                        continue;
                    }
                    if (wrapper.isAssigned() && rankMap.containsKey(wrapper.getAssignedUrl())) {
                        wrapper.setFasterUrl(wrapper.getAssignedUrl());
                        continue;
                    }
                }
                if (!wrapper.isFailCountOverLimit()) continue;
                PushDomainManager.setOrUpdateFastUrl(wrapper, GTConfig.getDefaultDomainUrl(wrapper.isSSL()));
                PushDomainManager.addDomainUrls(wrapper.getDomainUrls());
            }
        }
    }

    private static String getMinResponseTimeUrl(Map<String, Long> rankMap, OSDomainWrapper wrapper) {
        long minTime = Long.MAX_VALUE;
        String fastUrl = "";
        for (String url : wrapper.getDomainUrls()) {
            if (!rankMap.containsKey(url) || minTime - rankMap.get(url) <= 0L) continue;
            minTime = rankMap.get(url);
            fastUrl = url;
        }
        return fastUrl;
    }

    private static long getResponseTime(String host) {
        try {
            long start = System.currentTimeMillis();
            client.executeHead(host);
            long end = System.currentTimeMillis();
            return end - start;
        }
        catch (Throwable e) {
            return Long.MAX_VALUE;
        }
    }

    public static void initOSDomain(String domainKey, OSDomainWrapper wrapper) {
        if (!wrapper.isAssigned()) {
            List<String> domainUrls = wrapper.getDomainUrls();
            if (domainUrls == null) {
                domainUrls = GTConfig.getDefaultDomainUrl(wrapper.isSSL());
            }
            PushDomainManager.setOrUpdateFastUrl(wrapper, domainUrls);
        }
        PushDomainManager.addOSDomainWrapper(domainKey, wrapper);
    }

    private static void setOrUpdateFastUrl(OSDomainWrapper wrapper, List<String> domainUrls) {
        List<String> osPushDomainUrlList = PushDomainManager.getOSPushDomainUrlList(domainUrls, wrapper.getAppKey());
        wrapper.setDomainUrls(osPushDomainUrlList);
        wrapper.setFasterUrl(osPushDomainUrlList.get(0));
        wrapper.reSetContinuousFailCount();
    }

    private static List<String> getOSPushDomainUrlList(List<String> hosts, String appKey) {
        List urlList = null;
        HashMap<String, Object> postData = new HashMap<String, Object>(4);
        postData.put("action", "getOSPushDomailUrlListAction");
        postData.put("appkey", appKey);
        Exception ex = null;
        for (String host : hosts) {
            try {
                Map<String, Object> response = client.executePostJson(host, postData, false, false);
                urlList = (List)response.get("osList");
                if (urlList == null || urlList.size() <= 0) continue;
                break;
            }
            catch (Exception e) {
                ex = e;
            }
        }
        if (urlList == null || urlList.size() <= 0) {
            throw new RuntimeException("Can not get hosts from " + hosts, ex);
        }
        return urlList;
    }

    public static void notifyDomainError(String domainKey, List<String> osList) {
        OSDomainWrapper wrapper = domainMap.get(domainKey);
        if (wrapper == null || osList == null || osList.isEmpty()) {
            return;
        }
        wrapper.setDomainUrls(osList);
    }

    public static void notifyServerError(String domainKey) {
        OSDomainWrapper wrapper = domainMap.get(domainKey);
        if (wrapper == null) {
            return;
        }
        if (wrapper.isNeedTrigger() && isRunning.compareAndSet(false, true)) {
            wrapper.updateTriggerTime();
            PushDomainManager.triggerCheck();
        }
    }

    private static void triggerCheck() {
        Thread triggerCheckThread = new Thread(new Runnable(){

            @Override
            public void run() {
                PushDomainManager.cycleTest();
            }
        }, "triggerCheckThread");
        triggerCheckThread.start();
    }

    public static String getFastUrl(String domainKey) {
        return domainMap.get(domainKey).getFasterUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addOSDomainWrapper(String domainKey, OSDomainWrapper wrapper) {
        if (wrapper == null) {
            return;
        }
        Map<String, OSDomainWrapper> map = domainMap;
        synchronized (map) {
            domainMap.put(domainKey, wrapper);
        }
        PushDomainManager.addDomainUrls(wrapper.getDomainUrls());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDomainUrls(List<String> domainUrls) {
        if (domainUrls == null) {
            return;
        }
        Set<String> set = domainPool;
        synchronized (set) {
            for (String domainUrl : domainUrls) {
                domainPool.add(domainUrl.replaceAll(":(80|443)", ""));
            }
        }
    }

    public static void initProxy(GtHttpProxy proxy) {
        client.setProxy(proxy);
    }

    static {
        Thread cycleThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    try {
                        if (!isRunning.compareAndSet(false, true)) continue;
                        PushDomainManager.cycleTest();
                        continue;
                    }
                    finally {
                        try {
                            Thread.sleep(GTConfig.getHttpInspectInterval());
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    break;
                }
            }
        }, "cycleTestThread");
        cycleThread.setDaemon(true);
        cycleThread.start();
    }
}

