/*
 * Decompiled with CFR 0.152.
 */
package com.ckfinder.connector.plugins;

import com.ckfinder.connector.configuration.IConfiguration;
import com.ckfinder.connector.data.BeforeExecuteCommandEventArgs;
import com.ckfinder.connector.data.EventArgs;
import com.ckfinder.connector.data.IEventHandler;
import com.ckfinder.connector.data.PluginInfo;
import com.ckfinder.connector.data.PluginParam;
import com.ckfinder.connector.data.ResourceType;
import com.ckfinder.connector.errors.ConnectorException;
import com.ckfinder.connector.handlers.command.XMLCommand;
import com.ckfinder.connector.utils.AccessControlUtil;
import com.ckfinder.connector.utils.FileUtils;
import com.ckfinder.connector.utils.ImageUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Element;

public class ImageResizeCommad
extends XMLCommand
implements IEventHandler {
    private PluginInfo pluginInfo;
    private String fileName;
    private String newFileName;
    private String overwrite;
    private Integer width;
    private Integer height;
    private boolean wrongReqSizesParams;
    private Map<String, String> sizesFromReq;
    private static final String[] SIZES = new String[]{"small", "medium", "large"};

    public boolean runEventHandler(EventArgs eventArgs, IConfiguration configuration1) throws ConnectorException {
        BeforeExecuteCommandEventArgs args = (BeforeExecuteCommandEventArgs)eventArgs;
        if ("ImageResize".equals(args.getCommand())) {
            this.runCommand(args.getRequest(), args.getResponse(), configuration1, new Object[0]);
            return false;
        }
        return true;
    }

    protected void createXMLChildNodes(int arg0, Element arg1) throws ConnectorException {
    }

    protected int getDataForXml() {
        if (!AccessControlUtil.getInstance((IConfiguration)this.configuration).checkFolderACL(this.type, this.currentFolder, this.userRole, 160)) {
            return 103;
        }
        if (this.fileName == null || this.fileName.equals("")) {
            return 102;
        }
        if (!FileUtils.checkFileName((String)this.fileName) || FileUtils.checkIfFileIsHidden((String)this.fileName, (IConfiguration)this.configuration)) {
            return 109;
        }
        if (FileUtils.checkFileExtension((String)this.fileName, (ResourceType)((ResourceType)this.configuration.getTypes().get(this.type))) == 1) {
            return 109;
        }
        File file = new File(((ResourceType)this.configuration.getTypes().get(this.type)).getPath() + this.currentFolder, this.fileName);
        try {
            if (!file.exists() || !file.isFile()) {
                return 117;
            }
            if (this.wrongReqSizesParams) {
                return 109;
            }
            if (this.width != null && this.height != null) {
                if (!FileUtils.checkFileName((String)this.newFileName) && FileUtils.checkIfFileIsHidden((String)this.newFileName, (IConfiguration)this.configuration)) {
                    return 102;
                }
                if (FileUtils.checkFileExtension((String)this.newFileName, (ResourceType)((ResourceType)this.configuration.getTypes().get(this.type))) == 1) {
                    return 105;
                }
                File thumbFile = new File(((ResourceType)this.configuration.getTypes().get(this.type)).getPath() + this.currentFolder, this.newFileName);
                if (thumbFile.canWrite()) {
                    return 104;
                }
                if (!"1".equals(this.overwrite) && thumbFile.exists()) {
                    return 115;
                }
                int maxImageHeight = this.configuration.getImgHeight();
                int maxImageWidth = this.configuration.getImgWidth();
                if (maxImageWidth > 0 && this.width > maxImageWidth || maxImageHeight > 0 && this.height > maxImageHeight) {
                    return 109;
                }
                try {
                    ImageUtils.createResizedImage((File)file, (File)thumbFile, (int)this.width, (int)this.height, (float)this.configuration.getImgQuality());
                }
                catch (IOException e) {
                    if (this.configuration.isDebugMode()) {
                        this.exception = e;
                    }
                    return 104;
                }
            }
            String fileNameWithoutExt = FileUtils.getFileNameWithoutExtension((String)this.fileName);
            String fileExt = FileUtils.getFileExtension((String)this.fileName);
            for (String size : SIZES) {
                if (this.sizesFromReq.get(size) == null || !this.sizesFromReq.get(size).equals("1")) continue;
                String thumbName = fileNameWithoutExt.concat("_").concat(size).concat(".").concat(fileExt);
                File thumbFile = new File(((ResourceType)this.configuration.getTypes().get(this.type)).getPath().concat(this.currentFolder).concat(thumbName));
                for (PluginParam param : this.pluginInfo.getParams()) {
                    if (!size.concat("Thumb").equals(param.getName()) || !this.checkParamSize(param.getValue())) continue;
                    String[] params = this.parseValue(param.getValue());
                    try {
                        ImageUtils.createResizedImage((File)file, (File)thumbFile, (int)Integer.valueOf(params[0]), (int)Integer.valueOf(params[1]), (float)this.configuration.getImgQuality());
                    }
                    catch (IOException e) {
                        if (this.configuration.isDebugMode()) {
                            this.exception = e;
                        }
                        return 104;
                    }
                }
            }
        }
        catch (SecurityException e) {
            if (this.configuration.isDebugMode()) {
                this.exception = e;
            }
            return 104;
        }
        return 0;
    }

    private String[] parseValue(String value) {
        StringTokenizer st = new StringTokenizer(value, "x");
        String[] res = new String[]{st.nextToken(), st.nextToken()};
        return res;
    }

    private boolean checkParamSize(String value) {
        return Pattern.matches("(\\d)+x(\\d)+", value);
    }

    public void initParams(HttpServletRequest request, IConfiguration configuration1, Object ... params) throws ConnectorException {
        super.initParams(request, configuration1, params);
        this.sizesFromReq = new HashMap<String, String>();
        this.fileName = this.getParameter(request, "fileName");
        this.newFileName = this.getParameter(request, "newFileName");
        this.overwrite = request.getParameter("overwrite");
        String width = request.getParameter("width");
        String height = request.getParameter("height");
        this.wrongReqSizesParams = false;
        try {
            this.width = width != null && !width.equals("") ? Integer.valueOf(width) : null;
        }
        catch (NumberFormatException e) {
            this.width = null;
            this.wrongReqSizesParams = true;
        }
        try {
            this.height = height != null && !height.equals("") ? Integer.valueOf(height) : null;
        }
        catch (NumberFormatException e) {
            this.height = null;
            this.wrongReqSizesParams = true;
        }
        for (String size : SIZES) {
            this.sizesFromReq.put(size, request.getParameter(size));
        }
    }

    public ImageResizeCommad(PluginInfo pluginInfo) {
        this.pluginInfo = pluginInfo;
    }
}

