/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BinaryRedisPipeline;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Client;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.Queable;
import redis.clients.jedis.RedisPipeline;
import redis.clients.jedis.Response;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;

abstract class PipelineBase
extends Queable
implements BinaryRedisPipeline,
RedisPipeline {
    PipelineBase() {
    }

    protected abstract Client getClient(String var1);

    protected abstract Client getClient(byte[] var1);

    @Override
    public Response<Long> append(String key, String value) {
        this.getClient(key).append(key, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> append(byte[] key, byte[] value) {
        this.getClient(key).append(key, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<List<String>> blpop(String key) {
        String[] temp = new String[]{key};
        this.getClient(key).blpop(temp);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    @Override
    public Response<List<String>> brpop(String key) {
        String[] temp = new String[]{key};
        this.getClient(key).brpop(temp);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    @Override
    public Response<List<byte[]>> blpop(byte[] key) {
        byte[][] temp = new byte[][]{key};
        this.getClient(key).blpop(temp);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_LIST);
    }

    @Override
    public Response<List<byte[]>> brpop(byte[] key) {
        byte[][] temp = new byte[][]{key};
        this.getClient(key).brpop(temp);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_LIST);
    }

    @Override
    public Response<Long> decr(String key) {
        this.getClient(key).decr(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> decr(byte[] key) {
        this.getClient(key).decr(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> decrBy(String key, long integer) {
        this.getClient(key).decrBy(key, integer);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> decrBy(byte[] key, long integer) {
        this.getClient(key).decrBy(key, integer);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> del(String key) {
        this.getClient(key).del(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> del(byte[] key) {
        this.getClient(key).del(new byte[][]{key});
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> echo(String string) {
        this.getClient(string).echo(string);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<byte[]> echo(byte[] string) {
        this.getClient(string).echo(string);
        return this.getResponse(BuilderFactory.BYTE_ARRAY);
    }

    @Override
    public Response<Boolean> exists(String key) {
        this.getClient(key).exists(key);
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    @Override
    public Response<Boolean> exists(byte[] key) {
        this.getClient(key).exists(key);
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    @Override
    public Response<Long> expire(String key, int seconds) {
        this.getClient(key).expire(key, seconds);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> expire(byte[] key, int seconds) {
        this.getClient(key).expire(key, seconds);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> expireAt(String key, long unixTime) {
        this.getClient(key).expireAt(key, unixTime);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> expireAt(byte[] key, long unixTime) {
        this.getClient(key).expireAt(key, unixTime);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> get(String key) {
        this.getClient(key).get(key);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<byte[]> get(byte[] key) {
        this.getClient(key).get(key);
        return this.getResponse(BuilderFactory.BYTE_ARRAY);
    }

    @Override
    public Response<Boolean> getbit(String key, long offset) {
        this.getClient(key).getbit(key, offset);
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    @Override
    public Response<Boolean> getbit(byte[] key, long offset) {
        this.getClient(key).getbit(key, offset);
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    public Response<Long> bitpos(String key, boolean value) {
        return this.bitpos(key, value, new BitPosParams());
    }

    public Response<Long> bitpos(String key, boolean value, BitPosParams params) {
        this.getClient(key).bitpos(key, value, params);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> bitpos(byte[] key, boolean value) {
        return this.bitpos(key, value, new BitPosParams());
    }

    public Response<Long> bitpos(byte[] key, boolean value, BitPosParams params) {
        this.getClient(key).bitpos(key, value, params);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> getrange(String key, long startOffset, long endOffset) {
        this.getClient(key).getrange(key, startOffset, endOffset);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> getSet(String key, String value) {
        this.getClient(key).getSet(key, value);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<byte[]> getSet(byte[] key, byte[] value) {
        this.getClient(key).getSet(key, value);
        return this.getResponse(BuilderFactory.BYTE_ARRAY);
    }

    @Override
    public Response<Long> getrange(byte[] key, long startOffset, long endOffset) {
        this.getClient(key).getrange(key, startOffset, endOffset);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> hdel(String key, String ... field) {
        this.getClient(key).hdel(key, field);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> hdel(byte[] key, byte[] ... field) {
        this.getClient(key).hdel(key, field);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Boolean> hexists(String key, String field) {
        this.getClient(key).hexists(key, field);
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    @Override
    public Response<Boolean> hexists(byte[] key, byte[] field) {
        this.getClient(key).hexists(key, field);
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    @Override
    public Response<String> hget(String key, String field) {
        this.getClient(key).hget(key, field);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<byte[]> hget(byte[] key, byte[] field) {
        this.getClient(key).hget(key, field);
        return this.getResponse(BuilderFactory.BYTE_ARRAY);
    }

    @Override
    public Response<Map<String, String>> hgetAll(String key) {
        this.getClient(key).hgetAll(key);
        return this.getResponse(BuilderFactory.STRING_MAP);
    }

    @Override
    public Response<Map<byte[], byte[]>> hgetAll(byte[] key) {
        this.getClient(key).hgetAll(key);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_MAP);
    }

    @Override
    public Response<Long> hincrBy(String key, String field, long value) {
        this.getClient(key).hincrBy(key, field, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> hincrBy(byte[] key, byte[] field, long value) {
        this.getClient(key).hincrBy(key, field, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Set<String>> hkeys(String key) {
        this.getClient(key).hkeys(key);
        return this.getResponse(BuilderFactory.STRING_SET);
    }

    @Override
    public Response<Set<byte[]>> hkeys(byte[] key) {
        this.getClient(key).hkeys(key);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<Long> hlen(String key) {
        this.getClient(key).hlen(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> hlen(byte[] key) {
        this.getClient(key).hlen(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<List<String>> hmget(String key, String ... fields) {
        this.getClient(key).hmget(key, fields);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    @Override
    public Response<List<byte[]>> hmget(byte[] key, byte[] ... fields) {
        this.getClient(key).hmget(key, fields);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_LIST);
    }

    @Override
    public Response<String> hmset(String key, Map<String, String> hash) {
        this.getClient(key).hmset(key, hash);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> hmset(byte[] key, Map<byte[], byte[]> hash) {
        this.getClient(key).hmset(key, hash);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<Long> hset(String key, String field, String value) {
        this.getClient(key).hset(key, field, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> hset(byte[] key, byte[] field, byte[] value) {
        this.getClient(key).hset(key, field, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> hsetnx(String key, String field, String value) {
        this.getClient(key).hsetnx(key, field, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> hsetnx(byte[] key, byte[] field, byte[] value) {
        this.getClient(key).hsetnx(key, field, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<List<String>> hvals(String key) {
        this.getClient(key).hvals(key);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    @Override
    public Response<List<byte[]>> hvals(byte[] key) {
        this.getClient(key).hvals(key);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_LIST);
    }

    @Override
    public Response<Long> incr(String key) {
        this.getClient(key).incr(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> incr(byte[] key) {
        this.getClient(key).incr(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> incrBy(String key, long integer) {
        this.getClient(key).incrBy(key, integer);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> incrBy(byte[] key, long integer) {
        this.getClient(key).incrBy(key, integer);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> lindex(String key, long index) {
        this.getClient(key).lindex(key, index);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<byte[]> lindex(byte[] key, long index) {
        this.getClient(key).lindex(key, index);
        return this.getResponse(BuilderFactory.BYTE_ARRAY);
    }

    @Override
    public Response<Long> linsert(String key, BinaryClient.LIST_POSITION where, String pivot, String value) {
        this.getClient(key).linsert(key, where, pivot, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> linsert(byte[] key, BinaryClient.LIST_POSITION where, byte[] pivot, byte[] value) {
        this.getClient(key).linsert(key, where, pivot, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> llen(String key) {
        this.getClient(key).llen(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> llen(byte[] key) {
        this.getClient(key).llen(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> lpop(String key) {
        this.getClient(key).lpop(key);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<byte[]> lpop(byte[] key) {
        this.getClient(key).lpop(key);
        return this.getResponse(BuilderFactory.BYTE_ARRAY);
    }

    @Override
    public Response<Long> lpush(String key, String ... string) {
        this.getClient(key).lpush(key, string);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> lpush(byte[] key, byte[] ... string) {
        this.getClient(key).lpush(key, string);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> lpushx(String key, String ... string) {
        this.getClient(key).lpushx(key, string);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> lpushx(byte[] key, byte[] ... bytes) {
        this.getClient(key).lpushx(key, bytes);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<List<String>> lrange(String key, long start, long end) {
        this.getClient(key).lrange(key, start, end);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    @Override
    public Response<List<byte[]>> lrange(byte[] key, long start, long end) {
        this.getClient(key).lrange(key, start, end);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_LIST);
    }

    @Override
    public Response<Long> lrem(String key, long count, String value) {
        this.getClient(key).lrem(key, count, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> lrem(byte[] key, long count, byte[] value) {
        this.getClient(key).lrem(key, count, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> lset(String key, long index, String value) {
        this.getClient(key).lset(key, index, value);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> lset(byte[] key, long index, byte[] value) {
        this.getClient(key).lset(key, index, value);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> ltrim(String key, long start, long end) {
        this.getClient(key).ltrim(key, start, end);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> ltrim(byte[] key, long start, long end) {
        this.getClient(key).ltrim(key, start, end);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<Long> move(String key, int dbIndex) {
        this.getClient(key).move(key, dbIndex);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> move(byte[] key, int dbIndex) {
        this.getClient(key).move(key, dbIndex);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> persist(String key) {
        this.getClient(key).persist(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> persist(byte[] key) {
        this.getClient(key).persist(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> rpop(String key) {
        this.getClient(key).rpop(key);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<byte[]> rpop(byte[] key) {
        this.getClient(key).rpop(key);
        return this.getResponse(BuilderFactory.BYTE_ARRAY);
    }

    @Override
    public Response<Long> rpush(String key, String ... string) {
        this.getClient(key).rpush(key, string);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> rpush(byte[] key, byte[] ... string) {
        this.getClient(key).rpush(key, string);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> rpushx(String key, String ... string) {
        this.getClient(key).rpushx(key, string);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> rpushx(byte[] key, byte[] ... string) {
        this.getClient(key).rpushx(key, string);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> sadd(String key, String ... member) {
        this.getClient(key).sadd(key, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> sadd(byte[] key, byte[] ... member) {
        this.getClient(key).sadd(key, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> scard(String key) {
        this.getClient(key).scard(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> scard(byte[] key) {
        this.getClient(key).scard(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> set(String key, String value) {
        this.getClient(key).set(key, value);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> set(byte[] key, byte[] value) {
        this.getClient(key).set(key, value);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<Boolean> setbit(String key, long offset, boolean value) {
        this.getClient(key).setbit(key, offset, value);
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    @Override
    public Response<Boolean> setbit(byte[] key, long offset, byte[] value) {
        this.getClient(key).setbit(key, offset, value);
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    @Override
    public Response<String> setex(String key, int seconds, String value) {
        this.getClient(key).setex(key, seconds, value);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> setex(byte[] key, int seconds, byte[] value) {
        this.getClient(key).setex(key, seconds, value);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<Long> setnx(String key, String value) {
        this.getClient(key).setnx(key, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> setnx(byte[] key, byte[] value) {
        this.getClient(key).setnx(key, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> setrange(String key, long offset, String value) {
        this.getClient(key).setrange(key, offset, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> setrange(byte[] key, long offset, byte[] value) {
        this.getClient(key).setrange(key, offset, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Boolean> sismember(String key, String member) {
        this.getClient(key).sismember(key, member);
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    @Override
    public Response<Boolean> sismember(byte[] key, byte[] member) {
        this.getClient(key).sismember(key, member);
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    @Override
    public Response<Set<String>> smembers(String key) {
        this.getClient(key).smembers(key);
        return this.getResponse(BuilderFactory.STRING_SET);
    }

    @Override
    public Response<Set<byte[]>> smembers(byte[] key) {
        this.getClient(key).smembers(key);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<List<String>> sort(String key) {
        this.getClient(key).sort(key);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    @Override
    public Response<List<byte[]>> sort(byte[] key) {
        this.getClient(key).sort(key);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_LIST);
    }

    @Override
    public Response<List<String>> sort(String key, SortingParams sortingParameters) {
        this.getClient(key).sort(key, sortingParameters);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    @Override
    public Response<List<byte[]>> sort(byte[] key, SortingParams sortingParameters) {
        this.getClient(key).sort(key, sortingParameters);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_LIST);
    }

    @Override
    public Response<String> spop(String key) {
        this.getClient(key).spop(key);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<byte[]> spop(byte[] key) {
        this.getClient(key).spop(key);
        return this.getResponse(BuilderFactory.BYTE_ARRAY);
    }

    @Override
    public Response<String> srandmember(String key) {
        this.getClient(key).srandmember(key);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<List<String>> srandmember(String key, int count) {
        this.getClient(key).srandmember(key, count);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    @Override
    public Response<byte[]> srandmember(byte[] key) {
        this.getClient(key).srandmember(key);
        return this.getResponse(BuilderFactory.BYTE_ARRAY);
    }

    public Response<List<byte[]>> srandmember(byte[] key, int count) {
        this.getClient(key).srandmember(key, count);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_LIST);
    }

    @Override
    public Response<Long> srem(String key, String ... member) {
        this.getClient(key).srem(key, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> srem(byte[] key, byte[] ... member) {
        this.getClient(key).srem(key, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> strlen(String key) {
        this.getClient(key).strlen(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> strlen(byte[] key) {
        this.getClient(key).strlen(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> substr(String key, int start, int end) {
        this.getClient(key).substr(key, start, end);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> substr(byte[] key, int start, int end) {
        this.getClient(key).substr(key, start, end);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<Long> ttl(String key) {
        this.getClient(key).ttl(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> ttl(byte[] key) {
        this.getClient(key).ttl(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> type(String key) {
        this.getClient(key).type(key);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> type(byte[] key) {
        this.getClient(key).type(key);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<Long> zadd(String key, double score, String member) {
        this.getClient(key).zadd(key, score, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> zadd(String key, Map<String, Double> scoreMembers) {
        this.getClient(key).zadd(key, scoreMembers);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zadd(byte[] key, double score, byte[] member) {
        this.getClient(key).zadd(key, score, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zcard(String key) {
        this.getClient(key).zcard(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zcard(byte[] key) {
        this.getClient(key).zcard(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zcount(String key, double min, double max) {
        this.getClient(key).zcount(key, min, max);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> zcount(String key, String min, String max) {
        this.getClient(key).zcount(key, min, max);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zcount(byte[] key, double min, double max) {
        this.getClient(key).zcount(key, Protocol.toByteArray(min), Protocol.toByteArray(max));
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Double> zincrby(String key, double score, String member) {
        this.getClient(key).zincrby(key, score, member);
        return this.getResponse(BuilderFactory.DOUBLE);
    }

    @Override
    public Response<Double> zincrby(byte[] key, double score, byte[] member) {
        this.getClient(key).zincrby(key, score, member);
        return this.getResponse(BuilderFactory.DOUBLE);
    }

    @Override
    public Response<Set<String>> zrange(String key, long start, long end) {
        this.getClient(key).zrange(key, start, end);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    @Override
    public Response<Set<byte[]>> zrange(byte[] key, long start, long end) {
        this.getClient(key).zrange(key, start, end);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<Set<String>> zrangeByScore(String key, double min, double max) {
        this.getClient(key).zrangeByScore(key, min, max);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    @Override
    public Response<Set<byte[]>> zrangeByScore(byte[] key, double min, double max) {
        return this.zrangeByScore(key, Protocol.toByteArray(min), Protocol.toByteArray(max));
    }

    @Override
    public Response<Set<String>> zrangeByScore(String key, String min, String max) {
        this.getClient(key).zrangeByScore(key, min, max);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    @Override
    public Response<Set<byte[]>> zrangeByScore(byte[] key, byte[] min, byte[] max) {
        this.getClient(key).zrangeByScore(key, min, max);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<Set<String>> zrangeByScore(String key, double min, double max, int offset, int count) {
        this.getClient(key).zrangeByScore(key, min, max, offset, count);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    public Response<Set<String>> zrangeByScore(String key, String min, String max, int offset, int count) {
        this.getClient(key).zrangeByScore(key, min, max, offset, count);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    @Override
    public Response<Set<byte[]>> zrangeByScore(byte[] key, double min, double max, int offset, int count) {
        return this.zrangeByScore(key, Protocol.toByteArray(min), Protocol.toByteArray(max), offset, count);
    }

    @Override
    public Response<Set<byte[]>> zrangeByScore(byte[] key, byte[] min, byte[] max, int offset, int count) {
        this.getClient(key).zrangeByScore(key, min, max, offset, count);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<Set<Tuple>> zrangeByScoreWithScores(String key, double min, double max) {
        this.getClient(key).zrangeByScoreWithScores(key, min, max);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    public Response<Set<Tuple>> zrangeByScoreWithScores(String key, String min, String max) {
        this.getClient(key).zrangeByScoreWithScores(key, min, max);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    @Override
    public Response<Set<Tuple>> zrangeByScoreWithScores(byte[] key, double min, double max) {
        return this.zrangeByScoreWithScores(key, Protocol.toByteArray(min), Protocol.toByteArray(max));
    }

    @Override
    public Response<Set<Tuple>> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max) {
        this.getClient(key).zrangeByScoreWithScores(key, min, max);
        return this.getResponse(BuilderFactory.TUPLE_ZSET_BINARY);
    }

    @Override
    public Response<Set<Tuple>> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        this.getClient(key).zrangeByScoreWithScores(key, min, max, offset, count);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    public Response<Set<Tuple>> zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        this.getClient(key).zrangeByScoreWithScores(key, min, max, offset, count);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    @Override
    public Response<Set<Tuple>> zrangeByScoreWithScores(byte[] key, double min, double max, int offset, int count) {
        this.getClient(key).zrangeByScoreWithScores(key, Protocol.toByteArray(min), Protocol.toByteArray(max), offset, count);
        return this.getResponse(BuilderFactory.TUPLE_ZSET_BINARY);
    }

    @Override
    public Response<Set<Tuple>> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max, int offset, int count) {
        this.getClient(key).zrangeByScoreWithScores(key, min, max, offset, count);
        return this.getResponse(BuilderFactory.TUPLE_ZSET_BINARY);
    }

    @Override
    public Response<Set<String>> zrevrangeByScore(String key, double max, double min) {
        this.getClient(key).zrevrangeByScore(key, max, min);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    @Override
    public Response<Set<byte[]>> zrevrangeByScore(byte[] key, double max, double min) {
        this.getClient(key).zrevrangeByScore(key, Protocol.toByteArray(max), Protocol.toByteArray(min));
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<Set<String>> zrevrangeByScore(String key, String max, String min) {
        this.getClient(key).zrevrangeByScore(key, max, min);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    @Override
    public Response<Set<byte[]>> zrevrangeByScore(byte[] key, byte[] max, byte[] min) {
        this.getClient(key).zrevrangeByScore(key, max, min);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<Set<String>> zrevrangeByScore(String key, double max, double min, int offset, int count) {
        this.getClient(key).zrevrangeByScore(key, max, min, offset, count);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    public Response<Set<String>> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        this.getClient(key).zrevrangeByScore(key, max, min, offset, count);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    @Override
    public Response<Set<byte[]>> zrevrangeByScore(byte[] key, double max, double min, int offset, int count) {
        this.getClient(key).zrevrangeByScore(key, Protocol.toByteArray(max), Protocol.toByteArray(min), offset, count);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<Set<byte[]>> zrevrangeByScore(byte[] key, byte[] max, byte[] min, int offset, int count) {
        this.getClient(key).zrevrangeByScore(key, max, min, offset, count);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(String key, double max, double min) {
        this.getClient(key).zrevrangeByScoreWithScores(key, max, min);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    public Response<Set<Tuple>> zrevrangeByScoreWithScores(String key, String max, String min) {
        this.getClient(key).zrevrangeByScoreWithScores(key, max, min);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    @Override
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(byte[] key, double max, double min) {
        this.getClient(key).zrevrangeByScoreWithScores(key, Protocol.toByteArray(max), Protocol.toByteArray(min));
        return this.getResponse(BuilderFactory.TUPLE_ZSET_BINARY);
    }

    @Override
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min) {
        this.getClient(key).zrevrangeByScoreWithScores(key, max, min);
        return this.getResponse(BuilderFactory.TUPLE_ZSET_BINARY);
    }

    @Override
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        this.getClient(key).zrevrangeByScoreWithScores(key, max, min, offset, count);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    public Response<Set<Tuple>> zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count) {
        this.getClient(key).zrevrangeByScoreWithScores(key, max, min, offset, count);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    @Override
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(byte[] key, double max, double min, int offset, int count) {
        this.getClient(key).zrevrangeByScoreWithScores(key, Protocol.toByteArray(max), Protocol.toByteArray(min), offset, count);
        return this.getResponse(BuilderFactory.TUPLE_ZSET_BINARY);
    }

    @Override
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min, int offset, int count) {
        this.getClient(key).zrevrangeByScoreWithScores(key, max, min, offset, count);
        return this.getResponse(BuilderFactory.TUPLE_ZSET_BINARY);
    }

    @Override
    public Response<Set<Tuple>> zrangeWithScores(String key, long start, long end) {
        this.getClient(key).zrangeWithScores(key, start, end);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    @Override
    public Response<Set<Tuple>> zrangeWithScores(byte[] key, long start, long end) {
        this.getClient(key).zrangeWithScores(key, start, end);
        return this.getResponse(BuilderFactory.TUPLE_ZSET_BINARY);
    }

    @Override
    public Response<Long> zrank(String key, String member) {
        this.getClient(key).zrank(key, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zrank(byte[] key, byte[] member) {
        this.getClient(key).zrank(key, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zrem(String key, String ... member) {
        this.getClient(key).zrem(key, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zrem(byte[] key, byte[] ... member) {
        this.getClient(key).zrem(key, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zremrangeByRank(String key, long start, long end) {
        this.getClient(key).zremrangeByRank(key, start, end);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zremrangeByRank(byte[] key, long start, long end) {
        this.getClient(key).zremrangeByRank(key, start, end);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zremrangeByScore(String key, double start, double end) {
        this.getClient(key).zremrangeByScore(key, start, end);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> zremrangeByScore(String key, String start, String end) {
        this.getClient(key).zremrangeByScore(key, start, end);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zremrangeByScore(byte[] key, double start, double end) {
        this.getClient(key).zremrangeByScore(key, Protocol.toByteArray(start), Protocol.toByteArray(end));
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zremrangeByScore(byte[] key, byte[] start, byte[] end) {
        this.getClient(key).zremrangeByScore(key, start, end);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Set<String>> zrevrange(String key, long start, long end) {
        this.getClient(key).zrevrange(key, start, end);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    @Override
    public Response<Set<byte[]>> zrevrange(byte[] key, long start, long end) {
        this.getClient(key).zrevrange(key, start, end);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<Set<Tuple>> zrevrangeWithScores(String key, long start, long end) {
        this.getClient(key).zrevrangeWithScores(key, start, end);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    @Override
    public Response<Set<Tuple>> zrevrangeWithScores(byte[] key, long start, long end) {
        this.getClient(key).zrevrangeWithScores(key, start, end);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    @Override
    public Response<Long> zrevrank(String key, String member) {
        this.getClient(key).zrevrank(key, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zrevrank(byte[] key, byte[] member) {
        this.getClient(key).zrevrank(key, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Double> zscore(String key, String member) {
        this.getClient(key).zscore(key, member);
        return this.getResponse(BuilderFactory.DOUBLE);
    }

    @Override
    public Response<Double> zscore(byte[] key, byte[] member) {
        this.getClient(key).zscore(key, member);
        return this.getResponse(BuilderFactory.DOUBLE);
    }

    @Override
    public Response<Long> zlexcount(byte[] key, byte[] min, byte[] max) {
        this.getClient(key).zlexcount(key, min, max);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zlexcount(String key, String min, String max) {
        this.getClient(key).zlexcount(key, min, max);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Set<byte[]>> zrangeByLex(byte[] key, byte[] min, byte[] max) {
        this.getClient(key).zrangeByLex(key, min, max);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<Set<String>> zrangeByLex(String key, String min, String max) {
        this.getClient(key).zrangeByLex(key, min, max);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    @Override
    public Response<Set<byte[]>> zrangeByLex(byte[] key, byte[] min, byte[] max, int offset, int count) {
        this.getClient(key).zrangeByLex(key, min, max, offset, count);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<Set<String>> zrangeByLex(String key, String min, String max, int offset, int count) {
        this.getClient(key).zrangeByLex(key, min, max, offset, count);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    @Override
    public Response<Long> zremrangeByLex(byte[] key, byte[] min, byte[] max) {
        this.getClient(key).zremrangeByLex(key, min, max);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zremrangeByLex(String key, String min, String max) {
        this.getClient(key).zremrangeByLex(key, min, max);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> bitcount(String key) {
        this.getClient(key).bitcount(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> bitcount(String key, long start, long end) {
        this.getClient(key).bitcount(key, start, end);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> bitcount(byte[] key) {
        this.getClient(key).bitcount(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> bitcount(byte[] key, long start, long end) {
        this.getClient(key).bitcount(key, start, end);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<byte[]> dump(String key) {
        this.getClient(key).dump(key);
        return this.getResponse(BuilderFactory.BYTE_ARRAY);
    }

    public Response<byte[]> dump(byte[] key) {
        this.getClient(key).dump(key);
        return this.getResponse(BuilderFactory.BYTE_ARRAY);
    }

    public Response<String> migrate(String host, int port, String key, int destinationDb, int timeout) {
        this.getClient(key).migrate(host, port, key, destinationDb, timeout);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<String> migrate(byte[] host, int port, byte[] key, int destinationDb, int timeout) {
        this.getClient(key).migrate(host, port, key, destinationDb, timeout);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> objectRefcount(String key) {
        this.getClient(key).objectRefcount(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> objectRefcount(byte[] key) {
        this.getClient(key).objectRefcount(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> objectEncoding(String key) {
        this.getClient(key).objectEncoding(key);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<byte[]> objectEncoding(byte[] key) {
        this.getClient(key).objectEncoding(key);
        return this.getResponse(BuilderFactory.BYTE_ARRAY);
    }

    public Response<Long> objectIdletime(String key) {
        this.getClient(key).objectIdletime(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> objectIdletime(byte[] key) {
        this.getClient(key).objectIdletime(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Deprecated
    public Response<Long> pexpire(String key, int milliseconds) {
        return this.pexpire(key, (long)milliseconds);
    }

    @Deprecated
    public Response<Long> pexpire(byte[] key, int milliseconds) {
        return this.pexpire(key, (long)milliseconds);
    }

    public Response<Long> pexpire(String key, long milliseconds) {
        this.getClient(key).pexpire(key, milliseconds);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> pexpire(byte[] key, long milliseconds) {
        this.getClient(key).pexpire(key, milliseconds);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> pexpireAt(String key, long millisecondsTimestamp) {
        this.getClient(key).pexpireAt(key, millisecondsTimestamp);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> pexpireAt(byte[] key, long millisecondsTimestamp) {
        this.getClient(key).pexpireAt(key, millisecondsTimestamp);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> pttl(String key) {
        this.getClient(key).pttl(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> pttl(byte[] key) {
        this.getClient(key).pttl(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> restore(String key, int ttl, byte[] serializedValue) {
        this.getClient(key).restore(key, ttl, serializedValue);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<String> restore(byte[] key, int ttl, byte[] serializedValue) {
        this.getClient(key).restore(key, ttl, serializedValue);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Double> incrByFloat(String key, double increment) {
        this.getClient(key).incrByFloat(key, increment);
        return this.getResponse(BuilderFactory.DOUBLE);
    }

    public Response<Double> incrByFloat(byte[] key, double increment) {
        this.getClient(key).incrByFloat(key, increment);
        return this.getResponse(BuilderFactory.DOUBLE);
    }

    public Response<String> psetex(String key, int milliseconds, String value) {
        this.getClient(key).psetex(key, milliseconds, value);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<String> psetex(byte[] key, int milliseconds, byte[] value) {
        this.getClient(key).psetex(key, milliseconds, value);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<String> set(String key, String value, String nxxx) {
        this.getClient(key).set(key, value, nxxx);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<String> set(byte[] key, byte[] value, byte[] nxxx) {
        this.getClient(key).set(key, value, nxxx);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<String> set(String key, String value, String nxxx, String expx, int time) {
        this.getClient(key).set(key, value, nxxx, expx, time);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<String> set(byte[] key, byte[] value, byte[] nxxx, byte[] expx, int time) {
        this.getClient(key).set(key, value, nxxx, expx, time);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Double> hincrByFloat(String key, String field, double increment) {
        this.getClient(key).hincrByFloat(key, field, increment);
        return this.getResponse(BuilderFactory.DOUBLE);
    }

    public Response<Double> hincrByFloat(byte[] key, byte[] field, double increment) {
        this.getClient(key).hincrByFloat(key, field, increment);
        return this.getResponse(BuilderFactory.DOUBLE);
    }

    public Response<String> eval(String script) {
        return this.eval(script, 0, new String[0]);
    }

    public Response<String> eval(String script, List<String> keys, List<String> args) {
        String[] argv = Jedis.getParams(keys, args);
        return this.eval(script, keys.size(), argv);
    }

    public Response<String> eval(String script, int numKeys, String ... args) {
        this.getClient(script).eval(script, numKeys, args);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<String> evalsha(String script) {
        return this.evalsha(script, 0, new String[0]);
    }

    public Response<String> evalsha(String sha1, List<String> keys, List<String> args) {
        String[] argv = Jedis.getParams(keys, args);
        return this.evalsha(sha1, keys.size(), argv);
    }

    public Response<String> evalsha(String sha1, int numKeys, String ... args) {
        this.getClient(sha1).evalsha(sha1, numKeys, args);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<Long> pfadd(byte[] key, byte[] ... elements) {
        this.getClient(key).pfadd(key, elements);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> pfcount(byte[] key) {
        this.getClient(key).pfcount(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> pfadd(String key, String ... elements) {
        this.getClient(key).pfadd(key, elements);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> pfcount(String key) {
        this.getClient(key).pfcount(key);
        return this.getResponse(BuilderFactory.LONG);
    }
}

