/*
 * Decompiled with CFR 0.152.
 */
package tachyon.master;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import tachyon.Constants;
import tachyon.HeartbeatExecutor;
import tachyon.HeartbeatThread;
import tachyon.Pair;
import tachyon.PrefixList;
import tachyon.UnderFileSystem;
import tachyon.conf.CommonConf;
import tachyon.conf.MasterConf;
import tachyon.master.BlockInfo;
import tachyon.master.Counters;
import tachyon.master.Dependency;
import tachyon.master.DependencyType;
import tachyon.master.ImageElement;
import tachyon.master.ImageElementType;
import tachyon.master.ImageWriter;
import tachyon.master.Inode;
import tachyon.master.InodeFile;
import tachyon.master.InodeFolder;
import tachyon.master.Journal;
import tachyon.master.MasterWorkerInfo;
import tachyon.master.RawTables;
import tachyon.master.RecomputeCommand;
import tachyon.thrift.BlockInfoException;
import tachyon.thrift.ClientBlockInfo;
import tachyon.thrift.ClientDependencyInfo;
import tachyon.thrift.ClientFileInfo;
import tachyon.thrift.ClientRawTableInfo;
import tachyon.thrift.ClientWorkerInfo;
import tachyon.thrift.Command;
import tachyon.thrift.CommandType;
import tachyon.thrift.DependencyDoesNotExistException;
import tachyon.thrift.FileAlreadyExistException;
import tachyon.thrift.FileDoesNotExistException;
import tachyon.thrift.InvalidPathException;
import tachyon.thrift.NetAddress;
import tachyon.thrift.SuspectedFileSizeException;
import tachyon.thrift.TableColumnException;
import tachyon.thrift.TableDoesNotExistException;
import tachyon.thrift.TachyonException;
import tachyon.util.CommonUtils;

public class MasterInfo
extends ImageWriter {
    public static final String COL = "COL_";
    private final Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);
    private final InetSocketAddress MASTER_ADDRESS;
    private final long START_TIME_NS_PREFIX;
    private final long START_TIME_MS;
    private final MasterConf MASTER_CONF;
    private final Counters mCheckpointInfo = new Counters(0, 0L, 0);
    private final AtomicInteger mInodeCounter = new AtomicInteger(0);
    private final AtomicInteger mDependencyCounter = new AtomicInteger(0);
    private final AtomicInteger mRerunCounter = new AtomicInteger(0);
    private final AtomicInteger mUserCounter = new AtomicInteger(0);
    private final AtomicInteger mWorkerCounter = new AtomicInteger(0);
    private InodeFolder mRoot;
    private final Map<Integer, Inode> mInodes = new HashMap<Integer, Inode>();
    private final Map<Integer, Dependency> mDependencies = new HashMap<Integer, Dependency>();
    private final RawTables mRawTables = new RawTables();
    private final Set<Integer> mUncheckpointedDependencies = new HashSet<Integer>();
    private final Set<Integer> mPriorityDependencies = new HashSet<Integer>();
    private final Set<Integer> mLostFiles = new HashSet<Integer>();
    private final Set<Integer> mBeingRecomputedFiles = new HashSet<Integer>();
    private final Set<Integer> mMustRecomputeDependencies = new HashSet<Integer>();
    private final Map<Long, MasterWorkerInfo> mWorkers = new HashMap<Long, MasterWorkerInfo>();
    private final Map<InetSocketAddress, Long> mWorkerAddressToId = new HashMap<InetSocketAddress, Long>();
    private final BlockingQueue<MasterWorkerInfo> mLostWorkers = new ArrayBlockingQueue<MasterWorkerInfo>(32);
    private final PrefixList mWhiteList;
    private final Set<Integer> mFileIdPinList;
    private final Journal mJournal;
    private HeartbeatThread mHeartbeatThread;
    private Thread mRecomputeThread;

    public MasterInfo(InetSocketAddress address, Journal journal) throws IOException {
        this.MASTER_CONF = MasterConf.get();
        this.mRoot = new InodeFolder("", this.mInodeCounter.incrementAndGet(), -1, System.currentTimeMillis());
        this.mInodes.put(this.mRoot.getId(), this.mRoot);
        this.MASTER_ADDRESS = address;
        this.START_TIME_MS = System.currentTimeMillis();
        this.START_TIME_NS_PREFIX = this.START_TIME_MS - this.START_TIME_MS % 1000000L;
        this.mJournal = journal;
        this.mWhiteList = new PrefixList(this.MASTER_CONF.WHITELIST);
        this.mFileIdPinList = Collections.synchronizedSet(new HashSet());
        this.mJournal.loadImage(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int _createDependency(List<Integer> parentsIds, List<Integer> childrenIds, String commandPrefix, List<ByteBuffer> data, String comment, String framework, String frameworkVersion, DependencyType dependencyType, int dependencyId, long creationTimeMs) throws InvalidPathException, FileDoesNotExistException {
        Dependency dep = null;
        Object object = this.mRoot;
        synchronized (object) {
            Inode inode;
            HashSet<Integer> parentDependencyIds = new HashSet<Integer>();
            for (int k = 0; k < parentsIds.size(); ++k) {
                int parentId = parentsIds.get(k);
                inode = this.mInodes.get(parentId);
                if (inode.isFile()) {
                    this.LOG.info((Object)("PARENT DEPENDENCY ID IS " + ((InodeFile)inode).getDependencyId() + " " + inode));
                    if (((InodeFile)inode).getDependencyId() == -1) continue;
                    parentDependencyIds.add(((InodeFile)inode).getDependencyId());
                    continue;
                }
                throw new InvalidPathException("Parent " + parentId + " is not a file.");
            }
            dep = new Dependency(dependencyId, parentsIds, childrenIds, commandPrefix, data, comment, framework, frameworkVersion, dependencyType, parentDependencyIds, creationTimeMs);
            ArrayList<Inode> childrenInodes = new ArrayList<Inode>();
            for (int k = 0; k < childrenIds.size(); ++k) {
                inode = (InodeFile)this.mInodes.get(childrenIds.get(k));
                ((InodeFile)inode).setDependencyId(dep.ID);
                childrenInodes.add(inode);
                if (!((InodeFile)inode).hasCheckpointed()) continue;
                dep.childCheckpointed(inode.getId());
            }
        }
        object = this.mDependencies;
        synchronized (object) {
            this.mDependencies.put(dep.ID, dep);
            if (!dep.hasCheckpointed()) {
                this.mUncheckpointedDependencies.add(dep.ID);
            }
            for (int parentDependencyId : dep.PARENT_DEPENDENCIES) {
                this.mDependencies.get(parentDependencyId).addChildrenDependency(dep.ID);
            }
        }
        this.mJournal.getEditLog().createDependency(parentsIds, childrenIds, commandPrefix, data, comment, framework, frameworkVersion, dependencyType, dependencyId, creationTimeMs);
        this.mJournal.getEditLog().flush();
        this.LOG.info((Object)("Dependency created: " + dep));
        return dep.ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int _createFile(boolean recursive, String path, boolean directory, long blockSizeByte, long creationTimeMs) throws FileAlreadyExistException, InvalidPathException, BlockInfoException, TachyonException {
        if (path.equals("/")) {
            this.LOG.info((Object)("FileAlreadyExistException: " + path));
            throw new FileAlreadyExistException(path);
        }
        if (!directory && blockSizeByte < 1L) {
            throw new BlockInfoException("Invalid block size " + blockSizeByte);
        }
        if (CommonUtils.isRoot(path)) {
            throw new InvalidPathException("Cannot create the root path");
        }
        this.LOG.debug((Object)("createFile" + CommonUtils.parametersToString(path)));
        String[] pathNames = CommonUtils.getPathComponents(path);
        String name = pathNames[pathNames.length - 1];
        String[] parentPath = new String[pathNames.length - 1];
        System.arraycopy(pathNames, 0, parentPath, 0, parentPath.length);
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Pair<Inode, Integer> inodeTraversal = this.traverseToInode(parentPath);
            int pathIndex = parentPath.length;
            if (!this.traversalSucceeded(inodeTraversal)) {
                if (!recursive) {
                    String msg = "File " + path + " creation failed. Component " + inodeTraversal.getSecond() + "(" + parentPath[inodeTraversal.getSecond()] + ") does not exist";
                    this.LOG.info((Object)("InvalidPathException: " + msg));
                    throw new InvalidPathException(msg);
                }
                pathIndex = inodeTraversal.getSecond();
            }
            if (!inodeTraversal.getFirst().isDirectory()) {
                throw new InvalidPathException("Could not traverse to parent folder of path " + path + ". Component " + pathNames[pathIndex - 1] + " is not a directory.");
            }
            InodeFolder currentInodeFolder = (InodeFolder)inodeTraversal.getFirst();
            for (int k = pathIndex; k < parentPath.length; ++k) {
                InodeFolder dir = new InodeFolder(pathNames[k], this.mInodeCounter.incrementAndGet(), currentInodeFolder.getId(), creationTimeMs);
                dir.setPinned(currentInodeFolder.isPinned());
                currentInodeFolder.addChild(dir);
                this.mInodes.put(dir.getId(), dir);
                currentInodeFolder = dir;
            }
            Inode ret = currentInodeFolder.getChild(name);
            if (ret != null) {
                if (ret.isDirectory() && directory) {
                    return ret.getId();
                }
                this.LOG.info((Object)("FileAlreadyExistException: " + path));
                throw new FileAlreadyExistException(path);
            }
            if (directory) {
                ret = new InodeFolder(name, this.mInodeCounter.incrementAndGet(), currentInodeFolder.getId(), creationTimeMs);
                ret.setPinned(currentInodeFolder.isPinned());
            } else {
                ret = new InodeFile(name, this.mInodeCounter.incrementAndGet(), currentInodeFolder.getId(), blockSizeByte, creationTimeMs);
                ret.setPinned(currentInodeFolder.isPinned());
                if (ret.isPinned()) {
                    this.mFileIdPinList.add(ret.getId());
                }
                if (this.mWhiteList.inList(path)) {
                    ((InodeFile)ret).setCache(true);
                }
            }
            this.mInodes.put(ret.getId(), ret);
            currentInodeFolder.addChild(ret);
            this.LOG.debug((Object)("createFile: File Created: " + ret.toString() + " parent: " + currentInodeFolder.toString()));
            return ret.getId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _createRawTable(int tableId, int columns, ByteBuffer metadata) throws TachyonException {
        RawTables rawTables = this.mRawTables;
        synchronized (rawTables) {
            if (!this.mRawTables.addRawTable(tableId, columns, metadata)) {
                throw new TachyonException("Failed to create raw table.");
            }
            this.mJournal.getEditLog().createRawTable(tableId, columns, metadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean _delete(int fileId, boolean recursive) throws TachyonException {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.mInodes.get(fileId);
            if (inode == null) {
                return true;
            }
            if (inode.isDirectory() && !recursive && ((InodeFolder)inode).getNumberOfChildren() > 0) {
                return false;
            }
            if (inode.getId() == this.mRoot.getId()) {
                return false;
            }
            ArrayList<Inode> delInodes = new ArrayList<Inode>();
            delInodes.add(inode);
            if (inode.isDirectory()) {
                delInodes.addAll(this.getInodeChildrenRecursive((InodeFolder)inode));
            }
            for (int i = delInodes.size() - 1; i >= 0; --i) {
                Inode delInode = (Inode)delInodes.get(i);
                if (delInode.isFile()) {
                    String checkpointPath = ((InodeFile)delInode).getUfsPath();
                    if (!checkpointPath.equals("")) {
                        UnderFileSystem ufs = UnderFileSystem.get(checkpointPath);
                        try {
                            if (!ufs.exists(checkpointPath)) {
                                this.LOG.warn((Object)("File does not exist the underfs: " + checkpointPath));
                            } else if (!ufs.delete(checkpointPath, true)) {
                                return false;
                            }
                        }
                        catch (IOException e) {
                            throw new TachyonException(e.getMessage());
                        }
                    }
                    List<Pair<Long, Long>> blockIdWorkerIdList = ((InodeFile)delInode).getBlockIdWorkerIdPairs();
                    Map<Long, MasterWorkerInfo> map = this.mWorkers;
                    synchronized (map) {
                        for (Pair<Long, Long> blockIdWorkerId : blockIdWorkerIdList) {
                            MasterWorkerInfo workerInfo = this.mWorkers.get(blockIdWorkerId.getSecond());
                            if (workerInfo == null) continue;
                            workerInfo.updateToRemovedBlock(true, blockIdWorkerId.getFirst());
                        }
                    }
                    this.mFileIdPinList.remove(delInode.getId());
                }
                InodeFolder parent = (InodeFolder)this.mInodes.get(delInode.getParentId());
                parent.removeChild(delInode);
                if (this.mRawTables.exist(delInode.getId()) && !this.mRawTables.delete(delInode.getId())) {
                    return false;
                }
                this.mInodes.remove(delInode.getId());
                delInode.reverseId();
            }
            return true;
        }
    }

    public ClientRawTableInfo _getClientRawTableInfo(String path, Inode inode) throws TableDoesNotExistException {
        this.LOG.info((Object)("getClientRawTableInfo(" + path + ")"));
        if (!this.mRawTables.exist(inode.getId())) {
            throw new TableDoesNotExistException("Table " + inode.getId() + " does not exist.");
        }
        ClientRawTableInfo ret = new ClientRawTableInfo();
        ret.id = inode.getId();
        ret.name = inode.getName();
        ret.path = path;
        ret.columns = this.mRawTables.getColumns(ret.id);
        ret.metadata = this.mRawTables.getMetadata(ret.id);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> _ls(Inode inode, String path, boolean recursive) throws InvalidPathException, FileDoesNotExistException {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            ArrayList<String> ret = new ArrayList<String>();
            ret.add(path);
            if (inode.isDirectory()) {
                for (Inode child : ((InodeFolder)inode).getChildren()) {
                    String childPath = CommonUtils.concat(path, child.getName());
                    if (recursive) {
                        ret.addAll(this._ls(child, childPath, recursive));
                        continue;
                    }
                    ret.add(childPath);
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean _rename(int fileId, String dstPath) throws FileDoesNotExistException, InvalidPathException {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            String[] dstComponents;
            String srcPath = this.getPath(fileId);
            if (srcPath.equals(dstPath)) {
                return true;
            }
            if (srcPath.equals("/") || dstPath.equals("/")) {
                return false;
            }
            String[] srcComponents = CommonUtils.getPathComponents(srcPath);
            if (srcComponents.length < (dstComponents = CommonUtils.getPathComponents(dstPath)).length) {
                boolean isPrefix = true;
                for (int prefixInd = 0; prefixInd < srcComponents.length; ++prefixInd) {
                    if (srcComponents[prefixInd].equals(dstComponents[prefixInd])) continue;
                    isPrefix = false;
                    break;
                }
                if (isPrefix) {
                    throw new InvalidPathException("Failed to rename: " + srcPath + " is a prefix of " + dstPath);
                }
            }
            String srcParent = CommonUtils.getParent(srcPath);
            String dstParent = CommonUtils.getParent(dstPath);
            Inode srcParentInode = this.getInode(srcParent);
            if (srcParentInode == null || !srcParentInode.isDirectory()) {
                return false;
            }
            Inode dstParentInode = this.getInode(dstParent);
            if (dstParentInode == null || !dstParentInode.isDirectory()) {
                return false;
            }
            Inode srcInode = ((InodeFolder)srcParentInode).getChild(srcComponents[srcComponents.length - 1]);
            if (srcInode == null) {
                return false;
            }
            if (((InodeFolder)dstParentInode).getChild(dstComponents[dstComponents.length - 1]) != null) {
                return false;
            }
            ((InodeFolder)srcParentInode).removeChild(srcInode);
            srcInode.setParentId(dstParentInode.getId());
            srcInode.setName(dstComponents[dstComponents.length - 1]);
            ((InodeFolder)dstParentInode).addChild(srcInode);
            return true;
        }
    }

    private void addBlock(InodeFile tFile, BlockInfo blockInfo) throws BlockInfoException {
        tFile.addBlock(blockInfo);
        this.mJournal.getEditLog().addBlock(tFile.getId(), blockInfo.BLOCK_INDEX, blockInfo.LENGTH);
        this.mJournal.getEditLog().flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCheckpoint(long workerId, int fileId, long length, String checkpointPath) throws FileNotFoundException, SuspectedFileSizeException, BlockInfoException {
        this.LOG.info((Object)CommonUtils.parametersToString(workerId, fileId, length, checkpointPath));
        if (workerId != -1L) {
            MasterWorkerInfo tWorkerInfo = this.getWorkerInfo(workerId);
            tWorkerInfo.updateLastUpdatedTimeMs();
        }
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.mInodes.get(fileId);
            if (inode == null) {
                throw new FileNotFoundException("File " + fileId + " does not exist.");
            }
            if (inode.isDirectory()) {
                throw new FileNotFoundException("File " + fileId + " is a folder.");
            }
            InodeFile tFile = (InodeFile)inode;
            boolean needLog = false;
            if (tFile.isComplete()) {
                if (tFile.getLength() != length) {
                    throw new SuspectedFileSizeException(fileId + ". Original Size: " + tFile.getLength() + ". New Size: " + length);
                }
            } else {
                tFile.setLength(length);
                needLog = true;
            }
            if (!tFile.hasCheckpointed()) {
                tFile.setUfsPath(checkpointPath);
                needLog = true;
                Map<Integer, Dependency> map = this.mDependencies;
                synchronized (map) {
                    int depId = tFile.getDependencyId();
                    if (depId != -1) {
                        Dependency dep = this.mDependencies.get(depId);
                        dep.childCheckpointed(tFile.getId());
                        if (dep.hasCheckpointed()) {
                            this.mUncheckpointedDependencies.remove(dep.ID);
                            this.mPriorityDependencies.remove(dep.ID);
                        }
                    }
                }
            }
            this.addFile(fileId, tFile.getDependencyId());
            tFile.setComplete();
            if (needLog) {
                this.mJournal.getEditLog().addCheckpoint(fileId, length, checkpointPath);
                this.mJournal.getEditLog().flush();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFile(int fileId, int dependencyId) {
        Map<Integer, Dependency> map = this.mDependencies;
        synchronized (map) {
            if (this.mLostFiles.contains(fileId)) {
                this.mLostFiles.remove(fileId);
            }
            if (this.mBeingRecomputedFiles.contains(fileId)) {
                this.mBeingRecomputedFiles.remove(fileId);
            }
        }
    }

    private void recomputePinnedFiles(Inode inode, Optional<Boolean> setPinState) {
        if (setPinState.isPresent()) {
            inode.setPinned((Boolean)setPinState.get());
        }
        if (inode.isFile()) {
            if (inode.isPinned()) {
                this.mFileIdPinList.add(inode.getId());
            } else {
                this.mFileIdPinList.remove(inode.getId());
            }
        } else if (inode.isDirectory()) {
            for (Inode child : ((InodeFolder)inode).getChildren()) {
                this.recomputePinnedFiles(child, setPinState);
            }
        }
    }

    private void addToInodeMap(Inode inode, Map<Integer, Inode> map) {
        map.put(inode.getId(), inode);
        if (inode.isDirectory()) {
            InodeFolder inodeFolder = (InodeFolder)inode;
            for (Inode child : inodeFolder.getChildren()) {
                this.addToInodeMap(child, map);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cacheBlock(long workerId, long workerUsedBytes, long blockId, long length) throws FileDoesNotExistException, SuspectedFileSizeException, BlockInfoException {
        this.LOG.debug((Object)CommonUtils.parametersToString(workerId, workerUsedBytes, blockId, length));
        MasterWorkerInfo tWorkerInfo = this.getWorkerInfo(workerId);
        tWorkerInfo.updateBlock(true, blockId);
        tWorkerInfo.updateUsedBytes(workerUsedBytes);
        tWorkerInfo.updateLastUpdatedTimeMs();
        int fileId = BlockInfo.computeInodeId(blockId);
        int blockIndex = BlockInfo.computeBlockIndex(blockId);
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.mInodes.get(fileId);
            if (inode == null) {
                throw new FileDoesNotExistException("File " + fileId + " does not exist.");
            }
            if (inode.isDirectory()) {
                throw new FileDoesNotExistException("File " + fileId + " is a folder.");
            }
            InodeFile tFile = (InodeFile)inode;
            if (tFile.getNumberOfBlocks() <= blockIndex) {
                this.addBlock(tFile, new BlockInfo(tFile, blockIndex, length));
            }
            InetSocketAddress address = tWorkerInfo.ADDRESS;
            tFile.addLocation(blockIndex, workerId, new NetAddress(address.getAddress().getCanonicalHostName(), address.getPort()));
            if (tFile.hasCheckpointed()) {
                return -1;
            }
            return tFile.getDependencyId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeFile(int fileId) throws FileDoesNotExistException {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.mInodes.get(fileId);
            if (inode == null) {
                throw new FileDoesNotExistException("File " + fileId + " does not exit.");
            }
            if (!inode.isFile()) {
                throw new FileDoesNotExistException("File " + fileId + " is not a file.");
            }
            this.addFile(fileId, ((InodeFile)inode).getDependencyId());
            ((InodeFile)inode).setComplete();
            this.mJournal.getEditLog().completeFile(fileId);
            this.mJournal.getEditLog().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createDependency(List<String> parents, List<String> children, String commandPrefix, List<ByteBuffer> data, String comment, String framework, String frameworkVersion, DependencyType dependencyType) throws InvalidPathException, FileDoesNotExistException {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            this.LOG.info((Object)("ParentList: " + CommonUtils.listToString(parents)));
            List<Integer> parentsIdList = this.getFilesIds(parents);
            List<Integer> childrenIdList = this.getFilesIds(children);
            int depId = this.mDependencyCounter.incrementAndGet();
            long creationTimeMs = System.currentTimeMillis();
            int ret = this._createDependency(parentsIdList, childrenIdList, commandPrefix, data, comment, framework, frameworkVersion, dependencyType, depId, creationTimeMs);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createFile(boolean recursive, String path, boolean directory, long blockSizeByte) throws FileAlreadyExistException, InvalidPathException, BlockInfoException, TachyonException {
        long creationTimeMs = System.currentTimeMillis();
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            int ret = this._createFile(recursive, path, directory, blockSizeByte, creationTimeMs);
            this.mJournal.getEditLog().createFile(recursive, path, directory, blockSizeByte, creationTimeMs);
            this.mJournal.getEditLog().flush();
            return ret;
        }
    }

    public int createFile(String path, long blockSizeByte) throws FileAlreadyExistException, InvalidPathException, BlockInfoException, TachyonException {
        return this.createFile(true, path, false, blockSizeByte);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createNewBlock(int fileId) throws FileDoesNotExistException {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.mInodes.get(fileId);
            if (inode == null) {
                throw new FileDoesNotExistException("File " + fileId + " does not exit.");
            }
            if (!inode.isFile()) {
                throw new FileDoesNotExistException("File " + fileId + " is not a file.");
            }
            return ((InodeFile)inode).getNewBlockId();
        }
    }

    public int createRawTable(String path, int columns, ByteBuffer metadata) throws FileAlreadyExistException, InvalidPathException, TableColumnException, TachyonException {
        int id;
        this.LOG.info((Object)("createRawTable" + CommonUtils.parametersToString(path, columns)));
        if (columns <= 0 || columns >= CommonConf.get().MAX_COLUMNS) {
            throw new TableColumnException("Column " + columns + " should between 0 to " + CommonConf.get().MAX_COLUMNS);
        }
        try {
            id = this.createFile(true, path, true, 0L);
            this._createRawTable(id, columns, metadata);
        }
        catch (BlockInfoException e) {
            throw new FileAlreadyExistException(e.getMessage());
        }
        for (int k = 0; k < columns; ++k) {
            this.mkdir(CommonUtils.concat(path, COL + k));
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(int fileId, boolean recursive) throws TachyonException {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            boolean ret = this._delete(fileId, recursive);
            this.mJournal.getEditLog().delete(fileId, recursive);
            this.mJournal.getEditLog().flush();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String path, boolean recursive) throws TachyonException {
        this.LOG.info((Object)("delete(" + path + ")"));
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = null;
            try {
                inode = this.getInode(path);
            }
            catch (InvalidPathException e) {
                return false;
            }
            if (inode == null) {
                return true;
            }
            return this.delete(inode.getId(), recursive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBlockIdBasedOnOffset(int fileId, long offset) throws FileDoesNotExistException {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.mInodes.get(fileId);
            if (inode == null) {
                throw new FileDoesNotExistException("FileId " + fileId + " does not exist.");
            }
            if (!inode.isFile()) {
                throw new FileDoesNotExistException(fileId + " is not a file.");
            }
            return ((InodeFile)inode).getBlockIdBasedOnOffset(offset);
        }
    }

    public List<BlockInfo> getBlockList(String path) throws InvalidPathException, FileDoesNotExistException {
        Inode inode = this.getInode(path);
        if (inode == null) {
            throw new FileDoesNotExistException(path + " does not exist.");
        }
        if (!inode.isFile()) {
            throw new FileDoesNotExistException(path + " is not a file.");
        }
        InodeFile inodeFile = (InodeFile)inode;
        return inodeFile.getBlockList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCapacityBytes() {
        long ret = 0L;
        Map<Long, MasterWorkerInfo> map = this.mWorkers;
        synchronized (map) {
            for (MasterWorkerInfo worker : this.mWorkers.values()) {
                ret += worker.getCapacityBytes();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientBlockInfo getClientBlockInfo(long blockId) throws FileDoesNotExistException, IOException, BlockInfoException {
        int fileId = BlockInfo.computeInodeId(blockId);
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.mInodes.get(fileId);
            if (inode == null || inode.isDirectory()) {
                throw new FileDoesNotExistException("FileId " + fileId + " does not exist.");
            }
            ClientBlockInfo ret = ((InodeFile)inode).getClientBlockInfo(BlockInfo.computeBlockIndex(blockId));
            this.LOG.debug((Object)("getClientBlockInfo: " + blockId + ret));
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientDependencyInfo getClientDependencyInfo(int dependencyId) throws DependencyDoesNotExistException {
        Dependency dep = null;
        Map<Integer, Dependency> map = this.mDependencies;
        synchronized (map) {
            dep = this.mDependencies.get(dependencyId);
            if (dep == null) {
                throw new DependencyDoesNotExistException("No dependency with id " + dependencyId);
            }
        }
        return dep.generateClientDependencyInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientFileInfo getClientFileInfo(int fid) throws FileDoesNotExistException, InvalidPathException {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.mInodes.get(fid);
            if (inode == null) {
                throw new FileDoesNotExistException("Failed to get client file info: " + fid + " does not exist");
            }
            return inode.generateClientFileInfo(this.getPath(inode));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientFileInfo getClientFileInfo(String path) throws FileDoesNotExistException, InvalidPathException {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.getInode(path);
            if (inode == null) {
                throw new FileDoesNotExistException("Failed to getClientFileInfo: " + path + " does not exist");
            }
            return inode.generateClientFileInfo(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientRawTableInfo getClientRawTableInfo(int id) throws TableDoesNotExistException {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.mInodes.get(id);
            if (inode == null || !inode.isDirectory()) {
                throw new TableDoesNotExistException("Table " + id + " does not exist.");
            }
            return this._getClientRawTableInfo(this.getPath(inode), inode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientRawTableInfo getClientRawTableInfo(String path) throws TableDoesNotExistException, InvalidPathException {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.getInode(path);
            if (inode == null) {
                throw new TableDoesNotExistException("Table " + path + " does not exist.");
            }
            return this._getClientRawTableInfo(path, inode);
        }
    }

    public int getFileId(String path) throws InvalidPathException {
        this.LOG.debug((Object)("getFileId(" + path + ")"));
        Inode inode = this.getInode(path);
        int ret = -1;
        if (inode != null) {
            ret = inode.getId();
        }
        this.LOG.debug((Object)("getFileId(" + path + "): " + ret));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ClientBlockInfo> getFileLocations(int fileId) throws FileDoesNotExistException, IOException {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.mInodes.get(fileId);
            if (inode == null || inode.isDirectory()) {
                throw new FileDoesNotExistException("FileId " + fileId + " does not exist.");
            }
            List<ClientBlockInfo> ret = ((InodeFile)inode).getClientBlockInfos();
            this.LOG.debug((Object)("getFileLocations: " + fileId + ret));
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ClientBlockInfo> getFileLocations(String path) throws FileDoesNotExistException, InvalidPathException, IOException {
        this.LOG.info((Object)("getFileLocations: " + path));
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.getInode(path);
            if (inode == null) {
                throw new FileDoesNotExistException(path);
            }
            return this.getFileLocations(inode.getId());
        }
    }

    private List<Integer> getFilesIds(List<String> pathList) throws InvalidPathException, FileDoesNotExistException {
        ArrayList<Integer> ret = new ArrayList<Integer>(pathList.size());
        for (int k = 0; k < pathList.size(); ++k) {
            ret.addAll(this.listFiles(pathList.get(k), true));
        }
        return ret;
    }

    public List<ClientFileInfo> getFilesInfo(String path) throws FileDoesNotExistException, InvalidPathException {
        ArrayList<ClientFileInfo> ret = new ArrayList<ClientFileInfo>();
        Inode inode = this.getInode(path);
        if (inode == null) {
            throw new FileDoesNotExistException(path);
        }
        if (inode.isDirectory()) {
            for (Inode child : ((InodeFolder)inode).getChildren()) {
                ret.add(child.generateClientFileInfo(CommonUtils.concat(path, child.getName())));
            }
        } else {
            ret.add(inode.generateClientFileInfo(path));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getInMemoryFiles() {
        ArrayList<String> ret = new ArrayList<String>();
        this.LOG.info((Object)"getInMemoryFiles()");
        LinkedList<Pair<InodeFolder, String>> nodesQueue = new LinkedList<Pair<InodeFolder, String>>();
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            nodesQueue.add(new Pair<InodeFolder, String>(this.mRoot, ""));
            while (!nodesQueue.isEmpty()) {
                Pair tPair = (Pair)nodesQueue.poll();
                InodeFolder tFolder = (InodeFolder)tPair.getFirst();
                String curPath = (String)tPair.getSecond();
                Set<Inode> children = tFolder.getChildren();
                for (Inode tInode : children) {
                    String newPath = CommonUtils.concat(curPath, tInode.getName());
                    if (tInode.isDirectory()) {
                        nodesQueue.add(new Pair<InodeFolder, String>((InodeFolder)tInode, newPath));
                        continue;
                    }
                    if (!((InodeFile)tInode).isFullyInMemory()) continue;
                    ret.add(newPath);
                }
            }
        }
        return ret;
    }

    private Inode getInode(String path) throws InvalidPathException {
        return this.getInode(CommonUtils.getPathComponents(path));
    }

    private Inode getInode(String[] pathNames) throws InvalidPathException {
        Pair<Inode, Integer> inodeTraversal = this.traverseToInode(pathNames);
        if (!this.traversalSucceeded(inodeTraversal)) {
            return null;
        }
        return inodeTraversal.getFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Inode> getInodeChildrenRecursive(InodeFolder inodeFolder) {
        InodeFolder inodeFolder2 = this.mRoot;
        synchronized (inodeFolder2) {
            ArrayList<Inode> ret = new ArrayList<Inode>();
            for (Inode i : inodeFolder.getChildren()) {
                ret.add(i);
                if (!i.isDirectory()) continue;
                ret.addAll(this.getInodeChildrenRecursive((InodeFolder)i));
            }
            return ret;
        }
    }

    public Journal getJournal() {
        return this.mJournal;
    }

    public InetSocketAddress getMasterAddress() {
        return this.MASTER_ADDRESS;
    }

    public long getNewUserId() {
        return this.mUserCounter.incrementAndGet();
    }

    public int getNumberOfFiles(String path) throws InvalidPathException, FileDoesNotExistException {
        Inode inode = this.getInode(path);
        if (inode == null) {
            throw new FileDoesNotExistException(path);
        }
        if (inode.isFile()) {
            return 1;
        }
        return ((InodeFolder)inode).getNumberOfChildren();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPath(Inode inode) {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            if (inode.getId() == 1) {
                return "/";
            }
            if (inode.getParentId() == 1) {
                return "/" + inode.getName();
            }
            return CommonUtils.concat(this.getPath(this.mInodes.get(inode.getParentId())), inode.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPath(int fileId) throws FileDoesNotExistException {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.mInodes.get(fileId);
            if (inode == null) {
                throw new FileDoesNotExistException("FileId " + fileId + " does not exist");
            }
            return this.getPath(inode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getPinIdList() {
        Set<Integer> set = this.mFileIdPinList;
        synchronized (set) {
            return Lists.newArrayList(this.mFileIdPinList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getPriorityDependencyList() {
        Map<Integer, Dependency> map = this.mDependencies;
        synchronized (map) {
            int earliestDepId = -1;
            if (this.mPriorityDependencies.isEmpty()) {
                long earliest = Long.MAX_VALUE;
                for (int depId : this.mUncheckpointedDependencies) {
                    Dependency dep = this.mDependencies.get(depId);
                    if (!dep.hasChildrenDependency()) {
                        this.mPriorityDependencies.add(dep.ID);
                    }
                    if (dep.CREATION_TIME_MS >= earliest) continue;
                    earliest = dep.CREATION_TIME_MS;
                    earliestDepId = dep.ID;
                }
                if (!this.mPriorityDependencies.isEmpty()) {
                    this.LOG.info((Object)("New computed priority dependency list " + this.mPriorityDependencies));
                }
            }
            if (this.mPriorityDependencies.isEmpty() && earliestDepId != -1) {
                this.mPriorityDependencies.add(earliestDepId);
                this.LOG.info((Object)("Priority dependency list by earliest creation time: " + this.mPriorityDependencies));
            }
            ArrayList<Integer> ret = new ArrayList<Integer>(this.mPriorityDependencies.size());
            ret.addAll(this.mPriorityDependencies);
            return ret;
        }
    }

    public int getRawTableId(String path) throws InvalidPathException, TableDoesNotExistException {
        int id;
        Inode inode = this.getInode(path);
        if (inode == null) {
            throw new TableDoesNotExistException(path);
        }
        if (inode.isDirectory() && this.mRawTables.exist(id = inode.getId())) {
            return id;
        }
        return -1;
    }

    public long getStarttimeMs() {
        return this.START_TIME_MS;
    }

    public long getUnderFsCapacityBytes() throws IOException {
        UnderFileSystem ufs = UnderFileSystem.get(CommonConf.get().UNDERFS_DATA_FOLDER);
        return ufs.getSpace(CommonConf.get().UNDERFS_DATA_FOLDER, UnderFileSystem.SpaceType.SPACE_TOTAL);
    }

    public long getUnderFsFreeBytes() throws IOException {
        UnderFileSystem ufs = UnderFileSystem.get(CommonConf.get().UNDERFS_DATA_FOLDER);
        return ufs.getSpace(CommonConf.get().UNDERFS_DATA_FOLDER, UnderFileSystem.SpaceType.SPACE_FREE);
    }

    public long getUnderFsUsedBytes() throws IOException {
        UnderFileSystem ufs = UnderFileSystem.get(CommonConf.get().UNDERFS_DATA_FOLDER);
        return ufs.getSpace(CommonConf.get().UNDERFS_DATA_FOLDER, UnderFileSystem.SpaceType.SPACE_USED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUsedBytes() {
        long ret = 0L;
        Map<Long, MasterWorkerInfo> map = this.mWorkers;
        synchronized (map) {
            for (MasterWorkerInfo worker : this.mWorkers.values()) {
                ret += worker.getUsedBytes();
            }
        }
        return ret;
    }

    public List<String> getWhiteList() {
        return this.mWhiteList.getList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetAddress getWorker(boolean random, String host) {
        Map<Long, MasterWorkerInfo> map = this.mWorkers;
        synchronized (map) {
            if (this.mWorkerAddressToId.isEmpty()) {
                return null;
            }
            if (random) {
                int index = new Random(this.mWorkerAddressToId.size()).nextInt(this.mWorkerAddressToId.size());
                for (InetSocketAddress address : this.mWorkerAddressToId.keySet()) {
                    if (index == 0) {
                        this.LOG.debug((Object)("getRandomWorker: " + address));
                        return new NetAddress(address.getHostName(), address.getPort());
                    }
                    --index;
                }
                Iterator<InetSocketAddress> i$ = this.mWorkerAddressToId.keySet().iterator();
                if (i$.hasNext()) {
                    InetSocketAddress address;
                    address = i$.next();
                    this.LOG.debug((Object)("getRandomWorker: " + address));
                    return new NetAddress(address.getHostName(), address.getPort());
                }
            } else {
                for (InetSocketAddress address : this.mWorkerAddressToId.keySet()) {
                    if (!address.getHostName().equals(host) && !address.getAddress().getHostAddress().equals(host) && !address.getAddress().getCanonicalHostName().equals(host)) continue;
                    this.LOG.debug((Object)("getLocalWorker: " + address));
                    return new NetAddress(address.getHostName(), address.getPort());
                }
            }
        }
        this.LOG.info((Object)("getLocalWorker: no local worker on " + host));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWorkerCount() {
        Map<Long, MasterWorkerInfo> map = this.mWorkers;
        synchronized (map) {
            return this.mWorkers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MasterWorkerInfo getWorkerInfo(long workerId) {
        MasterWorkerInfo ret = null;
        Map<Long, MasterWorkerInfo> map = this.mWorkers;
        synchronized (map) {
            ret = this.mWorkers.get(workerId);
            if (ret == null) {
                this.LOG.error((Object)("No worker: " + workerId));
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ClientWorkerInfo> getWorkersInfo() {
        ArrayList<ClientWorkerInfo> ret = new ArrayList<ClientWorkerInfo>();
        Map<Long, MasterWorkerInfo> map = this.mWorkers;
        synchronized (map) {
            for (MasterWorkerInfo worker : this.mWorkers.values()) {
                ret.add(worker.generateClientWorkerInfo());
            }
        }
        return ret;
    }

    public void init() throws IOException {
        this.mCheckpointInfo.updateEditTransactionCounter(this.mJournal.loadEditLog(this));
        this.mJournal.createImage(this);
        this.mJournal.createEditLog(this.mCheckpointInfo.getEditTransactionCounter());
        this.mHeartbeatThread = new HeartbeatThread("Master Heartbeat", new MasterInfoHeartbeatExecutor(), this.MASTER_CONF.HEARTBEAT_INTERVAL_MS);
        this.mHeartbeatThread.start();
        this.mRecomputeThread = new Thread(new RecomputationScheduler());
        this.mRecomputeThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> listFiles(String path, boolean recursive) throws InvalidPathException, FileDoesNotExistException {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.getInode(path);
            if (inode == null) {
                throw new FileDoesNotExistException(path);
            }
            if (inode.isFile()) {
                ret.add(inode.getId());
            } else if (recursive) {
                LinkedList<Inode> queue = new LinkedList<Inode>();
                queue.addAll(((InodeFolder)inode).getChildren());
                while (!queue.isEmpty()) {
                    Inode qinode = (Inode)queue.poll();
                    if (qinode.isDirectory()) {
                        queue.addAll(((InodeFolder)qinode).getChildren());
                        continue;
                    }
                    ret.add(qinode.getId());
                }
            }
        }
        return ret;
    }

    public void loadImage(JsonParser parser, String path) throws IOException {
        block10: while (true) {
            ImageElement ele;
            try {
                ele = (ImageElement)parser.readValueAs(ImageElement.class);
                this.LOG.debug((Object)("Read Element: " + ele));
            }
            catch (IOException e) {
                if (e.getMessage().contains("end-of-input")) break;
                throw e;
            }
            switch (ele.type) {
                case Version: {
                    if (ele.getInt("version") == 2) continue block10;
                    throw new IOException("Image " + path + " has journal version " + ele.getInt("version") + " . The system has verion " + 2);
                }
                case Checkpoint: {
                    this.mInodeCounter.set(ele.getInt("inodeCounter"));
                    this.mCheckpointInfo.updateEditTransactionCounter(ele.getLong("editTransactionCounter"));
                    this.mCheckpointInfo.updateDependencyCounter(ele.getInt("dependencyCounter"));
                    break;
                }
                case Dependency: {
                    Dependency dep = Dependency.loadImage(ele);
                    this.mDependencies.put(dep.ID, dep);
                    if (!dep.hasCheckpointed()) {
                        this.mUncheckpointedDependencies.add(dep.ID);
                    }
                    Iterator<Integer> i$ = dep.PARENT_DEPENDENCIES.iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block10;
                        int parentDependencyId = i$.next();
                        this.mDependencies.get(parentDependencyId).addChildrenDependency(dep.ID);
                    }
                }
                case InodeFile: {
                    throw new IOException("Invalid element type " + ele);
                }
                case InodeFolder: {
                    InodeFolder inode = InodeFolder.loadImage(parser, ele);
                    this.addToInodeMap(inode, this.mInodes);
                    this.recomputePinnedFiles(inode, (Optional<Boolean>)Optional.absent());
                    if (inode.getId() != 1) {
                        throw new IOException("Invalid element type " + ele);
                    }
                    this.mRoot = inode;
                    break;
                }
                case RawTable: {
                    this.mRawTables.loadImage(ele);
                    break;
                }
                default: {
                    throw new IOException("Invalid element type " + ele);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> ls(String path, boolean recursive) throws InvalidPathException, FileDoesNotExistException {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.getInode(path);
            if (inode == null) {
                throw new FileDoesNotExistException(path);
            }
            return this._ls(inode, path, recursive);
        }
    }

    public boolean mkdir(String path) throws FileAlreadyExistException, InvalidPathException, TachyonException {
        try {
            return this.createFile(true, path, true, 0L) > 0;
        }
        catch (BlockInfoException e) {
            throw new FileAlreadyExistException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void opAddBlock(int fileId, int blockIndex, long blockLength) throws FileDoesNotExistException, BlockInfoException {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.mInodes.get(fileId);
            if (inode == null) {
                throw new FileDoesNotExistException("File " + fileId + " does not exist.");
            }
            if (inode.isDirectory()) {
                throw new FileDoesNotExistException("File " + fileId + " is a folder.");
            }
            this.addBlock((InodeFile)inode, new BlockInfo((InodeFile)inode, blockIndex, blockLength));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long registerWorker(NetAddress workerNetAddress, long totalBytes, long usedBytes, List<Long> currentBlockIds) throws BlockInfoException {
        long id = 0L;
        InetSocketAddress workerAddress = new InetSocketAddress(workerNetAddress.mHost, workerNetAddress.mPort);
        this.LOG.info((Object)("registerWorker(): WorkerNetAddress: " + workerAddress));
        Object object = this.mWorkers;
        synchronized (object) {
            MasterWorkerInfo tWorkerInfo;
            if (this.mWorkerAddressToId.containsKey(workerAddress)) {
                id = this.mWorkerAddressToId.get(workerAddress);
                this.mWorkerAddressToId.remove(workerAddress);
                this.LOG.warn((Object)("The worker " + workerAddress + " already exists as id " + id + "."));
            }
            if (id != 0L && this.mWorkers.containsKey(id)) {
                tWorkerInfo = this.mWorkers.get(id);
                this.mWorkers.remove(id);
                this.mLostWorkers.add(tWorkerInfo);
                this.LOG.warn((Object)("The worker with id " + id + " has been removed."));
            }
            id = this.START_TIME_NS_PREFIX + (long)this.mWorkerCounter.incrementAndGet();
            tWorkerInfo = new MasterWorkerInfo(id, workerAddress, totalBytes);
            tWorkerInfo.updateUsedBytes(usedBytes);
            tWorkerInfo.updateBlocks(true, currentBlockIds);
            tWorkerInfo.updateLastUpdatedTimeMs();
            this.mWorkers.put(id, tWorkerInfo);
            this.mWorkerAddressToId.put(workerAddress, id);
            this.LOG.info((Object)("registerWorker(): " + tWorkerInfo));
        }
        object = this.mRoot;
        synchronized (object) {
            for (long blockId : currentBlockIds) {
                int fileId = BlockInfo.computeInodeId(blockId);
                int blockIndex = BlockInfo.computeBlockIndex(blockId);
                Inode inode = this.mInodes.get(fileId);
                if (inode != null && inode.isFile()) {
                    ((InodeFile)inode).addLocation(blockIndex, id, workerNetAddress);
                    continue;
                }
                this.LOG.warn((Object)("registerWorker failed to add fileId " + fileId + " blockIndex " + blockIndex));
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rename(int fileId, String dstPath) throws FileDoesNotExistException, InvalidPathException {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            boolean ret = this._rename(fileId, dstPath);
            this.mJournal.getEditLog().rename(fileId, dstPath);
            this.mJournal.getEditLog().flush();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rename(String srcPath, String dstPath) throws FileDoesNotExistException, InvalidPathException {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.getInode(srcPath);
            if (inode == null) {
                throw new FileDoesNotExistException("Failed to rename: " + srcPath + " does not exist");
            }
            return this.rename(inode.getId(), dstPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportLostFile(int fileId) {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.mInodes.get(fileId);
            if (inode == null) {
                this.LOG.warn((Object)("Tachyon does not have file " + fileId));
            } else if (inode.isDirectory()) {
                this.LOG.warn((Object)("Reported file is a directory " + inode));
            } else {
                InodeFile iFile = (InodeFile)inode;
                int depId = iFile.getDependencyId();
                Map<Integer, Dependency> map = this.mDependencies;
                synchronized (map) {
                    this.mLostFiles.add(fileId);
                    if (depId == -1) {
                        this.LOG.error((Object)("There is no dependency info for " + iFile + " . No recovery on that"));
                    } else {
                        this.LOG.info((Object)("Reported file loss. Tachyon will recompute it: " + iFile.toString()));
                        Dependency dep = this.mDependencies.get(depId);
                        dep.addLostFile(fileId);
                        this.mMustRecomputeDependencies.add(depId);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestFilesInDependency(int depId) {
        Map<Integer, Dependency> map = this.mDependencies;
        synchronized (map) {
            if (this.mDependencies.containsKey(depId)) {
                Dependency dep = this.mDependencies.get(depId);
                this.LOG.info((Object)("Request files in dependency " + dep));
                if (dep.hasLostFile()) {
                    this.mMustRecomputeDependencies.add(depId);
                }
            } else {
                this.LOG.error((Object)("There is no dependency with id " + depId));
            }
        }
    }

    public void stop() {
        this.mHeartbeatThread.shutdown();
    }

    private boolean traversalSucceeded(Pair<Inode, Integer> inodeTraversal) {
        return inodeTraversal.getSecond() == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<Inode, Integer> traverseToInode(String[] pathNames) throws InvalidPathException {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            if (pathNames == null || pathNames.length == 0) {
                throw new InvalidPathException("passed-in pathNames is null or empty");
            }
            if (pathNames.length == 1) {
                if (pathNames[0].equals("")) {
                    return new Pair<Inode, Integer>(this.mRoot, -1);
                }
                String msg = "File name starts with " + pathNames[0];
                this.LOG.info((Object)("InvalidPathException: " + msg));
                throw new InvalidPathException(msg);
            }
            Pair<Inode, Integer> ret = new Pair<Inode, Integer>(this.mRoot, -1);
            for (int k = 1; k < pathNames.length; ++k) {
                Inode next = ret.getFirst().getChild(pathNames[k]);
                if (next == null) {
                    ret.setSecond(k);
                    break;
                }
                ret.setFirst(next);
                if (ret.getFirst().isDirectory()) continue;
                if (k == pathNames.length - 1) break;
                String msg = "Traversal failed. Component " + k + "(" + ret.getFirst().getName() + ") is a file";
                this.LOG.info((Object)("InvalidPathException: " + msg));
                throw new InvalidPathException(msg);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPinned(int fileId, boolean pinned) throws FileDoesNotExistException {
        this.LOG.info((Object)("setPinned(" + fileId + ", " + pinned + ")"));
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.mInodes.get(fileId);
            if (inode == null) {
                throw new FileDoesNotExistException("Failed to find inode" + fileId);
            }
            this.recomputePinnedFiles(inode, (Optional<Boolean>)Optional.of((Object)pinned));
            this.mJournal.getEditLog().setPinned(fileId, pinned);
            this.mJournal.getEditLog().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRawTableMetadata(int tableId, ByteBuffer metadata) throws TableDoesNotExistException, TachyonException {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.mInodes.get(tableId);
            if (inode == null || !inode.isDirectory() || !this.mRawTables.exist(tableId)) {
                throw new TableDoesNotExistException("Table " + tableId + " does not exist.");
            }
            this.mRawTables.updateMetadata(tableId, metadata);
            this.mJournal.getEditLog().updateRawTableMetadata(tableId, metadata);
            this.mJournal.getEditLog().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command workerHeartbeat(long workerId, long usedBytes, List<Long> removedBlockIds) throws BlockInfoException {
        this.LOG.debug((Object)("WorkerId: " + workerId));
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Map<Long, MasterWorkerInfo> map = this.mWorkers;
            synchronized (map) {
                MasterWorkerInfo tWorkerInfo = this.mWorkers.get(workerId);
                if (tWorkerInfo == null) {
                    this.LOG.info((Object)("worker_heartbeat(): Does not contain worker with ID " + workerId + " . Send command to let it re-register."));
                    return new Command(CommandType.Register, new ArrayList<Long>());
                }
                tWorkerInfo.updateUsedBytes(usedBytes);
                tWorkerInfo.updateBlocks(false, removedBlockIds);
                tWorkerInfo.updateToRemovedBlocks(false, removedBlockIds);
                tWorkerInfo.updateLastUpdatedTimeMs();
                for (long blockId : removedBlockIds) {
                    int fileId = BlockInfo.computeInodeId(blockId);
                    int blockIndex = BlockInfo.computeBlockIndex(blockId);
                    Inode inode = this.mInodes.get(fileId);
                    if (inode == null) {
                        this.LOG.error((Object)("File " + fileId + " does not exist"));
                        continue;
                    }
                    if (!inode.isFile()) continue;
                    ((InodeFile)inode).removeLocation(blockIndex, workerId);
                    this.LOG.debug((Object)("File " + fileId + " block " + blockIndex + " was evicted from worker " + workerId));
                }
                List<Long> toRemovedBlocks = tWorkerInfo.getToRemovedBlocks();
                if (toRemovedBlocks.size() != 0) {
                    return new Command(CommandType.Free, toRemovedBlocks);
                }
            }
        }
        return new Command(CommandType.Nothing, new ArrayList<Long>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeImage(ObjectWriter objWriter, DataOutputStream dos) throws IOException {
        ImageElement ele = new ImageElement(ImageElementType.Version).withParameter("version", 2);
        this.writeElement(objWriter, dos, ele);
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Map<Integer, Dependency> map = this.mDependencies;
            synchronized (map) {
                for (Dependency dep : this.mDependencies.values()) {
                    dep.writeImage(objWriter, dos);
                }
            }
            this.mRoot.writeImage(objWriter, dos);
            this.mRawTables.writeImage(objWriter, dos);
            ele = new ImageElement(ImageElementType.Checkpoint).withParameter("inodeCounter", this.mInodeCounter.get()).withParameter("editTransactionCounter", this.mCheckpointInfo.getEditTransactionCounter()).withParameter("dependencyCounter", this.mCheckpointInfo.getDependencyCounter());
            this.writeElement(objWriter, dos, ele);
        }
    }

    public class RecomputationScheduler
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                boolean hasLostFiles = false;
                boolean launched = false;
                ArrayList<String> cmds = new ArrayList<String>();
                InodeFolder inodeFolder = MasterInfo.this.mRoot;
                synchronized (inodeFolder) {
                    Map map = MasterInfo.this.mDependencies;
                    synchronized (map) {
                        if (!MasterInfo.this.mMustRecomputeDependencies.isEmpty()) {
                            Dependency dep;
                            ArrayList<Integer> recomputeList = new ArrayList<Integer>();
                            LinkedList<Integer> checkQueue = new LinkedList<Integer>();
                            checkQueue.addAll(MasterInfo.this.mMustRecomputeDependencies);
                            while (!checkQueue.isEmpty()) {
                                int depId = (Integer)checkQueue.poll();
                                dep = (Dependency)MasterInfo.this.mDependencies.get(depId);
                                boolean canLaunch = true;
                                for (int k = 0; k < dep.PARENT_FILES.size(); ++k) {
                                    int tDepId;
                                    int fildId = dep.PARENT_FILES.get(k);
                                    if (!MasterInfo.this.mLostFiles.contains(fildId)) continue;
                                    canLaunch = false;
                                    InodeFile iFile = (InodeFile)MasterInfo.this.mInodes.get(fildId);
                                    if (MasterInfo.this.mBeingRecomputedFiles.contains(fildId) || (tDepId = iFile.getDependencyId()) == -1 || MasterInfo.this.mMustRecomputeDependencies.contains(tDepId)) continue;
                                    MasterInfo.this.mMustRecomputeDependencies.add(tDepId);
                                    checkQueue.add(tDepId);
                                }
                                if (!canLaunch) continue;
                                recomputeList.add(depId);
                            }
                            hasLostFiles = !MasterInfo.this.mMustRecomputeDependencies.isEmpty();
                            launched = recomputeList.size() > 0;
                            for (int k = 0; k < recomputeList.size(); ++k) {
                                MasterInfo.this.mMustRecomputeDependencies.remove(recomputeList.get(k));
                                dep = (Dependency)MasterInfo.this.mDependencies.get(recomputeList.get(k));
                                MasterInfo.this.mBeingRecomputedFiles.addAll(dep.getLostFiles());
                                cmds.add(dep.getCommand());
                            }
                        }
                    }
                }
                for (String cmd : cmds) {
                    String filePath = CommonConf.get().TACHYON_HOME + "/logs/rerun-" + MasterInfo.this.mRerunCounter.incrementAndGet();
                    new Thread(new RecomputeCommand(cmd, filePath)).start();
                }
                if (launched) continue;
                if (hasLostFiles) {
                    MasterInfo.this.LOG.info((Object)"HasLostFiles, but no job can be launched.");
                }
                CommonUtils.sleepMs(MasterInfo.this.LOG, 1000L);
            }
        }
    }

    public class MasterInfoHeartbeatExecutor
    implements HeartbeatExecutor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void heartbeat() {
            MasterInfo.this.LOG.debug((Object)"System status checking.");
            HashSet lostWorkers = new HashSet();
            Map map = MasterInfo.this.mWorkers;
            synchronized (map) {
                for (Map.Entry worker : MasterInfo.this.mWorkers.entrySet()) {
                    if (CommonUtils.getCurrentMs() - ((MasterWorkerInfo)worker.getValue()).getLastUpdatedTimeMs() <= (long)((MasterInfo)MasterInfo.this).MASTER_CONF.WORKER_TIMEOUT_MS) continue;
                    MasterInfo.this.LOG.error((Object)("The worker " + worker.getValue() + " got timed out!"));
                    MasterInfo.this.mLostWorkers.add(worker.getValue());
                    lostWorkers.add(worker.getKey());
                }
                Iterator i$ = lostWorkers.iterator();
                while (i$.hasNext()) {
                    long workerId = (Long)((Object)i$.next());
                    MasterWorkerInfo workerInfo = (MasterWorkerInfo)MasterInfo.this.mWorkers.get(workerId);
                    MasterInfo.this.mWorkerAddressToId.remove(workerInfo.getAddress());
                    MasterInfo.this.mWorkers.remove(workerId);
                }
            }
            boolean hadFailedWorker = false;
            while (MasterInfo.this.mLostWorkers.size() != 0) {
                hadFailedWorker = true;
                MasterWorkerInfo worker = (MasterWorkerInfo)MasterInfo.this.mLostWorkers.poll();
                InodeFolder inodeFolder = MasterInfo.this.mRoot;
                synchronized (inodeFolder) {
                    Map map2 = MasterInfo.this.mDependencies;
                    synchronized (map2) {
                        try {
                            for (long blockId : worker.getBlocks()) {
                                int fileId = BlockInfo.computeInodeId(blockId);
                                InodeFile tFile = (InodeFile)MasterInfo.this.mInodes.get(fileId);
                                if (tFile == null) continue;
                                int blockIndex = BlockInfo.computeBlockIndex(blockId);
                                tFile.removeLocation(blockIndex, worker.getId());
                                if (!tFile.hasCheckpointed() && tFile.getBlockLocations(blockIndex).size() == 0) {
                                    MasterInfo.this.LOG.info((Object)("Block " + blockId + " got lost from worker " + worker.getId() + " ."));
                                    int depId = tFile.getDependencyId();
                                    if (depId == -1) {
                                        MasterInfo.this.LOG.error((Object)("Permanent Data loss: " + tFile));
                                        continue;
                                    }
                                    MasterInfo.this.mLostFiles.add(tFile.getId());
                                    Dependency dep = (Dependency)MasterInfo.this.mDependencies.get(depId);
                                    dep.addLostFile(tFile.getId());
                                    MasterInfo.this.LOG.info((Object)("File " + tFile.getId() + " got lost from worker " + worker.getId() + " . Trying to recompute it using dependency " + dep.ID));
                                    if (MasterInfo.this.getPath(tFile).startsWith(((MasterInfo)MasterInfo.this).MASTER_CONF.TEMPORARY_FOLDER)) continue;
                                    MasterInfo.this.mMustRecomputeDependencies.add(depId);
                                    continue;
                                }
                                MasterInfo.this.LOG.info((Object)("Block " + blockId + " only lost an in memory copy from worker " + worker.getId()));
                            }
                        }
                        catch (BlockInfoException e) {
                            MasterInfo.this.LOG.error((Object)e);
                        }
                    }
                }
            }
            if (hadFailedWorker) {
                MasterInfo.this.LOG.warn((Object)"Restarting failed workers.");
                try {
                    Runtime.getRuntime().exec(CommonConf.get().TACHYON_HOME + "/bin/tachyon-start.sh restart_workers");
                }
                catch (IOException e) {
                    MasterInfo.this.LOG.error((Object)e.getMessage());
                }
            }
        }
    }
}

